/******************************** -*- C -*- ****************************
 *
 *	Byte Code interpreter declarations.
 *
 *	$Revision: 1.8.3$
 *	$Date: 2000/09/05 16:16:17$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Steve Byrne.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/


#ifndef __GSTINTERP__
#define __GSTINTERP__

#define NUM_PRIORITIES		9

typedef struct MethodContextStruct {
  OBJ_HEADER;
  OOP		parentContext;
  OOP		ipOffset;	/* an integer byte index into method */
  OOP		spOffset;	/* an integer index into cur context stack */
  OOP		receiver;	/* the receiver OOP */
  OOP		method;		/* the method that we're executing */
  OOP		flags;		/* must be an int to distinguish Block/MethodContext */
  OOP		contextStack[1];
} *MethodContext;

typedef struct BlockContextStruct {
  OBJ_HEADER;
  OOP           parentContext;
  OOP		ipOffset;	/* an integer byte index into method */
  OOP		spOffset;	/* an integer index into cur context stack */
  OOP		receiver;	/* the receiver OOP */
  OOP		method;		/* the method that we're executing */
  OOP		outerContext;   /* the parent BlockContext or MethodContext */
  OOP		contextStack[1];
} *BlockContext;

typedef struct SemaphoreStruct {
  OBJ_HEADER;
  OOP		firstLink;
  OOP		lastLink;
  OOP		signals;
} *Semaphore;

typedef struct ProcessStruct {
  OBJ_HEADER;
  OOP		nextLink;
  OOP		suspendedContext;
  OOP		priority;
  OOP		myList;
  OOP		name;
  OOP		exceptionHandlers;
} *Process;

typedef struct ProcessorSchedulerStruct {
  OBJ_HEADER;
  OOP		processLists;
  OOP		activeProcess;
  OOP		idleTasks;
} *ProcessorScheduler;


extern unsigned long		primitivesExecuted;
extern unsigned long		literalReturns, instVarReturns, selfReturns;
extern unsigned long		byteCodeCounter, sampleCounter;
extern unsigned long		cacheMisses;
extern mst_Boolean		executionTracing;
extern mst_Boolean		makeCoreFile;
extern mst_Boolean		nonInteractive;
extern OOP			thisMethod;


extern OOP			finishExecutionEnvironment();
extern void			interpret(), sendMessageInternal(),
				initInterpreter(), emptyContextPool(),
				prepareExecutionEnvironment(), asyncSignal(),
				invalidateMethodCache(), showBacktrace(), 
				initSignals(), /* deallocPoolContext(), */
  				fixupObjectPointers(), restoreObjectPointers(),
  				initProcessSystem(), markProcessorRegisters(),
  				printProcessState();

#include "interp.inl"

#endif /* __GSTINTERP__ */
