AC_DEFUN(GST_FUNC_MMAP, [
  AC_CHECK_FUNCS(mmap getpagesize)

  if test $ac_cv_func_mmap != yes; then
    AC_MSG_ERROR([GNU Smalltalk requires mmap])
  fi

AC_CACHE_CHECK(where to allocate the heap, gst_cv_mmap_base, [
  AC_TRY_RUN([
#include <sys/mman.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <fcntl.h>
#include <stdio.h>

#ifndef MAP_FAILED
#define MAP_FAILED ((char *) -1)
#endif

#if defined(MAP_ANONYMOUS) && !defined(MAP_ANON)
#define MAP_ANON MAP_ANONYMOUS
#endif

#ifdef MAP_ANON
#define mmap_page(where, flags)				        \
  mmap ((where), pagesize, PROT_READ | PROT_WRITE | PROT_EXEC,	\
	(flags) | MAP_PRIVATE | MAP_ANON, -1, 0)

#else /* no MAP_ANON */

#define mmap_page(where, flags)			                \
  mmap ((where), pagesize, PROT_READ | PROT_WRITE | PROT_EXEC,	\
	(flags) | MAP_PRIVATE, fd, 0)

#endif /* no MAP_ANON */

#define BIG_STEP (256 << 20)
#define SMALL_STEP (16 << 20)

main()
{
#ifndef _WIN32
  char *guess;
  int pagesize;
  int step;
  FILE *fp;

/* Open file descriptor for the file to which heaps are mapped
 * (/dev/zero). */

#ifndef MAP_ANON
  int fd;
  fd = open ("/dev/zero", O_RDWR);
#endif

#ifdef HAVE_GETPAGESIZE
  pagesize = getpagesize();
#else
#ifdef _SC_PAGE_SIZE
  pagesize = sysconf(_SC_PAGE_SIZE);
#else
#ifdef _SC_PAGESIZE
  pagesize = sysconf(_SC_PAGESIZE);
#else
#ifdef	PAGESIZE
  pagesize = PAGESIZE;
#else
#ifdef	EXEC_PAGESIZE
  pagesize = EXEC_PAGESIZE;
#else
#ifdef	NBPG
#ifndef	CLSIZE
#define	CLSIZE 1
#endif
  pagesize = NBPG * CLSIZE;
#else
#ifdef	NBPC
  pagesize = NBPC
#else
  pagesize = 4096;		/* Just punt and use reasonable value */
#endif /* no NBPC */
#endif /* no NBPG */
#endif /* no EXEC_PAGESIZE */
#endif /* no PAGESIZE */
#endif /* no _SC_PAGESIZE */
#endif /* no _SC_PAGE_SIZE */
#endif /* no getpagesize() */

  fp = fopen ("mmapbase", "w");
  guess = mmap_page(NULL, 0);
  step = BIG_STEP;
  for (guess += step; step >= SMALL_STEP; step >>= 1, guess -= step)
    if (mmap_page(guess + BIG_STEP, MAP_FIXED) != MAP_FAILED 
	&& mmap_page(guess, MAP_FIXED) != MAP_FAILED) {
      fprintf (fp, "0x%x\n", guess);
      fclose (fp);
      exit (0);
    }

  guess -= step;
  step = BIG_STEP;
  for (guess -= step; step >= SMALL_STEP; step >>= 1, guess += step)
    if (mmap_page(guess, MAP_FIXED) != MAP_FAILED
        && mmap_page(guess + BIG_STEP, MAP_FIXED) != MAP_FAILED) {
      fprintf (fp, "0x%x\n", guess);
      fclose (fp);
      exit (0);
    }

  fclose (fp);
  exit (1);
#else /* WIN32 */
  exit (0);
#endif /* WIN32 */
}
],
  gst_cv_mmap_base=`cat mmapbase 2>/dev/null`,
  AC_MSG_ERROR([a valid heap base address could not be determined]))

  rm -f mmapbase 2> /dev/null
])

AC_DEFINE_UNQUOTED(MMAP_BASE, [((char *)${gst_cv_mmap_base})])

])dnl
