"======================================================================
|
|   Abstract ContentHandler class
|
|   $Revision: 1.8.3$
|   $Date: 2000/09/05 16:16:17$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


Object subclass: #ContentHandler
	  instanceVariableNames: 'stream'
	  classVariableNames: 'FileExtensionMap FileTypeMap'
	  poolDictionaries: ''
	  category: 'Sockets-MIME'
!

ContentHandler class instanceVariableNames: 'validTypes'!

!ContentHandler class methodsFor: 'checking files'!

contentTypeFor: aFileName
    | posi |
    posi := aFileName findLast: [ :each | each = $. ].
    posi = 0 ifTrue: [ ^'application/octet-stream' ].

    ^FileExtensionMap
	at: (aFileName copyFrom: posi + 1 to: aFileName size)
	ifAbsent: [ 'application/octet-stream' ]
!

guessContentTypeFor: aPositionableStream
     | str ba |
     str := aPositionableStream next: 12.
     ba := str asByteArray.

     FileTypeMap do: [ :each |
	| ok |
	ok := true.
	(each at: 1) doWithIndex: [ :ch :index |
	    ch isSymbol ifFalse: [
		ch isInteger
		    ifTrue:  [ ok := ((ba  at: index) = ch) | ok ]
		    ifFalse: [ ok := ((str at: index) = ch) | ok ]
	    ]
	].
	ok ifTrue: [ ^each at: 2 ]
    ].
    ^nil
!

classFor: mimeType
    self withAllSubclassesDo: [ :each |
	(each validTypes includes: mimeType) ifTrue: [ ^each ]
    ].
    ^self
! !

!ContentHandler class methodsFor: 'accessing'!

defaultFileExtensionMap
    ^#(	('aif' 'audio/x-aiff')
	('ai' 'application/postscript')
	('aifc' 'audio/aiff')
	('aiff' 'audio/x-aiff')
	('au' 'audio/basic')
	('avi' 'video/x-msvideo')
	('bmp' 'image/bmp')
	('cdf' 'application/x-cdf')
	('cer' 'application/x-x509-ca-cert')
	('crt' 'application/x-x509-ca-cert')
	('css' 'text/css')
	('dcr' 'application/x-director')
	('der' 'application/x-x509-ca-cert')
	('dir' 'application/x-director')
	('dll' 'application/x-msdownload')
	('doc' 'application/msword')
	('dot' 'application/msword')
	('dxr' 'application/x-director')
	('eml' 'message/rfc822')
	('eps' 'application/postscript')
	('exe' 'application/x-msdownload')
	('fif' 'application/fractals')
	('gif' 'image/gif')
	('gz' 'application/x-gzip')
	('hqx' 'application/mac-binhex40')
	('htm' 'text/html')
	('html' 'text/html')
	('htt' 'text/webviewhtml')
	('ins' 'application/x-internet-signup')
	('isp' 'application/x-internet-signup')
	('ivf' 'video/x-ivf')
	('jfif' 'image/pjpeg')
	('jpe' 'image/jpeg')
	('jpeg' 'image/jpeg')
	('jpg' 'image/jpeg')
	('latex' 'application/x-latex')
	('m1v' 'video/mpeg')
	('man' 'application/x-troff-man')
	('mht' 'message/rfc822')
	('mhtml' 'message/rfc882')
	('mid' 'audio/mid')
	('mov' 'movie/quicktime')
	('mov' 'video/quicktime')
	('mp2' 'video/mpeg')
	('mpa' 'video/mpeg')
	('mpe' 'movie/mpeg')
	('mpeg' 'movie/mpeg')
	('mpg' 'video/mpeg')
	('nws' 'message/rfc822')
	('p7c' 'application/pkcs7-mime')
	('pdf' 'application/pdf')
	('pot' 'application/vnd.ms-powerpoint')
	('ppa' 'application/vnd.ms-powerpoint')
	('pps' 'application/vnd.ms-powerpoint')
	('ppt' 'application/vnd.ms-powerpoint')
	('ps' 'application/postscript')
	('pwz' 'application/vnd.ms-powerpoint')
	('qt' 'video/quicktime')
	('rmi' 'audio/mid')
	('rtf' 'application/msword')
	('sgm' 'text/sgml')
	('sgml' 'text/sgml')
	('sit' 'application/x-stuffit')
	('snd' 'audio/basic')
	('spl' 'application/futuresplash')
	('st' 'text/plain')			"Of course!"
	('swf' 'application/x-shockwave-flash')
	('tar' 'application/x-tar')
	('tgz' 'application/x-compressed')
	('tif' 'image/tiff')
	('tiff' 'image/tiff')
	('txt' 'text/plain')
	('wav' 'audio/wav')
	('wiz' 'application/msword')
	('xbm' 'image/x-xbitmap')
	('xml' 'text/xml')
	('xls' 'application/vnd.ms-excel')
	('z' 'application/x-compress')
	('zip' 'application/x-zip-compressed'))
!

defaultFileTypeMap
    ^#(
	(($M  $Z)			      'application/x-msdownload')
	(($P  $K  3   4)		      'application/x-zip-compressed')
	(($%  $P  $D  $F)		      'application/pdf')
	(($%  $!  $P  $S)		      'application/postscript')
	(($.  $s  $n  $d)		      'audio/basic')
	(($d  $n  $s  $.)		      'audio/basic')
	(($M  $T  $h  $d)		      'audio/mid')
	(($R  $I  $F  $F - - - - $R $M $I $D) 'audio/mid')
	(($R  $I  $F  $F - - - - $W $A $V $E) 'audio/x-wav')
	(($<  $! $D $O $C $T $Y $P $E $  $ H) 'text/html')
	(($<  $! $- $-)			      'text/html')
	(($<  $h  $t  $m  $l)		      'text/html')
	(($<  $H  $T  $M  $L)		      'text/html')
	(($<  $?  $X) 			      'text/xml')
	(($<  $?  $x) 			      'text/xml')
	(($<  $!) 			       'text/sgml')
	(($G  $I  $F  $8)		      'image/gif')
	(($#  $d  $e  $f)		      'image/x-bitmap')
	(($!  $   $X  $P  $M  $2)	      'image/x-pixmap')
	(($/  $*  $   $X  $P  $M)	      'image/x-pixmap')
	(($I  $I  42   0)		      'image/tiff')
	(($M  $M   0  42)		      'image/tiff')
	((137 $P  $N  $G  13  10 26 10)	      'image/png')
	(($B  $M)			      'image/bmp')
	((255 216 255 224)		      'image/jpeg')
	((255 216 255 232)		      'image/jpg')
    )
!

contentType: type hasExtension: ext 
    ^FileExtensionMap at: ext put: type
!

contentType: type hasMagicData: data
    ^FileTypeMap add: (Array with: data with: type)
!

initialize
    FileExtensionMap := Dictionary new.
    FileTypeMap := self defaultFileTypeMap asOrderedCollection.
    self defaultFileExtensionMap do: [ :each |
	FileExtensionMap at: (each at: 1) put: (each at: 2)
    ].

    ContentHandler registerContentTypes: #(
	'application/octet-stream'
	'application/x-unknown'
	'text/english'
	'text/plain')
!

validTypes
    ^validTypes isNil
	ifTrue: [ #() ]
	ifFalse: [ validTypes ]
!

registerContentType: contentType
    validTypes isNil ifTrue: [ validTypes := OrderedCollection new ].
    validTypes add: contentType
!

registerContentTypes: contentType
    validTypes isNil ifTrue: [ validTypes := OrderedCollection new ].
    validTypes addAll: contentType
! !

!ContentHandler class methodsFor: 'instance creation'!

on: stream
    ^self new initialize: stream
! !

!ContentHandler methodsFor: 'retrieving contents'!

contents
    ^stream contents
!

initialize: aStream
    stream := aStream
! !

ContentHandler initialize!
