"======================================================================
|
|   DatagramSocket wrapper class
|
|   $Revision: 1.8.3$
|   $Date: 2000/09/05 16:16:17$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


AbstractSocket subclass: #DatagramSocket
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Sockets-Streams'
!

!DatagramSocket class methodsFor: 'initialization'!

initialize
    DatagramSocket defaultImplementationClass: UDPSocketImpl
! !

!DatagramSocket class methodsFor: 'instance creation'!

new
    ^self local: nil port: 0
!

port: localPort
    ^self local: nil port: localPort
!

local: ipAddress port: localPort
    (localPort < 0) | (localPort > 16rFFFF)
	ifTrue: [ self error: 'port out of range' ].

    ^super new
	local: ipAddress port: localPort
! !

!DatagramSocket methodsFor: 'accessing'!

address
    ^self localAddress
!

nextPut: aDatagram
    self
	waitUntil: [ self implementation canRead ]
	then: [ self implementation nextPut: aDatagram. aDatagram ]
	onTimeoutDo: [ nil ]
!

port
    ^self localPort
!

peek
    ^self
	waitUntil: [ self implementation canRead ]
	then: [ self implementation peek ]
	onTimeoutDo: [ nil ]
!

peek: datagram
    self
	waitUntil: [ self implementation canRead ]
	then: [ self implementation peek: datagram. true ]
	onTimeoutDo: [ false ]
!

receive: datagram
    self
	waitUntil: [ self implementation canRead ]
	then: [ self implementation receive: datagram. true ]
	onTimeoutDo: [ false ]
! !


!DatagramSocket methodsFor: 'direct operations'!

nextFrom: ipAddress port: port
    self
	waitUntil: [ self implementation canRead ]
	then: [ self implementation nextFrom: ipAddress port: port ]
	onTimeoutDo: [ nil ]
! !

!DatagramSocket methodsFor: 'private'!

create
    self implementation create
!

local: ipAddress port: localPort

    self create.
    self implementation
	bindTo: (ipAddress isNil
	    ifTrue: [ IPAddress anyLocalAddress ]
	    ifFalse: [ ipAddress ])
	port: localPort.
! !
