"======================================================================
|
|   UDPSocketImpl
|
|   $Revision: 1.8.3$
|   $Date: 2000/09/05 16:16:17$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


DatagramSocketImpl subclass: #UDPSocketImpl
	   instanceVariableNames: 'bufSize'
	   classVariableNames: ''
	   poolDictionaries: ''
	   category: 'Sockets-Protocols'
!

!UDPSocketImpl methodsFor: 'implementation'!

bindTo: ipAddress port: port
    | addr |
    addr := ipAddress port: port.
    [
        self bind: self fd to: addr addrLen: addr size.
        File checkError.
    ]   ifCurtailed: [ self nowDead; close ].
    self isOpen ifTrue: [ self hasBeenBound ]
!

create
    | descriptor |
    descriptor := self
	create: IPAddress pfInet
	type: self class sockDgran
	protocol: 0.
!

getSockName
    | sock sizePtr |
    sock := ByteArray new: CSockAddrStruct sizeof.
    sizePtr := ByteArray new: CInt sizeof.
    sizePtr intAt: 1 put: CSockAddrStruct sizeof.

    self
	getSockName: self fd
	addr: sock
	addrLen: sizePtr.

    ^sock
!

optionAt: opt level: level size: size
    | result |
    result := ByteArray new: size.
    self
	option: self fd
	level: level 
	at: opt
	get: result
	size: size.
    ^result
!

optionAt: opt level: level put: anObject
    | ba |
    ba := self makeByteArray: anObject.
    self
	option: self fd
	level: level
	at: opt
	put: ba
	size: ba size.
!

receive: flags datagram: aDatagram
    | address port data from |
    data := ByteArray new: self bufferSize.
    from := ByteArray new: CSockAddrStruct sizeof.
    self
	receive: self fd
	buffer: data
	size: data size
	flags: flags
	from: from
	size: from size.

    port := ValueHolder new.
    ^aDatagram
	data: data;
	address: (IPAddress fromSockAddr: from port: port);
	port: port value;
	yourself
!

nextPut: aDatagram
    | size receiver |
    aDatagram receiver isNil
	ifTrue: [ receiver := size := 0 ]
	ifFalse: [ receiver := aDatagram sockAddr. size := receiver size ].

    self
	send: self fd
	buffer: aDatagram data
	size: aDatagram data size
	flags: 0
	to: receiver
	size: size
! !

!UDPSocketImpl methodsFor: 'accessing'!

bufferSize
    ^bufSize
!

bufferSize: size
    bufSize := size
! !

