"======================================================================
|
|   Test process operations
|
|   $Revision: 1.8.3$
|   $Date: 2000/09/05 16:16:17$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright (C) 1999  Free Software Foundation.
| Written by Paolo Bonzini
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

"Test resuming/terminating a process"
| p |
p :=  [ 'inside p' printNl ] newProcess.
p printNl.
p resume.
p printNl!

"Test Process suspend/resume"
| p |
p := [
    'inside p' printNl.
    p suspend.
    'suspension finished' printNl ] newProcess.
p printNl.
p resume.
p printNl.
p resume.
p printNl!


"Test processes yielding control to each other without suspending themselves"
| p |
p := [
    'inside p' printNl.
    p yield.
    'yielded back to p' printNl ] newProcess.
p printNl.
p resume.
p printNl.
Processor yield.
p printNl!



"Test simple wait on a semaphore"
| p s |
s := Semaphore new.
p := [
    'inside p' printNl.
    s wait.
    'wait finished' printNl ] newProcess.
p printNl.
p resume.
p printNl.
s signal.
p printNl!


"Now test process interrupts"
| s p |
s := Semaphore new.
([ [ false ] whileFalse: [ ] ]
    forkAt: Processor userBackgroundPriority)
    name: 'background';
    queueInterrupt: [ (p := Processor activeProcess) printNl. s signal ].

s wait.
p printNl.
p terminate.
p printNl!

