#ifndef	_SYS_FS_FIST_COMMON_H
#define	_SYS_FS_FIST_COMMON_H

#include <sys/pathname.h>

/* for ioctl */
#define FIST_DBGIOC			('f' << 8)
#define FIST_IOCTL_GET_DEBUG_VALUE	(FIST_DBGIOC | 01)
#define FIST_IOCTL_SET_DEBUG_VALUE	(FIST_DBGIOC | 02)
/* reserve 10h-20h for specific fs */

#ifdef _KERNEL

/* common header definitions to all fist kernel modules */

#define	TYPICALMAXPATHLEN	64

#ifdef FIST_DEBUG

extern void fist_dprint_internal(int level, char *str, ...);
extern void fist_print_vnode(char *, vnode_t *);
extern void fist_print_vfs(char *, struct vfs *);
extern void fist_print_uap(char *, struct mounta *);
extern void fist_print_uio(char *, uio_t *);
extern void fist_print_uios(char *, uio_t *);
extern void fist_print_pnp(char *, pathname_t *);
extern void fist_print_pathname(char *fxn_name, struct pathname *pnp);
extern int fist_get_debug_value(void);
extern int fist_set_debug_value(int val);
#define print_location() \
	fist_dprint(4, "%s %s:%d\n", __FUNCTION__, __FILE__, __LINE__)

#undef CONSOLE_DEBUG
#ifdef CONSOLE_DEBUG
# define CONSOLE_PREFIX
#else /* not CONSOLE_PREFIX */
# define CONSOLE_PREFIX "!"
#endif /* not CONSOLE_PREFIX */

#define printk(format, args...) \
	cmn_err(CE_CONT, CONSOLE_PREFIX format, ## args)
#define fist_dprint(level, str, args...) \
	fist_dprint_internal(level, CONSOLE_PREFIX str, ## args)

#else /* not FIST_DEBUG */

#define printk(format, args...)
#define fist_dprint(level, format, args...)
#define print_location()
#define fist_print_vnode(a, b)
#define fist_print_vfs(a, b)
#define fist_print_uap(a, b)
#define fist_print_uios(a, b)
#define fist_print_pathname(a, b)
#define fist_set_debug_value(a)
#define fist_get_debug_value() -1

#endif /* not FIST_DEBUG */

extern vnode_t *fist_ht_find_vp(const vnode_t * hidden_vp, const vfs_t * this_vfsp);
extern void fist_ht_del_vp(const vnode_t * hidden_vp, const vfs_t * this_vfsp);
extern void fist_ht_insert_vp(vnode_t * hidden_vp, vnode_t * this_vp);
extern int fist_ht_empty_assert(const vfs_t * this_vfsp);

#define	FIST_HT_SIZE	64
#define	fisttablehash(vp)	((((int)(vp))>>10) & (FIST_HT_SIZE-1))

typedef struct fist_bucket {
  vnode_t *hidden_vp;		/* index */
  vnode_t *this_vp;
  struct fist_bucket *next;
} fist_bucket_t;

#endif /* _KERNEL */

#endif /* not _SYS_FS_FIST_COMMON_H */
