/*
 * Copyright (c) 1993 by Sun Microsystems, Inc.
 */

/*
 * Fist_usenetfs mount info - one per mount
 */

#ifndef	_SYS_FS_FIST_USENETFS_H
#define	_SYS_FS_FIST_USENETFS_H

#include <vm/page.h>
#include <sys/tiuser.h>

#ifdef	__cplusplus
extern "C" {
#endif

#undef	MAXNAMLEN
#define	MAXNAMLEN	255

  struct fist_usenet_args {
    struct netbuf addr;		/* daemon address */
    char *path;			/* fist_usenetfs mountpoint */
    char *opts;			/* default mount options */
    char *map;			/* name of map */
    int mount_to;		/* time in sec the fs is to remain */
    /* mounted after last reference */
    int rpc_to;			/* timeout for rpc calls */
    int direct;			/* 1 = direct mount */
  };

#ifdef	_KERNEL

  struct fist_usenet_callargs {
    vnode_t *fwc_vp;		/* vnode */
    char *fwc_name;		/* name of path to mount */
    cred_t *fwc_cred;
  };

  struct fist_usenetinfo {
    struct vfs *fwi_mountvfs;	/* vfs we interpose on */
    struct vnode *fwi_rootvnodep;	/* root vnode */
    int fwi_num_vnodes;		/* # of interposed vnodes */
    /* HT to map hidden_vp to vp */
    fist_bucket_t *fwi_buckets[FIST_HT_SIZE];
    kmutex_t fwi_ht_lock;	/* lock for HT */
  };

  /*
   * The fist_usenetnode is the "inode" for fist_usenetfs.  It contains
   * all the information necessary to handle fist_usenet-matic mounting.
   */
  typedef struct fist_usenetnode {
    vnode_t *fwn_vnodep;	/* interposed vnode pointer */
    u_int fwn_mapcnt;		/* mapped pages counter */
    kmutex_t fwn_lock;		/* lock for private data */
  } fist_usenetnode_t;

  /*
   * Mount flags
   */

#define	MF_MNTPNT		0x001	/* A mountpoint */
#define	MF_INPROG		0x002	/* mount in progress */
#define	MF_WAITING_MOUNT	0x004	/* thread waiting */
#define	MF_WAITING_UMOUNT	0x008
#define	MF_MOUNTED		0x010	/* mount taken place */
#define	MF_UNMOUNTING		0x020	/* unmount in prog */
#define	MF_DONTMOUNT		0x040	/* unmount failed, so don't */
  /* try another mount */
#define	MF_CHECKED		0x080	/* checked by unmount thread */

  /*
   * Convert between vfs/fist_usenetinfo & vnode/fist_usenetnode
   */
#define	fwntovn(ap)	(&((ap)->fwn_vnode))
#define	vntofwn(vp)	((struct fist_usenetnode *) ((vp)->v_data))
#define	vfstofwi(vfsp)	((struct fist_usenetinfo *) ((vfsp)->vfs_data))

  extern kmutex_t fist_usenetnode_list_lock;
  extern struct fist_usenetnode *fist_usenetnode_list;
  extern kmutex_t fist_usenetnode_count_lock;
  extern int anode_cnt, makefist_usenetnode_count, freefist_usenetnode_count;

  extern int do_mount(vnode_t *, char *, cred_t *);
  extern int fist_usenetdir_lookup(vnode_t *, char *, vnode_t **, cred_t *);
  extern int fist_usenet_direnter(fist_usenetnode_t *, fist_usenetnode_t *);
  extern void do_unmount(void);
  extern vnode_t *makefist_usenetnode(vtype_t, vfs_t *, cred_t *);
  extern void freefist_usenetnode(fist_usenetnode_t * anp);

  /* for page to kernel virtual memory mapping */
  extern caddr_t ppmapin(page_t * pp, u_int vprot, caddr_t hint);
  extern void ppmapout(caddr_t va);

  extern vnode_t *fist_usenet_interpose(vnode_t * hidden_vp, vfs_t * this_vfsp);
  extern int usenet_encode_block(char *func, int line, caddr_t base, int len, const vnode_t *vp);
  extern int usenet_decode_block(char *func, int line, caddr_t base, int len, const vnode_t *vp);
  extern int usenet_decode_path(const char *name, char *last2, char *prev2);
  extern int usenet_isnumber(const char *n);

#endif				/* _KERNEL */

#ifdef	__cplusplus
}

#endif
#endif				/* _SYS_FS_FIST_USENETFS_H */
