/*
 * Copyright (c) 1992 by Sun Microsystems, Inc.
 */

#include <sys/param.h>
#include <sys/kmem.h>
#include <sys/vfs.h>
#include <sys/vnode.h>
#include <sys/cmn_err.h>
#include <sys/debug.h>
#include <sys/systm.h>
#include <sys/t_lock.h>
#include <sys/errno.h>
#include <sys/thread.h>
#include <sys/tiuser.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#include <rpc/auth.h>
#include <rpc/clnt.h>
#include <vm/page.h>

#include <fist.h>
#include <rot13fs.h>


/* return the number of bytes written */
int
rot13_encode_block(char *func, int line, caddr_t base, int len, const vnode_t *vp)
{
  char c, *cp = (char *) base;
  int i;

  for (i = 0; i < len; i++) {
    c = *cp & ~0x20;		/* uppercase c */
    if (c < 'A' || c > 'Z') {
      cp++;
      continue;
    }
    if (c > 'M')
      *cp -= 13;
    else
      *cp += 13;
    cp++;
  }
  return len;
}


/* returns the number of bytes read */
int
rot13_decode_block(char *func, int line, caddr_t base, int len, const vnode_t *vp)
{
  /* rot13 decode and encode are identical */
  return rot13_encode_block(func, line, base, len, vp);
}
