#.........................................................
# Copyright (c) MM by Kevin C. O'Kane, All Rights Reserved
# Mumps interpreter checkout code - not exhaustive.
# Examples of code that works (mostly - the pattern
# match has problems).
#.........................................................

	; comments may either begin with a semi-colon like
	; this PROVIDED that the semi-colon is placed where
	; a command would go.  Semi-colons may not be used
	; prior to the required TAB character at the beginning
	; of a line.

# This is also a comment - it must be the very 1st thing on
# a line and have NO TAB characters.

#########################################################################

# this is a separate extrinsic.  it compiles
# to a separate C function rather than part of
# the main function.  it may also be compiled
# separately.  see documentation.
# separate functions must appear before they are used.

^subFunction(a,b,c)	; I am a separate extrinsic - a C sub function.
				; I must appear before I am used
	quit a+b+c

^test3(xxx)	; fcn
	write !,"****** linked function ",xxx,!
	quit

#########################################################################

	Zmain

	write !!,"Compiler Checkout Routines",!!
	write "Builtin variables (expected ... actual)",!!

	write "$fnumber(42000,""P"",2) ",?65,$fn(42000,"P",2),!
	write "$io",?45,"5 ",?65,$io,!
	write "$zd",?45,"current date ",?65,$zd,!
	write "$h",?45,"current date ",?65,$h,!
	if 1=1 set i=1
	write "$test",?45,"1 ",?65,$test,!
	write "$TEST",?45,"1 ",?65,$TEST,!
	write "$T",?45,"1 ",?65,$T,!
	write "$t",?45,"1 ",?65,$t,!
	if 1=0 set i=1
	write "$test",?45,"0 ",?65,$test,!
	write "$job ",?65,$job,!
	write "$storage",?45,"999 ",?65,$s,!
	write "$x $y",?65,$x," ",$y,!

	write !,"Functions (expected ... actual)... ",!!

	write "$ascii(""Beethoven"")",?45,"66 ",?65,$ascii("Beethoven"),!
	write "$ascii(""HAYDEN"",3)",?45,"89 ",?65,$ascii("HAYDEN",3),!
	write "$CHAR(66,-1,65,67,72)",?45,"BACH ",?65,$CHAR(66,-1,65,67,72),!
	set a="66"
	write "$char(a)",?45,"B ",?65,$c(a),!

	set ^a(1)=1
	set ^a(2)=1

	set ^a(1,1)=11
	set ^a(3,1)=1
	write "$data(^a(""none""))",?45,"0",?65,$data(^a("none")),!
	write "$data(^a(1))",?45,"11",?65,$data(^a(1)),!
	write "$data(^a(1,1))",?45,"1",?65,$data(^a(1,1)),!
	write "$data(^a(2))",?45,"1",?65,$data(^a(2)),!
	write "$data(^a(3))",?45,"10",?65,$data(^a(3)),!
	write "$data(none)",?45,"0",?65,$data(none),!
	set i=1
	write "$data(i)",?45,"1",?65,$data(i),!
	set xxx(1)=1
	write "$data(xxx(1)",?45,"1",?65,$data(xxx(1)),!
	set xxx(1,1)=11
	write "$data(xxx(1)",?45,"11",?65,$data(xxx(1)),!
	set yyy(1,1)=99
	write "$data(yyy(1)",?45,"10",?65,$data(yyy(1)),!
	write "$data(yyy)",?45,"10",?65,$data(yyy),!

	write "use $next, not $order",!
	for i=1:1:10 s a(i)=i
	write "$next(a(-1))",?45,"1",?65,$n(a(-1)),!
	write "$next(a(1))",?45,"10",?65,$n(a(1)),!
	write "$next(a(10))",?45,"2",?65,$n(a(10)),!

	write "$extract(""Brahms"")",?45,"B",?65,$extract("Brahms"),!
	write "$extract""Handel"",5)",?45,"e",?65,$extract("Handel",5),!
	write "$extract*""Mozart"",4,6)",?45,"art",?65,$extract("Mozart",4,6),!

	write "$find(""SIBELIUS"",""I"")",?45,"3",?65,$find("SIBELIUS","I"),!
	set i=3
	write "i=3",!
	write "$find(""SIBELIUS"",""I"",i)",?45,"7",?65,$find("SIBELIUS","I",i),!
	write "$find(""SIBELIUS"",""I"",7)",?45,"0",?65,$find("SIBELIUS","I",7),!

	write "$justify(""3.14159"",9)",?45,?65,"xx3.14159",?65,$justify("3.14159",9),!
	write "$justify(""3.14159"",9,2)",?45,?65,"xxxxx3.14",?65,$justify("3.14159",9,2),!

	write "$length(""Verdi & Wagner"")",?45,"14 ",?65,$length("Verdi & Wagner"),!
	write "$length(""Verdi & Wagner"",""&"")",?45,"2",?65,$length("Verdi & Wagner","&"),!
	write "$length(""Verdi & Wagner"","" "")",?45,"3",?65,$length("Verdi & Wagner"," "),!

	set B3="Beethoven,Bach,Brahms"
	write "set B3=""Beethoven,Bach,Brahms""",!
	write "$piece(B3,"","")",?45,"Beethoven",?65,$p(B3,","),!
	write "$piece(B3,"","",3)",?45,"Brahms",?65,$p(B3,",",3),!
	write "$piece(B3,"","",1,2)",?45,"Beethoven,Bach",?65,$p(B3,",",1,2),!

	write "$random(9)",?45,"{0,8}",?65,$random(9),!

	write !,"Operators ...",!!

	write "Unary +""27.3 days""",?45,"27.3",?65,+"27.3 days",!
	write "Unary - -""3.14 radians""",?45,"3.14",?65,-"3.14 radians",!
	write "Sum 2.718+""2 above e""",?45,"4.718",?65,2.718+"2 above e",!
	write "Difference 2.12-""6.3 eV""",?45,"4.18",?65,2.12-"6.3 eV",!
	write "Product 1.00794*""2 atoms/H2""",?45,"2.01588",?65,1.00794*"2 atoms/H2",!
	write "Division 144.132/12.011",?45,"12",?65,144.132/12.011,!
	write "Integer Division 82.8\""29.5 years/orbit""",?45,"2",?65,82.8\"29.5 years/orbit",!

	write "Modulo works like C modulo",!
	write "Modulo 42#5",?45,"2",?65,42#5,!
	write "Modulo -42#5",?45,"3",?65,-42#5,!
	write "Modulo 42#-5",?45,"3",?65,42#-5,!
	write "Modulo -42#-5",?45,"2",?65,-42#-5,!

	write "Less Than 1642<1879",?45,"1",?65,1642<1879,!
	write "Greater Than 1452>1564",?45,"0 ",?65,1452>1564,!

	write "Concatenate ""Feynman ""_1918",?45,"Feynman 1918 ",?65,"Feynman "_1918,!

	write "Equals 1969-5=1964",?45,"1",?65,1969-5=1964,!
	write "Equals 1967=""1967: M""",?45,"0",?65,1967="1967: M",!
	write "Equals 1966=01966",?45,"1",?65,1966=01966,!
	write "Equals 1966=""01966""",?45,"0",?65,1966="01966",!
	write "Equals ""Lovelace""=""Hopper""+2",?45,"2",?65,"Lovelace"="Hopper"+2,!
	write "Equals ""Lovelace""=""Lovelace""+3",?45,"3",?65,"Lovelace"="Lovelace"+2,!

	write "not equals ",?45,"0 ",?65,1969-5'=1964,!
	write "not equals ",?45,"1 ",?65,1967'="1967: M",!
	write "not equals ",?45,"0 ",?65,1966'=01966,!
	write "not equals ",?45,"1 ",?65,1966'="01966",!
	write "not equals ",?45,"3 ",?65,"Lovelace"'="Hopper"+2,!
	write "not equals ",?45,"2 ",?65,"Lovelace"'="Lovelace"+2,!

	write "Contains ",?45,"1 ",?65,"Darwin"["win",!
	write "Contains ",?45,"1 ",?65,"Linnaeus"["",!

	write "Follows ",?45,"0 ",?65,"COPERNICUS"]"KEPLER",!

	write "Pattern ",?45,"0 ",?65,"Leakey"?1a,!
	write "Pattern ",?45,"1 ",?65,"Boaz"?1.a,!
	write "Pattern ",?45,"1 ",?65,"Fossey"?1u.5l,!
	write "Pattern ",?45,"0 ",?65,"Goodall"?.4l.p6c.e,!
	write "Pattern ",?45,"1 ",?65,"Maslow"?.E1"low".CNP,!

	write "And ",?45,"0 ",?65,"Watson"&"Crick",!
	write "And ",?45,"0 ",?65,"Morgan"&1735,!
	write "And ",?45,"1 ",?65,1838&1839,!
	write "And ",?45,"1 ",?65,-12000&1996,!
	write "And ",?45,"0 ",?65,1859&0,!

	write "Or ",?45,"0 ",?65,"Jennifer"!"Pasteur",!
	write "Or ",?45,"1 ",?65,"Hoffman"!1928,!
	write "Or ",?45,"1 ",?65,1898!-400,!
	write "Or ",?45,"1 ",?65,1867!0,!

	set a="aaa$bbb$ccc"
	set b="$"
	set $p(a,b,2)="test"
	write "setpiece: (aaa$test$ccc) ",a,!
	set x(1)="123.45.6789"
	set x="123.45.6789"
	set j=1
	set ^a(j)=x
	set $piece(x(j),".",2)="**"
	write "setpiece local array ",x(j),!
	set $piece(x,".",2)="**"
	write "setpiece local scalar ",x,!
	set $piece(^a(j),".",2)="**"
	write "setpiece global array ",^a(j),!
	read "Enter a value for setpiece test",$piece(x,".",2)
	write "setpiece on read ",x,!

	write "exponention works",!
	set a=3
	set a=a**2
	write "exponentiation: ",a,!
	set a=9
	set a=a**.5
	write "exponentiation: ",a,!

	write "Not ",?45,"1 ",?65,'"Turing",!
	write "multiple not signs doesn't work",!
	; write "Not 0 ",''"Babbage",!
	write "Not ",?45,"1 ",?65,'"Backus"&1957,!
	write "Not ",?45,"1 ",?65,'("Wirth"&"Codd"),!

	write !!,"Command examples...",!!
	write "Open a file for output and write to it...",!
	open 1:"tmp.tmp,new"
	use 1
	for i=1:1:10 write "test ",i,!
	close 1
	use 5
	write "Reopen the same file and read from it ...",!
	open 1:"tmp.tmp,old"
	for i=1:1 use 1 read a quit:'$t  use 5 write "***",a,!
	use 5
	close 1

	write "Set command ...",!
	set a=1+(2+(3+(4+5)))
	set:1=1 a=1+(2+(3+(4+5))) set a=0 write "0 ",a,!

	write "for command ...",!
	for i=1:1:10 write " ",i
	write !
	for i=1:1 quit:i>10  write " ",i
	write !

	write "Goto based loops...",!
	set i=1
lab1	write i," "
	set i=i+1
	if i<11 goto lab1
	write !

	write "Init a global and Next thru it ...",!
	for i=1:1:10 for j=1:1:10 set ^a(i,j)=i_","_j
	for i=1:1:10 write ! for j=1:1:10 w ^a(i,j)," "
	write !
	set i=-1
lab2	set i=$next(^a(i))
	if i<0 goto lab3
	write !,i,":"
	set j=-1
lab2a	set j=$next(^a(i,j))
	if j<0 goto lab2
	write ^a(i,j)," "
	goto lab2a
lab3	write !

# This version of mumps normally stores numeric subscripts as strings.
# this means that, on retrieval, the order will be according to a
# character collating sequence.  The ZNUMBER command causes numeric
# subscripts to be stored padded to the left with blanks to a fixed
# length field of width 8.  Thus, positive integers will appear
# in numeric order when retrieved.  ZNUMBER must be ineffect when
# the array is created.

	znumber
	write !,"Init a global and Next thru it using cannonical numbers...",!
	for i=1:1:10 for j=1:1:10 set ^b(i,j)=i_","_j
	for i=1:1:10 write ! for j=1:1:10 w ^b(i,j)," "
	write !
	set i=-1
xlab2	set i=$next(^b(i))
	if i<0 goto xlab3
	write !,i,":"
	set j=-1
xlab2a	set j=$next(^b(i,j))
	if j<0 goto xlab2
	write ^b(i,j)," "
	goto xlab2a
xlab3	write !

	; too confusing - works but disabled
	; read "read with prompt - enter something: ",a
	; write "you wrote ",a,!

	write "Kill test ...",!
	kill ^a(5)
	write "6 ",$n(^a(4)),!
	set i=1
	set j=2
	write "do i and j exist? ",$d(i)," ",$d(j),!
	kill i,j
	write "do i and j exist now? ",$d(i)," ",$d(j),!
	set i=1,j=2,k=3
	write "do i, j and k exist? ",$d(i)," ",$d(j)," ",$d(k),!
	kill (i,k)
	write "do i, j and k exist now? ",$d(i)," ",$d(j)," ",$d(k),!
	set i=10
	set j="i"
	kill @j

	write "Hang test for 1 second ...",!
	hang 1
	write "Was that 1 second?",!

	write "ascending for loop: " for i=1:1:10 w i," "
	write !,"descending for loop: " for i=10:-1:1 w i," "
	write !

# I'm not sure about all these.  $zd is safe, though.

	write "Horolog (wrong) ",$zd," ",$h,!
	write "$zd ",$zd,!
	write "$zd1 - seconds since Jan 1, 1970: ",$zd1,!
	write "$zd2($zd1): ",$zd2($zd1),!
	write "$zd3(1998,11,25) (day of year) ",$zd3(1998,11,25),!
	write "$zd4(1998,329) (Nov 25 1998) ",$zd4(1998,329),!
	write "$zd5(1998,11,25) ",$zd5(1998,11,25),!
	write "$zd6 ",$zd6,!
	write "$zd7 ",$zd7,!
	write "$zd8 ",$zd8,!


	set i="test"
	set j=9
	write "select (test): ",$select(j+1:i,1:2),!

	write "New command ",!
	set i=99
	write "new before ",i,!
	do
	. write "in block before New ",i,!
	. new
	. set i=100
	. write "in block after new ",i,!
	write "new after bloock (99) ",i,!

	set i=1,j=2,k=3
	do
	. new (j,z)
	. write "new test (2) ",j,!
	. set j=99
	. write "new test (00) ",$d(i),$d(k),!
	write "new test (1993) ",i,j,k,!
	do xxx
	write "new test (999) ",j,!
	set i=1,j=2,k=3
	do
	. new j
	. write "(13) ",i,j,k,!
	. set i=100
	. set j=200
	. set k=300
	write "new test (1002300) ",i,j,k,!
	goto yyy

xxx	write "new test subroutine",!
	new (j)
	write "new test (99) ",j,!
	set j=999
	quit

yyy	set b=1
	set c=2
	set aa(1,2)="test array"
	set a=aa(b,c)
	write "array test ... ",a," ",aa(b,c),!

	write "block test",!
	for j=1:1:5 do
	. write "I am an outer block ",j,!
	. for i=1:1:5 do
	.. write "I am an inner block ",i,!
	.. quit
	. quit
	write "I am not a block",!

	write "Value returned by argumentless function: ",$$test1,!
	Set x=123
	Do ^test3(123)

# on entry into a function, a New is done.
# the arguments are instantiated - these become, initially, the
# only variables in the function.  on exit, the New is undone.

	write "Value returned by function: ",$$test2(1,2,3),!

# separately compiled extrinsic - appears at front of program

	write "Value returned by separately compiled extrinsic ",$$^subFunction(1,2,3),!

# indirection can be used with IF, SET and WRITE only.

	write "and, finally, for something completely different...",!
	write "indirection...",!
	set i="2*3"
	set %=@i
	write "@""2+3"" ",%,!
	set ^a(1)=99
	set i="^a(1)+1"
	set %=@i
	write "@",i,"=>",%,!
	set i="^a(j)"
	set j=10
	set @i=999
	set %=@i
	write %,!
	if @i=999 write "yes",!

	halt

test1	set i=12345
	quit "xxx"_i

test2(a,b,c)	; I must have a tab
	quit a+b+c
