//#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+   
//#+     Mumps Compiler 
//#+     Copyright (C) 2000 by Kevin C. O'Kane  
//#+
//#+     Kevin C. O'Kane
//#+     Department of Computer Science
//#+     University of Northern Iowa
//#+     Cedar Falls, IA 50613-0507 USA
//#+
//#+     anamfianna@earthlink.net
//#+     okane@cs.uni.edu
//#+     http://www.cs.uni.edu/~okane
//#+
//#+
//#+ This program is free software; you can redistribute it and/or modify
//#+ it under the terms of the GNU General Public License as published by
//#+ the Free Software Foundation; either version 2 of the License, or
//#+ (at your option) any later version.
//#+ 
//#+ This program is distributed in the hope that it will be useful,
//#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
//#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//#+ GNU General Public License for more details.
//#+ 
//#+ You should have received a copy of the GNU General Public License
//#+ along with this program; if not, write to the Free Software
//#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//#+
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+ This software is covered by the GPL - Not the LGPL.
//#+
//#+ A consequence of this is that if this code is incorporated
//#+ into another work, it causes that work to become covered by
//#+ the GNU GPL license. 
//#+
//#+ Contact the author for other licensing arrangements.
//#+
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+
//#+    Some of this code was originally written in Fortran
//#+    which will explain the odd array and label usage,
//#+    especially arrays beginning at index 1.
//#+
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+
//#+	Not all functions work at present.
//#+
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#include "memsize.h"

#include <stdio.h>
#include <fcntl.h>
#include <math.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <string.h>

#if UNIX==0
#include <process.h>
#include <io.h>

#ifdef MSVC
#include <malloc.h>
#else
#include <mem.h>
#endif

#include <dos.h>
#include <time.h>
#include <conio.h>
#endif

#define GBLBUF 31
#define GBLROOT 30

#define LINEFEED '\012'
#define CR '\15'
#define CTRLZ '\032'
#define TAB '\011'

extern FILE *Out;
void linepad (int, char *);
void cannon (char []);

errmod_ (msgnbr, text, opnfile)

     FILE *opnfile[];
     short msgnbr;
     unsigned char text[];

{

#include "externs.h"

  char msg[80];

  switch (msgnbr - 1) {

case 0:

      strcpy (msg, "multiple operators");
      break;

case 1:

      strcpy (msg, "unmatched quotes");
      break;

case 2:

      strcpy (msg, "global not found");
      break;

case 3:

      strcpy (msg, "expecting comma");
      break;

case 4:

      strcpy (msg, "argument not permitted");
      break;

case 5:

      strcpy (msg, "post-conditional error");
      break;

case 6:

      strcpy (msg, "invalid quote");
      break;

case 7:

      strcpy (msg, "label or file not found");
      break;

case 8:

      strcpy (msg, "too many/few fcn args");
      break;

case 9:

      strcpy (msg, "invalid nbr");
      break;

case 10:

      strcpy (msg, "missing operator");
      break;

case 11:

      strcpy (msg, "unrecognized operator");
      break;

case 12:

      strcpy (msg, "keyword");
      break;

case 13:

      strcpy (msg, "argument list");
      break;

case 14:

      strcpy (msg, "divide by zero");
      break;

case 15:

      strcpy (msg, "invalid expression");
      break;

case 16:

      strcpy (msg, "variable not found");
      break;

case 17:

      strcpy (msg, "invalid reference");
      break;

case 18:

      strcpy (msg, "logical space exceeded");
      break;

case 19:

      strcpy (msg, "I/O Error");
      break;

case 20:

      strcpy (msg, "21");
      break;

case 21:

      strcpy (msg, "22");
      break;

case 22:

      strcpy (msg, "symbol table full");
      break;

case 23:

      strcpy (msg, "function argument error");
      break;

case 24:

      strcpy (msg, "global not permitted");
      break;

case 25:

      strcpy (msg, "file error");
      break;

case 26:

      strcpy (msg, "Next/$Order error");
      break;

case 27:

      strcpy (msg, "28");
      break;

case 28:

      strcpy (msg, "break> at line:");
      break;

case 29:

      strcpy (msg, "function not found");
      break;

case 30:

      strcpy (msg, "program space exceeded");
      break;

case 31:

      strcpy (msg, "stack overflow");
      break;

    }

  printf ("\n>> %d %s", msgnbr, msg);
  printf ("\n>> %s", text);
  return;
}


xindex (source, ptrn, strt)

     unsigned char source[], ptrn[];
     short strt;

{
  short int i, j, k, l, istrt;

  for (i = 0; ptrn[i] != 0; i++); --i;
  for (j = 0; source[j] != 0; j++); --j;
  istrt = strt - 1;
  if (strt <= 1) istrt = 0;
  for (k = istrt; k <= j; k++) {
      for (l = 0; l <= i; l++) {
            if (ptrn[l] != source[k + l]) goto outer;
            }
      return (k + 1);

outer:      ;

    }
  return (0);
}


lpad (strin, strout, l)
     unsigned char strin[], strout[];
     short l;

{
  short int j, i, k;
  j = strlen (strin) - 1;
  k = (l - j - 1);
  if (k <= 0) return;
  for (i = j; i >= 0; i--) strout[i + k] = strin[i];
  strout[j + k + 1] = 0;
  for (i = 0; i < k; i++) strout[i] = ' ';
  return;
}

inout (text, cmnd, col)
     unsigned char text[];
     short cmnd;
     unsigned char col[];

{
#include "externs.h"
  short int i, j, dev;

  switch (cmnd) {

    case 1:			/* new page     */

      fprintf (Out, "\tfprintf(out_file[io],\"\\f\");");
      fprintf (Out, "hor[io]=1; ver[io]=1;\n");
      return;

    case 2:			/* skip line    */

      fprintf (Out, "\tfprintf(out_file[io],\"\\n\"); ");
      fprintf (Out, "hor[io]=0; ver[io]++;\n");
      return;

    case 3:			/* tab */

      // fprintf(Out,"\tfile[5]=stdout;\n");
      fprintf (Out, "\tif (hor[io]>atoi(%s)) {\n", col);
      fprintf (Out, "\t\tfprintf(out_file[io],\"\\n\");\n");
      fprintf (Out,
	       "\t\tfor(i=0;i<atoi(%s);i++) fprintf(out_file[io],\" \");\n",
	       col);
      fprintf (Out, "\t\thor[io]=atoi(%s);\n\t\tver[io]++;\n", col);
      fprintf (Out, "\t\t}\n");
      fprintf (Out, "\telse if (hor[io]<atoi(%s)) {\n", col);
      fprintf (Out,
	       "\t\tfor(i=hor[io];i<atoi(%s);i++) fprintf(out_file[io],\" \");\n",
	       col);
      fprintf (Out, "\t\thor[io]=atoi(%s);\n", col);
      fprintf (Out, "\t\t}\n");
      return;

    case 4:			/* text print */

      //fprintf(Out,"\tfile[5]=stdout;\n");
      fprintf (Out, "\thor[io]+=fprintf(out_file[io],\"%%s\",%s);\n", text);
      return;
    }
}

getstr1 (popn, opnflg, opnfile, lun, area)
     FILE *opnfile[];
     unsigned char area[];
     unsigned char opnflg[];
     short int lun;
     int popn[7][4];

{

#include "externs.h"

  short int i, chr;
  if (opnflg[lun] == 3) {
      area[0] = 27;
      area[1] = 'r';
      area[2] = 0;
      write (popn[lun][1], area, 2);	/* request data */
      i = read (popn[lun][2], area, 1000);
      return (i);
      }

  if (lun == 5) opnfile[lun] = stdin;

  for (i = 0; i < 1000; i++) { /* restrict input line length */
      chr = fgetc (opnfile[lun]);
      if (chr == EOF) {
	  area[0] = 0;
	  return (-1);
	  }

      area[i] = chr;
      if (area[i] == LINEFEED) {
	  area[i] = 0;
	  return (i);
	  }

      if (area[i] > 127) area[i] = ' ';
      if (area[i] == '\n') i--;
      else if (area[i] == '\r') i--;
      else if (area[i] == '\t') area[i] = '\t';
      else if (area[i] < 32) area[i] = ' ';
      }
  
  area[1000] = 0;		/* restricted length */
  return (-1);
}

substr (in, out, start, len)
     short start, len;
     unsigned char in[], out[];

{
  short i;

  if (len == 0) {
      out[0] = 0;
      return;
      }

  if (len < 0) len = 255;
  else if (len > 255) len = 255;

  start--;
  len--;
  for (i = 0; i <= len; i++) out[i] = in[start++];
  out[len + 1] = 0;
  return;
}

int readf_ (unsigned char *zd, int pd1org) {

#include "externs.h"

  short int i, k, n;
  FILE *infile;

  infile = fopen (zd, "r");

  if (infile == NULL) return (0);

  n = pd1org;

  for (i = pd1org; i < symlen; i++) {
      k = getc (infile);
      if (k > 127) continue;
      if (k == CR || k == CTRLZ) continue;

      if (k == LINEFEED) {
	  pd1[n++] = 0;
	  continue;
	  }

      if (k < 1) {
	  fclose (infile);
	  pd1[n] = 0;
	  pd1[n + 1] = 0;
	  pd1len = n - 1;
	  return (1);
	  }

      if (k > 0) pd1[n++] = k;
      }
}

match (pts, lx, ct, ad, rslt)
     short *rslt, pts[3][20], ct[], lx;
     unsigned char ad[];

{

#include "externs.h"

  unsigned char tmp[2], tmp1[1024], tmp2[1024];
  short ptr, i, j;
  ptr = (-1);
  *rslt = 0;
  tmp[1] = 0;
  for (i = 1; i <= lx; i++) {
      if (ct[i] == 0)
	continue;
      switch (bd[pts[1][i]]) {

case 'C':
case 'c':

	  for (j = 1; j <= ct[i]; j++) {
	      ptr++;
	      if (ptr > strlen (ad)) return;
	      if (ad[ptr] < 32) continue;
	      if (ad[ptr] == 127) continue;
	      return;
	      }

	  break;

case 'N':
case 'n':

	  for (j = 1; j <= ct[i]; j++) {
	      ptr++;
	      if (ptr > strlen (ad)) return;
	      if (ad[ptr] >= '0' && ad[ptr] <= '9') continue;
	      return;
	      }			/* for j=... */

	  break;

case 'P':
case 'p':

	  for (j = 1; j <= ct[i]; j++) {
	      ptr++;
	      if (ptr > strlen (ad)) return;
	      tmp[0] = ad[ptr];
	      if (xindex (" !\"#$%&''()*+,-./:;<=>?@[\\]^_`{|}~", tmp, 1) > 0) continue;
	      return;
	      }			/* for j=... */

	  break;

case 'A':
case 'a':

	  for (j = 1; j <= ct[i]; j++) {
	      ptr++;
	      if (ptr > strlen (ad)) return;
	      if (ad[ptr] >= 65 && ad[ptr] <= 90) continue;
	      if (ad[ptr] >= 97 && ad[ptr] <= 122) continue;
	      return;
	      }			/* for j... */

	  break;

case 'L':
case 'l':

	  for (j = 1; j <= ct[i]; j++) {
	      ptr++;
	      if (ptr > strlen (ad)) return;
	      if (ad[ptr] >= 97 && ad[ptr] <= 122) continue;
	      return;
	    }			/*for j=... */

	  break;

case 'U':
case 'u':

	  for (j = 1; j <= ct[i]; j++) {
	      ptr++;
	      if (ptr > strlen (ad)) return;
	      if (ad[ptr] >= 65 && ad[ptr] <= 90) continue;
	      return;
	      }			/* for j=... */

	  break;

case 'E':
case 'e':

	  for (j = 1; j <= ct[i]; j++) {
	      ptr++;
	      if (ptr > strlen (ad)) return;
	      if (ad[ptr] > 127) return;
	      }

	  break;

case '"':

	  for (j = 1; j <= ct[i]; j++) {
	      if (pts[2][i] == 0) continue;
	      if (ptr + pts[2][i] - 1 > strlen (ad)) return;
	      ptr++;
	      substr (&ad[ptr], tmp1, 1, pts[2][i] - 1);
	      substr (&bd[1], tmp2, pts[1][i] + 1, pts[2][i] - 1);
	      if (strcmp (tmp2, tmp1) != 0) return;
	      ptr = ptr + strlen (tmp1) - 1;
	      }

	  break;

default:

	  return;
	  }
    }				/* for i=... */

  if (ptr + 1 != strlen (ad)) return;
  *rslt = 1;
  return;

}				/* match() */

patrn (ad)

     unsigned char ad[];

{

#include "externs.h"

  unsigned char indef, tmp[10];
  short iptr, k, j, i, m, pts[3][20], lx, count[20], ct2[20], stk[20], stx;
  short high[20], low[20], lad;

  indef = 0;
  lx = 0;
  lad = strlen (ad);

  for (i = 0; i < 20; i++) {
      high[i] = lad;
      low[i] = 0;
      }

  for (i = 1; i <= strlen (&bd[1]); i++) {

      lx++;
      if (bd[i] < '0' || bd[i] > '9') {
	  if (bd[i] != '.') i--;
	  count[lx] = (-1);
	  indef = 1;
	  i++;
	  if (bd[i] >= '0' && bd[i] <= '9') {
	      j = i;
	      while (bd[i] >= '0' && bd[i] <= '9')
		i++;
	      substr (&bd[1], tmp, j, i - j);
	      cannon ((char *) tmp);
	      high[lx] = atoi (tmp);
	      }
	  }

      else {
	  j = i;
	  while (bd[i] >= '0' && bd[i] <= '9') i++;
	  substr (&bd[1], tmp, j, i - j);
	  cannon (tmp);
	  count[lx] = atoi (tmp);
	  if (bd[i] == '.') {
	      low[lx] = count[lx];
	      count[lx] = -1;
	      indef = 1;
	      i++;
	      if (bd[i] >= '0' && bd[i] <= '9') {
		  j = i;
		  while (bd[i] >= '0' && bd[i] <= '9') i++;
		  substr (&bd[1], tmp, j, i - j);
		  cannon (tmp);
		  high[lx] = atoi (tmp);
		  }
	      }
	  }

      if (bd[i] != '"') {
	  tmp[0] = bd[i];
	  tmp[1] = 0;
	  if (xindex ("cnpalue", tmp, 1) == 0 &&
	      xindex ("CNPALUE", tmp, 1) == 0) goto err;
	  pts[1][lx] = i;
	  pts[2][lx] = 1;
	  continue;
	  }

      j = i;

      if (bd[j + 1] == '"') {
	  j++;
	  pts[1][lx] = i;
	  pts[2][lx] = 0;
	  i = j;
	  continue;
	  }

a108:

      if (bd[++j] == 0) goto err;

      if (bd[j] != '"') {
	  if (bd[j] == 210) bd[j] = '"';
	  goto a108;
	  }

      pts[1][lx] = i;
      pts[2][lx] = j - i;
      i = j;
      }

  if (indef != 1) {
      match (pts, lx, count, ad, &j);
      ierr1 = j;
      return;
      }

  stx = 0;
  for (i = 1; i <= lx; i++) {
      if (count[i] < 0)
	stk[++stx] = i;
      }

  for (i = 1; i <= lx; i++) {
      if (count[i] >= 0)
	ct2[i] = count[i];
      else
	ct2[i] = low[i];
      }

  iptr = stx;
  goto retry1;

retry:

      ct2[stk[1]]++;

retry1:

      if (ct2[stk[1]] > lad || ct2[stk[1]] > high[stk[1]]) {
            ct2[stk[1]] = low[stk[1]];
            m = 2;
            if (stx == 1) {
	            ierr1 = 0;
	            return;
	            }
            ct2[stk[m]]++;

recount:

            if (ct2[stk[m]] > lad || ct2[stk[m]] > high[stk[m]]) {

                  if (m >= stx) {
                        ierr1 = 0;
                        return;
                        }

                  ct2[stk[m]] = low[stk[m]];
                  m++;
                  ct2[stk[m]]++;
                  goto recount;
                  }
            }

  k = 0;
  for (j = 1; j <= lx; j++) k = k + ct2[j];
  if (k > lad) goto retry;

  match (pts, lx, ct2, ad, &j);

  if ((ierr1 = j) == 1) return;
  goto retry;

err:

      ierr1 = 99;
      return;
}

patrn1 (jpx, ernbr)
  /* pattern argument [right side) set up */
     short *jpx, *ernbr;

{

#include "externs.h"

  static unsigned char tmp1[2], cod210[2] = { 210, 0 };
  tmp1[0] = 0;
  tmp1[1] = 0;

a1285:

      if (xd[*jpx] == '"') {
            strcat (&bd[1], "\"");

a1283:

            *jpx = (*jpx + 1);
            if (xd[*jpx] == 0) {
	            *ernbr = 2;
	            return;
	            }

      if (xd[*jpx] == '"') {
            if (xd[*jpx + 1] != '"')
            goto a1281;
            strcat (&bd[1], cod210);
            *jpx = (*jpx + 1);
            }

      else {
            tmp1[0] = xd[*jpx];
            strcat (&bd[1], tmp1);
            }

      goto a1283;
      }

a1281:

      tmp1[0] = xd[*jpx];

      if (xd[*jpx] != 0) {
            if (xindex (" ,&:!''><=[)+-*/#_", tmp1, 1) == 0) {
	            strcat (&bd[1], tmp1);
	            *jpx = (*jpx + 1);
	            goto a1285;
	            }
            }

  xpx = (*jpx - 1);
  *ernbr = 0;
  return;
}

#if UNIX==0
sigc (void)
#endif

#if UNIX==1
  sigc ()
#endif

{
#include "externs.h"
  ctrlc = 1;
  return (1);
}

#if UNIX==1

itoa (val, str, rad)
     int val, rad;
     char *str;
{

  sprintf (str, "%d", val);
  return;
}


#if SYSTEM!=UNIX

memmove (to, from, count)
     char to[], from[];
     int count;
{
  int j;
  char buf[4096];
  for (j = 0; j < count; j++) buf[j] = from[j];
  for (j = 0; j < count; j++) to[j] = buf[j];
  return;
}
#endif

#ifndef MSVC

strnset (string, chr, size)
     char string[];
     int chr, size;
{
  int i;
  for (i = 0; i < size; i++) string[i] = chr;
  return;
}
#endif

#endif

MyFunc (unsigned char v1d[], int iiitmp) {

  char bd[1024], name[128];
  int i, j, k, l;
  extern short ExitCode;

  for (i = 0; v1d[i] != 0 && v1d[i] < 127 && v1d[i] != ' '; i++) 
    name[i] = v1d[i];
  if (v1d[i] != 0) strcpy (v1d, &v1d[i + 1]);
  else strcpy (v1d, "");
  name[i] = 0;

  j = 1;
  k = 0;

  while (strlen (v1d) > 0) {

      if (k > 9) {
	  printf ("*** Too Many Extrinsic Functions Arguments\n");
	  ExitCode = 99;
	  k = 9;
	  }

      for (i = 0; v1d[i] != 0 && v1d[i] < 127; i++);
      j = v1d[i];
      v1d[i] = 0;
      fprintf (Out,
	       "\tif (_Arg%d==NULL) _Arg%d=(unsigned char *)malloc(256); // Allocate\n",
	       k, k);
      fprintf (Out,
	       "\tif (_Arg%d==NULL) {\n\t\tprintf(\"************** Error - Out of "
	       "Memory in or near line %%d\\n\",LineNumber); \n\t\tgoto _epilogue;}\n",
	       k);
      fprintf (Out, "\tstrcpy(_Arg%d,%s); // Set up arguments\n", k, v1d);
      strcpy (v1d, &v1d[i + 1]);
      k++;
      }

  strcpy (bd, "gtmp");
  fprintf (Out, "\t_ArgCount=%d;\n", k);

  if (name[0] != '^') {
      linepad (fprintf
	       (Out, "\tif (setjmp(_doStack[_doStx++])==0) goto %s;", name),
	       "Jump to function");

      if (iiitmp >= 0)
	fprintf (Out, "\tstrcpy(tmp%d,_ReturnVal); // Copy result\n", iiitmp);
      return;
      }

  fprintf (Out, "\tstrcpy(tmp%d,(char *)%s(", iiitmp, &name[1]);  //#+ function call

  if (k == 0) {
      fprintf (Out, ")); // Call compiled function\n");
      return;
      }

  for (i = 0; i < k - 1; i++) fprintf (Out, "_Arg%d,", i);
  fprintf (Out, "_Arg%d));\n", k - 1);
  return;

}

void linepad (int sent, char *str) {
  int i, j, f=0;
//  i = 40 - strlen (str);
//  if (sent > i) {
//      fprintf (Out, "\n");
//      sent = 0;
//      }
// if (sent>0) fprintf(Out," //");
// else fprintf(Out,"//");
//  for (j = sent; j < i; j++) fprintf (Out, " ");
//  if (sent >40) { fprintf(Out,"\n"); sent=0; f=1;}
  if (sent < 80 ) for (j = sent; j < 80; j++) fprintf (Out, " ");
//  else if (sent < 80 ) for (j = sent; j < 80; j++) fprintf (Out, " ");
//  else if (sent < 120 ) for (j = sent; j < 120; j++) fprintf (Out, " ");
  fprintf (Out, "  //+++ %s\n", str);
//  if (f) fprintf(Out,"\n");
  return;
}

void linepad1 (char * str) {
  int i,j;
  i=fprintf(Out,"/* %s ",str);
  for (j=i; j<25; j++) fprintf(Out,".");
  fprintf(Out,"*/ ");
  return;
  }


void mult( char [], char[], char[]);

void cannon (char a[]) {

  int i, j, k;
  char tmp[25];

i = 0;
j = 0;
while (a[i] == '+' || a[i] == '-') {
    if (a[i] == '-')
      if (j == 0) j = 1;
      else j = 0;
    i++;
    }

if (i > 0) {
    if (j == 0) strcpy (a, &a[i]);
    else {
	a[0] = '-';
	if (i > 1) strcpy (&a[1], &a[i]);
      }
  }

j = -1;
while (a[i] == '.' || (a[i] >= '0' && a[i] <= '9')) {
    if (a[i] == '.')
      j = i;
    i++;
    }

if (i == 0) {
    a[0] = '0';
    a[1] = 0;
    return;
    }

if (a[i] != 'E' && a[i] != 'e') a[i] = 0;

if (a[i] == 0) {
    if (j >= 0) {
	for (i--; a[i] == '0'; i--) a[i] = 0;
	if (a[i] == '.') a[i] = 0;
	if (i == 0) {
	    a[0] = '0';
	    a[1] = 0;
	  }
      }

    if (a[0] == '-') j = 1;
    else j = 0;

    while (a[j] == '0') strcpy (&a[j], &a[j + 1]);

    if (a[j] == 0) {
	a[0] = '0';
	a[1] = 0;
      }

    if (a[j] == '.' && a[j + 1] == 0) a[j] = '0';
    return;
  }

if (a[i] != 'e' && a[i] != 'E') return;

a[i] = 0;
i++;
if (a[i] == '-') {
    i++;
    j = 1;
  }

else {
    j = 0;
    if (a[i] == '+')
      i++;
  }

for (k = 0; (tmp[k] = a[i]) != 0 && (tmp[k] >= '0' && tmp[k] <= '9');
     (k++, i++));

tmp[k] = 0;
i = atoi (tmp);
if (i > 0)
  if (j == 0)
    for (j = 1; j <= i; j++) mult (a, "10", a);
  else for (j = 1; j <= i; j++) mult (a, ".1", a);
return;
}

#if GCVT==1

void gcvt (x, i, a)
     char a[];
     double x;
     int i;

{
  sprintf (a, "%g", x);
  return;
}
#endif

void mult (a, b, c)

     char a[], b[], c[];

{

  float aa, bb, cc;

#if UNIX==1
  double atof ();
#endif

  aa = atof (a);
  bb = atof (b);
  cc = aa * bb;
  gcvt (cc, 7, c);
  return;
}



int readfile(){

long timex;
char xxx[32];

#if WEB==0
return 0;
}

#else

char in[1024];
int i;
int j;
int k;
int flg=0;
int n=0;
int last=0;

FILE *Out;
FILE *Out1;

printf("Content-type: text/html \n\n");
printf("<HTML><HEAD><TITLE> Documents</TITLE></HEAD> <BODY>\n");

strcpy(in,(void *)getenv("CONTENT_LENGTH"));
k=atoi(in);

if (k==0) {
	printf("No file name given</body></html>\n");
	return 1;
	}
Out=fopen("test.file","w");
Out1=fopen("archive","a");
timex=time(&timex);
sprintf(xxx,"%d",timex);
fprintf(Out1,"%s --------------------------------------------------\n\n",ctime(&timex));

for (i=0; i<k; i++) {
		j=getchar();
		if (last=='\n'&&j=='-') break;
		last=j;
		if (j=='\r') continue;
		if (flg) {
			putc(j,Out);
			putc(j,Out1);
			putchar(j);
				}
		if (j=='\n') { 
			n++;
			if (n>2) {
				flg=1;
				putchar('<');
				putchar('b');
				putchar('r');
				putchar('>');
				putchar('/');
				putchar('/');
				putchar(' ');
				}
			}
		}
fclose(Out);
fclose(Out1);
return 0;
}
#endif

