/*******************************************************************************
 *
 *	Adobe Glyph List data for Wine PostScript driver
 *
 *	This data is derived from the Adobe Glyph List at
 *
 *	    http://partners.adobe.com/asn/developer/type/glyphlist.txt
 *
 *	which is Copyright 1998 Adobe Systems Incorporated
 *
 */

#include "psdrv.h"

/*
 *  Every glyph name in the AGL
 *
 */
static const CHAR gndata[] =
{
    "A\0"			/* LATIN CAPITAL LETTER A */
    "AE\0"			/* LATIN CAPITAL LETTER AE */
    "AEacute\0"			/* LATIN CAPITAL LETTER AE WITH ACUTE */
    "AEsmall\0"			/* LATIN SMALL CAPITAL LETTER AE */
    "Aacute\0"			/* LATIN CAPITAL LETTER A WITH ACUTE */
    "Aacutesmall\0"		/* LATIN SMALL CAPITAL LETTER A WITH ACUTE */
    "Abreve\0"			/* LATIN CAPITAL LETTER A WITH BREVE */
    "Acircumflex\0"		/* LATIN CAPITAL LETTER A WITH CIRCUMFLEX */
    "Acircumflexsmall\0"	/* LATIN SMALL CAPITAL LETTER A WITH CIRCUMFLEX */
    "Acute\0"			/* CAPITAL ACUTE ACCENT */
    "Acutesmall\0"		/* SMALL CAPITAL ACUTE ACCENT */
    "Adieresis\0"		/* LATIN CAPITAL LETTER A WITH DIAERESIS */
    "Adieresissmall\0"		/* LATIN SMALL CAPITAL LETTER A WITH DIAERESIS */
    "Agrave\0"			/* LATIN CAPITAL LETTER A WITH GRAVE */
    "Agravesmall\0"		/* LATIN SMALL CAPITAL LETTER A WITH GRAVE */
    "Alpha\0"			/* GREEK CAPITAL LETTER ALPHA */
    "Alphatonos\0"		/* GREEK CAPITAL LETTER ALPHA WITH TONOS */
    "Amacron\0"			/* LATIN CAPITAL LETTER A WITH MACRON */
    "Aogonek\0"			/* LATIN CAPITAL LETTER A WITH OGONEK */
    "Aring\0"			/* LATIN CAPITAL LETTER A WITH RING ABOVE */
    "Aringacute\0"		/* LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE */
    "Aringsmall\0"		/* LATIN SMALL CAPITAL LETTER A WITH RING ABOVE */
    "Asmall\0"			/* LATIN SMALL CAPITAL LETTER A */
    "Atilde\0"			/* LATIN CAPITAL LETTER A WITH TILDE */
    "Atildesmall\0"		/* LATIN SMALL CAPITAL LETTER A WITH TILDE */
    "B\0"			/* LATIN CAPITAL LETTER B */
    "Beta\0"			/* GREEK CAPITAL LETTER BETA */
    "Brevesmall\0"		/* SMALL CAPITAL BREVE */
    "Bsmall\0"			/* LATIN SMALL CAPITAL LETTER B */
    "C\0"			/* LATIN CAPITAL LETTER C */
    "Cacute\0"			/* LATIN CAPITAL LETTER C WITH ACUTE */
    "Caron\0"			/* CAPITAL CARON */
    "Caronsmall\0"		/* SMALL CAPITAL CARON */
    "Ccaron\0"			/* LATIN CAPITAL LETTER C WITH CARON */
    "Ccedilla\0"		/* LATIN CAPITAL LETTER C WITH CEDILLA */
    "Ccedillasmall\0"		/* LATIN SMALL CAPITAL LETTER C WITH CEDILLA */
    "Ccircumflex\0"		/* LATIN CAPITAL LETTER C WITH CIRCUMFLEX */
    "Cdotaccent\0"		/* LATIN CAPITAL LETTER C WITH DOT ABOVE */
    "Cedillasmall\0"		/* SMALL CAPITAL CEDILLA */
    "Chi\0"			/* GREEK CAPITAL LETTER CHI */
    "Circumflexsmall\0"		/* SMALL CAPITAL MODIFIER LETTER CIRCUMFLEX ACCENT */
    "Csmall\0"			/* LATIN SMALL CAPITAL LETTER C */
    "D\0"			/* LATIN CAPITAL LETTER D */
    "Dcaron\0"			/* LATIN CAPITAL LETTER D WITH CARON */
    "Dcroat\0"			/* LATIN CAPITAL LETTER D WITH STROKE */
    "Delta\0"			/* INCREMENT */
				/* GREEK CAPITAL LETTER DELTA;Duplicate */
    "Dieresis\0"		/* CAPITAL DIAERESIS */
    "DieresisAcute\0"		/* CAPITAL DIAERESIS ACUTE ACCENT */
    "DieresisGrave\0"		/* CAPITAL DIAERESIS GRAVE ACCENT */
    "Dieresissmall\0"		/* SMALL CAPITAL DIAERESIS */
    "Dotaccentsmall\0"		/* SMALL CAPITAL DOT ABOVE */
    "Dsmall\0"			/* LATIN SMALL CAPITAL LETTER D */
    "E\0"			/* LATIN CAPITAL LETTER E */
    "Eacute\0"			/* LATIN CAPITAL LETTER E WITH ACUTE */
    "Eacutesmall\0"		/* LATIN SMALL CAPITAL LETTER E WITH ACUTE */
    "Ebreve\0"			/* LATIN CAPITAL LETTER E WITH BREVE */
    "Ecaron\0"			/* LATIN CAPITAL LETTER E WITH CARON */
    "Ecircumflex\0"		/* LATIN CAPITAL LETTER E WITH CIRCUMFLEX */
    "Ecircumflexsmall\0"	/* LATIN SMALL CAPITAL LETTER E WITH CIRCUMFLEX */
    "Edieresis\0"		/* LATIN CAPITAL LETTER E WITH DIAERESIS */
    "Edieresissmall\0"		/* LATIN SMALL CAPITAL LETTER E WITH DIAERESIS */
    "Edotaccent\0"		/* LATIN CAPITAL LETTER E WITH DOT ABOVE */
    "Egrave\0"			/* LATIN CAPITAL LETTER E WITH GRAVE */
    "Egravesmall\0"		/* LATIN SMALL CAPITAL LETTER E WITH GRAVE */
    "Emacron\0"			/* LATIN CAPITAL LETTER E WITH MACRON */
    "Eng\0"			/* LATIN CAPITAL LETTER ENG */
    "Eogonek\0"			/* LATIN CAPITAL LETTER E WITH OGONEK */
    "Epsilon\0"			/* GREEK CAPITAL LETTER EPSILON */
    "Epsilontonos\0"		/* GREEK CAPITAL LETTER EPSILON WITH TONOS */
    "Esmall\0"			/* LATIN SMALL CAPITAL LETTER E */
    "Eta\0"			/* GREEK CAPITAL LETTER ETA */
    "Etatonos\0"		/* GREEK CAPITAL LETTER ETA WITH TONOS */
    "Eth\0"			/* LATIN CAPITAL LETTER ETH */
    "Ethsmall\0"		/* LATIN SMALL CAPITAL LETTER ETH */
    "Euro\0"			/* EURO SIGN */
    "F\0"			/* LATIN CAPITAL LETTER F */
    "Fsmall\0"			/* LATIN SMALL CAPITAL LETTER F */
    "G\0"			/* LATIN CAPITAL LETTER G */
    "Gamma\0"			/* GREEK CAPITAL LETTER GAMMA */
    "Gbreve\0"			/* LATIN CAPITAL LETTER G WITH BREVE */
    "Gcaron\0"			/* LATIN CAPITAL LETTER G WITH CARON */
    "Gcircumflex\0"		/* LATIN CAPITAL LETTER G WITH CIRCUMFLEX */
    "Gcommaaccent\0"		/* LATIN CAPITAL LETTER G WITH CEDILLA */
    "Gdotaccent\0"		/* LATIN CAPITAL LETTER G WITH DOT ABOVE */
    "Grave\0"			/* CAPITAL GRAVE ACCENT */
    "Gravesmall\0"		/* SMALL CAPITAL GRAVE ACCENT */
    "Gsmall\0"			/* LATIN SMALL CAPITAL LETTER G */
    "H\0"			/* LATIN CAPITAL LETTER H */
    "H18533\0"			/* BLACK CIRCLE */
    "H18543\0"			/* BLACK SMALL SQUARE */
    "H18551\0"			/* WHITE SMALL SQUARE */
    "H22073\0"			/* WHITE SQUARE */
    "Hbar\0"			/* LATIN CAPITAL LETTER H WITH STROKE */
    "Hcircumflex\0"		/* LATIN CAPITAL LETTER H WITH CIRCUMFLEX */
    "Hsmall\0"			/* LATIN SMALL CAPITAL LETTER H */
    "Hungarumlaut\0"		/* CAPITAL DOUBLE ACUTE ACCENT */
    "Hungarumlautsmall\0"	/* SMALL CAPITAL DOUBLE ACUTE ACCENT */
    "I\0"			/* LATIN CAPITAL LETTER I */
    "IJ\0"			/* LATIN CAPITAL LIGATURE IJ */
    "Iacute\0"			/* LATIN CAPITAL LETTER I WITH ACUTE */
    "Iacutesmall\0"		/* LATIN SMALL CAPITAL LETTER I WITH ACUTE */
    "Ibreve\0"			/* LATIN CAPITAL LETTER I WITH BREVE */
    "Icircumflex\0"		/* LATIN CAPITAL LETTER I WITH CIRCUMFLEX */
    "Icircumflexsmall\0"	/* LATIN SMALL CAPITAL LETTER I WITH CIRCUMFLEX */
    "Idieresis\0"		/* LATIN CAPITAL LETTER I WITH DIAERESIS */
    "Idieresissmall\0"		/* LATIN SMALL CAPITAL LETTER I WITH DIAERESIS */
    "Idotaccent\0"		/* LATIN CAPITAL LETTER I WITH DOT ABOVE */
    "Ifraktur\0"		/* BLACK-LETTER CAPITAL I */
    "Igrave\0"			/* LATIN CAPITAL LETTER I WITH GRAVE */
    "Igravesmall\0"		/* LATIN SMALL CAPITAL LETTER I WITH GRAVE */
    "Imacron\0"			/* LATIN CAPITAL LETTER I WITH MACRON */
    "Iogonek\0"			/* LATIN CAPITAL LETTER I WITH OGONEK */
    "Iota\0"			/* GREEK CAPITAL LETTER IOTA */
    "Iotadieresis\0"		/* GREEK CAPITAL LETTER IOTA WITH DIALYTIKA */
    "Iotatonos\0"		/* GREEK CAPITAL LETTER IOTA WITH TONOS */
    "Ismall\0"			/* LATIN SMALL CAPITAL LETTER I */
    "Itilde\0"			/* LATIN CAPITAL LETTER I WITH TILDE */
    "J\0"			/* LATIN CAPITAL LETTER J */
    "Jcircumflex\0"		/* LATIN CAPITAL LETTER J WITH CIRCUMFLEX */
    "Jsmall\0"			/* LATIN SMALL CAPITAL LETTER J */
    "K\0"			/* LATIN CAPITAL LETTER K */
    "Kappa\0"			/* GREEK CAPITAL LETTER KAPPA */
    "Kcommaaccent\0"		/* LATIN CAPITAL LETTER K WITH CEDILLA */
    "Ksmall\0"			/* LATIN SMALL CAPITAL LETTER K */
    "L\0"			/* LATIN CAPITAL LETTER L */
    "LL\0"			/* LATIN CAPITAL LETTER LL */
    "Lacute\0"			/* LATIN CAPITAL LETTER L WITH ACUTE */
    "Lambda\0"			/* GREEK CAPITAL LETTER LAMDA */
    "Lcaron\0"			/* LATIN CAPITAL LETTER L WITH CARON */
    "Lcommaaccent\0"		/* LATIN CAPITAL LETTER L WITH CEDILLA */
    "Ldot\0"			/* LATIN CAPITAL LETTER L WITH MIDDLE DOT */
    "Lslash\0"			/* LATIN CAPITAL LETTER L WITH STROKE */
    "Lslashsmall\0"		/* LATIN SMALL CAPITAL LETTER L WITH STROKE */
    "Lsmall\0"			/* LATIN SMALL CAPITAL LETTER L */
    "M\0"			/* LATIN CAPITAL LETTER M */
    "Macron\0"			/* CAPITAL MACRON */
    "Macronsmall\0"		/* SMALL CAPITAL MACRON */
    "Msmall\0"			/* LATIN SMALL CAPITAL LETTER M */
    "Mu\0"			/* GREEK CAPITAL LETTER MU */
    "N\0"			/* LATIN CAPITAL LETTER N */
    "Nacute\0"			/* LATIN CAPITAL LETTER N WITH ACUTE */
    "Ncaron\0"			/* LATIN CAPITAL LETTER N WITH CARON */
    "Ncommaaccent\0"		/* LATIN CAPITAL LETTER N WITH CEDILLA */
    "Nsmall\0"			/* LATIN SMALL CAPITAL LETTER N */
    "Ntilde\0"			/* LATIN CAPITAL LETTER N WITH TILDE */
    "Ntildesmall\0"		/* LATIN SMALL CAPITAL LETTER N WITH TILDE */
    "Nu\0"			/* GREEK CAPITAL LETTER NU */
    "O\0"			/* LATIN CAPITAL LETTER O */
    "OE\0"			/* LATIN CAPITAL LIGATURE OE */
    "OEsmall\0"			/* LATIN SMALL CAPITAL LIGATURE OE */
    "Oacute\0"			/* LATIN CAPITAL LETTER O WITH ACUTE */
    "Oacutesmall\0"		/* LATIN SMALL CAPITAL LETTER O WITH ACUTE */
    "Obreve\0"			/* LATIN CAPITAL LETTER O WITH BREVE */
    "Ocircumflex\0"		/* LATIN CAPITAL LETTER O WITH CIRCUMFLEX */
    "Ocircumflexsmall\0"	/* LATIN SMALL CAPITAL LETTER O WITH CIRCUMFLEX */
    "Odieresis\0"		/* LATIN CAPITAL LETTER O WITH DIAERESIS */
    "Odieresissmall\0"		/* LATIN SMALL CAPITAL LETTER O WITH DIAERESIS */
    "Ogoneksmall\0"		/* SMALL CAPITAL OGONEK */
    "Ograve\0"			/* LATIN CAPITAL LETTER O WITH GRAVE */
    "Ogravesmall\0"		/* LATIN SMALL CAPITAL LETTER O WITH GRAVE */
    "Ohorn\0"			/* LATIN CAPITAL LETTER O WITH HORN */
    "Ohungarumlaut\0"		/* LATIN CAPITAL LETTER O WITH DOUBLE ACUTE */
    "Omacron\0"			/* LATIN CAPITAL LETTER O WITH MACRON */
    "Omega\0"			/* OHM SIGN */
				/* GREEK CAPITAL LETTER OMEGA;Duplicate */
    "Omegatonos\0"		/* GREEK CAPITAL LETTER OMEGA WITH TONOS */
    "Omicron\0"			/* GREEK CAPITAL LETTER OMICRON */
    "Omicrontonos\0"		/* GREEK CAPITAL LETTER OMICRON WITH TONOS */
    "Oslash\0"			/* LATIN CAPITAL LETTER O WITH STROKE */
    "Oslashacute\0"		/* LATIN CAPITAL LETTER O WITH STROKE AND ACUTE */
    "Oslashsmall\0"		/* LATIN SMALL CAPITAL LETTER O WITH STROKE */
    "Osmall\0"			/* LATIN SMALL CAPITAL LETTER O */
    "Otilde\0"			/* LATIN CAPITAL LETTER O WITH TILDE */
    "Otildesmall\0"		/* LATIN SMALL CAPITAL LETTER O WITH TILDE */
    "P\0"			/* LATIN CAPITAL LETTER P */
    "Phi\0"			/* GREEK CAPITAL LETTER PHI */
    "Pi\0"			/* GREEK CAPITAL LETTER PI */
    "Psi\0"			/* GREEK CAPITAL LETTER PSI */
    "Psmall\0"			/* LATIN SMALL CAPITAL LETTER P */
    "Q\0"			/* LATIN CAPITAL LETTER Q */
    "Qsmall\0"			/* LATIN SMALL CAPITAL LETTER Q */
    "R\0"			/* LATIN CAPITAL LETTER R */
    "Racute\0"			/* LATIN CAPITAL LETTER R WITH ACUTE */
    "Rcaron\0"			/* LATIN CAPITAL LETTER R WITH CARON */
    "Rcommaaccent\0"		/* LATIN CAPITAL LETTER R WITH CEDILLA */
    "Rfraktur\0"		/* BLACK-LETTER CAPITAL R */
    "Rho\0"			/* GREEK CAPITAL LETTER RHO */
    "Ringsmall\0"		/* SMALL CAPITAL RING ABOVE */
    "Rsmall\0"			/* LATIN SMALL CAPITAL LETTER R */
    "S\0"			/* LATIN CAPITAL LETTER S */
    "SF010000\0"		/* BOX DRAWINGS LIGHT DOWN AND RIGHT */
    "SF020000\0"		/* BOX DRAWINGS LIGHT UP AND RIGHT */
    "SF030000\0"		/* BOX DRAWINGS LIGHT DOWN AND LEFT */
    "SF040000\0"		/* BOX DRAWINGS LIGHT UP AND LEFT */
    "SF050000\0"		/* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
    "SF060000\0"		/* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
    "SF070000\0"		/* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
    "SF080000\0"		/* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
    "SF090000\0"		/* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
    "SF100000\0"		/* BOX DRAWINGS LIGHT HORIZONTAL */
    "SF110000\0"		/* BOX DRAWINGS LIGHT VERTICAL */
    "SF190000\0"		/* BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE */
    "SF200000\0"		/* BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE */
    "SF210000\0"		/* BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE */
    "SF220000\0"		/* BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE */
    "SF230000\0"		/* BOX DRAWINGS DOUBLE VERTICAL AND LEFT */
    "SF240000\0"		/* BOX DRAWINGS DOUBLE VERTICAL */
    "SF250000\0"		/* BOX DRAWINGS DOUBLE DOWN AND LEFT */
    "SF260000\0"		/* BOX DRAWINGS DOUBLE UP AND LEFT */
    "SF270000\0"		/* BOX DRAWINGS UP DOUBLE AND LEFT SINGLE */
    "SF280000\0"		/* BOX DRAWINGS UP SINGLE AND LEFT DOUBLE */
    "SF360000\0"		/* BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE */
    "SF370000\0"		/* BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE */
    "SF380000\0"		/* BOX DRAWINGS DOUBLE UP AND RIGHT */
    "SF390000\0"		/* BOX DRAWINGS DOUBLE DOWN AND RIGHT */
    "SF400000\0"		/* BOX DRAWINGS DOUBLE UP AND HORIZONTAL */
    "SF410000\0"		/* BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL */
    "SF420000\0"		/* BOX DRAWINGS DOUBLE VERTICAL AND RIGHT */
    "SF430000\0"		/* BOX DRAWINGS DOUBLE HORIZONTAL */
    "SF440000\0"		/* BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL */
    "SF450000\0"		/* BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE */
    "SF460000\0"		/* BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE */
    "SF470000\0"		/* BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE */
    "SF480000\0"		/* BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE */
    "SF490000\0"		/* BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE */
    "SF500000\0"		/* BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE */
    "SF510000\0"		/* BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE */
    "SF520000\0"		/* BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE */
    "SF530000\0"		/* BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE */
    "SF540000\0"		/* BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE */
    "Sacute\0"			/* LATIN CAPITAL LETTER S WITH ACUTE */
    "Scaron\0"			/* LATIN CAPITAL LETTER S WITH CARON */
    "Scaronsmall\0"		/* LATIN SMALL CAPITAL LETTER S WITH CARON */
    "Scedilla\0"		/* LATIN CAPITAL LETTER S WITH CEDILLA */
				/* LATIN CAPITAL LETTER S WITH CEDILLA;Duplicate */
    "Scircumflex\0"		/* LATIN CAPITAL LETTER S WITH CIRCUMFLEX */
    "Scommaaccent\0"		/* LATIN CAPITAL LETTER S WITH COMMA BELOW */
    "Sigma\0"			/* GREEK CAPITAL LETTER SIGMA */
    "Ssmall\0"			/* LATIN SMALL CAPITAL LETTER S */
    "T\0"			/* LATIN CAPITAL LETTER T */
    "Tau\0"			/* GREEK CAPITAL LETTER TAU */
    "Tbar\0"			/* LATIN CAPITAL LETTER T WITH STROKE */
    "Tcaron\0"			/* LATIN CAPITAL LETTER T WITH CARON */
    "Tcommaaccent\0"		/* LATIN CAPITAL LETTER T WITH CEDILLA */
				/* LATIN CAPITAL LETTER T WITH COMMA BELOW;Duplicate */
    "Theta\0"			/* GREEK CAPITAL LETTER THETA */
    "Thorn\0"			/* LATIN CAPITAL LETTER THORN */
    "Thornsmall\0"		/* LATIN SMALL CAPITAL LETTER THORN */
    "Tildesmall\0"		/* SMALL CAPITAL SMALL TILDE */
    "Tsmall\0"			/* LATIN SMALL CAPITAL LETTER T */
    "U\0"			/* LATIN CAPITAL LETTER U */
    "Uacute\0"			/* LATIN CAPITAL LETTER U WITH ACUTE */
    "Uacutesmall\0"		/* LATIN SMALL CAPITAL LETTER U WITH ACUTE */
    "Ubreve\0"			/* LATIN CAPITAL LETTER U WITH BREVE */
    "Ucircumflex\0"		/* LATIN CAPITAL LETTER U WITH CIRCUMFLEX */
    "Ucircumflexsmall\0"	/* LATIN SMALL CAPITAL LETTER U WITH CIRCUMFLEX */
    "Udieresis\0"		/* LATIN CAPITAL LETTER U WITH DIAERESIS */
    "Udieresissmall\0"		/* LATIN SMALL CAPITAL LETTER U WITH DIAERESIS */
    "Ugrave\0"			/* LATIN CAPITAL LETTER U WITH GRAVE */
    "Ugravesmall\0"		/* LATIN SMALL CAPITAL LETTER U WITH GRAVE */
    "Uhorn\0"			/* LATIN CAPITAL LETTER U WITH HORN */
    "Uhungarumlaut\0"		/* LATIN CAPITAL LETTER U WITH DOUBLE ACUTE */
    "Umacron\0"			/* LATIN CAPITAL LETTER U WITH MACRON */
    "Uogonek\0"			/* LATIN CAPITAL LETTER U WITH OGONEK */
    "Upsilon\0"			/* GREEK CAPITAL LETTER UPSILON */
    "Upsilon1\0"		/* GREEK UPSILON WITH HOOK SYMBOL */
    "Upsilondieresis\0"		/* GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA */
    "Upsilontonos\0"		/* GREEK CAPITAL LETTER UPSILON WITH TONOS */
    "Uring\0"			/* LATIN CAPITAL LETTER U WITH RING ABOVE */
    "Usmall\0"			/* LATIN SMALL CAPITAL LETTER U */
    "Utilde\0"			/* LATIN CAPITAL LETTER U WITH TILDE */
    "V\0"			/* LATIN CAPITAL LETTER V */
    "Vsmall\0"			/* LATIN SMALL CAPITAL LETTER V */
    "W\0"			/* LATIN CAPITAL LETTER W */
    "Wacute\0"			/* LATIN CAPITAL LETTER W WITH ACUTE */
    "Wcircumflex\0"		/* LATIN CAPITAL LETTER W WITH CIRCUMFLEX */
    "Wdieresis\0"		/* LATIN CAPITAL LETTER W WITH DIAERESIS */
    "Wgrave\0"			/* LATIN CAPITAL LETTER W WITH GRAVE */
    "Wsmall\0"			/* LATIN SMALL CAPITAL LETTER W */
    "X\0"			/* LATIN CAPITAL LETTER X */
    "Xi\0"			/* GREEK CAPITAL LETTER XI */
    "Xsmall\0"			/* LATIN SMALL CAPITAL LETTER X */
    "Y\0"			/* LATIN CAPITAL LETTER Y */
    "Yacute\0"			/* LATIN CAPITAL LETTER Y WITH ACUTE */
    "Yacutesmall\0"		/* LATIN SMALL CAPITAL LETTER Y WITH ACUTE */
    "Ycircumflex\0"		/* LATIN CAPITAL LETTER Y WITH CIRCUMFLEX */
    "Ydieresis\0"		/* LATIN CAPITAL LETTER Y WITH DIAERESIS */
    "Ydieresissmall\0"		/* LATIN SMALL CAPITAL LETTER Y WITH DIAERESIS */
    "Ygrave\0"			/* LATIN CAPITAL LETTER Y WITH GRAVE */
    "Ysmall\0"			/* LATIN SMALL CAPITAL LETTER Y */
    "Z\0"			/* LATIN CAPITAL LETTER Z */
    "Zacute\0"			/* LATIN CAPITAL LETTER Z WITH ACUTE */
    "Zcaron\0"			/* LATIN CAPITAL LETTER Z WITH CARON */
    "Zcaronsmall\0"		/* LATIN SMALL CAPITAL LETTER Z WITH CARON */
    "Zdotaccent\0"		/* LATIN CAPITAL LETTER Z WITH DOT ABOVE */
    "Zeta\0"			/* GREEK CAPITAL LETTER ZETA */
    "Zsmall\0"			/* LATIN SMALL CAPITAL LETTER Z */
    "a\0"			/* LATIN SMALL LETTER A */
    "aacute\0"			/* LATIN SMALL LETTER A WITH ACUTE */
    "abreve\0"			/* LATIN SMALL LETTER A WITH BREVE */
    "acircumflex\0"		/* LATIN SMALL LETTER A WITH CIRCUMFLEX */
    "acute\0"			/* ACUTE ACCENT */
    "acutecomb\0"		/* COMBINING ACUTE ACCENT */
    "adieresis\0"		/* LATIN SMALL LETTER A WITH DIAERESIS */
    "ae\0"			/* LATIN SMALL LETTER AE */
    "aeacute\0"			/* LATIN SMALL LETTER AE WITH ACUTE */
    "afii00208\0"		/* HORIZONTAL BAR */
    "afii10017\0"		/* CYRILLIC CAPITAL LETTER A */
    "afii10018\0"		/* CYRILLIC CAPITAL LETTER BE */
    "afii10019\0"		/* CYRILLIC CAPITAL LETTER VE */
    "afii10020\0"		/* CYRILLIC CAPITAL LETTER GHE */
    "afii10021\0"		/* CYRILLIC CAPITAL LETTER DE */
    "afii10022\0"		/* CYRILLIC CAPITAL LETTER IE */
    "afii10023\0"		/* CYRILLIC CAPITAL LETTER IO */
    "afii10024\0"		/* CYRILLIC CAPITAL LETTER ZHE */
    "afii10025\0"		/* CYRILLIC CAPITAL LETTER ZE */
    "afii10026\0"		/* CYRILLIC CAPITAL LETTER I */
    "afii10027\0"		/* CYRILLIC CAPITAL LETTER SHORT I */
    "afii10028\0"		/* CYRILLIC CAPITAL LETTER KA */
    "afii10029\0"		/* CYRILLIC CAPITAL LETTER EL */
    "afii10030\0"		/* CYRILLIC CAPITAL LETTER EM */
    "afii10031\0"		/* CYRILLIC CAPITAL LETTER EN */
    "afii10032\0"		/* CYRILLIC CAPITAL LETTER O */
    "afii10033\0"		/* CYRILLIC CAPITAL LETTER PE */
    "afii10034\0"		/* CYRILLIC CAPITAL LETTER ER */
    "afii10035\0"		/* CYRILLIC CAPITAL LETTER ES */
    "afii10036\0"		/* CYRILLIC CAPITAL LETTER TE */
    "afii10037\0"		/* CYRILLIC CAPITAL LETTER U */
    "afii10038\0"		/* CYRILLIC CAPITAL LETTER EF */
    "afii10039\0"		/* CYRILLIC CAPITAL LETTER HA */
    "afii10040\0"		/* CYRILLIC CAPITAL LETTER TSE */
    "afii10041\0"		/* CYRILLIC CAPITAL LETTER CHE */
    "afii10042\0"		/* CYRILLIC CAPITAL LETTER SHA */
    "afii10043\0"		/* CYRILLIC CAPITAL LETTER SHCHA */
    "afii10044\0"		/* CYRILLIC CAPITAL LETTER HARD SIGN */
    "afii10045\0"		/* CYRILLIC CAPITAL LETTER YERU */
    "afii10046\0"		/* CYRILLIC CAPITAL LETTER SOFT SIGN */
    "afii10047\0"		/* CYRILLIC CAPITAL LETTER E */
    "afii10048\0"		/* CYRILLIC CAPITAL LETTER YU */
    "afii10049\0"		/* CYRILLIC CAPITAL LETTER YA */
    "afii10050\0"		/* CYRILLIC CAPITAL LETTER GHE WITH UPTURN */
    "afii10051\0"		/* CYRILLIC CAPITAL LETTER DJE */
    "afii10052\0"		/* CYRILLIC CAPITAL LETTER GJE */
    "afii10053\0"		/* CYRILLIC CAPITAL LETTER UKRAINIAN IE */
    "afii10054\0"		/* CYRILLIC CAPITAL LETTER DZE */
    "afii10055\0"		/* CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I */
    "afii10056\0"		/* CYRILLIC CAPITAL LETTER YI */
    "afii10057\0"		/* CYRILLIC CAPITAL LETTER JE */
    "afii10058\0"		/* CYRILLIC CAPITAL LETTER LJE */
    "afii10059\0"		/* CYRILLIC CAPITAL LETTER NJE */
    "afii10060\0"		/* CYRILLIC CAPITAL LETTER TSHE */
    "afii10061\0"		/* CYRILLIC CAPITAL LETTER KJE */
    "afii10062\0"		/* CYRILLIC CAPITAL LETTER SHORT U */
    "afii10063\0"		/* CYRILLIC SMALL LETTER GHE VARIANT */
    "afii10064\0"		/* CYRILLIC SMALL LETTER BE VARIANT */
    "afii10065\0"		/* CYRILLIC SMALL LETTER A */
    "afii10066\0"		/* CYRILLIC SMALL LETTER BE */
    "afii10067\0"		/* CYRILLIC SMALL LETTER VE */
    "afii10068\0"		/* CYRILLIC SMALL LETTER GHE */
    "afii10069\0"		/* CYRILLIC SMALL LETTER DE */
    "afii10070\0"		/* CYRILLIC SMALL LETTER IE */
    "afii10071\0"		/* CYRILLIC SMALL LETTER IO */
    "afii10072\0"		/* CYRILLIC SMALL LETTER ZHE */
    "afii10073\0"		/* CYRILLIC SMALL LETTER ZE */
    "afii10074\0"		/* CYRILLIC SMALL LETTER I */
    "afii10075\0"		/* CYRILLIC SMALL LETTER SHORT I */
    "afii10076\0"		/* CYRILLIC SMALL LETTER KA */
    "afii10077\0"		/* CYRILLIC SMALL LETTER EL */
    "afii10078\0"		/* CYRILLIC SMALL LETTER EM */
    "afii10079\0"		/* CYRILLIC SMALL LETTER EN */
    "afii10080\0"		/* CYRILLIC SMALL LETTER O */
    "afii10081\0"		/* CYRILLIC SMALL LETTER PE */
    "afii10082\0"		/* CYRILLIC SMALL LETTER ER */
    "afii10083\0"		/* CYRILLIC SMALL LETTER ES */
    "afii10084\0"		/* CYRILLIC SMALL LETTER TE */
    "afii10085\0"		/* CYRILLIC SMALL LETTER U */
    "afii10086\0"		/* CYRILLIC SMALL LETTER EF */
    "afii10087\0"		/* CYRILLIC SMALL LETTER HA */
    "afii10088\0"		/* CYRILLIC SMALL LETTER TSE */
    "afii10089\0"		/* CYRILLIC SMALL LETTER CHE */
    "afii10090\0"		/* CYRILLIC SMALL LETTER SHA */
    "afii10091\0"		/* CYRILLIC SMALL LETTER SHCHA */
    "afii10092\0"		/* CYRILLIC SMALL LETTER HARD SIGN */
    "afii10093\0"		/* CYRILLIC SMALL LETTER YERU */
    "afii10094\0"		/* CYRILLIC SMALL LETTER SOFT SIGN */
    "afii10095\0"		/* CYRILLIC SMALL LETTER E */
    "afii10096\0"		/* CYRILLIC SMALL LETTER YU */
    "afii10097\0"		/* CYRILLIC SMALL LETTER YA */
    "afii10098\0"		/* CYRILLIC SMALL LETTER GHE WITH UPTURN */
    "afii10099\0"		/* CYRILLIC SMALL LETTER DJE */
    "afii10100\0"		/* CYRILLIC SMALL LETTER GJE */
    "afii10101\0"		/* CYRILLIC SMALL LETTER UKRAINIAN IE */
    "afii10102\0"		/* CYRILLIC SMALL LETTER DZE */
    "afii10103\0"		/* CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I */
    "afii10104\0"		/* CYRILLIC SMALL LETTER YI */
    "afii10105\0"		/* CYRILLIC SMALL LETTER JE */
    "afii10106\0"		/* CYRILLIC SMALL LETTER LJE */
    "afii10107\0"		/* CYRILLIC SMALL LETTER NJE */
    "afii10108\0"		/* CYRILLIC SMALL LETTER TSHE */
    "afii10109\0"		/* CYRILLIC SMALL LETTER KJE */
    "afii10110\0"		/* CYRILLIC SMALL LETTER SHORT U */
    "afii10145\0"		/* CYRILLIC CAPITAL LETTER DZHE */
    "afii10146\0"		/* CYRILLIC CAPITAL LETTER YAT */
    "afii10147\0"		/* CYRILLIC CAPITAL LETTER FITA */
    "afii10148\0"		/* CYRILLIC CAPITAL LETTER IZHITSA */
    "afii10192\0"		/* CYRILLIC SMALL LETTER DE VARIANT */
    "afii10193\0"		/* CYRILLIC SMALL LETTER DZHE */
    "afii10194\0"		/* CYRILLIC SMALL LETTER YAT */
    "afii10195\0"		/* CYRILLIC SMALL LETTER FITA */
    "afii10196\0"		/* CYRILLIC SMALL LETTER IZHITSA */
    "afii10831\0"		/* CYRILLIC SMALL LETTER PE VARIANT */
    "afii10832\0"		/* CYRILLIC SMALL LETTER TE VARIANT */
    "afii10846\0"		/* CYRILLIC SMALL LETTER SCHWA */
    "afii299\0"			/* LEFT-TO-RIGHT MARK */
    "afii300\0"			/* RIGHT-TO-LEFT MARK */
    "afii301\0"			/* ZERO WIDTH JOINER */
    "afii57381\0"		/* ARABIC PERCENT SIGN */
    "afii57388\0"		/* ARABIC COMMA */
    "afii57392\0"		/* ARABIC-INDIC DIGIT ZERO */
    "afii57393\0"		/* ARABIC-INDIC DIGIT ONE */
    "afii57394\0"		/* ARABIC-INDIC DIGIT TWO */
    "afii57395\0"		/* ARABIC-INDIC DIGIT THREE */
    "afii57396\0"		/* ARABIC-INDIC DIGIT FOUR */
    "afii57397\0"		/* ARABIC-INDIC DIGIT FIVE */
    "afii57398\0"		/* ARABIC-INDIC DIGIT SIX */
    "afii57399\0"		/* ARABIC-INDIC DIGIT SEVEN */
    "afii57400\0"		/* ARABIC-INDIC DIGIT EIGHT */
    "afii57401\0"		/* ARABIC-INDIC DIGIT NINE */
    "afii57403\0"		/* ARABIC SEMICOLON */
    "afii57407\0"		/* ARABIC QUESTION MARK */
    "afii57409\0"		/* ARABIC LETTER HAMZA */
    "afii57410\0"		/* ARABIC LETTER ALEF WITH MADDA ABOVE */
    "afii57411\0"		/* ARABIC LETTER ALEF WITH HAMZA ABOVE */
    "afii57412\0"		/* ARABIC LETTER WAW WITH HAMZA ABOVE */
    "afii57413\0"		/* ARABIC LETTER ALEF WITH HAMZA BELOW */
    "afii57414\0"		/* ARABIC LETTER YEH WITH HAMZA ABOVE */
    "afii57415\0"		/* ARABIC LETTER ALEF */
    "afii57416\0"		/* ARABIC LETTER BEH */
    "afii57417\0"		/* ARABIC LETTER TEH MARBUTA */
    "afii57418\0"		/* ARABIC LETTER TEH */
    "afii57419\0"		/* ARABIC LETTER THEH */
    "afii57420\0"		/* ARABIC LETTER JEEM */
    "afii57421\0"		/* ARABIC LETTER HAH */
    "afii57422\0"		/* ARABIC LETTER KHAH */
    "afii57423\0"		/* ARABIC LETTER DAL */
    "afii57424\0"		/* ARABIC LETTER THAL */
    "afii57425\0"		/* ARABIC LETTER REH */
    "afii57426\0"		/* ARABIC LETTER ZAIN */
    "afii57427\0"		/* ARABIC LETTER SEEN */
    "afii57428\0"		/* ARABIC LETTER SHEEN */
    "afii57429\0"		/* ARABIC LETTER SAD */
    "afii57430\0"		/* ARABIC LETTER DAD */
    "afii57431\0"		/* ARABIC LETTER TAH */
    "afii57432\0"		/* ARABIC LETTER ZAH */
    "afii57433\0"		/* ARABIC LETTER AIN */
    "afii57434\0"		/* ARABIC LETTER GHAIN */
    "afii57440\0"		/* ARABIC TATWEEL */
    "afii57441\0"		/* ARABIC LETTER FEH */
    "afii57442\0"		/* ARABIC LETTER QAF */
    "afii57443\0"		/* ARABIC LETTER KAF */
    "afii57444\0"		/* ARABIC LETTER LAM */
    "afii57445\0"		/* ARABIC LETTER MEEM */
    "afii57446\0"		/* ARABIC LETTER NOON */
    "afii57448\0"		/* ARABIC LETTER WAW */
    "afii57449\0"		/* ARABIC LETTER ALEF MAKSURA */
    "afii57450\0"		/* ARABIC LETTER YEH */
    "afii57451\0"		/* ARABIC FATHATAN */
    "afii57452\0"		/* ARABIC DAMMATAN */
    "afii57453\0"		/* ARABIC KASRATAN */
    "afii57454\0"		/* ARABIC FATHA */
    "afii57455\0"		/* ARABIC DAMMA */
    "afii57456\0"		/* ARABIC KASRA */
    "afii57457\0"		/* ARABIC SHADDA */
    "afii57458\0"		/* ARABIC SUKUN */
    "afii57470\0"		/* ARABIC LETTER HEH */
    "afii57505\0"		/* ARABIC LETTER VEH */
    "afii57506\0"		/* ARABIC LETTER PEH */
    "afii57507\0"		/* ARABIC LETTER TCHEH */
    "afii57508\0"		/* ARABIC LETTER JEH */
    "afii57509\0"		/* ARABIC LETTER GAF */
    "afii57511\0"		/* ARABIC LETTER TTEH */
    "afii57512\0"		/* ARABIC LETTER DDAL */
    "afii57513\0"		/* ARABIC LETTER RREH */
    "afii57514\0"		/* ARABIC LETTER NOON GHUNNA */
    "afii57519\0"		/* ARABIC LETTER YEH BARREE */
    "afii57534\0"		/* ARABIC LETTER AE */
    "afii57636\0"		/* NEW SHEQEL SIGN */
    "afii57645\0"		/* HEBREW PUNCTUATION MAQAF */
    "afii57658\0"		/* HEBREW PUNCTUATION SOF PASUQ */
    "afii57664\0"		/* HEBREW LETTER ALEF */
    "afii57665\0"		/* HEBREW LETTER BET */
    "afii57666\0"		/* HEBREW LETTER GIMEL */
    "afii57667\0"		/* HEBREW LETTER DALET */
    "afii57668\0"		/* HEBREW LETTER HE */
    "afii57669\0"		/* HEBREW LETTER VAV */
    "afii57670\0"		/* HEBREW LETTER ZAYIN */
    "afii57671\0"		/* HEBREW LETTER HET */
    "afii57672\0"		/* HEBREW LETTER TET */
    "afii57673\0"		/* HEBREW LETTER YOD */
    "afii57674\0"		/* HEBREW LETTER FINAL KAF */
    "afii57675\0"		/* HEBREW LETTER KAF */
    "afii57676\0"		/* HEBREW LETTER LAMED */
    "afii57677\0"		/* HEBREW LETTER FINAL MEM */
    "afii57678\0"		/* HEBREW LETTER MEM */
    "afii57679\0"		/* HEBREW LETTER FINAL NUN */
    "afii57680\0"		/* HEBREW LETTER NUN */
    "afii57681\0"		/* HEBREW LETTER SAMEKH */
    "afii57682\0"		/* HEBREW LETTER AYIN */
    "afii57683\0"		/* HEBREW LETTER FINAL PE */
    "afii57684\0"		/* HEBREW LETTER PE */
    "afii57685\0"		/* HEBREW LETTER FINAL TSADI */
    "afii57686\0"		/* HEBREW LETTER TSADI */
    "afii57687\0"		/* HEBREW LETTER QOF */
    "afii57688\0"		/* HEBREW LETTER RESH */
    "afii57689\0"		/* HEBREW LETTER SHIN */
    "afii57690\0"		/* HEBREW LETTER TAV */
    "afii57694\0"		/* HEBREW LETTER SHIN WITH SHIN DOT */
    "afii57695\0"		/* HEBREW LETTER SHIN WITH SIN DOT */
    "afii57700\0"		/* HEBREW LETTER VAV WITH HOLAM */
    "afii57705\0"		/* HEBREW LIGATURE YIDDISH YOD YOD PATAH */
    "afii57716\0"		/* HEBREW LIGATURE YIDDISH DOUBLE VAV */
    "afii57717\0"		/* HEBREW LIGATURE YIDDISH VAV YOD */
    "afii57718\0"		/* HEBREW LIGATURE YIDDISH DOUBLE YOD */
    "afii57723\0"		/* HEBREW LETTER VAV WITH DAGESH */
    "afii57793\0"		/* HEBREW POINT HIRIQ */
    "afii57794\0"		/* HEBREW POINT TSERE */
    "afii57795\0"		/* HEBREW POINT SEGOL */
    "afii57796\0"		/* HEBREW POINT QUBUTS */
    "afii57797\0"		/* HEBREW POINT QAMATS */
    "afii57798\0"		/* HEBREW POINT PATAH */
    "afii57799\0"		/* HEBREW POINT SHEVA */
    "afii57800\0"		/* HEBREW POINT HATAF PATAH */
    "afii57801\0"		/* HEBREW POINT HATAF SEGOL */
    "afii57802\0"		/* HEBREW POINT HATAF QAMATS */
    "afii57803\0"		/* HEBREW POINT SIN DOT */
    "afii57804\0"		/* HEBREW POINT SHIN DOT */
    "afii57806\0"		/* HEBREW POINT HOLAM */
    "afii57807\0"		/* HEBREW POINT DAGESH OR MAPIQ */
    "afii57839\0"		/* HEBREW POINT METEG */
    "afii57841\0"		/* HEBREW POINT RAFE */
    "afii57842\0"		/* HEBREW PUNCTUATION PASEQ */
    "afii57929\0"		/* MODIFIER LETTER APOSTROPHE */
    "afii61248\0"		/* CARE OF */
    "afii61289\0"		/* SCRIPT SMALL L */
    "afii61352\0"		/* NUMERO SIGN */
    "afii61573\0"		/* POP DIRECTIONAL FORMATTING */
    "afii61574\0"		/* LEFT-TO-RIGHT OVERRIDE */
    "afii61575\0"		/* RIGHT-TO-LEFT OVERRIDE */
    "afii61664\0"		/* ZERO WIDTH NON-JOINER */
    "afii63167\0"		/* ARABIC FIVE POINTED STAR */
    "afii64937\0"		/* MODIFIER LETTER REVERSED COMMA */
    "agrave\0"			/* LATIN SMALL LETTER A WITH GRAVE */
    "aleph\0"			/* ALEF SYMBOL */
    "alpha\0"			/* GREEK SMALL LETTER ALPHA */
    "alphatonos\0"		/* GREEK SMALL LETTER ALPHA WITH TONOS */
    "amacron\0"			/* LATIN SMALL LETTER A WITH MACRON */
    "ampersand\0"		/* AMPERSAND */
    "ampersandsmall\0"		/* SMALL CAPITAL AMPERSAND */
    "angle\0"			/* ANGLE */
    "angleleft\0"		/* LEFT-POINTING ANGLE BRACKET */
    "angleright\0"		/* RIGHT-POINTING ANGLE BRACKET */
    "anoteleia\0"		/* GREEK ANO TELEIA */
    "aogonek\0"			/* LATIN SMALL LETTER A WITH OGONEK */
    "approxequal\0"		/* ALMOST EQUAL TO */
    "aring\0"			/* LATIN SMALL LETTER A WITH RING ABOVE */
    "aringacute\0"		/* LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE */
    "arrowboth\0"		/* LEFT RIGHT ARROW */
    "arrowdblboth\0"		/* LEFT RIGHT DOUBLE ARROW */
    "arrowdbldown\0"		/* DOWNWARDS DOUBLE ARROW */
    "arrowdblleft\0"		/* LEFTWARDS DOUBLE ARROW */
    "arrowdblright\0"		/* RIGHTWARDS DOUBLE ARROW */
    "arrowdblup\0"		/* UPWARDS DOUBLE ARROW */
    "arrowdown\0"		/* DOWNWARDS ARROW */
    "arrowhorizex\0"		/* HORIZONTAL ARROW EXTENDER */
    "arrowleft\0"		/* LEFTWARDS ARROW */
    "arrowright\0"		/* RIGHTWARDS ARROW */
    "arrowup\0"			/* UPWARDS ARROW */
    "arrowupdn\0"		/* UP DOWN ARROW */
    "arrowupdnbse\0"		/* UP DOWN ARROW WITH BASE */
    "arrowvertex\0"		/* VERTICAL ARROW EXTENDER */
    "asciicircum\0"		/* CIRCUMFLEX ACCENT */
    "asciitilde\0"		/* TILDE */
    "asterisk\0"		/* ASTERISK */
    "asteriskmath\0"		/* ASTERISK OPERATOR */
    "asuperior\0"		/* SUPERSCRIPT LATIN SMALL LETTER A */
    "at\0"			/* COMMERCIAL AT */
    "atilde\0"			/* LATIN SMALL LETTER A WITH TILDE */
    "b\0"			/* LATIN SMALL LETTER B */
    "backslash\0"		/* REVERSE SOLIDUS */
    "bar\0"			/* VERTICAL LINE */
    "beta\0"			/* GREEK SMALL LETTER BETA */
    "block\0"			/* FULL BLOCK */
    "braceex\0"			/* CURLY BRACKET EXTENDER */
    "braceleft\0"		/* LEFT CURLY BRACKET */
    "braceleftbt\0"		/* LEFT CURLY BRACKET BOTTOM */
    "braceleftmid\0"		/* LEFT CURLY BRACKET MID */
    "bracelefttp\0"		/* LEFT CURLY BRACKET TOP */
    "braceright\0"		/* RIGHT CURLY BRACKET */
    "bracerightbt\0"		/* RIGHT CURLY BRACKET BOTTOM */
    "bracerightmid\0"		/* RIGHT CURLY BRACKET MID */
    "bracerighttp\0"		/* RIGHT CURLY BRACKET TOP */
    "bracketleft\0"		/* LEFT SQUARE BRACKET */
    "bracketleftbt\0"		/* LEFT SQUARE BRACKET BOTTOM */
    "bracketleftex\0"		/* LEFT SQUARE BRACKET EXTENDER */
    "bracketlefttp\0"		/* LEFT SQUARE BRACKET TOP */
    "bracketright\0"		/* RIGHT SQUARE BRACKET */
    "bracketrightbt\0"		/* RIGHT SQUARE BRACKET BOTTOM */
    "bracketrightex\0"		/* RIGHT SQUARE BRACKET EXTENDER */
    "bracketrighttp\0"		/* RIGHT SQUARE BRACKET TOP */
    "breve\0"			/* BREVE */
    "brokenbar\0"		/* BROKEN BAR */
    "bsuperior\0"		/* SUPERSCRIPT LATIN SMALL LETTER B */
    "bullet\0"			/* BULLET */
    "c\0"			/* LATIN SMALL LETTER C */
    "cacute\0"			/* LATIN SMALL LETTER C WITH ACUTE */
    "caron\0"			/* CARON */
    "carriagereturn\0"		/* DOWNWARDS ARROW WITH CORNER LEFTWARDS */
    "ccaron\0"			/* LATIN SMALL LETTER C WITH CARON */
    "ccedilla\0"		/* LATIN SMALL LETTER C WITH CEDILLA */
    "ccircumflex\0"		/* LATIN SMALL LETTER C WITH CIRCUMFLEX */
    "cdotaccent\0"		/* LATIN SMALL LETTER C WITH DOT ABOVE */
    "cedilla\0"			/* CEDILLA */
    "cent\0"			/* CENT SIGN */
    "centinferior\0"		/* SUBSCRIPT CENT SIGN */
    "centoldstyle\0"		/* OLDSTYLE CENT SIGN */
    "centsuperior\0"		/* SUPERSCRIPT CENT SIGN */
    "chi\0"			/* GREEK SMALL LETTER CHI */
    "circle\0"			/* WHITE CIRCLE */
    "circlemultiply\0"		/* CIRCLED TIMES */
    "circleplus\0"		/* CIRCLED PLUS */
    "circumflex\0"		/* MODIFIER LETTER CIRCUMFLEX ACCENT */
    "club\0"			/* BLACK CLUB SUIT */
    "colon\0"			/* COLON */
    "colonmonetary\0"		/* COLON SIGN */
    "comma\0"			/* COMMA */
    "commaaccent\0"		/* COMMA BELOW */
    "commainferior\0"		/* SUBSCRIPT COMMA */
    "commasuperior\0"		/* SUPERSCRIPT COMMA */
    "congruent\0"		/* APPROXIMATELY EQUAL TO */
    "copyright\0"		/* COPYRIGHT SIGN */
    "copyrightsans\0"		/* COPYRIGHT SIGN SANS SERIF */
    "copyrightserif\0"		/* COPYRIGHT SIGN SERIF */
    "currency\0"		/* CURRENCY SIGN */
    "cyrBreve\0"		/* CAPITAL CYRILLIC BREVE */
    "cyrFlex\0"			/* CAPITAL CYRILLIC CIRCUMFLEX */
    "cyrbreve\0"		/* CYRILLIC BREVE */
    "cyrflex\0"			/* CYRILLIC CIRCUMFLEX */
    "d\0"			/* LATIN SMALL LETTER D */
    "dagger\0"			/* DAGGER */
    "daggerdbl\0"		/* DOUBLE DAGGER */
    "dblGrave\0"		/* CAPITAL DOUBLE GRAVE ACCENT */
    "dblgrave\0"		/* DOUBLE GRAVE ACCENT */
    "dcaron\0"			/* LATIN SMALL LETTER D WITH CARON */
    "dcroat\0"			/* LATIN SMALL LETTER D WITH STROKE */
    "degree\0"			/* DEGREE SIGN */
    "delta\0"			/* GREEK SMALL LETTER DELTA */
    "diamond\0"			/* BLACK DIAMOND SUIT */
    "dieresis\0"		/* DIAERESIS */
    "dieresisacute\0"		/* DIAERESIS ACUTE ACCENT */
    "dieresisgrave\0"		/* DIAERESIS GRAVE ACCENT */
    "dieresistonos\0"		/* GREEK DIALYTIKA TONOS */
    "divide\0"			/* DIVISION SIGN */
    "dkshade\0"			/* DARK SHADE */
    "dnblock\0"			/* LOWER HALF BLOCK */
    "dollar\0"			/* DOLLAR SIGN */
    "dollarinferior\0"		/* SUBSCRIPT DOLLAR SIGN */
    "dollaroldstyle\0"		/* OLDSTYLE DOLLAR SIGN */
    "dollarsuperior\0"		/* SUPERSCRIPT DOLLAR SIGN */
    "dong\0"			/* DONG SIGN */
    "dotaccent\0"		/* DOT ABOVE */
    "dotbelowcomb\0"		/* COMBINING DOT BELOW */
    "dotlessi\0"		/* LATIN SMALL LETTER DOTLESS I */
    "dotlessj\0"		/* LATIN SMALL LETTER DOTLESS J */
    "dotmath\0"			/* DOT OPERATOR */
    "dsuperior\0"		/* SUPERSCRIPT LATIN SMALL LETTER D */
    "e\0"			/* LATIN SMALL LETTER E */
    "eacute\0"			/* LATIN SMALL LETTER E WITH ACUTE */
    "ebreve\0"			/* LATIN SMALL LETTER E WITH BREVE */
    "ecaron\0"			/* LATIN SMALL LETTER E WITH CARON */
    "ecircumflex\0"		/* LATIN SMALL LETTER E WITH CIRCUMFLEX */
    "edieresis\0"		/* LATIN SMALL LETTER E WITH DIAERESIS */
    "edotaccent\0"		/* LATIN SMALL LETTER E WITH DOT ABOVE */
    "egrave\0"			/* LATIN SMALL LETTER E WITH GRAVE */
    "eight\0"			/* DIGIT EIGHT */
    "eightinferior\0"		/* SUBSCRIPT EIGHT */
    "eightoldstyle\0"		/* OLDSTYLE DIGIT EIGHT */
    "eightsuperior\0"		/* SUPERSCRIPT EIGHT */
    "element\0"			/* ELEMENT OF */
    "ellipsis\0"		/* HORIZONTAL ELLIPSIS */
    "emacron\0"			/* LATIN SMALL LETTER E WITH MACRON */
    "emdash\0"			/* EM DASH */
    "emptyset\0"		/* EMPTY SET */
    "endash\0"			/* EN DASH */
    "eng\0"			/* LATIN SMALL LETTER ENG */
    "eogonek\0"			/* LATIN SMALL LETTER E WITH OGONEK */
    "epsilon\0"			/* GREEK SMALL LETTER EPSILON */
    "epsilontonos\0"		/* GREEK SMALL LETTER EPSILON WITH TONOS */
    "equal\0"			/* EQUALS SIGN */
    "equivalence\0"		/* IDENTICAL TO */
    "estimated\0"		/* ESTIMATED SYMBOL */
    "esuperior\0"		/* SUPERSCRIPT LATIN SMALL LETTER E */
    "eta\0"			/* GREEK SMALL LETTER ETA */
    "etatonos\0"		/* GREEK SMALL LETTER ETA WITH TONOS */
    "eth\0"			/* LATIN SMALL LETTER ETH */
    "exclam\0"			/* EXCLAMATION MARK */
    "exclamdbl\0"		/* DOUBLE EXCLAMATION MARK */
    "exclamdown\0"		/* INVERTED EXCLAMATION MARK */
    "exclamdownsmall\0"		/* SMALL CAPITAL INVERTED EXCLAMATION MARK */
    "exclamsmall\0"		/* SMALL CAPITAL EXCLAMATION MARK */
    "existential\0"		/* THERE EXISTS */
    "f\0"			/* LATIN SMALL LETTER F */
    "female\0"			/* FEMALE SIGN */
    "ff\0"			/* LATIN SMALL LIGATURE FF */
    "ffi\0"			/* LATIN SMALL LIGATURE FFI */
    "ffl\0"			/* LATIN SMALL LIGATURE FFL */
    "fi\0"			/* LATIN SMALL LIGATURE FI */
    "figuredash\0"		/* FIGURE DASH */
    "filledbox\0"		/* BLACK SQUARE */
    "filledrect\0"		/* BLACK RECTANGLE */
    "five\0"			/* DIGIT FIVE */
    "fiveeighths\0"		/* VULGAR FRACTION FIVE EIGHTHS */
    "fiveinferior\0"		/* SUBSCRIPT FIVE */
    "fiveoldstyle\0"		/* OLDSTYLE DIGIT FIVE */
    "fivesuperior\0"		/* SUPERSCRIPT FIVE */
    "fl\0"			/* LATIN SMALL LIGATURE FL */
    "florin\0"			/* LATIN SMALL LETTER F WITH HOOK */
    "four\0"			/* DIGIT FOUR */
    "fourinferior\0"		/* SUBSCRIPT FOUR */
    "fouroldstyle\0"		/* OLDSTYLE DIGIT FOUR */
    "foursuperior\0"		/* SUPERSCRIPT FOUR */
    "fraction\0"		/* FRACTION SLASH */
				/* DIVISION SLASH;Duplicate */
    "franc\0"			/* FRENCH FRANC SIGN */
    "g\0"			/* LATIN SMALL LETTER G */
    "gamma\0"			/* GREEK SMALL LETTER GAMMA */
    "gbreve\0"			/* LATIN SMALL LETTER G WITH BREVE */
    "gcaron\0"			/* LATIN SMALL LETTER G WITH CARON */
    "gcircumflex\0"		/* LATIN SMALL LETTER G WITH CIRCUMFLEX */
    "gcommaaccent\0"		/* LATIN SMALL LETTER G WITH CEDILLA */
    "gdotaccent\0"		/* LATIN SMALL LETTER G WITH DOT ABOVE */
    "germandbls\0"		/* LATIN SMALL LETTER SHARP S */
    "gradient\0"		/* NABLA */
    "grave\0"			/* GRAVE ACCENT */
    "gravecomb\0"		/* COMBINING GRAVE ACCENT */
    "greater\0"			/* GREATER-THAN SIGN */
    "greaterequal\0"		/* GREATER-THAN OR EQUAL TO */
    "guillemotleft\0"		/* LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */
    "guillemotright\0"		/* RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */
    "guilsinglleft\0"		/* SINGLE LEFT-POINTING ANGLE QUOTATION MARK */
    "guilsinglright\0"		/* SINGLE RIGHT-POINTING ANGLE QUOTATION MARK */
    "h\0"			/* LATIN SMALL LETTER H */
    "hbar\0"			/* LATIN SMALL LETTER H WITH STROKE */
    "hcircumflex\0"		/* LATIN SMALL LETTER H WITH CIRCUMFLEX */
    "heart\0"			/* BLACK HEART SUIT */
    "hookabovecomb\0"		/* COMBINING HOOK ABOVE */
    "house\0"			/* HOUSE */
    "hungarumlaut\0"		/* DOUBLE ACUTE ACCENT */
    "hyphen\0"			/* HYPHEN-MINUS */
				/* SOFT HYPHEN;Duplicate */
    "hypheninferior\0"		/* SUBSCRIPT HYPHEN-MINUS */
    "hyphensuperior\0"		/* SUPERSCRIPT HYPHEN-MINUS */
    "i\0"			/* LATIN SMALL LETTER I */
    "iacute\0"			/* LATIN SMALL LETTER I WITH ACUTE */
    "ibreve\0"			/* LATIN SMALL LETTER I WITH BREVE */
    "icircumflex\0"		/* LATIN SMALL LETTER I WITH CIRCUMFLEX */
    "idieresis\0"		/* LATIN SMALL LETTER I WITH DIAERESIS */
    "igrave\0"			/* LATIN SMALL LETTER I WITH GRAVE */
    "ij\0"			/* LATIN SMALL LIGATURE IJ */
    "imacron\0"			/* LATIN SMALL LETTER I WITH MACRON */
    "infinity\0"		/* INFINITY */
    "integral\0"		/* INTEGRAL */
    "integralbt\0"		/* BOTTOM HALF INTEGRAL */
    "integralex\0"		/* INTEGRAL EXTENDER */
    "integraltp\0"		/* TOP HALF INTEGRAL */
    "intersection\0"		/* INTERSECTION */
    "invbullet\0"		/* INVERSE BULLET */
    "invcircle\0"		/* INVERSE WHITE CIRCLE */
    "invsmileface\0"		/* BLACK SMILING FACE */
    "iogonek\0"			/* LATIN SMALL LETTER I WITH OGONEK */
    "iota\0"			/* GREEK SMALL LETTER IOTA */
    "iotadieresis\0"		/* GREEK SMALL LETTER IOTA WITH DIALYTIKA */
    "iotadieresistonos\0"	/* GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS */
    "iotatonos\0"		/* GREEK SMALL LETTER IOTA WITH TONOS */
    "isuperior\0"		/* SUPERSCRIPT LATIN SMALL LETTER I */
    "itilde\0"			/* LATIN SMALL LETTER I WITH TILDE */
    "j\0"			/* LATIN SMALL LETTER J */
    "jcircumflex\0"		/* LATIN SMALL LETTER J WITH CIRCUMFLEX */
    "k\0"			/* LATIN SMALL LETTER K */
    "kappa\0"			/* GREEK SMALL LETTER KAPPA */
    "kcommaaccent\0"		/* LATIN SMALL LETTER K WITH CEDILLA */
    "kgreenlandic\0"		/* LATIN SMALL LETTER KRA */
    "l\0"			/* LATIN SMALL LETTER L */
    "lacute\0"			/* LATIN SMALL LETTER L WITH ACUTE */
    "lambda\0"			/* GREEK SMALL LETTER LAMDA */
    "lcaron\0"			/* LATIN SMALL LETTER L WITH CARON */
    "lcommaaccent\0"		/* LATIN SMALL LETTER L WITH CEDILLA */
    "ldot\0"			/* LATIN SMALL LETTER L WITH MIDDLE DOT */
    "less\0"			/* LESS-THAN SIGN */
    "lessequal\0"		/* LESS-THAN OR EQUAL TO */
    "lfblock\0"			/* LEFT HALF BLOCK */
    "lira\0"			/* LIRA SIGN */
    "ll\0"			/* LATIN SMALL LETTER LL */
    "logicaland\0"		/* LOGICAL AND */
    "logicalnot\0"		/* NOT SIGN */
    "logicalor\0"		/* LOGICAL OR */
    "longs\0"			/* LATIN SMALL LETTER LONG S */
    "lozenge\0"			/* LOZENGE */
    "lslash\0"			/* LATIN SMALL LETTER L WITH STROKE */
    "lsuperior\0"		/* SUPERSCRIPT LATIN SMALL LETTER L */
    "ltshade\0"			/* LIGHT SHADE */
    "m\0"			/* LATIN SMALL LETTER M */
    "macron\0"			/* MACRON */
				/* MODIFIER LETTER MACRON;Duplicate */
    "male\0"			/* MALE SIGN */
    "minus\0"			/* MINUS SIGN */
    "minute\0"			/* PRIME */
    "msuperior\0"		/* SUPERSCRIPT LATIN SMALL LETTER M */
    "mu\0"			/* MICRO SIGN */
				/* GREEK SMALL LETTER MU;Duplicate */
    "multiply\0"		/* MULTIPLICATION SIGN */
    "musicalnote\0"		/* EIGHTH NOTE */
    "musicalnotedbl\0"		/* BEAMED EIGHTH NOTES */
    "n\0"			/* LATIN SMALL LETTER N */
    "nacute\0"			/* LATIN SMALL LETTER N WITH ACUTE */
    "napostrophe\0"		/* LATIN SMALL LETTER N PRECEDED BY APOSTROPHE */
    "ncaron\0"			/* LATIN SMALL LETTER N WITH CARON */
    "ncommaaccent\0"		/* LATIN SMALL LETTER N WITH CEDILLA */
    "nine\0"			/* DIGIT NINE */
    "nineinferior\0"		/* SUBSCRIPT NINE */
    "nineoldstyle\0"		/* OLDSTYLE DIGIT NINE */
    "ninesuperior\0"		/* SUPERSCRIPT NINE */
    "notelement\0"		/* NOT AN ELEMENT OF */
    "notequal\0"		/* NOT EQUAL TO */
    "notsubset\0"		/* NOT A SUBSET OF */
    "nsuperior\0"		/* SUPERSCRIPT LATIN SMALL LETTER N */
    "ntilde\0"			/* LATIN SMALL LETTER N WITH TILDE */
    "nu\0"			/* GREEK SMALL LETTER NU */
    "numbersign\0"		/* NUMBER SIGN */
    "o\0"			/* LATIN SMALL LETTER O */
    "oacute\0"			/* LATIN SMALL LETTER O WITH ACUTE */
    "obreve\0"			/* LATIN SMALL LETTER O WITH BREVE */
    "ocircumflex\0"		/* LATIN SMALL LETTER O WITH CIRCUMFLEX */
    "odieresis\0"		/* LATIN SMALL LETTER O WITH DIAERESIS */
    "oe\0"			/* LATIN SMALL LIGATURE OE */
    "ogonek\0"			/* OGONEK */
    "ograve\0"			/* LATIN SMALL LETTER O WITH GRAVE */
    "ohorn\0"			/* LATIN SMALL LETTER O WITH HORN */
    "ohungarumlaut\0"		/* LATIN SMALL LETTER O WITH DOUBLE ACUTE */
    "omacron\0"			/* LATIN SMALL LETTER O WITH MACRON */
    "omega\0"			/* GREEK SMALL LETTER OMEGA */
    "omega1\0"			/* GREEK PI SYMBOL */
    "omegatonos\0"		/* GREEK SMALL LETTER OMEGA WITH TONOS */
    "omicron\0"			/* GREEK SMALL LETTER OMICRON */
    "omicrontonos\0"		/* GREEK SMALL LETTER OMICRON WITH TONOS */
    "one\0"			/* DIGIT ONE */
    "onedotenleader\0"		/* ONE DOT LEADER */
    "oneeighth\0"		/* VULGAR FRACTION ONE EIGHTH */
    "onefitted\0"		/* PROPORTIONAL DIGIT ONE */
    "onehalf\0"			/* VULGAR FRACTION ONE HALF */
    "oneinferior\0"		/* SUBSCRIPT ONE */
    "oneoldstyle\0"		/* OLDSTYLE DIGIT ONE */
    "onequarter\0"		/* VULGAR FRACTION ONE QUARTER */
    "onesuperior\0"		/* SUPERSCRIPT ONE */
    "onethird\0"		/* VULGAR FRACTION ONE THIRD */
    "openbullet\0"		/* WHITE BULLET */
    "ordfeminine\0"		/* FEMININE ORDINAL INDICATOR */
    "ordmasculine\0"		/* MASCULINE ORDINAL INDICATOR */
    "orthogonal\0"		/* RIGHT ANGLE */
    "oslash\0"			/* LATIN SMALL LETTER O WITH STROKE */
    "oslashacute\0"		/* LATIN SMALL LETTER O WITH STROKE AND ACUTE */
    "osuperior\0"		/* SUPERSCRIPT LATIN SMALL LETTER O */
    "otilde\0"			/* LATIN SMALL LETTER O WITH TILDE */
    "p\0"			/* LATIN SMALL LETTER P */
    "paragraph\0"		/* PILCROW SIGN */
    "parenleft\0"		/* LEFT PARENTHESIS */
    "parenleftbt\0"		/* LEFT PAREN BOTTOM */
    "parenleftex\0"		/* LEFT PAREN EXTENDER */
    "parenleftinferior\0"	/* SUBSCRIPT LEFT PARENTHESIS */
    "parenleftsuperior\0"	/* SUPERSCRIPT LEFT PARENTHESIS */
    "parenlefttp\0"		/* LEFT PAREN TOP */
    "parenright\0"		/* RIGHT PARENTHESIS */
    "parenrightbt\0"		/* RIGHT PAREN BOTTOM */
    "parenrightex\0"		/* RIGHT PAREN EXTENDER */
    "parenrightinferior\0"	/* SUBSCRIPT RIGHT PARENTHESIS */
    "parenrightsuperior\0"	/* SUPERSCRIPT RIGHT PARENTHESIS */
    "parenrighttp\0"		/* RIGHT PAREN TOP */
    "partialdiff\0"		/* PARTIAL DIFFERENTIAL */
    "percent\0"			/* PERCENT SIGN */
    "period\0"			/* FULL STOP */
    "periodcentered\0"		/* MIDDLE DOT */
				/* BULLET OPERATOR;Duplicate */
    "periodinferior\0"		/* SUBSCRIPT FULL STOP */
    "periodsuperior\0"		/* SUPERSCRIPT FULL STOP */
    "perpendicular\0"		/* UP TACK */
    "perthousand\0"		/* PER MILLE SIGN */
    "peseta\0"			/* PESETA SIGN */
    "phi\0"			/* GREEK SMALL LETTER PHI */
    "phi1\0"			/* GREEK PHI SYMBOL */
    "pi\0"			/* GREEK SMALL LETTER PI */
    "plus\0"			/* PLUS SIGN */
    "plusminus\0"		/* PLUS-MINUS SIGN */
    "prescription\0"		/* PRESCRIPTION TAKE */
    "product\0"			/* N-ARY PRODUCT */
    "propersubset\0"		/* SUBSET OF */
    "propersuperset\0"		/* SUPERSET OF */
    "proportional\0"		/* PROPORTIONAL TO */
    "psi\0"			/* GREEK SMALL LETTER PSI */
    "q\0"			/* LATIN SMALL LETTER Q */
    "question\0"		/* QUESTION MARK */
    "questiondown\0"		/* INVERTED QUESTION MARK */
    "questiondownsmall\0"	/* SMALL CAPITAL INVERTED QUESTION MARK */
    "questionsmall\0"		/* SMALL CAPITAL QUESTION MARK */
    "quotedbl\0"		/* QUOTATION MARK */
    "quotedblbase\0"		/* DOUBLE LOW-9 QUOTATION MARK */
    "quotedblleft\0"		/* LEFT DOUBLE QUOTATION MARK */
    "quotedblright\0"		/* RIGHT DOUBLE QUOTATION MARK */
    "quoteleft\0"		/* LEFT SINGLE QUOTATION MARK */
    "quotereversed\0"		/* SINGLE HIGH-REVERSED-9 QUOTATION MARK */
    "quoteright\0"		/* RIGHT SINGLE QUOTATION MARK */
    "quotesinglbase\0"		/* SINGLE LOW-9 QUOTATION MARK */
    "quotesingle\0"		/* APOSTROPHE */
    "r\0"			/* LATIN SMALL LETTER R */
    "racute\0"			/* LATIN SMALL LETTER R WITH ACUTE */
    "radical\0"			/* SQUARE ROOT */
    "radicalex\0"		/* RADICAL EXTENDER */
    "rcaron\0"			/* LATIN SMALL LETTER R WITH CARON */
    "rcommaaccent\0"		/* LATIN SMALL LETTER R WITH CEDILLA */
    "reflexsubset\0"		/* SUBSET OF OR EQUAL TO */
    "reflexsuperset\0"		/* SUPERSET OF OR EQUAL TO */
    "registered\0"		/* REGISTERED SIGN */
    "registersans\0"		/* REGISTERED SIGN SANS SERIF */
    "registerserif\0"		/* REGISTERED SIGN SERIF */
    "revlogicalnot\0"		/* REVERSED NOT SIGN */
    "rho\0"			/* GREEK SMALL LETTER RHO */
    "ring\0"			/* RING ABOVE */
    "rsuperior\0"		/* SUPERSCRIPT LATIN SMALL LETTER R */
    "rtblock\0"			/* RIGHT HALF BLOCK */
    "rupiah\0"			/* RUPIAH SIGN */
    "s\0"			/* LATIN SMALL LETTER S */
    "sacute\0"			/* LATIN SMALL LETTER S WITH ACUTE */
    "scaron\0"			/* LATIN SMALL LETTER S WITH CARON */
    "scedilla\0"		/* LATIN SMALL LETTER S WITH CEDILLA */
				/* LATIN SMALL LETTER S WITH CEDILLA;Duplicate */
    "scircumflex\0"		/* LATIN SMALL LETTER S WITH CIRCUMFLEX */
    "scommaaccent\0"		/* LATIN SMALL LETTER S WITH COMMA BELOW */
    "second\0"			/* DOUBLE PRIME */
    "section\0"			/* SECTION SIGN */
    "semicolon\0"		/* SEMICOLON */
    "seven\0"			/* DIGIT SEVEN */
    "seveneighths\0"		/* VULGAR FRACTION SEVEN EIGHTHS */
    "seveninferior\0"		/* SUBSCRIPT SEVEN */
    "sevenoldstyle\0"		/* OLDSTYLE DIGIT SEVEN */
    "sevensuperior\0"		/* SUPERSCRIPT SEVEN */
    "shade\0"			/* MEDIUM SHADE */
    "sigma\0"			/* GREEK SMALL LETTER SIGMA */
    "sigma1\0"			/* GREEK SMALL LETTER FINAL SIGMA */
    "similar\0"			/* TILDE OPERATOR */
    "six\0"			/* DIGIT SIX */
    "sixinferior\0"		/* SUBSCRIPT SIX */
    "sixoldstyle\0"		/* OLDSTYLE DIGIT SIX */
    "sixsuperior\0"		/* SUPERSCRIPT SIX */
    "slash\0"			/* SOLIDUS */
    "smileface\0"		/* WHITE SMILING FACE */
    "space\0"			/* SPACE */
				/* NO-BREAK SPACE;Duplicate */
    "spade\0"			/* BLACK SPADE SUIT */
    "ssuperior\0"		/* SUPERSCRIPT LATIN SMALL LETTER S */
    "sterling\0"		/* POUND SIGN */
    "suchthat\0"		/* CONTAINS AS MEMBER */
    "summation\0"		/* N-ARY SUMMATION */
    "sun\0"			/* WHITE SUN WITH RAYS */
    "t\0"			/* LATIN SMALL LETTER T */
    "tau\0"			/* GREEK SMALL LETTER TAU */
    "tbar\0"			/* LATIN SMALL LETTER T WITH STROKE */
    "tcaron\0"			/* LATIN SMALL LETTER T WITH CARON */
    "tcommaaccent\0"		/* LATIN SMALL LETTER T WITH CEDILLA */
				/* LATIN SMALL LETTER T WITH COMMA BELOW;Duplicate */
    "therefore\0"		/* THEREFORE */
    "theta\0"			/* GREEK SMALL LETTER THETA */
    "theta1\0"			/* GREEK THETA SYMBOL */
    "thorn\0"			/* LATIN SMALL LETTER THORN */
    "three\0"			/* DIGIT THREE */
    "threeeighths\0"		/* VULGAR FRACTION THREE EIGHTHS */
    "threeinferior\0"		/* SUBSCRIPT THREE */
    "threeoldstyle\0"		/* OLDSTYLE DIGIT THREE */
    "threequarters\0"		/* VULGAR FRACTION THREE QUARTERS */
    "threequartersemdash\0"	/* THREE QUARTERS EM DASH */
    "threesuperior\0"		/* SUPERSCRIPT THREE */
    "tilde\0"			/* SMALL TILDE */
    "tildecomb\0"		/* COMBINING TILDE */
    "tonos\0"			/* GREEK TONOS */
    "trademark\0"		/* TRADE MARK SIGN */
    "trademarksans\0"		/* TRADE MARK SIGN SANS SERIF */
    "trademarkserif\0"		/* TRADE MARK SIGN SERIF */
    "triagdn\0"			/* BLACK DOWN-POINTING TRIANGLE */
    "triaglf\0"			/* BLACK LEFT-POINTING POINTER */
    "triagrt\0"			/* BLACK RIGHT-POINTING POINTER */
    "triagup\0"			/* BLACK UP-POINTING TRIANGLE */
    "tsuperior\0"		/* SUPERSCRIPT LATIN SMALL LETTER T */
    "two\0"			/* DIGIT TWO */
    "twodotenleader\0"		/* TWO DOT LEADER */
    "twoinferior\0"		/* SUBSCRIPT TWO */
    "twooldstyle\0"		/* OLDSTYLE DIGIT TWO */
    "twosuperior\0"		/* SUPERSCRIPT TWO */
    "twothirds\0"		/* VULGAR FRACTION TWO THIRDS */
    "u\0"			/* LATIN SMALL LETTER U */
    "uacute\0"			/* LATIN SMALL LETTER U WITH ACUTE */
    "ubreve\0"			/* LATIN SMALL LETTER U WITH BREVE */
    "ucircumflex\0"		/* LATIN SMALL LETTER U WITH CIRCUMFLEX */
    "udieresis\0"		/* LATIN SMALL LETTER U WITH DIAERESIS */
    "ugrave\0"			/* LATIN SMALL LETTER U WITH GRAVE */
    "uhorn\0"			/* LATIN SMALL LETTER U WITH HORN */
    "uhungarumlaut\0"		/* LATIN SMALL LETTER U WITH DOUBLE ACUTE */
    "umacron\0"			/* LATIN SMALL LETTER U WITH MACRON */
    "underscore\0"		/* LOW LINE */
    "underscoredbl\0"		/* DOUBLE LOW LINE */
    "union\0"			/* UNION */
    "universal\0"		/* FOR ALL */
    "uogonek\0"			/* LATIN SMALL LETTER U WITH OGONEK */
    "upblock\0"			/* UPPER HALF BLOCK */
    "upsilon\0"			/* GREEK SMALL LETTER UPSILON */
    "upsilondieresis\0"		/* GREEK SMALL LETTER UPSILON WITH DIALYTIKA */
    "upsilondieresistonos\0"	/* GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS */
    "upsilontonos\0"		/* GREEK SMALL LETTER UPSILON WITH TONOS */
    "uring\0"			/* LATIN SMALL LETTER U WITH RING ABOVE */
    "utilde\0"			/* LATIN SMALL LETTER U WITH TILDE */
    "v\0"			/* LATIN SMALL LETTER V */
    "w\0"			/* LATIN SMALL LETTER W */
    "wacute\0"			/* LATIN SMALL LETTER W WITH ACUTE */
    "wcircumflex\0"		/* LATIN SMALL LETTER W WITH CIRCUMFLEX */
    "wdieresis\0"		/* LATIN SMALL LETTER W WITH DIAERESIS */
    "weierstrass\0"		/* SCRIPT CAPITAL P */
    "wgrave\0"			/* LATIN SMALL LETTER W WITH GRAVE */
    "x\0"			/* LATIN SMALL LETTER X */
    "xi\0"			/* GREEK SMALL LETTER XI */
    "y\0"			/* LATIN SMALL LETTER Y */
    "yacute\0"			/* LATIN SMALL LETTER Y WITH ACUTE */
    "ycircumflex\0"		/* LATIN SMALL LETTER Y WITH CIRCUMFLEX */
    "ydieresis\0"		/* LATIN SMALL LETTER Y WITH DIAERESIS */
    "yen\0"			/* YEN SIGN */
    "ygrave\0"			/* LATIN SMALL LETTER Y WITH GRAVE */
    "z\0"			/* LATIN SMALL LETTER Z */
    "zacute\0"			/* LATIN SMALL LETTER Z WITH ACUTE */
    "zcaron\0"			/* LATIN SMALL LETTER Z WITH CARON */
    "zdotaccent\0"		/* LATIN SMALL LETTER Z WITH DOT ABOVE */
    "zero\0"			/* DIGIT ZERO */
    "zeroinferior\0"		/* SUBSCRIPT ZERO */
    "zerooldstyle\0"		/* OLDSTYLE DIGIT ZERO */
    "zerosuperior\0"		/* SUPERSCRIPT ZERO */
    "zeta\0"			/* GREEK SMALL LETTER ZETA */
};

/*
 *  Pointers to all the AGL glyph names, sorted by name
 *
 */
GLYPHNAME PSDRV_AGLGlyphNames[1039] =
{
    { -1, gndata +    0 },	/* A */
    { -1, gndata +    2 },	/* AE */
    { -1, gndata +    5 },	/* AEacute */
    { -1, gndata +   13 },	/* AEsmall */
    { -1, gndata +   21 },	/* Aacute */
    { -1, gndata +   28 },	/* Aacutesmall */
    { -1, gndata +   40 },	/* Abreve */
    { -1, gndata +   47 },	/* Acircumflex */
    { -1, gndata +   59 },	/* Acircumflexsmall */
    { -1, gndata +   76 },	/* Acute */
    { -1, gndata +   82 },	/* Acutesmall */
    { -1, gndata +   93 },	/* Adieresis */
    { -1, gndata +  103 },	/* Adieresissmall */
    { -1, gndata +  118 },	/* Agrave */
    { -1, gndata +  125 },	/* Agravesmall */
    { -1, gndata +  137 },	/* Alpha */
    { -1, gndata +  143 },	/* Alphatonos */
    { -1, gndata +  154 },	/* Amacron */
    { -1, gndata +  162 },	/* Aogonek */
    { -1, gndata +  170 },	/* Aring */
    { -1, gndata +  176 },	/* Aringacute */
    { -1, gndata +  187 },	/* Aringsmall */
    { -1, gndata +  198 },	/* Asmall */
    { -1, gndata +  205 },	/* Atilde */
    { -1, gndata +  212 },	/* Atildesmall */
    { -1, gndata +  224 },	/* B */
    { -1, gndata +  226 },	/* Beta */
    { -1, gndata +  231 },	/* Brevesmall */
    { -1, gndata +  242 },	/* Bsmall */
    { -1, gndata +  249 },	/* C */
    { -1, gndata +  251 },	/* Cacute */
    { -1, gndata +  258 },	/* Caron */
    { -1, gndata +  264 },	/* Caronsmall */
    { -1, gndata +  275 },	/* Ccaron */
    { -1, gndata +  282 },	/* Ccedilla */
    { -1, gndata +  291 },	/* Ccedillasmall */
    { -1, gndata +  305 },	/* Ccircumflex */
    { -1, gndata +  317 },	/* Cdotaccent */
    { -1, gndata +  328 },	/* Cedillasmall */
    { -1, gndata +  341 },	/* Chi */
    { -1, gndata +  345 },	/* Circumflexsmall */
    { -1, gndata +  361 },	/* Csmall */
    { -1, gndata +  368 },	/* D */
    { -1, gndata +  370 },	/* Dcaron */
    { -1, gndata +  377 },	/* Dcroat */
    { -1, gndata +  384 },	/* Delta */
    { -1, gndata +  390 },	/* Dieresis */
    { -1, gndata +  399 },	/* DieresisAcute */
    { -1, gndata +  413 },	/* DieresisGrave */
    { -1, gndata +  427 },	/* Dieresissmall */
    { -1, gndata +  441 },	/* Dotaccentsmall */
    { -1, gndata +  456 },	/* Dsmall */
    { -1, gndata +  463 },	/* E */
    { -1, gndata +  465 },	/* Eacute */
    { -1, gndata +  472 },	/* Eacutesmall */
    { -1, gndata +  484 },	/* Ebreve */
    { -1, gndata +  491 },	/* Ecaron */
    { -1, gndata +  498 },	/* Ecircumflex */
    { -1, gndata +  510 },	/* Ecircumflexsmall */
    { -1, gndata +  527 },	/* Edieresis */
    { -1, gndata +  537 },	/* Edieresissmall */
    { -1, gndata +  552 },	/* Edotaccent */
    { -1, gndata +  563 },	/* Egrave */
    { -1, gndata +  570 },	/* Egravesmall */
    { -1, gndata +  582 },	/* Emacron */
    { -1, gndata +  590 },	/* Eng */
    { -1, gndata +  594 },	/* Eogonek */
    { -1, gndata +  602 },	/* Epsilon */
    { -1, gndata +  610 },	/* Epsilontonos */
    { -1, gndata +  623 },	/* Esmall */
    { -1, gndata +  630 },	/* Eta */
    { -1, gndata +  634 },	/* Etatonos */
    { -1, gndata +  643 },	/* Eth */
    { -1, gndata +  647 },	/* Ethsmall */
    { -1, gndata +  656 },	/* Euro */
    { -1, gndata +  661 },	/* F */
    { -1, gndata +  663 },	/* Fsmall */
    { -1, gndata +  670 },	/* G */
    { -1, gndata +  672 },	/* Gamma */
    { -1, gndata +  678 },	/* Gbreve */
    { -1, gndata +  685 },	/* Gcaron */
    { -1, gndata +  692 },	/* Gcircumflex */
    { -1, gndata +  704 },	/* Gcommaaccent */
    { -1, gndata +  717 },	/* Gdotaccent */
    { -1, gndata +  728 },	/* Grave */
    { -1, gndata +  734 },	/* Gravesmall */
    { -1, gndata +  745 },	/* Gsmall */
    { -1, gndata +  752 },	/* H */
    { -1, gndata +  754 },	/* H18533 */
    { -1, gndata +  761 },	/* H18543 */
    { -1, gndata +  768 },	/* H18551 */
    { -1, gndata +  775 },	/* H22073 */
    { -1, gndata +  782 },	/* Hbar */
    { -1, gndata +  787 },	/* Hcircumflex */
    { -1, gndata +  799 },	/* Hsmall */
    { -1, gndata +  806 },	/* Hungarumlaut */
    { -1, gndata +  819 },	/* Hungarumlautsmall */
    { -1, gndata +  837 },	/* I */
    { -1, gndata +  839 },	/* IJ */
    { -1, gndata +  842 },	/* Iacute */
    { -1, gndata +  849 },	/* Iacutesmall */
    { -1, gndata +  861 },	/* Ibreve */
    { -1, gndata +  868 },	/* Icircumflex */
    { -1, gndata +  880 },	/* Icircumflexsmall */
    { -1, gndata +  897 },	/* Idieresis */
    { -1, gndata +  907 },	/* Idieresissmall */
    { -1, gndata +  922 },	/* Idotaccent */
    { -1, gndata +  933 },	/* Ifraktur */
    { -1, gndata +  942 },	/* Igrave */
    { -1, gndata +  949 },	/* Igravesmall */
    { -1, gndata +  961 },	/* Imacron */
    { -1, gndata +  969 },	/* Iogonek */
    { -1, gndata +  977 },	/* Iota */
    { -1, gndata +  982 },	/* Iotadieresis */
    { -1, gndata +  995 },	/* Iotatonos */
    { -1, gndata + 1005 },	/* Ismall */
    { -1, gndata + 1012 },	/* Itilde */
    { -1, gndata + 1019 },	/* J */
    { -1, gndata + 1021 },	/* Jcircumflex */
    { -1, gndata + 1033 },	/* Jsmall */
    { -1, gndata + 1040 },	/* K */
    { -1, gndata + 1042 },	/* Kappa */
    { -1, gndata + 1048 },	/* Kcommaaccent */
    { -1, gndata + 1061 },	/* Ksmall */
    { -1, gndata + 1068 },	/* L */
    { -1, gndata + 1070 },	/* LL */
    { -1, gndata + 1073 },	/* Lacute */
    { -1, gndata + 1080 },	/* Lambda */
    { -1, gndata + 1087 },	/* Lcaron */
    { -1, gndata + 1094 },	/* Lcommaaccent */
    { -1, gndata + 1107 },	/* Ldot */
    { -1, gndata + 1112 },	/* Lslash */
    { -1, gndata + 1119 },	/* Lslashsmall */
    { -1, gndata + 1131 },	/* Lsmall */
    { -1, gndata + 1138 },	/* M */
    { -1, gndata + 1140 },	/* Macron */
    { -1, gndata + 1147 },	/* Macronsmall */
    { -1, gndata + 1159 },	/* Msmall */
    { -1, gndata + 1166 },	/* Mu */
    { -1, gndata + 1169 },	/* N */
    { -1, gndata + 1171 },	/* Nacute */
    { -1, gndata + 1178 },	/* Ncaron */
    { -1, gndata + 1185 },	/* Ncommaaccent */
    { -1, gndata + 1198 },	/* Nsmall */
    { -1, gndata + 1205 },	/* Ntilde */
    { -1, gndata + 1212 },	/* Ntildesmall */
    { -1, gndata + 1224 },	/* Nu */
    { -1, gndata + 1227 },	/* O */
    { -1, gndata + 1229 },	/* OE */
    { -1, gndata + 1232 },	/* OEsmall */
    { -1, gndata + 1240 },	/* Oacute */
    { -1, gndata + 1247 },	/* Oacutesmall */
    { -1, gndata + 1259 },	/* Obreve */
    { -1, gndata + 1266 },	/* Ocircumflex */
    { -1, gndata + 1278 },	/* Ocircumflexsmall */
    { -1, gndata + 1295 },	/* Odieresis */
    { -1, gndata + 1305 },	/* Odieresissmall */
    { -1, gndata + 1320 },	/* Ogoneksmall */
    { -1, gndata + 1332 },	/* Ograve */
    { -1, gndata + 1339 },	/* Ogravesmall */
    { -1, gndata + 1351 },	/* Ohorn */
    { -1, gndata + 1357 },	/* Ohungarumlaut */
    { -1, gndata + 1371 },	/* Omacron */
    { -1, gndata + 1379 },	/* Omega */
    { -1, gndata + 1385 },	/* Omegatonos */
    { -1, gndata + 1396 },	/* Omicron */
    { -1, gndata + 1404 },	/* Omicrontonos */
    { -1, gndata + 1417 },	/* Oslash */
    { -1, gndata + 1424 },	/* Oslashacute */
    { -1, gndata + 1436 },	/* Oslashsmall */
    { -1, gndata + 1448 },	/* Osmall */
    { -1, gndata + 1455 },	/* Otilde */
    { -1, gndata + 1462 },	/* Otildesmall */
    { -1, gndata + 1474 },	/* P */
    { -1, gndata + 1476 },	/* Phi */
    { -1, gndata + 1480 },	/* Pi */
    { -1, gndata + 1483 },	/* Psi */
    { -1, gndata + 1487 },	/* Psmall */
    { -1, gndata + 1494 },	/* Q */
    { -1, gndata + 1496 },	/* Qsmall */
    { -1, gndata + 1503 },	/* R */
    { -1, gndata + 1505 },	/* Racute */
    { -1, gndata + 1512 },	/* Rcaron */
    { -1, gndata + 1519 },	/* Rcommaaccent */
    { -1, gndata + 1532 },	/* Rfraktur */
    { -1, gndata + 1541 },	/* Rho */
    { -1, gndata + 1545 },	/* Ringsmall */
    { -1, gndata + 1555 },	/* Rsmall */
    { -1, gndata + 1562 },	/* S */
    { -1, gndata + 1564 },	/* SF010000 */
    { -1, gndata + 1573 },	/* SF020000 */
    { -1, gndata + 1582 },	/* SF030000 */
    { -1, gndata + 1591 },	/* SF040000 */
    { -1, gndata + 1600 },	/* SF050000 */
    { -1, gndata + 1609 },	/* SF060000 */
    { -1, gndata + 1618 },	/* SF070000 */
    { -1, gndata + 1627 },	/* SF080000 */
    { -1, gndata + 1636 },	/* SF090000 */
    { -1, gndata + 1645 },	/* SF100000 */
    { -1, gndata + 1654 },	/* SF110000 */
    { -1, gndata + 1663 },	/* SF190000 */
    { -1, gndata + 1672 },	/* SF200000 */
    { -1, gndata + 1681 },	/* SF210000 */
    { -1, gndata + 1690 },	/* SF220000 */
    { -1, gndata + 1699 },	/* SF230000 */
    { -1, gndata + 1708 },	/* SF240000 */
    { -1, gndata + 1717 },	/* SF250000 */
    { -1, gndata + 1726 },	/* SF260000 */
    { -1, gndata + 1735 },	/* SF270000 */
    { -1, gndata + 1744 },	/* SF280000 */
    { -1, gndata + 1753 },	/* SF360000 */
    { -1, gndata + 1762 },	/* SF370000 */
    { -1, gndata + 1771 },	/* SF380000 */
    { -1, gndata + 1780 },	/* SF390000 */
    { -1, gndata + 1789 },	/* SF400000 */
    { -1, gndata + 1798 },	/* SF410000 */
    { -1, gndata + 1807 },	/* SF420000 */
    { -1, gndata + 1816 },	/* SF430000 */
    { -1, gndata + 1825 },	/* SF440000 */
    { -1, gndata + 1834 },	/* SF450000 */
    { -1, gndata + 1843 },	/* SF460000 */
    { -1, gndata + 1852 },	/* SF470000 */
    { -1, gndata + 1861 },	/* SF480000 */
    { -1, gndata + 1870 },	/* SF490000 */
    { -1, gndata + 1879 },	/* SF500000 */
    { -1, gndata + 1888 },	/* SF510000 */
    { -1, gndata + 1897 },	/* SF520000 */
    { -1, gndata + 1906 },	/* SF530000 */
    { -1, gndata + 1915 },	/* SF540000 */
    { -1, gndata + 1924 },	/* Sacute */
    { -1, gndata + 1931 },	/* Scaron */
    { -1, gndata + 1938 },	/* Scaronsmall */
    { -1, gndata + 1950 },	/* Scedilla */
    { -1, gndata + 1959 },	/* Scircumflex */
    { -1, gndata + 1971 },	/* Scommaaccent */
    { -1, gndata + 1984 },	/* Sigma */
    { -1, gndata + 1990 },	/* Ssmall */
    { -1, gndata + 1997 },	/* T */
    { -1, gndata + 1999 },	/* Tau */
    { -1, gndata + 2003 },	/* Tbar */
    { -1, gndata + 2008 },	/* Tcaron */
    { -1, gndata + 2015 },	/* Tcommaaccent */
    { -1, gndata + 2028 },	/* Theta */
    { -1, gndata + 2034 },	/* Thorn */
    { -1, gndata + 2040 },	/* Thornsmall */
    { -1, gndata + 2051 },	/* Tildesmall */
    { -1, gndata + 2062 },	/* Tsmall */
    { -1, gndata + 2069 },	/* U */
    { -1, gndata + 2071 },	/* Uacute */
    { -1, gndata + 2078 },	/* Uacutesmall */
    { -1, gndata + 2090 },	/* Ubreve */
    { -1, gndata + 2097 },	/* Ucircumflex */
    { -1, gndata + 2109 },	/* Ucircumflexsmall */
    { -1, gndata + 2126 },	/* Udieresis */
    { -1, gndata + 2136 },	/* Udieresissmall */
    { -1, gndata + 2151 },	/* Ugrave */
    { -1, gndata + 2158 },	/* Ugravesmall */
    { -1, gndata + 2170 },	/* Uhorn */
    { -1, gndata + 2176 },	/* Uhungarumlaut */
    { -1, gndata + 2190 },	/* Umacron */
    { -1, gndata + 2198 },	/* Uogonek */
    { -1, gndata + 2206 },	/* Upsilon */
    { -1, gndata + 2214 },	/* Upsilon1 */
    { -1, gndata + 2223 },	/* Upsilondieresis */
    { -1, gndata + 2239 },	/* Upsilontonos */
    { -1, gndata + 2252 },	/* Uring */
    { -1, gndata + 2258 },	/* Usmall */
    { -1, gndata + 2265 },	/* Utilde */
    { -1, gndata + 2272 },	/* V */
    { -1, gndata + 2274 },	/* Vsmall */
    { -1, gndata + 2281 },	/* W */
    { -1, gndata + 2283 },	/* Wacute */
    { -1, gndata + 2290 },	/* Wcircumflex */
    { -1, gndata + 2302 },	/* Wdieresis */
    { -1, gndata + 2312 },	/* Wgrave */
    { -1, gndata + 2319 },	/* Wsmall */
    { -1, gndata + 2326 },	/* X */
    { -1, gndata + 2328 },	/* Xi */
    { -1, gndata + 2331 },	/* Xsmall */
    { -1, gndata + 2338 },	/* Y */
    { -1, gndata + 2340 },	/* Yacute */
    { -1, gndata + 2347 },	/* Yacutesmall */
    { -1, gndata + 2359 },	/* Ycircumflex */
    { -1, gndata + 2371 },	/* Ydieresis */
    { -1, gndata + 2381 },	/* Ydieresissmall */
    { -1, gndata + 2396 },	/* Ygrave */
    { -1, gndata + 2403 },	/* Ysmall */
    { -1, gndata + 2410 },	/* Z */
    { -1, gndata + 2412 },	/* Zacute */
    { -1, gndata + 2419 },	/* Zcaron */
    { -1, gndata + 2426 },	/* Zcaronsmall */
    { -1, gndata + 2438 },	/* Zdotaccent */
    { -1, gndata + 2449 },	/* Zeta */
    { -1, gndata + 2454 },	/* Zsmall */
    { -1, gndata + 2461 },	/* a */
    { -1, gndata + 2463 },	/* aacute */
    { -1, gndata + 2470 },	/* abreve */
    { -1, gndata + 2477 },	/* acircumflex */
    { -1, gndata + 2489 },	/* acute */
    { -1, gndata + 2495 },	/* acutecomb */
    { -1, gndata + 2505 },	/* adieresis */
    { -1, gndata + 2515 },	/* ae */
    { -1, gndata + 2518 },	/* aeacute */
    { -1, gndata + 2526 },	/* afii00208 */
    { -1, gndata + 2536 },	/* afii10017 */
    { -1, gndata + 2546 },	/* afii10018 */
    { -1, gndata + 2556 },	/* afii10019 */
    { -1, gndata + 2566 },	/* afii10020 */
    { -1, gndata + 2576 },	/* afii10021 */
    { -1, gndata + 2586 },	/* afii10022 */
    { -1, gndata + 2596 },	/* afii10023 */
    { -1, gndata + 2606 },	/* afii10024 */
    { -1, gndata + 2616 },	/* afii10025 */
    { -1, gndata + 2626 },	/* afii10026 */
    { -1, gndata + 2636 },	/* afii10027 */
    { -1, gndata + 2646 },	/* afii10028 */
    { -1, gndata + 2656 },	/* afii10029 */
    { -1, gndata + 2666 },	/* afii10030 */
    { -1, gndata + 2676 },	/* afii10031 */
    { -1, gndata + 2686 },	/* afii10032 */
    { -1, gndata + 2696 },	/* afii10033 */
    { -1, gndata + 2706 },	/* afii10034 */
    { -1, gndata + 2716 },	/* afii10035 */
    { -1, gndata + 2726 },	/* afii10036 */
    { -1, gndata + 2736 },	/* afii10037 */
    { -1, gndata + 2746 },	/* afii10038 */
    { -1, gndata + 2756 },	/* afii10039 */
    { -1, gndata + 2766 },	/* afii10040 */
    { -1, gndata + 2776 },	/* afii10041 */
    { -1, gndata + 2786 },	/* afii10042 */
    { -1, gndata + 2796 },	/* afii10043 */
    { -1, gndata + 2806 },	/* afii10044 */
    { -1, gndata + 2816 },	/* afii10045 */
    { -1, gndata + 2826 },	/* afii10046 */
    { -1, gndata + 2836 },	/* afii10047 */
    { -1, gndata + 2846 },	/* afii10048 */
    { -1, gndata + 2856 },	/* afii10049 */
    { -1, gndata + 2866 },	/* afii10050 */
    { -1, gndata + 2876 },	/* afii10051 */
    { -1, gndata + 2886 },	/* afii10052 */
    { -1, gndata + 2896 },	/* afii10053 */
    { -1, gndata + 2906 },	/* afii10054 */
    { -1, gndata + 2916 },	/* afii10055 */
    { -1, gndata + 2926 },	/* afii10056 */
    { -1, gndata + 2936 },	/* afii10057 */
    { -1, gndata + 2946 },	/* afii10058 */
    { -1, gndata + 2956 },	/* afii10059 */
    { -1, gndata + 2966 },	/* afii10060 */
    { -1, gndata + 2976 },	/* afii10061 */
    { -1, gndata + 2986 },	/* afii10062 */
    { -1, gndata + 2996 },	/* afii10063 */
    { -1, gndata + 3006 },	/* afii10064 */
    { -1, gndata + 3016 },	/* afii10065 */
    { -1, gndata + 3026 },	/* afii10066 */
    { -1, gndata + 3036 },	/* afii10067 */
    { -1, gndata + 3046 },	/* afii10068 */
    { -1, gndata + 3056 },	/* afii10069 */
    { -1, gndata + 3066 },	/* afii10070 */
    { -1, gndata + 3076 },	/* afii10071 */
    { -1, gndata + 3086 },	/* afii10072 */
    { -1, gndata + 3096 },	/* afii10073 */
    { -1, gndata + 3106 },	/* afii10074 */
    { -1, gndata + 3116 },	/* afii10075 */
    { -1, gndata + 3126 },	/* afii10076 */
    { -1, gndata + 3136 },	/* afii10077 */
    { -1, gndata + 3146 },	/* afii10078 */
    { -1, gndata + 3156 },	/* afii10079 */
    { -1, gndata + 3166 },	/* afii10080 */
    { -1, gndata + 3176 },	/* afii10081 */
    { -1, gndata + 3186 },	/* afii10082 */
    { -1, gndata + 3196 },	/* afii10083 */
    { -1, gndata + 3206 },	/* afii10084 */
    { -1, gndata + 3216 },	/* afii10085 */
    { -1, gndata + 3226 },	/* afii10086 */
    { -1, gndata + 3236 },	/* afii10087 */
    { -1, gndata + 3246 },	/* afii10088 */
    { -1, gndata + 3256 },	/* afii10089 */
    { -1, gndata + 3266 },	/* afii10090 */
    { -1, gndata + 3276 },	/* afii10091 */
    { -1, gndata + 3286 },	/* afii10092 */
    { -1, gndata + 3296 },	/* afii10093 */
    { -1, gndata + 3306 },	/* afii10094 */
    { -1, gndata + 3316 },	/* afii10095 */
    { -1, gndata + 3326 },	/* afii10096 */
    { -1, gndata + 3336 },	/* afii10097 */
    { -1, gndata + 3346 },	/* afii10098 */
    { -1, gndata + 3356 },	/* afii10099 */
    { -1, gndata + 3366 },	/* afii10100 */
    { -1, gndata + 3376 },	/* afii10101 */
    { -1, gndata + 3386 },	/* afii10102 */
    { -1, gndata + 3396 },	/* afii10103 */
    { -1, gndata + 3406 },	/* afii10104 */
    { -1, gndata + 3416 },	/* afii10105 */
    { -1, gndata + 3426 },	/* afii10106 */
    { -1, gndata + 3436 },	/* afii10107 */
    { -1, gndata + 3446 },	/* afii10108 */
    { -1, gndata + 3456 },	/* afii10109 */
    { -1, gndata + 3466 },	/* afii10110 */
    { -1, gndata + 3476 },	/* afii10145 */
    { -1, gndata + 3486 },	/* afii10146 */
    { -1, gndata + 3496 },	/* afii10147 */
    { -1, gndata + 3506 },	/* afii10148 */
    { -1, gndata + 3516 },	/* afii10192 */
    { -1, gndata + 3526 },	/* afii10193 */
    { -1, gndata + 3536 },	/* afii10194 */
    { -1, gndata + 3546 },	/* afii10195 */
    { -1, gndata + 3556 },	/* afii10196 */
    { -1, gndata + 3566 },	/* afii10831 */
    { -1, gndata + 3576 },	/* afii10832 */
    { -1, gndata + 3586 },	/* afii10846 */
    { -1, gndata + 3596 },	/* afii299 */
    { -1, gndata + 3604 },	/* afii300 */
    { -1, gndata + 3612 },	/* afii301 */
    { -1, gndata + 3620 },	/* afii57381 */
    { -1, gndata + 3630 },	/* afii57388 */
    { -1, gndata + 3640 },	/* afii57392 */
    { -1, gndata + 3650 },	/* afii57393 */
    { -1, gndata + 3660 },	/* afii57394 */
    { -1, gndata + 3670 },	/* afii57395 */
    { -1, gndata + 3680 },	/* afii57396 */
    { -1, gndata + 3690 },	/* afii57397 */
    { -1, gndata + 3700 },	/* afii57398 */
    { -1, gndata + 3710 },	/* afii57399 */
    { -1, gndata + 3720 },	/* afii57400 */
    { -1, gndata + 3730 },	/* afii57401 */
    { -1, gndata + 3740 },	/* afii57403 */
    { -1, gndata + 3750 },	/* afii57407 */
    { -1, gndata + 3760 },	/* afii57409 */
    { -1, gndata + 3770 },	/* afii57410 */
    { -1, gndata + 3780 },	/* afii57411 */
    { -1, gndata + 3790 },	/* afii57412 */
    { -1, gndata + 3800 },	/* afii57413 */
    { -1, gndata + 3810 },	/* afii57414 */
    { -1, gndata + 3820 },	/* afii57415 */
    { -1, gndata + 3830 },	/* afii57416 */
    { -1, gndata + 3840 },	/* afii57417 */
    { -1, gndata + 3850 },	/* afii57418 */
    { -1, gndata + 3860 },	/* afii57419 */
    { -1, gndata + 3870 },	/* afii57420 */
    { -1, gndata + 3880 },	/* afii57421 */
    { -1, gndata + 3890 },	/* afii57422 */
    { -1, gndata + 3900 },	/* afii57423 */
    { -1, gndata + 3910 },	/* afii57424 */
    { -1, gndata + 3920 },	/* afii57425 */
    { -1, gndata + 3930 },	/* afii57426 */
    { -1, gndata + 3940 },	/* afii57427 */
    { -1, gndata + 3950 },	/* afii57428 */
    { -1, gndata + 3960 },	/* afii57429 */
    { -1, gndata + 3970 },	/* afii57430 */
    { -1, gndata + 3980 },	/* afii57431 */
    { -1, gndata + 3990 },	/* afii57432 */
    { -1, gndata + 4000 },	/* afii57433 */
    { -1, gndata + 4010 },	/* afii57434 */
    { -1, gndata + 4020 },	/* afii57440 */
    { -1, gndata + 4030 },	/* afii57441 */
    { -1, gndata + 4040 },	/* afii57442 */
    { -1, gndata + 4050 },	/* afii57443 */
    { -1, gndata + 4060 },	/* afii57444 */
    { -1, gndata + 4070 },	/* afii57445 */
    { -1, gndata + 4080 },	/* afii57446 */
    { -1, gndata + 4090 },	/* afii57448 */
    { -1, gndata + 4100 },	/* afii57449 */
    { -1, gndata + 4110 },	/* afii57450 */
    { -1, gndata + 4120 },	/* afii57451 */
    { -1, gndata + 4130 },	/* afii57452 */
    { -1, gndata + 4140 },	/* afii57453 */
    { -1, gndata + 4150 },	/* afii57454 */
    { -1, gndata + 4160 },	/* afii57455 */
    { -1, gndata + 4170 },	/* afii57456 */
    { -1, gndata + 4180 },	/* afii57457 */
    { -1, gndata + 4190 },	/* afii57458 */
    { -1, gndata + 4200 },	/* afii57470 */
    { -1, gndata + 4210 },	/* afii57505 */
    { -1, gndata + 4220 },	/* afii57506 */
    { -1, gndata + 4230 },	/* afii57507 */
    { -1, gndata + 4240 },	/* afii57508 */
    { -1, gndata + 4250 },	/* afii57509 */
    { -1, gndata + 4260 },	/* afii57511 */
    { -1, gndata + 4270 },	/* afii57512 */
    { -1, gndata + 4280 },	/* afii57513 */
    { -1, gndata + 4290 },	/* afii57514 */
    { -1, gndata + 4300 },	/* afii57519 */
    { -1, gndata + 4310 },	/* afii57534 */
    { -1, gndata + 4320 },	/* afii57636 */
    { -1, gndata + 4330 },	/* afii57645 */
    { -1, gndata + 4340 },	/* afii57658 */
    { -1, gndata + 4350 },	/* afii57664 */
    { -1, gndata + 4360 },	/* afii57665 */
    { -1, gndata + 4370 },	/* afii57666 */
    { -1, gndata + 4380 },	/* afii57667 */
    { -1, gndata + 4390 },	/* afii57668 */
    { -1, gndata + 4400 },	/* afii57669 */
    { -1, gndata + 4410 },	/* afii57670 */
    { -1, gndata + 4420 },	/* afii57671 */
    { -1, gndata + 4430 },	/* afii57672 */
    { -1, gndata + 4440 },	/* afii57673 */
    { -1, gndata + 4450 },	/* afii57674 */
    { -1, gndata + 4460 },	/* afii57675 */
    { -1, gndata + 4470 },	/* afii57676 */
    { -1, gndata + 4480 },	/* afii57677 */
    { -1, gndata + 4490 },	/* afii57678 */
    { -1, gndata + 4500 },	/* afii57679 */
    { -1, gndata + 4510 },	/* afii57680 */
    { -1, gndata + 4520 },	/* afii57681 */
    { -1, gndata + 4530 },	/* afii57682 */
    { -1, gndata + 4540 },	/* afii57683 */
    { -1, gndata + 4550 },	/* afii57684 */
    { -1, gndata + 4560 },	/* afii57685 */
    { -1, gndata + 4570 },	/* afii57686 */
    { -1, gndata + 4580 },	/* afii57687 */
    { -1, gndata + 4590 },	/* afii57688 */
    { -1, gndata + 4600 },	/* afii57689 */
    { -1, gndata + 4610 },	/* afii57690 */
    { -1, gndata + 4620 },	/* afii57694 */
    { -1, gndata + 4630 },	/* afii57695 */
    { -1, gndata + 4640 },	/* afii57700 */
    { -1, gndata + 4650 },	/* afii57705 */
    { -1, gndata + 4660 },	/* afii57716 */
    { -1, gndata + 4670 },	/* afii57717 */
    { -1, gndata + 4680 },	/* afii57718 */
    { -1, gndata + 4690 },	/* afii57723 */
    { -1, gndata + 4700 },	/* afii57793 */
    { -1, gndata + 4710 },	/* afii57794 */
    { -1, gndata + 4720 },	/* afii57795 */
    { -1, gndata + 4730 },	/* afii57796 */
    { -1, gndata + 4740 },	/* afii57797 */
    { -1, gndata + 4750 },	/* afii57798 */
    { -1, gndata + 4760 },	/* afii57799 */
    { -1, gndata + 4770 },	/* afii57800 */
    { -1, gndata + 4780 },	/* afii57801 */
    { -1, gndata + 4790 },	/* afii57802 */
    { -1, gndata + 4800 },	/* afii57803 */
    { -1, gndata + 4810 },	/* afii57804 */
    { -1, gndata + 4820 },	/* afii57806 */
    { -1, gndata + 4830 },	/* afii57807 */
    { -1, gndata + 4840 },	/* afii57839 */
    { -1, gndata + 4850 },	/* afii57841 */
    { -1, gndata + 4860 },	/* afii57842 */
    { -1, gndata + 4870 },	/* afii57929 */
    { -1, gndata + 4880 },	/* afii61248 */
    { -1, gndata + 4890 },	/* afii61289 */
    { -1, gndata + 4900 },	/* afii61352 */
    { -1, gndata + 4910 },	/* afii61573 */
    { -1, gndata + 4920 },	/* afii61574 */
    { -1, gndata + 4930 },	/* afii61575 */
    { -1, gndata + 4940 },	/* afii61664 */
    { -1, gndata + 4950 },	/* afii63167 */
    { -1, gndata + 4960 },	/* afii64937 */
    { -1, gndata + 4970 },	/* agrave */
    { -1, gndata + 4977 },	/* aleph */
    { -1, gndata + 4983 },	/* alpha */
    { -1, gndata + 4989 },	/* alphatonos */
    { -1, gndata + 5000 },	/* amacron */
    { -1, gndata + 5008 },	/* ampersand */
    { -1, gndata + 5018 },	/* ampersandsmall */
    { -1, gndata + 5033 },	/* angle */
    { -1, gndata + 5039 },	/* angleleft */
    { -1, gndata + 5049 },	/* angleright */
    { -1, gndata + 5060 },	/* anoteleia */
    { -1, gndata + 5070 },	/* aogonek */
    { -1, gndata + 5078 },	/* approxequal */
    { -1, gndata + 5090 },	/* aring */
    { -1, gndata + 5096 },	/* aringacute */
    { -1, gndata + 5107 },	/* arrowboth */
    { -1, gndata + 5117 },	/* arrowdblboth */
    { -1, gndata + 5130 },	/* arrowdbldown */
    { -1, gndata + 5143 },	/* arrowdblleft */
    { -1, gndata + 5156 },	/* arrowdblright */
    { -1, gndata + 5170 },	/* arrowdblup */
    { -1, gndata + 5181 },	/* arrowdown */
    { -1, gndata + 5191 },	/* arrowhorizex */
    { -1, gndata + 5204 },	/* arrowleft */
    { -1, gndata + 5214 },	/* arrowright */
    { -1, gndata + 5225 },	/* arrowup */
    { -1, gndata + 5233 },	/* arrowupdn */
    { -1, gndata + 5243 },	/* arrowupdnbse */
    { -1, gndata + 5256 },	/* arrowvertex */
    { -1, gndata + 5268 },	/* asciicircum */
    { -1, gndata + 5280 },	/* asciitilde */
    { -1, gndata + 5291 },	/* asterisk */
    { -1, gndata + 5300 },	/* asteriskmath */
    { -1, gndata + 5313 },	/* asuperior */
    { -1, gndata + 5323 },	/* at */
    { -1, gndata + 5326 },	/* atilde */
    { -1, gndata + 5333 },	/* b */
    { -1, gndata + 5335 },	/* backslash */
    { -1, gndata + 5345 },	/* bar */
    { -1, gndata + 5349 },	/* beta */
    { -1, gndata + 5354 },	/* block */
    { -1, gndata + 5360 },	/* braceex */
    { -1, gndata + 5368 },	/* braceleft */
    { -1, gndata + 5378 },	/* braceleftbt */
    { -1, gndata + 5390 },	/* braceleftmid */
    { -1, gndata + 5403 },	/* bracelefttp */
    { -1, gndata + 5415 },	/* braceright */
    { -1, gndata + 5426 },	/* bracerightbt */
    { -1, gndata + 5439 },	/* bracerightmid */
    { -1, gndata + 5453 },	/* bracerighttp */
    { -1, gndata + 5466 },	/* bracketleft */
    { -1, gndata + 5478 },	/* bracketleftbt */
    { -1, gndata + 5492 },	/* bracketleftex */
    { -1, gndata + 5506 },	/* bracketlefttp */
    { -1, gndata + 5520 },	/* bracketright */
    { -1, gndata + 5533 },	/* bracketrightbt */
    { -1, gndata + 5548 },	/* bracketrightex */
    { -1, gndata + 5563 },	/* bracketrighttp */
    { -1, gndata + 5578 },	/* breve */
    { -1, gndata + 5584 },	/* brokenbar */
    { -1, gndata + 5594 },	/* bsuperior */
    { -1, gndata + 5604 },	/* bullet */
    { -1, gndata + 5611 },	/* c */
    { -1, gndata + 5613 },	/* cacute */
    { -1, gndata + 5620 },	/* caron */
    { -1, gndata + 5626 },	/* carriagereturn */
    { -1, gndata + 5641 },	/* ccaron */
    { -1, gndata + 5648 },	/* ccedilla */
    { -1, gndata + 5657 },	/* ccircumflex */
    { -1, gndata + 5669 },	/* cdotaccent */
    { -1, gndata + 5680 },	/* cedilla */
    { -1, gndata + 5688 },	/* cent */
    { -1, gndata + 5693 },	/* centinferior */
    { -1, gndata + 5706 },	/* centoldstyle */
    { -1, gndata + 5719 },	/* centsuperior */
    { -1, gndata + 5732 },	/* chi */
    { -1, gndata + 5736 },	/* circle */
    { -1, gndata + 5743 },	/* circlemultiply */
    { -1, gndata + 5758 },	/* circleplus */
    { -1, gndata + 5769 },	/* circumflex */
    { -1, gndata + 5780 },	/* club */
    { -1, gndata + 5785 },	/* colon */
    { -1, gndata + 5791 },	/* colonmonetary */
    { -1, gndata + 5805 },	/* comma */
    { -1, gndata + 5811 },	/* commaaccent */
    { -1, gndata + 5823 },	/* commainferior */
    { -1, gndata + 5837 },	/* commasuperior */
    { -1, gndata + 5851 },	/* congruent */
    { -1, gndata + 5861 },	/* copyright */
    { -1, gndata + 5871 },	/* copyrightsans */
    { -1, gndata + 5885 },	/* copyrightserif */
    { -1, gndata + 5900 },	/* currency */
    { -1, gndata + 5909 },	/* cyrBreve */
    { -1, gndata + 5918 },	/* cyrFlex */
    { -1, gndata + 5926 },	/* cyrbreve */
    { -1, gndata + 5935 },	/* cyrflex */
    { -1, gndata + 5943 },	/* d */
    { -1, gndata + 5945 },	/* dagger */
    { -1, gndata + 5952 },	/* daggerdbl */
    { -1, gndata + 5962 },	/* dblGrave */
    { -1, gndata + 5971 },	/* dblgrave */
    { -1, gndata + 5980 },	/* dcaron */
    { -1, gndata + 5987 },	/* dcroat */
    { -1, gndata + 5994 },	/* degree */
    { -1, gndata + 6001 },	/* delta */
    { -1, gndata + 6007 },	/* diamond */
    { -1, gndata + 6015 },	/* dieresis */
    { -1, gndata + 6024 },	/* dieresisacute */
    { -1, gndata + 6038 },	/* dieresisgrave */
    { -1, gndata + 6052 },	/* dieresistonos */
    { -1, gndata + 6066 },	/* divide */
    { -1, gndata + 6073 },	/* dkshade */
    { -1, gndata + 6081 },	/* dnblock */
    { -1, gndata + 6089 },	/* dollar */
    { -1, gndata + 6096 },	/* dollarinferior */
    { -1, gndata + 6111 },	/* dollaroldstyle */
    { -1, gndata + 6126 },	/* dollarsuperior */
    { -1, gndata + 6141 },	/* dong */
    { -1, gndata + 6146 },	/* dotaccent */
    { -1, gndata + 6156 },	/* dotbelowcomb */
    { -1, gndata + 6169 },	/* dotlessi */
    { -1, gndata + 6178 },	/* dotlessj */
    { -1, gndata + 6187 },	/* dotmath */
    { -1, gndata + 6195 },	/* dsuperior */
    { -1, gndata + 6205 },	/* e */
    { -1, gndata + 6207 },	/* eacute */
    { -1, gndata + 6214 },	/* ebreve */
    { -1, gndata + 6221 },	/* ecaron */
    { -1, gndata + 6228 },	/* ecircumflex */
    { -1, gndata + 6240 },	/* edieresis */
    { -1, gndata + 6250 },	/* edotaccent */
    { -1, gndata + 6261 },	/* egrave */
    { -1, gndata + 6268 },	/* eight */
    { -1, gndata + 6274 },	/* eightinferior */
    { -1, gndata + 6288 },	/* eightoldstyle */
    { -1, gndata + 6302 },	/* eightsuperior */
    { -1, gndata + 6316 },	/* element */
    { -1, gndata + 6324 },	/* ellipsis */
    { -1, gndata + 6333 },	/* emacron */
    { -1, gndata + 6341 },	/* emdash */
    { -1, gndata + 6348 },	/* emptyset */
    { -1, gndata + 6357 },	/* endash */
    { -1, gndata + 6364 },	/* eng */
    { -1, gndata + 6368 },	/* eogonek */
    { -1, gndata + 6376 },	/* epsilon */
    { -1, gndata + 6384 },	/* epsilontonos */
    { -1, gndata + 6397 },	/* equal */
    { -1, gndata + 6403 },	/* equivalence */
    { -1, gndata + 6415 },	/* estimated */
    { -1, gndata + 6425 },	/* esuperior */
    { -1, gndata + 6435 },	/* eta */
    { -1, gndata + 6439 },	/* etatonos */
    { -1, gndata + 6448 },	/* eth */
    { -1, gndata + 6452 },	/* exclam */
    { -1, gndata + 6459 },	/* exclamdbl */
    { -1, gndata + 6469 },	/* exclamdown */
    { -1, gndata + 6480 },	/* exclamdownsmall */
    { -1, gndata + 6496 },	/* exclamsmall */
    { -1, gndata + 6508 },	/* existential */
    { -1, gndata + 6520 },	/* f */
    { -1, gndata + 6522 },	/* female */
    { -1, gndata + 6529 },	/* ff */
    { -1, gndata + 6532 },	/* ffi */
    { -1, gndata + 6536 },	/* ffl */
    { -1, gndata + 6540 },	/* fi */
    { -1, gndata + 6543 },	/* figuredash */
    { -1, gndata + 6554 },	/* filledbox */
    { -1, gndata + 6564 },	/* filledrect */
    { -1, gndata + 6575 },	/* five */
    { -1, gndata + 6580 },	/* fiveeighths */
    { -1, gndata + 6592 },	/* fiveinferior */
    { -1, gndata + 6605 },	/* fiveoldstyle */
    { -1, gndata + 6618 },	/* fivesuperior */
    { -1, gndata + 6631 },	/* fl */
    { -1, gndata + 6634 },	/* florin */
    { -1, gndata + 6641 },	/* four */
    { -1, gndata + 6646 },	/* fourinferior */
    { -1, gndata + 6659 },	/* fouroldstyle */
    { -1, gndata + 6672 },	/* foursuperior */
    { -1, gndata + 6685 },	/* fraction */
    { -1, gndata + 6694 },	/* franc */
    { -1, gndata + 6700 },	/* g */
    { -1, gndata + 6702 },	/* gamma */
    { -1, gndata + 6708 },	/* gbreve */
    { -1, gndata + 6715 },	/* gcaron */
    { -1, gndata + 6722 },	/* gcircumflex */
    { -1, gndata + 6734 },	/* gcommaaccent */
    { -1, gndata + 6747 },	/* gdotaccent */
    { -1, gndata + 6758 },	/* germandbls */
    { -1, gndata + 6769 },	/* gradient */
    { -1, gndata + 6778 },	/* grave */
    { -1, gndata + 6784 },	/* gravecomb */
    { -1, gndata + 6794 },	/* greater */
    { -1, gndata + 6802 },	/* greaterequal */
    { -1, gndata + 6815 },	/* guillemotleft */
    { -1, gndata + 6829 },	/* guillemotright */
    { -1, gndata + 6844 },	/* guilsinglleft */
    { -1, gndata + 6858 },	/* guilsinglright */
    { -1, gndata + 6873 },	/* h */
    { -1, gndata + 6875 },	/* hbar */
    { -1, gndata + 6880 },	/* hcircumflex */
    { -1, gndata + 6892 },	/* heart */
    { -1, gndata + 6898 },	/* hookabovecomb */
    { -1, gndata + 6912 },	/* house */
    { -1, gndata + 6918 },	/* hungarumlaut */
    { -1, gndata + 6931 },	/* hyphen */
    { -1, gndata + 6938 },	/* hypheninferior */
    { -1, gndata + 6953 },	/* hyphensuperior */
    { -1, gndata + 6968 },	/* i */
    { -1, gndata + 6970 },	/* iacute */
    { -1, gndata + 6977 },	/* ibreve */
    { -1, gndata + 6984 },	/* icircumflex */
    { -1, gndata + 6996 },	/* idieresis */
    { -1, gndata + 7006 },	/* igrave */
    { -1, gndata + 7013 },	/* ij */
    { -1, gndata + 7016 },	/* imacron */
    { -1, gndata + 7024 },	/* infinity */
    { -1, gndata + 7033 },	/* integral */
    { -1, gndata + 7042 },	/* integralbt */
    { -1, gndata + 7053 },	/* integralex */
    { -1, gndata + 7064 },	/* integraltp */
    { -1, gndata + 7075 },	/* intersection */
    { -1, gndata + 7088 },	/* invbullet */
    { -1, gndata + 7098 },	/* invcircle */
    { -1, gndata + 7108 },	/* invsmileface */
    { -1, gndata + 7121 },	/* iogonek */
    { -1, gndata + 7129 },	/* iota */
    { -1, gndata + 7134 },	/* iotadieresis */
    { -1, gndata + 7147 },	/* iotadieresistonos */
    { -1, gndata + 7165 },	/* iotatonos */
    { -1, gndata + 7175 },	/* isuperior */
    { -1, gndata + 7185 },	/* itilde */
    { -1, gndata + 7192 },	/* j */
    { -1, gndata + 7194 },	/* jcircumflex */
    { -1, gndata + 7206 },	/* k */
    { -1, gndata + 7208 },	/* kappa */
    { -1, gndata + 7214 },	/* kcommaaccent */
    { -1, gndata + 7227 },	/* kgreenlandic */
    { -1, gndata + 7240 },	/* l */
    { -1, gndata + 7242 },	/* lacute */
    { -1, gndata + 7249 },	/* lambda */
    { -1, gndata + 7256 },	/* lcaron */
    { -1, gndata + 7263 },	/* lcommaaccent */
    { -1, gndata + 7276 },	/* ldot */
    { -1, gndata + 7281 },	/* less */
    { -1, gndata + 7286 },	/* lessequal */
    { -1, gndata + 7296 },	/* lfblock */
    { -1, gndata + 7304 },	/* lira */
    { -1, gndata + 7309 },	/* ll */
    { -1, gndata + 7312 },	/* logicaland */
    { -1, gndata + 7323 },	/* logicalnot */
    { -1, gndata + 7334 },	/* logicalor */
    { -1, gndata + 7344 },	/* longs */
    { -1, gndata + 7350 },	/* lozenge */
    { -1, gndata + 7358 },	/* lslash */
    { -1, gndata + 7365 },	/* lsuperior */
    { -1, gndata + 7375 },	/* ltshade */
    { -1, gndata + 7383 },	/* m */
    { -1, gndata + 7385 },	/* macron */
    { -1, gndata + 7392 },	/* male */
    { -1, gndata + 7397 },	/* minus */
    { -1, gndata + 7403 },	/* minute */
    { -1, gndata + 7410 },	/* msuperior */
    { -1, gndata + 7420 },	/* mu */
    { -1, gndata + 7423 },	/* multiply */
    { -1, gndata + 7432 },	/* musicalnote */
    { -1, gndata + 7444 },	/* musicalnotedbl */
    { -1, gndata + 7459 },	/* n */
    { -1, gndata + 7461 },	/* nacute */
    { -1, gndata + 7468 },	/* napostrophe */
    { -1, gndata + 7480 },	/* ncaron */
    { -1, gndata + 7487 },	/* ncommaaccent */
    { -1, gndata + 7500 },	/* nine */
    { -1, gndata + 7505 },	/* nineinferior */
    { -1, gndata + 7518 },	/* nineoldstyle */
    { -1, gndata + 7531 },	/* ninesuperior */
    { -1, gndata + 7544 },	/* notelement */
    { -1, gndata + 7555 },	/* notequal */
    { -1, gndata + 7564 },	/* notsubset */
    { -1, gndata + 7574 },	/* nsuperior */
    { -1, gndata + 7584 },	/* ntilde */
    { -1, gndata + 7591 },	/* nu */
    { -1, gndata + 7594 },	/* numbersign */
    { -1, gndata + 7605 },	/* o */
    { -1, gndata + 7607 },	/* oacute */
    { -1, gndata + 7614 },	/* obreve */
    { -1, gndata + 7621 },	/* ocircumflex */
    { -1, gndata + 7633 },	/* odieresis */
    { -1, gndata + 7643 },	/* oe */
    { -1, gndata + 7646 },	/* ogonek */
    { -1, gndata + 7653 },	/* ograve */
    { -1, gndata + 7660 },	/* ohorn */
    { -1, gndata + 7666 },	/* ohungarumlaut */
    { -1, gndata + 7680 },	/* omacron */
    { -1, gndata + 7688 },	/* omega */
    { -1, gndata + 7694 },	/* omega1 */
    { -1, gndata + 7701 },	/* omegatonos */
    { -1, gndata + 7712 },	/* omicron */
    { -1, gndata + 7720 },	/* omicrontonos */
    { -1, gndata + 7733 },	/* one */
    { -1, gndata + 7737 },	/* onedotenleader */
    { -1, gndata + 7752 },	/* oneeighth */
    { -1, gndata + 7762 },	/* onefitted */
    { -1, gndata + 7772 },	/* onehalf */
    { -1, gndata + 7780 },	/* oneinferior */
    { -1, gndata + 7792 },	/* oneoldstyle */
    { -1, gndata + 7804 },	/* onequarter */
    { -1, gndata + 7815 },	/* onesuperior */
    { -1, gndata + 7827 },	/* onethird */
    { -1, gndata + 7836 },	/* openbullet */
    { -1, gndata + 7847 },	/* ordfeminine */
    { -1, gndata + 7859 },	/* ordmasculine */
    { -1, gndata + 7872 },	/* orthogonal */
    { -1, gndata + 7883 },	/* oslash */
    { -1, gndata + 7890 },	/* oslashacute */
    { -1, gndata + 7902 },	/* osuperior */
    { -1, gndata + 7912 },	/* otilde */
    { -1, gndata + 7919 },	/* p */
    { -1, gndata + 7921 },	/* paragraph */
    { -1, gndata + 7931 },	/* parenleft */
    { -1, gndata + 7941 },	/* parenleftbt */
    { -1, gndata + 7953 },	/* parenleftex */
    { -1, gndata + 7965 },	/* parenleftinferior */
    { -1, gndata + 7983 },	/* parenleftsuperior */
    { -1, gndata + 8001 },	/* parenlefttp */
    { -1, gndata + 8013 },	/* parenright */
    { -1, gndata + 8024 },	/* parenrightbt */
    { -1, gndata + 8037 },	/* parenrightex */
    { -1, gndata + 8050 },	/* parenrightinferior */
    { -1, gndata + 8069 },	/* parenrightsuperior */
    { -1, gndata + 8088 },	/* parenrighttp */
    { -1, gndata + 8101 },	/* partialdiff */
    { -1, gndata + 8113 },	/* percent */
    { -1, gndata + 8121 },	/* period */
    { -1, gndata + 8128 },	/* periodcentered */
    { -1, gndata + 8143 },	/* periodinferior */
    { -1, gndata + 8158 },	/* periodsuperior */
    { -1, gndata + 8173 },	/* perpendicular */
    { -1, gndata + 8187 },	/* perthousand */
    { -1, gndata + 8199 },	/* peseta */
    { -1, gndata + 8206 },	/* phi */
    { -1, gndata + 8210 },	/* phi1 */
    { -1, gndata + 8215 },	/* pi */
    { -1, gndata + 8218 },	/* plus */
    { -1, gndata + 8223 },	/* plusminus */
    { -1, gndata + 8233 },	/* prescription */
    { -1, gndata + 8246 },	/* product */
    { -1, gndata + 8254 },	/* propersubset */
    { -1, gndata + 8267 },	/* propersuperset */
    { -1, gndata + 8282 },	/* proportional */
    { -1, gndata + 8295 },	/* psi */
    { -1, gndata + 8299 },	/* q */
    { -1, gndata + 8301 },	/* question */
    { -1, gndata + 8310 },	/* questiondown */
    { -1, gndata + 8323 },	/* questiondownsmall */
    { -1, gndata + 8341 },	/* questionsmall */
    { -1, gndata + 8355 },	/* quotedbl */
    { -1, gndata + 8364 },	/* quotedblbase */
    { -1, gndata + 8377 },	/* quotedblleft */
    { -1, gndata + 8390 },	/* quotedblright */
    { -1, gndata + 8404 },	/* quoteleft */
    { -1, gndata + 8414 },	/* quotereversed */
    { -1, gndata + 8428 },	/* quoteright */
    { -1, gndata + 8439 },	/* quotesinglbase */
    { -1, gndata + 8454 },	/* quotesingle */
    { -1, gndata + 8466 },	/* r */
    { -1, gndata + 8468 },	/* racute */
    { -1, gndata + 8475 },	/* radical */
    { -1, gndata + 8483 },	/* radicalex */
    { -1, gndata + 8493 },	/* rcaron */
    { -1, gndata + 8500 },	/* rcommaaccent */
    { -1, gndata + 8513 },	/* reflexsubset */
    { -1, gndata + 8526 },	/* reflexsuperset */
    { -1, gndata + 8541 },	/* registered */
    { -1, gndata + 8552 },	/* registersans */
    { -1, gndata + 8565 },	/* registerserif */
    { -1, gndata + 8579 },	/* revlogicalnot */
    { -1, gndata + 8593 },	/* rho */
    { -1, gndata + 8597 },	/* ring */
    { -1, gndata + 8602 },	/* rsuperior */
    { -1, gndata + 8612 },	/* rtblock */
    { -1, gndata + 8620 },	/* rupiah */
    { -1, gndata + 8627 },	/* s */
    { -1, gndata + 8629 },	/* sacute */
    { -1, gndata + 8636 },	/* scaron */
    { -1, gndata + 8643 },	/* scedilla */
    { -1, gndata + 8652 },	/* scircumflex */
    { -1, gndata + 8664 },	/* scommaaccent */
    { -1, gndata + 8677 },	/* second */
    { -1, gndata + 8684 },	/* section */
    { -1, gndata + 8692 },	/* semicolon */
    { -1, gndata + 8702 },	/* seven */
    { -1, gndata + 8708 },	/* seveneighths */
    { -1, gndata + 8721 },	/* seveninferior */
    { -1, gndata + 8735 },	/* sevenoldstyle */
    { -1, gndata + 8749 },	/* sevensuperior */
    { -1, gndata + 8763 },	/* shade */
    { -1, gndata + 8769 },	/* sigma */
    { -1, gndata + 8775 },	/* sigma1 */
    { -1, gndata + 8782 },	/* similar */
    { -1, gndata + 8790 },	/* six */
    { -1, gndata + 8794 },	/* sixinferior */
    { -1, gndata + 8806 },	/* sixoldstyle */
    { -1, gndata + 8818 },	/* sixsuperior */
    { -1, gndata + 8830 },	/* slash */
    { -1, gndata + 8836 },	/* smileface */
    { -1, gndata + 8846 },	/* space */
    { -1, gndata + 8852 },	/* spade */
    { -1, gndata + 8858 },	/* ssuperior */
    { -1, gndata + 8868 },	/* sterling */
    { -1, gndata + 8877 },	/* suchthat */
    { -1, gndata + 8886 },	/* summation */
    { -1, gndata + 8896 },	/* sun */
    { -1, gndata + 8900 },	/* t */
    { -1, gndata + 8902 },	/* tau */
    { -1, gndata + 8906 },	/* tbar */
    { -1, gndata + 8911 },	/* tcaron */
    { -1, gndata + 8918 },	/* tcommaaccent */
    { -1, gndata + 8931 },	/* therefore */
    { -1, gndata + 8941 },	/* theta */
    { -1, gndata + 8947 },	/* theta1 */
    { -1, gndata + 8954 },	/* thorn */
    { -1, gndata + 8960 },	/* three */
    { -1, gndata + 8966 },	/* threeeighths */
    { -1, gndata + 8979 },	/* threeinferior */
    { -1, gndata + 8993 },	/* threeoldstyle */
    { -1, gndata + 9007 },	/* threequarters */
    { -1, gndata + 9021 },	/* threequartersemdash */
    { -1, gndata + 9041 },	/* threesuperior */
    { -1, gndata + 9055 },	/* tilde */
    { -1, gndata + 9061 },	/* tildecomb */
    { -1, gndata + 9071 },	/* tonos */
    { -1, gndata + 9077 },	/* trademark */
    { -1, gndata + 9087 },	/* trademarksans */
    { -1, gndata + 9101 },	/* trademarkserif */
    { -1, gndata + 9116 },	/* triagdn */
    { -1, gndata + 9124 },	/* triaglf */
    { -1, gndata + 9132 },	/* triagrt */
    { -1, gndata + 9140 },	/* triagup */
    { -1, gndata + 9148 },	/* tsuperior */
    { -1, gndata + 9158 },	/* two */
    { -1, gndata + 9162 },	/* twodotenleader */
    { -1, gndata + 9177 },	/* twoinferior */
    { -1, gndata + 9189 },	/* twooldstyle */
    { -1, gndata + 9201 },	/* twosuperior */
    { -1, gndata + 9213 },	/* twothirds */
    { -1, gndata + 9223 },	/* u */
    { -1, gndata + 9225 },	/* uacute */
    { -1, gndata + 9232 },	/* ubreve */
    { -1, gndata + 9239 },	/* ucircumflex */
    { -1, gndata + 9251 },	/* udieresis */
    { -1, gndata + 9261 },	/* ugrave */
    { -1, gndata + 9268 },	/* uhorn */
    { -1, gndata + 9274 },	/* uhungarumlaut */
    { -1, gndata + 9288 },	/* umacron */
    { -1, gndata + 9296 },	/* underscore */
    { -1, gndata + 9307 },	/* underscoredbl */
    { -1, gndata + 9321 },	/* union */
    { -1, gndata + 9327 },	/* universal */
    { -1, gndata + 9337 },	/* uogonek */
    { -1, gndata + 9345 },	/* upblock */
    { -1, gndata + 9353 },	/* upsilon */
    { -1, gndata + 9361 },	/* upsilondieresis */
    { -1, gndata + 9377 },	/* upsilondieresistonos */
    { -1, gndata + 9398 },	/* upsilontonos */
    { -1, gndata + 9411 },	/* uring */
    { -1, gndata + 9417 },	/* utilde */
    { -1, gndata + 9424 },	/* v */
    { -1, gndata + 9426 },	/* w */
    { -1, gndata + 9428 },	/* wacute */
    { -1, gndata + 9435 },	/* wcircumflex */
    { -1, gndata + 9447 },	/* wdieresis */
    { -1, gndata + 9457 },	/* weierstrass */
    { -1, gndata + 9469 },	/* wgrave */
    { -1, gndata + 9476 },	/* x */
    { -1, gndata + 9478 },	/* xi */
    { -1, gndata + 9481 },	/* y */
    { -1, gndata + 9483 },	/* yacute */
    { -1, gndata + 9490 },	/* ycircumflex */
    { -1, gndata + 9502 },	/* ydieresis */
    { -1, gndata + 9512 },	/* yen */
    { -1, gndata + 9516 },	/* ygrave */
    { -1, gndata + 9523 },	/* z */
    { -1, gndata + 9525 },	/* zacute */
    { -1, gndata + 9532 },	/* zcaron */
    { -1, gndata + 9539 },	/* zdotaccent */
    { -1, gndata + 9550 },	/* zero */
    { -1, gndata + 9555 },	/* zeroinferior */
    { -1, gndata + 9568 },	/* zerooldstyle */
    { -1, gndata + 9581 },	/* zerosuperior */
    { -1, gndata + 9594 }	/* zeta */
};

const INT PSDRV_AGLGlyphNamesSize = 1039;

/*
 *  The AGL encoding vector, sorted by Unicode value
 *
 */
static const UNICODEGLYPH encoding[1051] =
{
    { 0x0020, PSDRV_AGLGlyphNames +  954 },	/* space */
    { 0x0021, PSDRV_AGLGlyphNames +  701 },	/* exclam */
    { 0x0022, PSDRV_AGLGlyphNames +  904 },	/* quotedbl */
    { 0x0023, PSDRV_AGLGlyphNames +  830 },	/* numbersign */
    { 0x0024, PSDRV_AGLGlyphNames +  661 },	/* dollar */
    { 0x0025, PSDRV_AGLGlyphNames +  880 },	/* percent */
    { 0x0026, PSDRV_AGLGlyphNames +  553 },	/* ampersand */
    { 0x0027, PSDRV_AGLGlyphNames +  912 },	/* quotesingle */
    { 0x0028, PSDRV_AGLGlyphNames +  867 },	/* parenleft */
    { 0x0029, PSDRV_AGLGlyphNames +  873 },	/* parenright */
    { 0x002a, PSDRV_AGLGlyphNames +  579 },	/* asterisk */
    { 0x002b, PSDRV_AGLGlyphNames +  891 },	/* plus */
    { 0x002c, PSDRV_AGLGlyphNames +  631 },	/* comma */
    { 0x002d, PSDRV_AGLGlyphNames +  753 },	/* hyphen */
    { 0x002e, PSDRV_AGLGlyphNames +  881 },	/* period */
    { 0x002f, PSDRV_AGLGlyphNames +  952 },	/* slash */
    { 0x0030, PSDRV_AGLGlyphNames + 1034 },	/* zero */
    { 0x0031, PSDRV_AGLGlyphNames +  847 },	/* one */
    { 0x0032, PSDRV_AGLGlyphNames +  988 },	/* two */
    { 0x0033, PSDRV_AGLGlyphNames +  970 },	/* three */
    { 0x0034, PSDRV_AGLGlyphNames +  723 },	/* four */
    { 0x0035, PSDRV_AGLGlyphNames +  716 },	/* five */
    { 0x0036, PSDRV_AGLGlyphNames +  948 },	/* six */
    { 0x0037, PSDRV_AGLGlyphNames +  939 },	/* seven */
    { 0x0038, PSDRV_AGLGlyphNames +  680 },	/* eight */
    { 0x0039, PSDRV_AGLGlyphNames +  820 },	/* nine */
    { 0x003a, PSDRV_AGLGlyphNames +  629 },	/* colon */
    { 0x003b, PSDRV_AGLGlyphNames +  938 },	/* semicolon */
    { 0x003c, PSDRV_AGLGlyphNames +  792 },	/* less */
    { 0x003d, PSDRV_AGLGlyphNames +  694 },	/* equal */
    { 0x003e, PSDRV_AGLGlyphNames +  740 },	/* greater */
    { 0x003f, PSDRV_AGLGlyphNames +  900 },	/* question */
    { 0x0040, PSDRV_AGLGlyphNames +  582 },	/* at */
    { 0x0041, PSDRV_AGLGlyphNames +    0 },	/* A */
    { 0x0042, PSDRV_AGLGlyphNames +   25 },	/* B */
    { 0x0043, PSDRV_AGLGlyphNames +   29 },	/* C */
    { 0x0044, PSDRV_AGLGlyphNames +   42 },	/* D */
    { 0x0045, PSDRV_AGLGlyphNames +   52 },	/* E */
    { 0x0046, PSDRV_AGLGlyphNames +   75 },	/* F */
    { 0x0047, PSDRV_AGLGlyphNames +   77 },	/* G */
    { 0x0048, PSDRV_AGLGlyphNames +   87 },	/* H */
    { 0x0049, PSDRV_AGLGlyphNames +   97 },	/* I */
    { 0x004a, PSDRV_AGLGlyphNames +  117 },	/* J */
    { 0x004b, PSDRV_AGLGlyphNames +  120 },	/* K */
    { 0x004c, PSDRV_AGLGlyphNames +  124 },	/* L */
    { 0x004d, PSDRV_AGLGlyphNames +  134 },	/* M */
    { 0x004e, PSDRV_AGLGlyphNames +  139 },	/* N */
    { 0x004f, PSDRV_AGLGlyphNames +  147 },	/* O */
    { 0x0050, PSDRV_AGLGlyphNames +  173 },	/* P */
    { 0x0051, PSDRV_AGLGlyphNames +  178 },	/* Q */
    { 0x0052, PSDRV_AGLGlyphNames +  180 },	/* R */
    { 0x0053, PSDRV_AGLGlyphNames +  188 },	/* S */
    { 0x0054, PSDRV_AGLGlyphNames +  237 },	/* T */
    { 0x0055, PSDRV_AGLGlyphNames +  247 },	/* U */
    { 0x0056, PSDRV_AGLGlyphNames +  268 },	/* V */
    { 0x0057, PSDRV_AGLGlyphNames +  270 },	/* W */
    { 0x0058, PSDRV_AGLGlyphNames +  276 },	/* X */
    { 0x0059, PSDRV_AGLGlyphNames +  279 },	/* Y */
    { 0x005a, PSDRV_AGLGlyphNames +  287 },	/* Z */
    { 0x005b, PSDRV_AGLGlyphNames +  598 },	/* bracketleft */
    { 0x005c, PSDRV_AGLGlyphNames +  585 },	/* backslash */
    { 0x005d, PSDRV_AGLGlyphNames +  602 },	/* bracketright */
    { 0x005e, PSDRV_AGLGlyphNames +  577 },	/* asciicircum */
    { 0x005f, PSDRV_AGLGlyphNames + 1003 },	/* underscore */
    { 0x0060, PSDRV_AGLGlyphNames +  738 },	/* grave */
    { 0x0061, PSDRV_AGLGlyphNames +  294 },	/* a */
    { 0x0062, PSDRV_AGLGlyphNames +  584 },	/* b */
    { 0x0063, PSDRV_AGLGlyphNames +  610 },	/* c */
    { 0x0064, PSDRV_AGLGlyphNames +  644 },	/* d */
    { 0x0065, PSDRV_AGLGlyphNames +  672 },	/* e */
    { 0x0066, PSDRV_AGLGlyphNames +  707 },	/* f */
    { 0x0067, PSDRV_AGLGlyphNames +  729 },	/* g */
    { 0x0068, PSDRV_AGLGlyphNames +  746 },	/* h */
    { 0x0069, PSDRV_AGLGlyphNames +  756 },	/* i */
    { 0x006a, PSDRV_AGLGlyphNames +  780 },	/* j */
    { 0x006b, PSDRV_AGLGlyphNames +  782 },	/* k */
    { 0x006c, PSDRV_AGLGlyphNames +  786 },	/* l */
    { 0x006d, PSDRV_AGLGlyphNames +  805 },	/* m */
    { 0x006e, PSDRV_AGLGlyphNames +  815 },	/* n */
    { 0x006f, PSDRV_AGLGlyphNames +  831 },	/* o */
    { 0x0070, PSDRV_AGLGlyphNames +  865 },	/* p */
    { 0x0071, PSDRV_AGLGlyphNames +  899 },	/* q */
    { 0x0072, PSDRV_AGLGlyphNames +  913 },	/* r */
    { 0x0073, PSDRV_AGLGlyphNames +  930 },	/* s */
    { 0x0074, PSDRV_AGLGlyphNames +  961 },	/* t */
    { 0x0075, PSDRV_AGLGlyphNames +  994 },	/* u */
    { 0x0076, PSDRV_AGLGlyphNames + 1015 },	/* v */
    { 0x0077, PSDRV_AGLGlyphNames + 1016 },	/* w */
    { 0x0078, PSDRV_AGLGlyphNames + 1022 },	/* x */
    { 0x0079, PSDRV_AGLGlyphNames + 1024 },	/* y */
    { 0x007a, PSDRV_AGLGlyphNames + 1030 },	/* z */
    { 0x007b, PSDRV_AGLGlyphNames +  590 },	/* braceleft */
    { 0x007c, PSDRV_AGLGlyphNames +  586 },	/* bar */
    { 0x007d, PSDRV_AGLGlyphNames +  594 },	/* braceright */
    { 0x007e, PSDRV_AGLGlyphNames +  578 },	/* asciitilde */
    { 0x00a0, PSDRV_AGLGlyphNames +  954 },	/* space */
    { 0x00a1, PSDRV_AGLGlyphNames +  703 },	/* exclamdown */
    { 0x00a2, PSDRV_AGLGlyphNames +  619 },	/* cent */
    { 0x00a3, PSDRV_AGLGlyphNames +  957 },	/* sterling */
    { 0x00a4, PSDRV_AGLGlyphNames +  639 },	/* currency */
    { 0x00a5, PSDRV_AGLGlyphNames + 1028 },	/* yen */
    { 0x00a6, PSDRV_AGLGlyphNames +  607 },	/* brokenbar */
    { 0x00a7, PSDRV_AGLGlyphNames +  937 },	/* section */
    { 0x00a8, PSDRV_AGLGlyphNames +  654 },	/* dieresis */
    { 0x00a9, PSDRV_AGLGlyphNames +  636 },	/* copyright */
    { 0x00aa, PSDRV_AGLGlyphNames +  858 },	/* ordfeminine */
    { 0x00ab, PSDRV_AGLGlyphNames +  742 },	/* guillemotleft */
    { 0x00ac, PSDRV_AGLGlyphNames +  798 },	/* logicalnot */
    { 0x00ad, PSDRV_AGLGlyphNames +  753 },	/* hyphen */
    { 0x00ae, PSDRV_AGLGlyphNames +  921 },	/* registered */
    { 0x00af, PSDRV_AGLGlyphNames +  806 },	/* macron */
    { 0x00b0, PSDRV_AGLGlyphNames +  651 },	/* degree */
    { 0x00b1, PSDRV_AGLGlyphNames +  892 },	/* plusminus */
    { 0x00b2, PSDRV_AGLGlyphNames +  992 },	/* twosuperior */
    { 0x00b3, PSDRV_AGLGlyphNames +  976 },	/* threesuperior */
    { 0x00b4, PSDRV_AGLGlyphNames +  298 },	/* acute */
    { 0x00b5, PSDRV_AGLGlyphNames +  811 },	/* mu */
    { 0x00b6, PSDRV_AGLGlyphNames +  866 },	/* paragraph */
    { 0x00b7, PSDRV_AGLGlyphNames +  882 },	/* periodcentered */
    { 0x00b8, PSDRV_AGLGlyphNames +  618 },	/* cedilla */
    { 0x00b9, PSDRV_AGLGlyphNames +  855 },	/* onesuperior */
    { 0x00ba, PSDRV_AGLGlyphNames +  859 },	/* ordmasculine */
    { 0x00bb, PSDRV_AGLGlyphNames +  743 },	/* guillemotright */
    { 0x00bc, PSDRV_AGLGlyphNames +  854 },	/* onequarter */
    { 0x00bd, PSDRV_AGLGlyphNames +  851 },	/* onehalf */
    { 0x00be, PSDRV_AGLGlyphNames +  974 },	/* threequarters */
    { 0x00bf, PSDRV_AGLGlyphNames +  901 },	/* questiondown */
    { 0x00c0, PSDRV_AGLGlyphNames +   13 },	/* Agrave */
    { 0x00c1, PSDRV_AGLGlyphNames +    4 },	/* Aacute */
    { 0x00c2, PSDRV_AGLGlyphNames +    7 },	/* Acircumflex */
    { 0x00c3, PSDRV_AGLGlyphNames +   23 },	/* Atilde */
    { 0x00c4, PSDRV_AGLGlyphNames +   11 },	/* Adieresis */
    { 0x00c5, PSDRV_AGLGlyphNames +   19 },	/* Aring */
    { 0x00c6, PSDRV_AGLGlyphNames +    1 },	/* AE */
    { 0x00c7, PSDRV_AGLGlyphNames +   34 },	/* Ccedilla */
    { 0x00c8, PSDRV_AGLGlyphNames +   62 },	/* Egrave */
    { 0x00c9, PSDRV_AGLGlyphNames +   53 },	/* Eacute */
    { 0x00ca, PSDRV_AGLGlyphNames +   57 },	/* Ecircumflex */
    { 0x00cb, PSDRV_AGLGlyphNames +   59 },	/* Edieresis */
    { 0x00cc, PSDRV_AGLGlyphNames +  108 },	/* Igrave */
    { 0x00cd, PSDRV_AGLGlyphNames +   99 },	/* Iacute */
    { 0x00ce, PSDRV_AGLGlyphNames +  102 },	/* Icircumflex */
    { 0x00cf, PSDRV_AGLGlyphNames +  104 },	/* Idieresis */
    { 0x00d0, PSDRV_AGLGlyphNames +   72 },	/* Eth */
    { 0x00d1, PSDRV_AGLGlyphNames +  144 },	/* Ntilde */
    { 0x00d2, PSDRV_AGLGlyphNames +  158 },	/* Ograve */
    { 0x00d3, PSDRV_AGLGlyphNames +  150 },	/* Oacute */
    { 0x00d4, PSDRV_AGLGlyphNames +  153 },	/* Ocircumflex */
    { 0x00d5, PSDRV_AGLGlyphNames +  171 },	/* Otilde */
    { 0x00d6, PSDRV_AGLGlyphNames +  155 },	/* Odieresis */
    { 0x00d7, PSDRV_AGLGlyphNames +  812 },	/* multiply */
    { 0x00d8, PSDRV_AGLGlyphNames +  167 },	/* Oslash */
    { 0x00d9, PSDRV_AGLGlyphNames +  255 },	/* Ugrave */
    { 0x00da, PSDRV_AGLGlyphNames +  248 },	/* Uacute */
    { 0x00db, PSDRV_AGLGlyphNames +  251 },	/* Ucircumflex */
    { 0x00dc, PSDRV_AGLGlyphNames +  253 },	/* Udieresis */
    { 0x00dd, PSDRV_AGLGlyphNames +  280 },	/* Yacute */
    { 0x00de, PSDRV_AGLGlyphNames +  243 },	/* Thorn */
    { 0x00df, PSDRV_AGLGlyphNames +  736 },	/* germandbls */
    { 0x00e0, PSDRV_AGLGlyphNames +  548 },	/* agrave */
    { 0x00e1, PSDRV_AGLGlyphNames +  295 },	/* aacute */
    { 0x00e2, PSDRV_AGLGlyphNames +  297 },	/* acircumflex */
    { 0x00e3, PSDRV_AGLGlyphNames +  583 },	/* atilde */
    { 0x00e4, PSDRV_AGLGlyphNames +  300 },	/* adieresis */
    { 0x00e5, PSDRV_AGLGlyphNames +  561 },	/* aring */
    { 0x00e6, PSDRV_AGLGlyphNames +  301 },	/* ae */
    { 0x00e7, PSDRV_AGLGlyphNames +  615 },	/* ccedilla */
    { 0x00e8, PSDRV_AGLGlyphNames +  679 },	/* egrave */
    { 0x00e9, PSDRV_AGLGlyphNames +  673 },	/* eacute */
    { 0x00ea, PSDRV_AGLGlyphNames +  676 },	/* ecircumflex */
    { 0x00eb, PSDRV_AGLGlyphNames +  677 },	/* edieresis */
    { 0x00ec, PSDRV_AGLGlyphNames +  761 },	/* igrave */
    { 0x00ed, PSDRV_AGLGlyphNames +  757 },	/* iacute */
    { 0x00ee, PSDRV_AGLGlyphNames +  759 },	/* icircumflex */
    { 0x00ef, PSDRV_AGLGlyphNames +  760 },	/* idieresis */
    { 0x00f0, PSDRV_AGLGlyphNames +  700 },	/* eth */
    { 0x00f1, PSDRV_AGLGlyphNames +  828 },	/* ntilde */
    { 0x00f2, PSDRV_AGLGlyphNames +  838 },	/* ograve */
    { 0x00f3, PSDRV_AGLGlyphNames +  832 },	/* oacute */
    { 0x00f4, PSDRV_AGLGlyphNames +  834 },	/* ocircumflex */
    { 0x00f5, PSDRV_AGLGlyphNames +  864 },	/* otilde */
    { 0x00f6, PSDRV_AGLGlyphNames +  835 },	/* odieresis */
    { 0x00f7, PSDRV_AGLGlyphNames +  658 },	/* divide */
    { 0x00f8, PSDRV_AGLGlyphNames +  861 },	/* oslash */
    { 0x00f9, PSDRV_AGLGlyphNames +  999 },	/* ugrave */
    { 0x00fa, PSDRV_AGLGlyphNames +  995 },	/* uacute */
    { 0x00fb, PSDRV_AGLGlyphNames +  997 },	/* ucircumflex */
    { 0x00fc, PSDRV_AGLGlyphNames +  998 },	/* udieresis */
    { 0x00fd, PSDRV_AGLGlyphNames + 1025 },	/* yacute */
    { 0x00fe, PSDRV_AGLGlyphNames +  969 },	/* thorn */
    { 0x00ff, PSDRV_AGLGlyphNames + 1027 },	/* ydieresis */
    { 0x0100, PSDRV_AGLGlyphNames +   17 },	/* Amacron */
    { 0x0101, PSDRV_AGLGlyphNames +  552 },	/* amacron */
    { 0x0102, PSDRV_AGLGlyphNames +    6 },	/* Abreve */
    { 0x0103, PSDRV_AGLGlyphNames +  296 },	/* abreve */
    { 0x0104, PSDRV_AGLGlyphNames +   18 },	/* Aogonek */
    { 0x0105, PSDRV_AGLGlyphNames +  559 },	/* aogonek */
    { 0x0106, PSDRV_AGLGlyphNames +   30 },	/* Cacute */
    { 0x0107, PSDRV_AGLGlyphNames +  611 },	/* cacute */
    { 0x0108, PSDRV_AGLGlyphNames +   36 },	/* Ccircumflex */
    { 0x0109, PSDRV_AGLGlyphNames +  616 },	/* ccircumflex */
    { 0x010a, PSDRV_AGLGlyphNames +   37 },	/* Cdotaccent */
    { 0x010b, PSDRV_AGLGlyphNames +  617 },	/* cdotaccent */
    { 0x010c, PSDRV_AGLGlyphNames +   33 },	/* Ccaron */
    { 0x010d, PSDRV_AGLGlyphNames +  614 },	/* ccaron */
    { 0x010e, PSDRV_AGLGlyphNames +   43 },	/* Dcaron */
    { 0x010f, PSDRV_AGLGlyphNames +  649 },	/* dcaron */
    { 0x0110, PSDRV_AGLGlyphNames +   44 },	/* Dcroat */
    { 0x0111, PSDRV_AGLGlyphNames +  650 },	/* dcroat */
    { 0x0112, PSDRV_AGLGlyphNames +   64 },	/* Emacron */
    { 0x0113, PSDRV_AGLGlyphNames +  686 },	/* emacron */
    { 0x0114, PSDRV_AGLGlyphNames +   55 },	/* Ebreve */
    { 0x0115, PSDRV_AGLGlyphNames +  674 },	/* ebreve */
    { 0x0116, PSDRV_AGLGlyphNames +   61 },	/* Edotaccent */
    { 0x0117, PSDRV_AGLGlyphNames +  678 },	/* edotaccent */
    { 0x0118, PSDRV_AGLGlyphNames +   66 },	/* Eogonek */
    { 0x0119, PSDRV_AGLGlyphNames +  691 },	/* eogonek */
    { 0x011a, PSDRV_AGLGlyphNames +   56 },	/* Ecaron */
    { 0x011b, PSDRV_AGLGlyphNames +  675 },	/* ecaron */
    { 0x011c, PSDRV_AGLGlyphNames +   81 },	/* Gcircumflex */
    { 0x011d, PSDRV_AGLGlyphNames +  733 },	/* gcircumflex */
    { 0x011e, PSDRV_AGLGlyphNames +   79 },	/* Gbreve */
    { 0x011f, PSDRV_AGLGlyphNames +  731 },	/* gbreve */
    { 0x0120, PSDRV_AGLGlyphNames +   83 },	/* Gdotaccent */
    { 0x0121, PSDRV_AGLGlyphNames +  735 },	/* gdotaccent */
    { 0x0122, PSDRV_AGLGlyphNames +   82 },	/* Gcommaaccent */
    { 0x0123, PSDRV_AGLGlyphNames +  734 },	/* gcommaaccent */
    { 0x0124, PSDRV_AGLGlyphNames +   93 },	/* Hcircumflex */
    { 0x0125, PSDRV_AGLGlyphNames +  748 },	/* hcircumflex */
    { 0x0126, PSDRV_AGLGlyphNames +   92 },	/* Hbar */
    { 0x0127, PSDRV_AGLGlyphNames +  747 },	/* hbar */
    { 0x0128, PSDRV_AGLGlyphNames +  116 },	/* Itilde */
    { 0x0129, PSDRV_AGLGlyphNames +  779 },	/* itilde */
    { 0x012a, PSDRV_AGLGlyphNames +  110 },	/* Imacron */
    { 0x012b, PSDRV_AGLGlyphNames +  763 },	/* imacron */
    { 0x012c, PSDRV_AGLGlyphNames +  101 },	/* Ibreve */
    { 0x012d, PSDRV_AGLGlyphNames +  758 },	/* ibreve */
    { 0x012e, PSDRV_AGLGlyphNames +  111 },	/* Iogonek */
    { 0x012f, PSDRV_AGLGlyphNames +  773 },	/* iogonek */
    { 0x0130, PSDRV_AGLGlyphNames +  106 },	/* Idotaccent */
    { 0x0131, PSDRV_AGLGlyphNames +  668 },	/* dotlessi */
    { 0x0132, PSDRV_AGLGlyphNames +   98 },	/* IJ */
    { 0x0133, PSDRV_AGLGlyphNames +  762 },	/* ij */
    { 0x0134, PSDRV_AGLGlyphNames +  118 },	/* Jcircumflex */
    { 0x0135, PSDRV_AGLGlyphNames +  781 },	/* jcircumflex */
    { 0x0136, PSDRV_AGLGlyphNames +  122 },	/* Kcommaaccent */
    { 0x0137, PSDRV_AGLGlyphNames +  784 },	/* kcommaaccent */
    { 0x0138, PSDRV_AGLGlyphNames +  785 },	/* kgreenlandic */
    { 0x0139, PSDRV_AGLGlyphNames +  126 },	/* Lacute */
    { 0x013a, PSDRV_AGLGlyphNames +  787 },	/* lacute */
    { 0x013b, PSDRV_AGLGlyphNames +  129 },	/* Lcommaaccent */
    { 0x013c, PSDRV_AGLGlyphNames +  790 },	/* lcommaaccent */
    { 0x013d, PSDRV_AGLGlyphNames +  128 },	/* Lcaron */
    { 0x013e, PSDRV_AGLGlyphNames +  789 },	/* lcaron */
    { 0x013f, PSDRV_AGLGlyphNames +  130 },	/* Ldot */
    { 0x0140, PSDRV_AGLGlyphNames +  791 },	/* ldot */
    { 0x0141, PSDRV_AGLGlyphNames +  131 },	/* Lslash */
    { 0x0142, PSDRV_AGLGlyphNames +  802 },	/* lslash */
    { 0x0143, PSDRV_AGLGlyphNames +  140 },	/* Nacute */
    { 0x0144, PSDRV_AGLGlyphNames +  816 },	/* nacute */
    { 0x0145, PSDRV_AGLGlyphNames +  142 },	/* Ncommaaccent */
    { 0x0146, PSDRV_AGLGlyphNames +  819 },	/* ncommaaccent */
    { 0x0147, PSDRV_AGLGlyphNames +  141 },	/* Ncaron */
    { 0x0148, PSDRV_AGLGlyphNames +  818 },	/* ncaron */
    { 0x0149, PSDRV_AGLGlyphNames +  817 },	/* napostrophe */
    { 0x014a, PSDRV_AGLGlyphNames +   65 },	/* Eng */
    { 0x014b, PSDRV_AGLGlyphNames +  690 },	/* eng */
    { 0x014c, PSDRV_AGLGlyphNames +  162 },	/* Omacron */
    { 0x014d, PSDRV_AGLGlyphNames +  841 },	/* omacron */
    { 0x014e, PSDRV_AGLGlyphNames +  152 },	/* Obreve */
    { 0x014f, PSDRV_AGLGlyphNames +  833 },	/* obreve */
    { 0x0150, PSDRV_AGLGlyphNames +  161 },	/* Ohungarumlaut */
    { 0x0151, PSDRV_AGLGlyphNames +  840 },	/* ohungarumlaut */
    { 0x0152, PSDRV_AGLGlyphNames +  148 },	/* OE */
    { 0x0153, PSDRV_AGLGlyphNames +  836 },	/* oe */
    { 0x0154, PSDRV_AGLGlyphNames +  181 },	/* Racute */
    { 0x0155, PSDRV_AGLGlyphNames +  914 },	/* racute */
    { 0x0156, PSDRV_AGLGlyphNames +  183 },	/* Rcommaaccent */
    { 0x0157, PSDRV_AGLGlyphNames +  918 },	/* rcommaaccent */
    { 0x0158, PSDRV_AGLGlyphNames +  182 },	/* Rcaron */
    { 0x0159, PSDRV_AGLGlyphNames +  917 },	/* rcaron */
    { 0x015a, PSDRV_AGLGlyphNames +  229 },	/* Sacute */
    { 0x015b, PSDRV_AGLGlyphNames +  931 },	/* sacute */
    { 0x015c, PSDRV_AGLGlyphNames +  233 },	/* Scircumflex */
    { 0x015d, PSDRV_AGLGlyphNames +  934 },	/* scircumflex */
    { 0x015e, PSDRV_AGLGlyphNames +  232 },	/* Scedilla */
    { 0x015f, PSDRV_AGLGlyphNames +  933 },	/* scedilla */
    { 0x0160, PSDRV_AGLGlyphNames +  230 },	/* Scaron */
    { 0x0161, PSDRV_AGLGlyphNames +  932 },	/* scaron */
    { 0x0162, PSDRV_AGLGlyphNames +  241 },	/* Tcommaaccent */
    { 0x0163, PSDRV_AGLGlyphNames +  965 },	/* tcommaaccent */
    { 0x0164, PSDRV_AGLGlyphNames +  240 },	/* Tcaron */
    { 0x0165, PSDRV_AGLGlyphNames +  964 },	/* tcaron */
    { 0x0166, PSDRV_AGLGlyphNames +  239 },	/* Tbar */
    { 0x0167, PSDRV_AGLGlyphNames +  963 },	/* tbar */
    { 0x0168, PSDRV_AGLGlyphNames +  267 },	/* Utilde */
    { 0x0169, PSDRV_AGLGlyphNames + 1014 },	/* utilde */
    { 0x016a, PSDRV_AGLGlyphNames +  259 },	/* Umacron */
    { 0x016b, PSDRV_AGLGlyphNames + 1002 },	/* umacron */
    { 0x016c, PSDRV_AGLGlyphNames +  250 },	/* Ubreve */
    { 0x016d, PSDRV_AGLGlyphNames +  996 },	/* ubreve */
    { 0x016e, PSDRV_AGLGlyphNames +  265 },	/* Uring */
    { 0x016f, PSDRV_AGLGlyphNames + 1013 },	/* uring */
    { 0x0170, PSDRV_AGLGlyphNames +  258 },	/* Uhungarumlaut */
    { 0x0171, PSDRV_AGLGlyphNames + 1001 },	/* uhungarumlaut */
    { 0x0172, PSDRV_AGLGlyphNames +  260 },	/* Uogonek */
    { 0x0173, PSDRV_AGLGlyphNames + 1007 },	/* uogonek */
    { 0x0174, PSDRV_AGLGlyphNames +  272 },	/* Wcircumflex */
    { 0x0175, PSDRV_AGLGlyphNames + 1018 },	/* wcircumflex */
    { 0x0176, PSDRV_AGLGlyphNames +  282 },	/* Ycircumflex */
    { 0x0177, PSDRV_AGLGlyphNames + 1026 },	/* ycircumflex */
    { 0x0178, PSDRV_AGLGlyphNames +  283 },	/* Ydieresis */
    { 0x0179, PSDRV_AGLGlyphNames +  288 },	/* Zacute */
    { 0x017a, PSDRV_AGLGlyphNames + 1031 },	/* zacute */
    { 0x017b, PSDRV_AGLGlyphNames +  291 },	/* Zdotaccent */
    { 0x017c, PSDRV_AGLGlyphNames + 1033 },	/* zdotaccent */
    { 0x017d, PSDRV_AGLGlyphNames +  289 },	/* Zcaron */
    { 0x017e, PSDRV_AGLGlyphNames + 1032 },	/* zcaron */
    { 0x017f, PSDRV_AGLGlyphNames +  800 },	/* longs */
    { 0x0192, PSDRV_AGLGlyphNames +  722 },	/* florin */
    { 0x01a0, PSDRV_AGLGlyphNames +  160 },	/* Ohorn */
    { 0x01a1, PSDRV_AGLGlyphNames +  839 },	/* ohorn */
    { 0x01af, PSDRV_AGLGlyphNames +  257 },	/* Uhorn */
    { 0x01b0, PSDRV_AGLGlyphNames + 1000 },	/* uhorn */
    { 0x01e6, PSDRV_AGLGlyphNames +   80 },	/* Gcaron */
    { 0x01e7, PSDRV_AGLGlyphNames +  732 },	/* gcaron */
    { 0x01fa, PSDRV_AGLGlyphNames +   20 },	/* Aringacute */
    { 0x01fb, PSDRV_AGLGlyphNames +  562 },	/* aringacute */
    { 0x01fc, PSDRV_AGLGlyphNames +    2 },	/* AEacute */
    { 0x01fd, PSDRV_AGLGlyphNames +  302 },	/* aeacute */
    { 0x01fe, PSDRV_AGLGlyphNames +  168 },	/* Oslashacute */
    { 0x01ff, PSDRV_AGLGlyphNames +  862 },	/* oslashacute */
    { 0x0218, PSDRV_AGLGlyphNames +  234 },	/* Scommaaccent */
    { 0x0219, PSDRV_AGLGlyphNames +  935 },	/* scommaaccent */
    { 0x021a, PSDRV_AGLGlyphNames +  241 },	/* Tcommaaccent */
    { 0x021b, PSDRV_AGLGlyphNames +  965 },	/* tcommaaccent */
    { 0x02bc, PSDRV_AGLGlyphNames +  538 },	/* afii57929 */
    { 0x02bd, PSDRV_AGLGlyphNames +  547 },	/* afii64937 */
    { 0x02c6, PSDRV_AGLGlyphNames +  627 },	/* circumflex */
    { 0x02c7, PSDRV_AGLGlyphNames +  612 },	/* caron */
    { 0x02c9, PSDRV_AGLGlyphNames +  806 },	/* macron */
    { 0x02d8, PSDRV_AGLGlyphNames +  606 },	/* breve */
    { 0x02d9, PSDRV_AGLGlyphNames +  666 },	/* dotaccent */
    { 0x02da, PSDRV_AGLGlyphNames +  926 },	/* ring */
    { 0x02db, PSDRV_AGLGlyphNames +  837 },	/* ogonek */
    { 0x02dc, PSDRV_AGLGlyphNames +  977 },	/* tilde */
    { 0x02dd, PSDRV_AGLGlyphNames +  752 },	/* hungarumlaut */
    { 0x0300, PSDRV_AGLGlyphNames +  739 },	/* gravecomb */
    { 0x0301, PSDRV_AGLGlyphNames +  299 },	/* acutecomb */
    { 0x0303, PSDRV_AGLGlyphNames +  978 },	/* tildecomb */
    { 0x0309, PSDRV_AGLGlyphNames +  750 },	/* hookabovecomb */
    { 0x0323, PSDRV_AGLGlyphNames +  667 },	/* dotbelowcomb */
    { 0x0384, PSDRV_AGLGlyphNames +  979 },	/* tonos */
    { 0x0385, PSDRV_AGLGlyphNames +  657 },	/* dieresistonos */
    { 0x0386, PSDRV_AGLGlyphNames +   16 },	/* Alphatonos */
    { 0x0387, PSDRV_AGLGlyphNames +  558 },	/* anoteleia */
    { 0x0388, PSDRV_AGLGlyphNames +   68 },	/* Epsilontonos */
    { 0x0389, PSDRV_AGLGlyphNames +   71 },	/* Etatonos */
    { 0x038a, PSDRV_AGLGlyphNames +  114 },	/* Iotatonos */
    { 0x038c, PSDRV_AGLGlyphNames +  166 },	/* Omicrontonos */
    { 0x038e, PSDRV_AGLGlyphNames +  264 },	/* Upsilontonos */
    { 0x038f, PSDRV_AGLGlyphNames +  164 },	/* Omegatonos */
    { 0x0390, PSDRV_AGLGlyphNames +  776 },	/* iotadieresistonos */
    { 0x0391, PSDRV_AGLGlyphNames +   15 },	/* Alpha */
    { 0x0392, PSDRV_AGLGlyphNames +   26 },	/* Beta */
    { 0x0393, PSDRV_AGLGlyphNames +   78 },	/* Gamma */
    { 0x0394, PSDRV_AGLGlyphNames +   45 },	/* Delta */
    { 0x0395, PSDRV_AGLGlyphNames +   67 },	/* Epsilon */
    { 0x0396, PSDRV_AGLGlyphNames +  292 },	/* Zeta */
    { 0x0397, PSDRV_AGLGlyphNames +   70 },	/* Eta */
    { 0x0398, PSDRV_AGLGlyphNames +  242 },	/* Theta */
    { 0x0399, PSDRV_AGLGlyphNames +  112 },	/* Iota */
    { 0x039a, PSDRV_AGLGlyphNames +  121 },	/* Kappa */
    { 0x039b, PSDRV_AGLGlyphNames +  127 },	/* Lambda */
    { 0x039c, PSDRV_AGLGlyphNames +  138 },	/* Mu */
    { 0x039d, PSDRV_AGLGlyphNames +  146 },	/* Nu */
    { 0x039e, PSDRV_AGLGlyphNames +  277 },	/* Xi */
    { 0x039f, PSDRV_AGLGlyphNames +  165 },	/* Omicron */
    { 0x03a0, PSDRV_AGLGlyphNames +  175 },	/* Pi */
    { 0x03a1, PSDRV_AGLGlyphNames +  185 },	/* Rho */
    { 0x03a3, PSDRV_AGLGlyphNames +  235 },	/* Sigma */
    { 0x03a4, PSDRV_AGLGlyphNames +  238 },	/* Tau */
    { 0x03a5, PSDRV_AGLGlyphNames +  261 },	/* Upsilon */
    { 0x03a6, PSDRV_AGLGlyphNames +  174 },	/* Phi */
    { 0x03a7, PSDRV_AGLGlyphNames +   39 },	/* Chi */
    { 0x03a8, PSDRV_AGLGlyphNames +  176 },	/* Psi */
    { 0x03a9, PSDRV_AGLGlyphNames +  163 },	/* Omega */
    { 0x03aa, PSDRV_AGLGlyphNames +  113 },	/* Iotadieresis */
    { 0x03ab, PSDRV_AGLGlyphNames +  263 },	/* Upsilondieresis */
    { 0x03ac, PSDRV_AGLGlyphNames +  551 },	/* alphatonos */
    { 0x03ad, PSDRV_AGLGlyphNames +  693 },	/* epsilontonos */
    { 0x03ae, PSDRV_AGLGlyphNames +  699 },	/* etatonos */
    { 0x03af, PSDRV_AGLGlyphNames +  777 },	/* iotatonos */
    { 0x03b0, PSDRV_AGLGlyphNames + 1011 },	/* upsilondieresistonos */
    { 0x03b1, PSDRV_AGLGlyphNames +  550 },	/* alpha */
    { 0x03b2, PSDRV_AGLGlyphNames +  587 },	/* beta */
    { 0x03b3, PSDRV_AGLGlyphNames +  730 },	/* gamma */
    { 0x03b4, PSDRV_AGLGlyphNames +  652 },	/* delta */
    { 0x03b5, PSDRV_AGLGlyphNames +  692 },	/* epsilon */
    { 0x03b6, PSDRV_AGLGlyphNames + 1038 },	/* zeta */
    { 0x03b7, PSDRV_AGLGlyphNames +  698 },	/* eta */
    { 0x03b8, PSDRV_AGLGlyphNames +  967 },	/* theta */
    { 0x03b9, PSDRV_AGLGlyphNames +  774 },	/* iota */
    { 0x03ba, PSDRV_AGLGlyphNames +  783 },	/* kappa */
    { 0x03bb, PSDRV_AGLGlyphNames +  788 },	/* lambda */
    { 0x03bc, PSDRV_AGLGlyphNames +  811 },	/* mu */
    { 0x03bd, PSDRV_AGLGlyphNames +  829 },	/* nu */
    { 0x03be, PSDRV_AGLGlyphNames + 1023 },	/* xi */
    { 0x03bf, PSDRV_AGLGlyphNames +  845 },	/* omicron */
    { 0x03c0, PSDRV_AGLGlyphNames +  890 },	/* pi */
    { 0x03c1, PSDRV_AGLGlyphNames +  925 },	/* rho */
    { 0x03c2, PSDRV_AGLGlyphNames +  946 },	/* sigma1 */
    { 0x03c3, PSDRV_AGLGlyphNames +  945 },	/* sigma */
    { 0x03c4, PSDRV_AGLGlyphNames +  962 },	/* tau */
    { 0x03c5, PSDRV_AGLGlyphNames + 1009 },	/* upsilon */
    { 0x03c6, PSDRV_AGLGlyphNames +  888 },	/* phi */
    { 0x03c7, PSDRV_AGLGlyphNames +  623 },	/* chi */
    { 0x03c8, PSDRV_AGLGlyphNames +  898 },	/* psi */
    { 0x03c9, PSDRV_AGLGlyphNames +  842 },	/* omega */
    { 0x03ca, PSDRV_AGLGlyphNames +  775 },	/* iotadieresis */
    { 0x03cb, PSDRV_AGLGlyphNames + 1010 },	/* upsilondieresis */
    { 0x03cc, PSDRV_AGLGlyphNames +  846 },	/* omicrontonos */
    { 0x03cd, PSDRV_AGLGlyphNames + 1012 },	/* upsilontonos */
    { 0x03ce, PSDRV_AGLGlyphNames +  844 },	/* omegatonos */
    { 0x03d1, PSDRV_AGLGlyphNames +  968 },	/* theta1 */
    { 0x03d2, PSDRV_AGLGlyphNames +  262 },	/* Upsilon1 */
    { 0x03d5, PSDRV_AGLGlyphNames +  889 },	/* phi1 */
    { 0x03d6, PSDRV_AGLGlyphNames +  843 },	/* omega1 */
    { 0x0401, PSDRV_AGLGlyphNames +  310 },	/* afii10023 */
    { 0x0402, PSDRV_AGLGlyphNames +  338 },	/* afii10051 */
    { 0x0403, PSDRV_AGLGlyphNames +  339 },	/* afii10052 */
    { 0x0404, PSDRV_AGLGlyphNames +  340 },	/* afii10053 */
    { 0x0405, PSDRV_AGLGlyphNames +  341 },	/* afii10054 */
    { 0x0406, PSDRV_AGLGlyphNames +  342 },	/* afii10055 */
    { 0x0407, PSDRV_AGLGlyphNames +  343 },	/* afii10056 */
    { 0x0408, PSDRV_AGLGlyphNames +  344 },	/* afii10057 */
    { 0x0409, PSDRV_AGLGlyphNames +  345 },	/* afii10058 */
    { 0x040a, PSDRV_AGLGlyphNames +  346 },	/* afii10059 */
    { 0x040b, PSDRV_AGLGlyphNames +  347 },	/* afii10060 */
    { 0x040c, PSDRV_AGLGlyphNames +  348 },	/* afii10061 */
    { 0x040e, PSDRV_AGLGlyphNames +  349 },	/* afii10062 */
    { 0x040f, PSDRV_AGLGlyphNames +  398 },	/* afii10145 */
    { 0x0410, PSDRV_AGLGlyphNames +  304 },	/* afii10017 */
    { 0x0411, PSDRV_AGLGlyphNames +  305 },	/* afii10018 */
    { 0x0412, PSDRV_AGLGlyphNames +  306 },	/* afii10019 */
    { 0x0413, PSDRV_AGLGlyphNames +  307 },	/* afii10020 */
    { 0x0414, PSDRV_AGLGlyphNames +  308 },	/* afii10021 */
    { 0x0415, PSDRV_AGLGlyphNames +  309 },	/* afii10022 */
    { 0x0416, PSDRV_AGLGlyphNames +  311 },	/* afii10024 */
    { 0x0417, PSDRV_AGLGlyphNames +  312 },	/* afii10025 */
    { 0x0418, PSDRV_AGLGlyphNames +  313 },	/* afii10026 */
    { 0x0419, PSDRV_AGLGlyphNames +  314 },	/* afii10027 */
    { 0x041a, PSDRV_AGLGlyphNames +  315 },	/* afii10028 */
    { 0x041b, PSDRV_AGLGlyphNames +  316 },	/* afii10029 */
    { 0x041c, PSDRV_AGLGlyphNames +  317 },	/* afii10030 */
    { 0x041d, PSDRV_AGLGlyphNames +  318 },	/* afii10031 */
    { 0x041e, PSDRV_AGLGlyphNames +  319 },	/* afii10032 */
    { 0x041f, PSDRV_AGLGlyphNames +  320 },	/* afii10033 */
    { 0x0420, PSDRV_AGLGlyphNames +  321 },	/* afii10034 */
    { 0x0421, PSDRV_AGLGlyphNames +  322 },	/* afii10035 */
    { 0x0422, PSDRV_AGLGlyphNames +  323 },	/* afii10036 */
    { 0x0423, PSDRV_AGLGlyphNames +  324 },	/* afii10037 */
    { 0x0424, PSDRV_AGLGlyphNames +  325 },	/* afii10038 */
    { 0x0425, PSDRV_AGLGlyphNames +  326 },	/* afii10039 */
    { 0x0426, PSDRV_AGLGlyphNames +  327 },	/* afii10040 */
    { 0x0427, PSDRV_AGLGlyphNames +  328 },	/* afii10041 */
    { 0x0428, PSDRV_AGLGlyphNames +  329 },	/* afii10042 */
    { 0x0429, PSDRV_AGLGlyphNames +  330 },	/* afii10043 */
    { 0x042a, PSDRV_AGLGlyphNames +  331 },	/* afii10044 */
    { 0x042b, PSDRV_AGLGlyphNames +  332 },	/* afii10045 */
    { 0x042c, PSDRV_AGLGlyphNames +  333 },	/* afii10046 */
    { 0x042d, PSDRV_AGLGlyphNames +  334 },	/* afii10047 */
    { 0x042e, PSDRV_AGLGlyphNames +  335 },	/* afii10048 */
    { 0x042f, PSDRV_AGLGlyphNames +  336 },	/* afii10049 */
    { 0x0430, PSDRV_AGLGlyphNames +  352 },	/* afii10065 */
    { 0x0431, PSDRV_AGLGlyphNames +  353 },	/* afii10066 */
    { 0x0432, PSDRV_AGLGlyphNames +  354 },	/* afii10067 */
    { 0x0433, PSDRV_AGLGlyphNames +  355 },	/* afii10068 */
    { 0x0434, PSDRV_AGLGlyphNames +  356 },	/* afii10069 */
    { 0x0435, PSDRV_AGLGlyphNames +  357 },	/* afii10070 */
    { 0x0436, PSDRV_AGLGlyphNames +  359 },	/* afii10072 */
    { 0x0437, PSDRV_AGLGlyphNames +  360 },	/* afii10073 */
    { 0x0438, PSDRV_AGLGlyphNames +  361 },	/* afii10074 */
    { 0x0439, PSDRV_AGLGlyphNames +  362 },	/* afii10075 */
    { 0x043a, PSDRV_AGLGlyphNames +  363 },	/* afii10076 */
    { 0x043b, PSDRV_AGLGlyphNames +  364 },	/* afii10077 */
    { 0x043c, PSDRV_AGLGlyphNames +  365 },	/* afii10078 */
    { 0x043d, PSDRV_AGLGlyphNames +  366 },	/* afii10079 */
    { 0x043e, PSDRV_AGLGlyphNames +  367 },	/* afii10080 */
    { 0x043f, PSDRV_AGLGlyphNames +  368 },	/* afii10081 */
    { 0x0440, PSDRV_AGLGlyphNames +  369 },	/* afii10082 */
    { 0x0441, PSDRV_AGLGlyphNames +  370 },	/* afii10083 */
    { 0x0442, PSDRV_AGLGlyphNames +  371 },	/* afii10084 */
    { 0x0443, PSDRV_AGLGlyphNames +  372 },	/* afii10085 */
    { 0x0444, PSDRV_AGLGlyphNames +  373 },	/* afii10086 */
    { 0x0445, PSDRV_AGLGlyphNames +  374 },	/* afii10087 */
    { 0x0446, PSDRV_AGLGlyphNames +  375 },	/* afii10088 */
    { 0x0447, PSDRV_AGLGlyphNames +  376 },	/* afii10089 */
    { 0x0448, PSDRV_AGLGlyphNames +  377 },	/* afii10090 */
    { 0x0449, PSDRV_AGLGlyphNames +  378 },	/* afii10091 */
    { 0x044a, PSDRV_AGLGlyphNames +  379 },	/* afii10092 */
    { 0x044b, PSDRV_AGLGlyphNames +  380 },	/* afii10093 */
    { 0x044c, PSDRV_AGLGlyphNames +  381 },	/* afii10094 */
    { 0x044d, PSDRV_AGLGlyphNames +  382 },	/* afii10095 */
    { 0x044e, PSDRV_AGLGlyphNames +  383 },	/* afii10096 */
    { 0x044f, PSDRV_AGLGlyphNames +  384 },	/* afii10097 */
    { 0x0451, PSDRV_AGLGlyphNames +  358 },	/* afii10071 */
    { 0x0452, PSDRV_AGLGlyphNames +  386 },	/* afii10099 */
    { 0x0453, PSDRV_AGLGlyphNames +  387 },	/* afii10100 */
    { 0x0454, PSDRV_AGLGlyphNames +  388 },	/* afii10101 */
    { 0x0455, PSDRV_AGLGlyphNames +  389 },	/* afii10102 */
    { 0x0456, PSDRV_AGLGlyphNames +  390 },	/* afii10103 */
    { 0x0457, PSDRV_AGLGlyphNames +  391 },	/* afii10104 */
    { 0x0458, PSDRV_AGLGlyphNames +  392 },	/* afii10105 */
    { 0x0459, PSDRV_AGLGlyphNames +  393 },	/* afii10106 */
    { 0x045a, PSDRV_AGLGlyphNames +  394 },	/* afii10107 */
    { 0x045b, PSDRV_AGLGlyphNames +  395 },	/* afii10108 */
    { 0x045c, PSDRV_AGLGlyphNames +  396 },	/* afii10109 */
    { 0x045e, PSDRV_AGLGlyphNames +  397 },	/* afii10110 */
    { 0x045f, PSDRV_AGLGlyphNames +  403 },	/* afii10193 */
    { 0x0462, PSDRV_AGLGlyphNames +  399 },	/* afii10146 */
    { 0x0463, PSDRV_AGLGlyphNames +  404 },	/* afii10194 */
    { 0x0472, PSDRV_AGLGlyphNames +  400 },	/* afii10147 */
    { 0x0473, PSDRV_AGLGlyphNames +  405 },	/* afii10195 */
    { 0x0474, PSDRV_AGLGlyphNames +  401 },	/* afii10148 */
    { 0x0475, PSDRV_AGLGlyphNames +  406 },	/* afii10196 */
    { 0x0490, PSDRV_AGLGlyphNames +  337 },	/* afii10050 */
    { 0x0491, PSDRV_AGLGlyphNames +  385 },	/* afii10098 */
    { 0x04d9, PSDRV_AGLGlyphNames +  409 },	/* afii10846 */
    { 0x05b0, PSDRV_AGLGlyphNames +  527 },	/* afii57799 */
    { 0x05b1, PSDRV_AGLGlyphNames +  529 },	/* afii57801 */
    { 0x05b2, PSDRV_AGLGlyphNames +  528 },	/* afii57800 */
    { 0x05b3, PSDRV_AGLGlyphNames +  530 },	/* afii57802 */
    { 0x05b4, PSDRV_AGLGlyphNames +  521 },	/* afii57793 */
    { 0x05b5, PSDRV_AGLGlyphNames +  522 },	/* afii57794 */
    { 0x05b6, PSDRV_AGLGlyphNames +  523 },	/* afii57795 */
    { 0x05b7, PSDRV_AGLGlyphNames +  526 },	/* afii57798 */
    { 0x05b8, PSDRV_AGLGlyphNames +  525 },	/* afii57797 */
    { 0x05b9, PSDRV_AGLGlyphNames +  533 },	/* afii57806 */
    { 0x05bb, PSDRV_AGLGlyphNames +  524 },	/* afii57796 */
    { 0x05bc, PSDRV_AGLGlyphNames +  534 },	/* afii57807 */
    { 0x05bd, PSDRV_AGLGlyphNames +  535 },	/* afii57839 */
    { 0x05be, PSDRV_AGLGlyphNames +  484 },	/* afii57645 */
    { 0x05bf, PSDRV_AGLGlyphNames +  536 },	/* afii57841 */
    { 0x05c0, PSDRV_AGLGlyphNames +  537 },	/* afii57842 */
    { 0x05c1, PSDRV_AGLGlyphNames +  532 },	/* afii57804 */
    { 0x05c2, PSDRV_AGLGlyphNames +  531 },	/* afii57803 */
    { 0x05c3, PSDRV_AGLGlyphNames +  485 },	/* afii57658 */
    { 0x05d0, PSDRV_AGLGlyphNames +  486 },	/* afii57664 */
    { 0x05d1, PSDRV_AGLGlyphNames +  487 },	/* afii57665 */
    { 0x05d2, PSDRV_AGLGlyphNames +  488 },	/* afii57666 */
    { 0x05d3, PSDRV_AGLGlyphNames +  489 },	/* afii57667 */
    { 0x05d4, PSDRV_AGLGlyphNames +  490 },	/* afii57668 */
    { 0x05d5, PSDRV_AGLGlyphNames +  491 },	/* afii57669 */
    { 0x05d6, PSDRV_AGLGlyphNames +  492 },	/* afii57670 */
    { 0x05d7, PSDRV_AGLGlyphNames +  493 },	/* afii57671 */
    { 0x05d8, PSDRV_AGLGlyphNames +  494 },	/* afii57672 */
    { 0x05d9, PSDRV_AGLGlyphNames +  495 },	/* afii57673 */
    { 0x05da, PSDRV_AGLGlyphNames +  496 },	/* afii57674 */
    { 0x05db, PSDRV_AGLGlyphNames +  497 },	/* afii57675 */
    { 0x05dc, PSDRV_AGLGlyphNames +  498 },	/* afii57676 */
    { 0x05dd, PSDRV_AGLGlyphNames +  499 },	/* afii57677 */
    { 0x05de, PSDRV_AGLGlyphNames +  500 },	/* afii57678 */
    { 0x05df, PSDRV_AGLGlyphNames +  501 },	/* afii57679 */
    { 0x05e0, PSDRV_AGLGlyphNames +  502 },	/* afii57680 */
    { 0x05e1, PSDRV_AGLGlyphNames +  503 },	/* afii57681 */
    { 0x05e2, PSDRV_AGLGlyphNames +  504 },	/* afii57682 */
    { 0x05e3, PSDRV_AGLGlyphNames +  505 },	/* afii57683 */
    { 0x05e4, PSDRV_AGLGlyphNames +  506 },	/* afii57684 */
    { 0x05e5, PSDRV_AGLGlyphNames +  507 },	/* afii57685 */
    { 0x05e6, PSDRV_AGLGlyphNames +  508 },	/* afii57686 */
    { 0x05e7, PSDRV_AGLGlyphNames +  509 },	/* afii57687 */
    { 0x05e8, PSDRV_AGLGlyphNames +  510 },	/* afii57688 */
    { 0x05e9, PSDRV_AGLGlyphNames +  511 },	/* afii57689 */
    { 0x05ea, PSDRV_AGLGlyphNames +  512 },	/* afii57690 */
    { 0x05f0, PSDRV_AGLGlyphNames +  517 },	/* afii57716 */
    { 0x05f1, PSDRV_AGLGlyphNames +  518 },	/* afii57717 */
    { 0x05f2, PSDRV_AGLGlyphNames +  519 },	/* afii57718 */
    { 0x060c, PSDRV_AGLGlyphNames +  414 },	/* afii57388 */
    { 0x061b, PSDRV_AGLGlyphNames +  425 },	/* afii57403 */
    { 0x061f, PSDRV_AGLGlyphNames +  426 },	/* afii57407 */
    { 0x0621, PSDRV_AGLGlyphNames +  427 },	/* afii57409 */
    { 0x0622, PSDRV_AGLGlyphNames +  428 },	/* afii57410 */
    { 0x0623, PSDRV_AGLGlyphNames +  429 },	/* afii57411 */
    { 0x0624, PSDRV_AGLGlyphNames +  430 },	/* afii57412 */
    { 0x0625, PSDRV_AGLGlyphNames +  431 },	/* afii57413 */
    { 0x0626, PSDRV_AGLGlyphNames +  432 },	/* afii57414 */
    { 0x0627, PSDRV_AGLGlyphNames +  433 },	/* afii57415 */
    { 0x0628, PSDRV_AGLGlyphNames +  434 },	/* afii57416 */
    { 0x0629, PSDRV_AGLGlyphNames +  435 },	/* afii57417 */
    { 0x062a, PSDRV_AGLGlyphNames +  436 },	/* afii57418 */
    { 0x062b, PSDRV_AGLGlyphNames +  437 },	/* afii57419 */
    { 0x062c, PSDRV_AGLGlyphNames +  438 },	/* afii57420 */
    { 0x062d, PSDRV_AGLGlyphNames +  439 },	/* afii57421 */
    { 0x062e, PSDRV_AGLGlyphNames +  440 },	/* afii57422 */
    { 0x062f, PSDRV_AGLGlyphNames +  441 },	/* afii57423 */
    { 0x0630, PSDRV_AGLGlyphNames +  442 },	/* afii57424 */
    { 0x0631, PSDRV_AGLGlyphNames +  443 },	/* afii57425 */
    { 0x0632, PSDRV_AGLGlyphNames +  444 },	/* afii57426 */
    { 0x0633, PSDRV_AGLGlyphNames +  445 },	/* afii57427 */
    { 0x0634, PSDRV_AGLGlyphNames +  446 },	/* afii57428 */
    { 0x0635, PSDRV_AGLGlyphNames +  447 },	/* afii57429 */
    { 0x0636, PSDRV_AGLGlyphNames +  448 },	/* afii57430 */
    { 0x0637, PSDRV_AGLGlyphNames +  449 },	/* afii57431 */
    { 0x0638, PSDRV_AGLGlyphNames +  450 },	/* afii57432 */
    { 0x0639, PSDRV_AGLGlyphNames +  451 },	/* afii57433 */
    { 0x063a, PSDRV_AGLGlyphNames +  452 },	/* afii57434 */
    { 0x0640, PSDRV_AGLGlyphNames +  453 },	/* afii57440 */
    { 0x0641, PSDRV_AGLGlyphNames +  454 },	/* afii57441 */
    { 0x0642, PSDRV_AGLGlyphNames +  455 },	/* afii57442 */
    { 0x0643, PSDRV_AGLGlyphNames +  456 },	/* afii57443 */
    { 0x0644, PSDRV_AGLGlyphNames +  457 },	/* afii57444 */
    { 0x0645, PSDRV_AGLGlyphNames +  458 },	/* afii57445 */
    { 0x0646, PSDRV_AGLGlyphNames +  459 },	/* afii57446 */
    { 0x0647, PSDRV_AGLGlyphNames +  471 },	/* afii57470 */
    { 0x0648, PSDRV_AGLGlyphNames +  460 },	/* afii57448 */
    { 0x0649, PSDRV_AGLGlyphNames +  461 },	/* afii57449 */
    { 0x064a, PSDRV_AGLGlyphNames +  462 },	/* afii57450 */
    { 0x064b, PSDRV_AGLGlyphNames +  463 },	/* afii57451 */
    { 0x064c, PSDRV_AGLGlyphNames +  464 },	/* afii57452 */
    { 0x064d, PSDRV_AGLGlyphNames +  465 },	/* afii57453 */
    { 0x064e, PSDRV_AGLGlyphNames +  466 },	/* afii57454 */
    { 0x064f, PSDRV_AGLGlyphNames +  467 },	/* afii57455 */
    { 0x0650, PSDRV_AGLGlyphNames +  468 },	/* afii57456 */
    { 0x0651, PSDRV_AGLGlyphNames +  469 },	/* afii57457 */
    { 0x0652, PSDRV_AGLGlyphNames +  470 },	/* afii57458 */
    { 0x0660, PSDRV_AGLGlyphNames +  415 },	/* afii57392 */
    { 0x0661, PSDRV_AGLGlyphNames +  416 },	/* afii57393 */
    { 0x0662, PSDRV_AGLGlyphNames +  417 },	/* afii57394 */
    { 0x0663, PSDRV_AGLGlyphNames +  418 },	/* afii57395 */
    { 0x0664, PSDRV_AGLGlyphNames +  419 },	/* afii57396 */
    { 0x0665, PSDRV_AGLGlyphNames +  420 },	/* afii57397 */
    { 0x0666, PSDRV_AGLGlyphNames +  421 },	/* afii57398 */
    { 0x0667, PSDRV_AGLGlyphNames +  422 },	/* afii57399 */
    { 0x0668, PSDRV_AGLGlyphNames +  423 },	/* afii57400 */
    { 0x0669, PSDRV_AGLGlyphNames +  424 },	/* afii57401 */
    { 0x066a, PSDRV_AGLGlyphNames +  413 },	/* afii57381 */
    { 0x066d, PSDRV_AGLGlyphNames +  546 },	/* afii63167 */
    { 0x0679, PSDRV_AGLGlyphNames +  477 },	/* afii57511 */
    { 0x067e, PSDRV_AGLGlyphNames +  473 },	/* afii57506 */
    { 0x0686, PSDRV_AGLGlyphNames +  474 },	/* afii57507 */
    { 0x0688, PSDRV_AGLGlyphNames +  478 },	/* afii57512 */
    { 0x0691, PSDRV_AGLGlyphNames +  479 },	/* afii57513 */
    { 0x0698, PSDRV_AGLGlyphNames +  475 },	/* afii57508 */
    { 0x06a4, PSDRV_AGLGlyphNames +  472 },	/* afii57505 */
    { 0x06af, PSDRV_AGLGlyphNames +  476 },	/* afii57509 */
    { 0x06ba, PSDRV_AGLGlyphNames +  480 },	/* afii57514 */
    { 0x06d2, PSDRV_AGLGlyphNames +  481 },	/* afii57519 */
    { 0x06d5, PSDRV_AGLGlyphNames +  482 },	/* afii57534 */
    { 0x1e80, PSDRV_AGLGlyphNames +  274 },	/* Wgrave */
    { 0x1e81, PSDRV_AGLGlyphNames + 1021 },	/* wgrave */
    { 0x1e82, PSDRV_AGLGlyphNames +  271 },	/* Wacute */
    { 0x1e83, PSDRV_AGLGlyphNames + 1017 },	/* wacute */
    { 0x1e84, PSDRV_AGLGlyphNames +  273 },	/* Wdieresis */
    { 0x1e85, PSDRV_AGLGlyphNames + 1019 },	/* wdieresis */
    { 0x1ef2, PSDRV_AGLGlyphNames +  285 },	/* Ygrave */
    { 0x1ef3, PSDRV_AGLGlyphNames + 1029 },	/* ygrave */
    { 0x200c, PSDRV_AGLGlyphNames +  545 },	/* afii61664 */
    { 0x200d, PSDRV_AGLGlyphNames +  412 },	/* afii301 */
    { 0x200e, PSDRV_AGLGlyphNames +  410 },	/* afii299 */
    { 0x200f, PSDRV_AGLGlyphNames +  411 },	/* afii300 */
    { 0x2012, PSDRV_AGLGlyphNames +  713 },	/* figuredash */
    { 0x2013, PSDRV_AGLGlyphNames +  689 },	/* endash */
    { 0x2014, PSDRV_AGLGlyphNames +  687 },	/* emdash */
    { 0x2015, PSDRV_AGLGlyphNames +  303 },	/* afii00208 */
    { 0x2017, PSDRV_AGLGlyphNames + 1004 },	/* underscoredbl */
    { 0x2018, PSDRV_AGLGlyphNames +  908 },	/* quoteleft */
    { 0x2019, PSDRV_AGLGlyphNames +  910 },	/* quoteright */
    { 0x201a, PSDRV_AGLGlyphNames +  911 },	/* quotesinglbase */
    { 0x201b, PSDRV_AGLGlyphNames +  909 },	/* quotereversed */
    { 0x201c, PSDRV_AGLGlyphNames +  906 },	/* quotedblleft */
    { 0x201d, PSDRV_AGLGlyphNames +  907 },	/* quotedblright */
    { 0x201e, PSDRV_AGLGlyphNames +  905 },	/* quotedblbase */
    { 0x2020, PSDRV_AGLGlyphNames +  645 },	/* dagger */
    { 0x2021, PSDRV_AGLGlyphNames +  646 },	/* daggerdbl */
    { 0x2022, PSDRV_AGLGlyphNames +  609 },	/* bullet */
    { 0x2024, PSDRV_AGLGlyphNames +  848 },	/* onedotenleader */
    { 0x2025, PSDRV_AGLGlyphNames +  989 },	/* twodotenleader */
    { 0x2026, PSDRV_AGLGlyphNames +  685 },	/* ellipsis */
    { 0x202c, PSDRV_AGLGlyphNames +  542 },	/* afii61573 */
    { 0x202d, PSDRV_AGLGlyphNames +  543 },	/* afii61574 */
    { 0x202e, PSDRV_AGLGlyphNames +  544 },	/* afii61575 */
    { 0x2030, PSDRV_AGLGlyphNames +  886 },	/* perthousand */
    { 0x2032, PSDRV_AGLGlyphNames +  809 },	/* minute */
    { 0x2033, PSDRV_AGLGlyphNames +  936 },	/* second */
    { 0x2039, PSDRV_AGLGlyphNames +  744 },	/* guilsinglleft */
    { 0x203a, PSDRV_AGLGlyphNames +  745 },	/* guilsinglright */
    { 0x203c, PSDRV_AGLGlyphNames +  702 },	/* exclamdbl */
    { 0x2044, PSDRV_AGLGlyphNames +  727 },	/* fraction */
    { 0x2070, PSDRV_AGLGlyphNames + 1037 },	/* zerosuperior */
    { 0x2074, PSDRV_AGLGlyphNames +  726 },	/* foursuperior */
    { 0x2075, PSDRV_AGLGlyphNames +  720 },	/* fivesuperior */
    { 0x2076, PSDRV_AGLGlyphNames +  951 },	/* sixsuperior */
    { 0x2077, PSDRV_AGLGlyphNames +  943 },	/* sevensuperior */
    { 0x2078, PSDRV_AGLGlyphNames +  683 },	/* eightsuperior */
    { 0x2079, PSDRV_AGLGlyphNames +  823 },	/* ninesuperior */
    { 0x207d, PSDRV_AGLGlyphNames +  871 },	/* parenleftsuperior */
    { 0x207e, PSDRV_AGLGlyphNames +  877 },	/* parenrightsuperior */
    { 0x207f, PSDRV_AGLGlyphNames +  827 },	/* nsuperior */
    { 0x2080, PSDRV_AGLGlyphNames + 1035 },	/* zeroinferior */
    { 0x2081, PSDRV_AGLGlyphNames +  852 },	/* oneinferior */
    { 0x2082, PSDRV_AGLGlyphNames +  990 },	/* twoinferior */
    { 0x2083, PSDRV_AGLGlyphNames +  972 },	/* threeinferior */
    { 0x2084, PSDRV_AGLGlyphNames +  724 },	/* fourinferior */
    { 0x2085, PSDRV_AGLGlyphNames +  718 },	/* fiveinferior */
    { 0x2086, PSDRV_AGLGlyphNames +  949 },	/* sixinferior */
    { 0x2087, PSDRV_AGLGlyphNames +  941 },	/* seveninferior */
    { 0x2088, PSDRV_AGLGlyphNames +  681 },	/* eightinferior */
    { 0x2089, PSDRV_AGLGlyphNames +  821 },	/* nineinferior */
    { 0x208d, PSDRV_AGLGlyphNames +  870 },	/* parenleftinferior */
    { 0x208e, PSDRV_AGLGlyphNames +  876 },	/* parenrightinferior */
    { 0x20a1, PSDRV_AGLGlyphNames +  630 },	/* colonmonetary */
    { 0x20a3, PSDRV_AGLGlyphNames +  728 },	/* franc */
    { 0x20a4, PSDRV_AGLGlyphNames +  795 },	/* lira */
    { 0x20a7, PSDRV_AGLGlyphNames +  887 },	/* peseta */
    { 0x20aa, PSDRV_AGLGlyphNames +  483 },	/* afii57636 */
    { 0x20ab, PSDRV_AGLGlyphNames +  665 },	/* dong */
    { 0x20ac, PSDRV_AGLGlyphNames +   74 },	/* Euro */
    { 0x2105, PSDRV_AGLGlyphNames +  539 },	/* afii61248 */
    { 0x2111, PSDRV_AGLGlyphNames +  107 },	/* Ifraktur */
    { 0x2113, PSDRV_AGLGlyphNames +  540 },	/* afii61289 */
    { 0x2116, PSDRV_AGLGlyphNames +  541 },	/* afii61352 */
    { 0x2118, PSDRV_AGLGlyphNames + 1020 },	/* weierstrass */
    { 0x211c, PSDRV_AGLGlyphNames +  184 },	/* Rfraktur */
    { 0x211e, PSDRV_AGLGlyphNames +  893 },	/* prescription */
    { 0x2122, PSDRV_AGLGlyphNames +  980 },	/* trademark */
    { 0x2126, PSDRV_AGLGlyphNames +  163 },	/* Omega */
    { 0x212e, PSDRV_AGLGlyphNames +  696 },	/* estimated */
    { 0x2135, PSDRV_AGLGlyphNames +  549 },	/* aleph */
    { 0x2153, PSDRV_AGLGlyphNames +  856 },	/* onethird */
    { 0x2154, PSDRV_AGLGlyphNames +  993 },	/* twothirds */
    { 0x215b, PSDRV_AGLGlyphNames +  849 },	/* oneeighth */
    { 0x215c, PSDRV_AGLGlyphNames +  971 },	/* threeeighths */
    { 0x215d, PSDRV_AGLGlyphNames +  717 },	/* fiveeighths */
    { 0x215e, PSDRV_AGLGlyphNames +  940 },	/* seveneighths */
    { 0x2190, PSDRV_AGLGlyphNames +  571 },	/* arrowleft */
    { 0x2191, PSDRV_AGLGlyphNames +  573 },	/* arrowup */
    { 0x2192, PSDRV_AGLGlyphNames +  572 },	/* arrowright */
    { 0x2193, PSDRV_AGLGlyphNames +  569 },	/* arrowdown */
    { 0x2194, PSDRV_AGLGlyphNames +  563 },	/* arrowboth */
    { 0x2195, PSDRV_AGLGlyphNames +  574 },	/* arrowupdn */
    { 0x21a8, PSDRV_AGLGlyphNames +  575 },	/* arrowupdnbse */
    { 0x21b5, PSDRV_AGLGlyphNames +  613 },	/* carriagereturn */
    { 0x21d0, PSDRV_AGLGlyphNames +  566 },	/* arrowdblleft */
    { 0x21d1, PSDRV_AGLGlyphNames +  568 },	/* arrowdblup */
    { 0x21d2, PSDRV_AGLGlyphNames +  567 },	/* arrowdblright */
    { 0x21d3, PSDRV_AGLGlyphNames +  565 },	/* arrowdbldown */
    { 0x21d4, PSDRV_AGLGlyphNames +  564 },	/* arrowdblboth */
    { 0x2200, PSDRV_AGLGlyphNames + 1006 },	/* universal */
    { 0x2202, PSDRV_AGLGlyphNames +  879 },	/* partialdiff */
    { 0x2203, PSDRV_AGLGlyphNames +  706 },	/* existential */
    { 0x2205, PSDRV_AGLGlyphNames +  688 },	/* emptyset */
    { 0x2206, PSDRV_AGLGlyphNames +   45 },	/* Delta */
    { 0x2207, PSDRV_AGLGlyphNames +  737 },	/* gradient */
    { 0x2208, PSDRV_AGLGlyphNames +  684 },	/* element */
    { 0x2209, PSDRV_AGLGlyphNames +  824 },	/* notelement */
    { 0x220b, PSDRV_AGLGlyphNames +  958 },	/* suchthat */
    { 0x220f, PSDRV_AGLGlyphNames +  894 },	/* product */
    { 0x2211, PSDRV_AGLGlyphNames +  959 },	/* summation */
    { 0x2212, PSDRV_AGLGlyphNames +  808 },	/* minus */
    { 0x2215, PSDRV_AGLGlyphNames +  727 },	/* fraction */
    { 0x2217, PSDRV_AGLGlyphNames +  580 },	/* asteriskmath */
    { 0x2219, PSDRV_AGLGlyphNames +  882 },	/* periodcentered */
    { 0x221a, PSDRV_AGLGlyphNames +  915 },	/* radical */
    { 0x221d, PSDRV_AGLGlyphNames +  897 },	/* proportional */
    { 0x221e, PSDRV_AGLGlyphNames +  764 },	/* infinity */
    { 0x221f, PSDRV_AGLGlyphNames +  860 },	/* orthogonal */
    { 0x2220, PSDRV_AGLGlyphNames +  555 },	/* angle */
    { 0x2227, PSDRV_AGLGlyphNames +  797 },	/* logicaland */
    { 0x2228, PSDRV_AGLGlyphNames +  799 },	/* logicalor */
    { 0x2229, PSDRV_AGLGlyphNames +  769 },	/* intersection */
    { 0x222a, PSDRV_AGLGlyphNames + 1005 },	/* union */
    { 0x222b, PSDRV_AGLGlyphNames +  765 },	/* integral */
    { 0x2234, PSDRV_AGLGlyphNames +  966 },	/* therefore */
    { 0x223c, PSDRV_AGLGlyphNames +  947 },	/* similar */
    { 0x2245, PSDRV_AGLGlyphNames +  635 },	/* congruent */
    { 0x2248, PSDRV_AGLGlyphNames +  560 },	/* approxequal */
    { 0x2260, PSDRV_AGLGlyphNames +  825 },	/* notequal */
    { 0x2261, PSDRV_AGLGlyphNames +  695 },	/* equivalence */
    { 0x2264, PSDRV_AGLGlyphNames +  793 },	/* lessequal */
    { 0x2265, PSDRV_AGLGlyphNames +  741 },	/* greaterequal */
    { 0x2282, PSDRV_AGLGlyphNames +  895 },	/* propersubset */
    { 0x2283, PSDRV_AGLGlyphNames +  896 },	/* propersuperset */
    { 0x2284, PSDRV_AGLGlyphNames +  826 },	/* notsubset */
    { 0x2286, PSDRV_AGLGlyphNames +  919 },	/* reflexsubset */
    { 0x2287, PSDRV_AGLGlyphNames +  920 },	/* reflexsuperset */
    { 0x2295, PSDRV_AGLGlyphNames +  626 },	/* circleplus */
    { 0x2297, PSDRV_AGLGlyphNames +  625 },	/* circlemultiply */
    { 0x22a5, PSDRV_AGLGlyphNames +  885 },	/* perpendicular */
    { 0x22c5, PSDRV_AGLGlyphNames +  670 },	/* dotmath */
    { 0x2302, PSDRV_AGLGlyphNames +  751 },	/* house */
    { 0x2310, PSDRV_AGLGlyphNames +  924 },	/* revlogicalnot */
    { 0x2320, PSDRV_AGLGlyphNames +  768 },	/* integraltp */
    { 0x2321, PSDRV_AGLGlyphNames +  766 },	/* integralbt */
    { 0x2329, PSDRV_AGLGlyphNames +  556 },	/* angleleft */
    { 0x232a, PSDRV_AGLGlyphNames +  557 },	/* angleright */
    { 0x2500, PSDRV_AGLGlyphNames +  198 },	/* SF100000 */
    { 0x2502, PSDRV_AGLGlyphNames +  199 },	/* SF110000 */
    { 0x250c, PSDRV_AGLGlyphNames +  189 },	/* SF010000 */
    { 0x2510, PSDRV_AGLGlyphNames +  191 },	/* SF030000 */
    { 0x2514, PSDRV_AGLGlyphNames +  190 },	/* SF020000 */
    { 0x2518, PSDRV_AGLGlyphNames +  192 },	/* SF040000 */
    { 0x251c, PSDRV_AGLGlyphNames +  196 },	/* SF080000 */
    { 0x2524, PSDRV_AGLGlyphNames +  197 },	/* SF090000 */
    { 0x252c, PSDRV_AGLGlyphNames +  194 },	/* SF060000 */
    { 0x2534, PSDRV_AGLGlyphNames +  195 },	/* SF070000 */
    { 0x253c, PSDRV_AGLGlyphNames +  193 },	/* SF050000 */
    { 0x2550, PSDRV_AGLGlyphNames +  217 },	/* SF430000 */
    { 0x2551, PSDRV_AGLGlyphNames +  205 },	/* SF240000 */
    { 0x2552, PSDRV_AGLGlyphNames +  225 },	/* SF510000 */
    { 0x2553, PSDRV_AGLGlyphNames +  226 },	/* SF520000 */
    { 0x2554, PSDRV_AGLGlyphNames +  213 },	/* SF390000 */
    { 0x2555, PSDRV_AGLGlyphNames +  203 },	/* SF220000 */
    { 0x2556, PSDRV_AGLGlyphNames +  202 },	/* SF210000 */
    { 0x2557, PSDRV_AGLGlyphNames +  206 },	/* SF250000 */
    { 0x2558, PSDRV_AGLGlyphNames +  224 },	/* SF500000 */
    { 0x2559, PSDRV_AGLGlyphNames +  223 },	/* SF490000 */
    { 0x255a, PSDRV_AGLGlyphNames +  212 },	/* SF380000 */
    { 0x255b, PSDRV_AGLGlyphNames +  209 },	/* SF280000 */
    { 0x255c, PSDRV_AGLGlyphNames +  208 },	/* SF270000 */
    { 0x255d, PSDRV_AGLGlyphNames +  207 },	/* SF260000 */
    { 0x255e, PSDRV_AGLGlyphNames +  210 },	/* SF360000 */
    { 0x255f, PSDRV_AGLGlyphNames +  211 },	/* SF370000 */
    { 0x2560, PSDRV_AGLGlyphNames +  216 },	/* SF420000 */
    { 0x2561, PSDRV_AGLGlyphNames +  200 },	/* SF190000 */
    { 0x2562, PSDRV_AGLGlyphNames +  201 },	/* SF200000 */
    { 0x2563, PSDRV_AGLGlyphNames +  204 },	/* SF230000 */
    { 0x2564, PSDRV_AGLGlyphNames +  221 },	/* SF470000 */
    { 0x2565, PSDRV_AGLGlyphNames +  222 },	/* SF480000 */
    { 0x2566, PSDRV_AGLGlyphNames +  215 },	/* SF410000 */
    { 0x2567, PSDRV_AGLGlyphNames +  219 },	/* SF450000 */
    { 0x2568, PSDRV_AGLGlyphNames +  220 },	/* SF460000 */
    { 0x2569, PSDRV_AGLGlyphNames +  214 },	/* SF400000 */
    { 0x256a, PSDRV_AGLGlyphNames +  228 },	/* SF540000 */
    { 0x256b, PSDRV_AGLGlyphNames +  227 },	/* SF530000 */
    { 0x256c, PSDRV_AGLGlyphNames +  218 },	/* SF440000 */
    { 0x2580, PSDRV_AGLGlyphNames + 1008 },	/* upblock */
    { 0x2584, PSDRV_AGLGlyphNames +  660 },	/* dnblock */
    { 0x2588, PSDRV_AGLGlyphNames +  588 },	/* block */
    { 0x258c, PSDRV_AGLGlyphNames +  794 },	/* lfblock */
    { 0x2590, PSDRV_AGLGlyphNames +  928 },	/* rtblock */
    { 0x2591, PSDRV_AGLGlyphNames +  804 },	/* ltshade */
    { 0x2592, PSDRV_AGLGlyphNames +  944 },	/* shade */
    { 0x2593, PSDRV_AGLGlyphNames +  659 },	/* dkshade */
    { 0x25a0, PSDRV_AGLGlyphNames +  714 },	/* filledbox */
    { 0x25a1, PSDRV_AGLGlyphNames +   91 },	/* H22073 */
    { 0x25aa, PSDRV_AGLGlyphNames +   89 },	/* H18543 */
    { 0x25ab, PSDRV_AGLGlyphNames +   90 },	/* H18551 */
    { 0x25ac, PSDRV_AGLGlyphNames +  715 },	/* filledrect */
    { 0x25b2, PSDRV_AGLGlyphNames +  986 },	/* triagup */
    { 0x25ba, PSDRV_AGLGlyphNames +  985 },	/* triagrt */
    { 0x25bc, PSDRV_AGLGlyphNames +  983 },	/* triagdn */
    { 0x25c4, PSDRV_AGLGlyphNames +  984 },	/* triaglf */
    { 0x25ca, PSDRV_AGLGlyphNames +  801 },	/* lozenge */
    { 0x25cb, PSDRV_AGLGlyphNames +  624 },	/* circle */
    { 0x25cf, PSDRV_AGLGlyphNames +   88 },	/* H18533 */
    { 0x25d8, PSDRV_AGLGlyphNames +  770 },	/* invbullet */
    { 0x25d9, PSDRV_AGLGlyphNames +  771 },	/* invcircle */
    { 0x25e6, PSDRV_AGLGlyphNames +  857 },	/* openbullet */
    { 0x263a, PSDRV_AGLGlyphNames +  953 },	/* smileface */
    { 0x263b, PSDRV_AGLGlyphNames +  772 },	/* invsmileface */
    { 0x263c, PSDRV_AGLGlyphNames +  960 },	/* sun */
    { 0x2640, PSDRV_AGLGlyphNames +  708 },	/* female */
    { 0x2642, PSDRV_AGLGlyphNames +  807 },	/* male */
    { 0x2660, PSDRV_AGLGlyphNames +  955 },	/* spade */
    { 0x2663, PSDRV_AGLGlyphNames +  628 },	/* club */
    { 0x2665, PSDRV_AGLGlyphNames +  749 },	/* heart */
    { 0x2666, PSDRV_AGLGlyphNames +  653 },	/* diamond */
    { 0x266a, PSDRV_AGLGlyphNames +  813 },	/* musicalnote */
    { 0x266b, PSDRV_AGLGlyphNames +  814 },	/* musicalnotedbl */
    { 0xf6be, PSDRV_AGLGlyphNames +  669 },	/* dotlessj */
    { 0xf6bf, PSDRV_AGLGlyphNames +  125 },	/* LL */
    { 0xf6c0, PSDRV_AGLGlyphNames +  796 },	/* ll */
    { 0xf6c1, PSDRV_AGLGlyphNames +  232 },	/* Scedilla */
    { 0xf6c2, PSDRV_AGLGlyphNames +  933 },	/* scedilla */
    { 0xf6c3, PSDRV_AGLGlyphNames +  632 },	/* commaaccent */
    { 0xf6c4, PSDRV_AGLGlyphNames +  350 },	/* afii10063 */
    { 0xf6c5, PSDRV_AGLGlyphNames +  351 },	/* afii10064 */
    { 0xf6c6, PSDRV_AGLGlyphNames +  402 },	/* afii10192 */
    { 0xf6c7, PSDRV_AGLGlyphNames +  407 },	/* afii10831 */
    { 0xf6c8, PSDRV_AGLGlyphNames +  408 },	/* afii10832 */
    { 0xf6c9, PSDRV_AGLGlyphNames +    9 },	/* Acute */
    { 0xf6ca, PSDRV_AGLGlyphNames +   31 },	/* Caron */
    { 0xf6cb, PSDRV_AGLGlyphNames +   46 },	/* Dieresis */
    { 0xf6cc, PSDRV_AGLGlyphNames +   47 },	/* DieresisAcute */
    { 0xf6cd, PSDRV_AGLGlyphNames +   48 },	/* DieresisGrave */
    { 0xf6ce, PSDRV_AGLGlyphNames +   84 },	/* Grave */
    { 0xf6cf, PSDRV_AGLGlyphNames +   95 },	/* Hungarumlaut */
    { 0xf6d0, PSDRV_AGLGlyphNames +  135 },	/* Macron */
    { 0xf6d1, PSDRV_AGLGlyphNames +  640 },	/* cyrBreve */
    { 0xf6d2, PSDRV_AGLGlyphNames +  641 },	/* cyrFlex */
    { 0xf6d3, PSDRV_AGLGlyphNames +  647 },	/* dblGrave */
    { 0xf6d4, PSDRV_AGLGlyphNames +  642 },	/* cyrbreve */
    { 0xf6d5, PSDRV_AGLGlyphNames +  643 },	/* cyrflex */
    { 0xf6d6, PSDRV_AGLGlyphNames +  648 },	/* dblgrave */
    { 0xf6d7, PSDRV_AGLGlyphNames +  655 },	/* dieresisacute */
    { 0xf6d8, PSDRV_AGLGlyphNames +  656 },	/* dieresisgrave */
    { 0xf6d9, PSDRV_AGLGlyphNames +  638 },	/* copyrightserif */
    { 0xf6da, PSDRV_AGLGlyphNames +  923 },	/* registerserif */
    { 0xf6db, PSDRV_AGLGlyphNames +  982 },	/* trademarkserif */
    { 0xf6dc, PSDRV_AGLGlyphNames +  850 },	/* onefitted */
    { 0xf6dd, PSDRV_AGLGlyphNames +  929 },	/* rupiah */
    { 0xf6de, PSDRV_AGLGlyphNames +  975 },	/* threequartersemdash */
    { 0xf6df, PSDRV_AGLGlyphNames +  620 },	/* centinferior */
    { 0xf6e0, PSDRV_AGLGlyphNames +  622 },	/* centsuperior */
    { 0xf6e1, PSDRV_AGLGlyphNames +  633 },	/* commainferior */
    { 0xf6e2, PSDRV_AGLGlyphNames +  634 },	/* commasuperior */
    { 0xf6e3, PSDRV_AGLGlyphNames +  662 },	/* dollarinferior */
    { 0xf6e4, PSDRV_AGLGlyphNames +  664 },	/* dollarsuperior */
    { 0xf6e5, PSDRV_AGLGlyphNames +  754 },	/* hypheninferior */
    { 0xf6e6, PSDRV_AGLGlyphNames +  755 },	/* hyphensuperior */
    { 0xf6e7, PSDRV_AGLGlyphNames +  883 },	/* periodinferior */
    { 0xf6e8, PSDRV_AGLGlyphNames +  884 },	/* periodsuperior */
    { 0xf6e9, PSDRV_AGLGlyphNames +  581 },	/* asuperior */
    { 0xf6ea, PSDRV_AGLGlyphNames +  608 },	/* bsuperior */
    { 0xf6eb, PSDRV_AGLGlyphNames +  671 },	/* dsuperior */
    { 0xf6ec, PSDRV_AGLGlyphNames +  697 },	/* esuperior */
    { 0xf6ed, PSDRV_AGLGlyphNames +  778 },	/* isuperior */
    { 0xf6ee, PSDRV_AGLGlyphNames +  803 },	/* lsuperior */
    { 0xf6ef, PSDRV_AGLGlyphNames +  810 },	/* msuperior */
    { 0xf6f0, PSDRV_AGLGlyphNames +  863 },	/* osuperior */
    { 0xf6f1, PSDRV_AGLGlyphNames +  927 },	/* rsuperior */
    { 0xf6f2, PSDRV_AGLGlyphNames +  956 },	/* ssuperior */
    { 0xf6f3, PSDRV_AGLGlyphNames +  987 },	/* tsuperior */
    { 0xf6f4, PSDRV_AGLGlyphNames +   27 },	/* Brevesmall */
    { 0xf6f5, PSDRV_AGLGlyphNames +   32 },	/* Caronsmall */
    { 0xf6f6, PSDRV_AGLGlyphNames +   40 },	/* Circumflexsmall */
    { 0xf6f7, PSDRV_AGLGlyphNames +   50 },	/* Dotaccentsmall */
    { 0xf6f8, PSDRV_AGLGlyphNames +   96 },	/* Hungarumlautsmall */
    { 0xf6f9, PSDRV_AGLGlyphNames +  132 },	/* Lslashsmall */
    { 0xf6fa, PSDRV_AGLGlyphNames +  149 },	/* OEsmall */
    { 0xf6fb, PSDRV_AGLGlyphNames +  157 },	/* Ogoneksmall */
    { 0xf6fc, PSDRV_AGLGlyphNames +  186 },	/* Ringsmall */
    { 0xf6fd, PSDRV_AGLGlyphNames +  231 },	/* Scaronsmall */
    { 0xf6fe, PSDRV_AGLGlyphNames +  245 },	/* Tildesmall */
    { 0xf6ff, PSDRV_AGLGlyphNames +  290 },	/* Zcaronsmall */
    { 0xf721, PSDRV_AGLGlyphNames +  705 },	/* exclamsmall */
    { 0xf724, PSDRV_AGLGlyphNames +  663 },	/* dollaroldstyle */
    { 0xf726, PSDRV_AGLGlyphNames +  554 },	/* ampersandsmall */
    { 0xf730, PSDRV_AGLGlyphNames + 1036 },	/* zerooldstyle */
    { 0xf731, PSDRV_AGLGlyphNames +  853 },	/* oneoldstyle */
    { 0xf732, PSDRV_AGLGlyphNames +  991 },	/* twooldstyle */
    { 0xf733, PSDRV_AGLGlyphNames +  973 },	/* threeoldstyle */
    { 0xf734, PSDRV_AGLGlyphNames +  725 },	/* fouroldstyle */
    { 0xf735, PSDRV_AGLGlyphNames +  719 },	/* fiveoldstyle */
    { 0xf736, PSDRV_AGLGlyphNames +  950 },	/* sixoldstyle */
    { 0xf737, PSDRV_AGLGlyphNames +  942 },	/* sevenoldstyle */
    { 0xf738, PSDRV_AGLGlyphNames +  682 },	/* eightoldstyle */
    { 0xf739, PSDRV_AGLGlyphNames +  822 },	/* nineoldstyle */
    { 0xf73f, PSDRV_AGLGlyphNames +  903 },	/* questionsmall */
    { 0xf760, PSDRV_AGLGlyphNames +   85 },	/* Gravesmall */
    { 0xf761, PSDRV_AGLGlyphNames +   22 },	/* Asmall */
    { 0xf762, PSDRV_AGLGlyphNames +   28 },	/* Bsmall */
    { 0xf763, PSDRV_AGLGlyphNames +   41 },	/* Csmall */
    { 0xf764, PSDRV_AGLGlyphNames +   51 },	/* Dsmall */
    { 0xf765, PSDRV_AGLGlyphNames +   69 },	/* Esmall */
    { 0xf766, PSDRV_AGLGlyphNames +   76 },	/* Fsmall */
    { 0xf767, PSDRV_AGLGlyphNames +   86 },	/* Gsmall */
    { 0xf768, PSDRV_AGLGlyphNames +   94 },	/* Hsmall */
    { 0xf769, PSDRV_AGLGlyphNames +  115 },	/* Ismall */
    { 0xf76a, PSDRV_AGLGlyphNames +  119 },	/* Jsmall */
    { 0xf76b, PSDRV_AGLGlyphNames +  123 },	/* Ksmall */
    { 0xf76c, PSDRV_AGLGlyphNames +  133 },	/* Lsmall */
    { 0xf76d, PSDRV_AGLGlyphNames +  137 },	/* Msmall */
    { 0xf76e, PSDRV_AGLGlyphNames +  143 },	/* Nsmall */
    { 0xf76f, PSDRV_AGLGlyphNames +  170 },	/* Osmall */
    { 0xf770, PSDRV_AGLGlyphNames +  177 },	/* Psmall */
    { 0xf771, PSDRV_AGLGlyphNames +  179 },	/* Qsmall */
    { 0xf772, PSDRV_AGLGlyphNames +  187 },	/* Rsmall */
    { 0xf773, PSDRV_AGLGlyphNames +  236 },	/* Ssmall */
    { 0xf774, PSDRV_AGLGlyphNames +  246 },	/* Tsmall */
    { 0xf775, PSDRV_AGLGlyphNames +  266 },	/* Usmall */
    { 0xf776, PSDRV_AGLGlyphNames +  269 },	/* Vsmall */
    { 0xf777, PSDRV_AGLGlyphNames +  275 },	/* Wsmall */
    { 0xf778, PSDRV_AGLGlyphNames +  278 },	/* Xsmall */
    { 0xf779, PSDRV_AGLGlyphNames +  286 },	/* Ysmall */
    { 0xf77a, PSDRV_AGLGlyphNames +  293 },	/* Zsmall */
    { 0xf7a1, PSDRV_AGLGlyphNames +  704 },	/* exclamdownsmall */
    { 0xf7a2, PSDRV_AGLGlyphNames +  621 },	/* centoldstyle */
    { 0xf7a8, PSDRV_AGLGlyphNames +   49 },	/* Dieresissmall */
    { 0xf7af, PSDRV_AGLGlyphNames +  136 },	/* Macronsmall */
    { 0xf7b4, PSDRV_AGLGlyphNames +   10 },	/* Acutesmall */
    { 0xf7b8, PSDRV_AGLGlyphNames +   38 },	/* Cedillasmall */
    { 0xf7bf, PSDRV_AGLGlyphNames +  902 },	/* questiondownsmall */
    { 0xf7e0, PSDRV_AGLGlyphNames +   14 },	/* Agravesmall */
    { 0xf7e1, PSDRV_AGLGlyphNames +    5 },	/* Aacutesmall */
    { 0xf7e2, PSDRV_AGLGlyphNames +    8 },	/* Acircumflexsmall */
    { 0xf7e3, PSDRV_AGLGlyphNames +   24 },	/* Atildesmall */
    { 0xf7e4, PSDRV_AGLGlyphNames +   12 },	/* Adieresissmall */
    { 0xf7e5, PSDRV_AGLGlyphNames +   21 },	/* Aringsmall */
    { 0xf7e6, PSDRV_AGLGlyphNames +    3 },	/* AEsmall */
    { 0xf7e7, PSDRV_AGLGlyphNames +   35 },	/* Ccedillasmall */
    { 0xf7e8, PSDRV_AGLGlyphNames +   63 },	/* Egravesmall */
    { 0xf7e9, PSDRV_AGLGlyphNames +   54 },	/* Eacutesmall */
    { 0xf7ea, PSDRV_AGLGlyphNames +   58 },	/* Ecircumflexsmall */
    { 0xf7eb, PSDRV_AGLGlyphNames +   60 },	/* Edieresissmall */
    { 0xf7ec, PSDRV_AGLGlyphNames +  109 },	/* Igravesmall */
    { 0xf7ed, PSDRV_AGLGlyphNames +  100 },	/* Iacutesmall */
    { 0xf7ee, PSDRV_AGLGlyphNames +  103 },	/* Icircumflexsmall */
    { 0xf7ef, PSDRV_AGLGlyphNames +  105 },	/* Idieresissmall */
    { 0xf7f0, PSDRV_AGLGlyphNames +   73 },	/* Ethsmall */
    { 0xf7f1, PSDRV_AGLGlyphNames +  145 },	/* Ntildesmall */
    { 0xf7f2, PSDRV_AGLGlyphNames +  159 },	/* Ogravesmall */
    { 0xf7f3, PSDRV_AGLGlyphNames +  151 },	/* Oacutesmall */
    { 0xf7f4, PSDRV_AGLGlyphNames +  154 },	/* Ocircumflexsmall */
    { 0xf7f5, PSDRV_AGLGlyphNames +  172 },	/* Otildesmall */
    { 0xf7f6, PSDRV_AGLGlyphNames +  156 },	/* Odieresissmall */
    { 0xf7f8, PSDRV_AGLGlyphNames +  169 },	/* Oslashsmall */
    { 0xf7f9, PSDRV_AGLGlyphNames +  256 },	/* Ugravesmall */
    { 0xf7fa, PSDRV_AGLGlyphNames +  249 },	/* Uacutesmall */
    { 0xf7fb, PSDRV_AGLGlyphNames +  252 },	/* Ucircumflexsmall */
    { 0xf7fc, PSDRV_AGLGlyphNames +  254 },	/* Udieresissmall */
    { 0xf7fd, PSDRV_AGLGlyphNames +  281 },	/* Yacutesmall */
    { 0xf7fe, PSDRV_AGLGlyphNames +  244 },	/* Thornsmall */
    { 0xf7ff, PSDRV_AGLGlyphNames +  284 },	/* Ydieresissmall */
    { 0xf8e5, PSDRV_AGLGlyphNames +  916 },	/* radicalex */
    { 0xf8e6, PSDRV_AGLGlyphNames +  576 },	/* arrowvertex */
    { 0xf8e7, PSDRV_AGLGlyphNames +  570 },	/* arrowhorizex */
    { 0xf8e8, PSDRV_AGLGlyphNames +  922 },	/* registersans */
    { 0xf8e9, PSDRV_AGLGlyphNames +  637 },	/* copyrightsans */
    { 0xf8ea, PSDRV_AGLGlyphNames +  981 },	/* trademarksans */
    { 0xf8eb, PSDRV_AGLGlyphNames +  872 },	/* parenlefttp */
    { 0xf8ec, PSDRV_AGLGlyphNames +  869 },	/* parenleftex */
    { 0xf8ed, PSDRV_AGLGlyphNames +  868 },	/* parenleftbt */
    { 0xf8ee, PSDRV_AGLGlyphNames +  601 },	/* bracketlefttp */
    { 0xf8ef, PSDRV_AGLGlyphNames +  600 },	/* bracketleftex */
    { 0xf8f0, PSDRV_AGLGlyphNames +  599 },	/* bracketleftbt */
    { 0xf8f1, PSDRV_AGLGlyphNames +  593 },	/* bracelefttp */
    { 0xf8f2, PSDRV_AGLGlyphNames +  592 },	/* braceleftmid */
    { 0xf8f3, PSDRV_AGLGlyphNames +  591 },	/* braceleftbt */
    { 0xf8f4, PSDRV_AGLGlyphNames +  589 },	/* braceex */
    { 0xf8f5, PSDRV_AGLGlyphNames +  767 },	/* integralex */
    { 0xf8f6, PSDRV_AGLGlyphNames +  878 },	/* parenrighttp */
    { 0xf8f7, PSDRV_AGLGlyphNames +  875 },	/* parenrightex */
    { 0xf8f8, PSDRV_AGLGlyphNames +  874 },	/* parenrightbt */
    { 0xf8f9, PSDRV_AGLGlyphNames +  605 },	/* bracketrighttp */
    { 0xf8fa, PSDRV_AGLGlyphNames +  604 },	/* bracketrightex */
    { 0xf8fb, PSDRV_AGLGlyphNames +  603 },	/* bracketrightbt */
    { 0xf8fc, PSDRV_AGLGlyphNames +  597 },	/* bracerighttp */
    { 0xf8fd, PSDRV_AGLGlyphNames +  596 },	/* bracerightmid */
    { 0xf8fe, PSDRV_AGLGlyphNames +  595 },	/* bracerightbt */
    { 0xfb00, PSDRV_AGLGlyphNames +  709 },	/* ff */
    { 0xfb01, PSDRV_AGLGlyphNames +  712 },	/* fi */
    { 0xfb02, PSDRV_AGLGlyphNames +  721 },	/* fl */
    { 0xfb03, PSDRV_AGLGlyphNames +  710 },	/* ffi */
    { 0xfb04, PSDRV_AGLGlyphNames +  711 },	/* ffl */
    { 0xfb1f, PSDRV_AGLGlyphNames +  516 },	/* afii57705 */
    { 0xfb2a, PSDRV_AGLGlyphNames +  513 },	/* afii57694 */
    { 0xfb2b, PSDRV_AGLGlyphNames +  514 },	/* afii57695 */
    { 0xfb35, PSDRV_AGLGlyphNames +  520 },	/* afii57723 */
    { 0xfb4b, PSDRV_AGLGlyphNames +  515 }	/* afii57700 */
};

UNICODEVECTOR PSDRV_AdobeGlyphList = { 1051, encoding };
