
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include "win.h"
#include "ocr.h"
#include "baum.h"
#include "main.h"
#include "german.h"

 extern char *OrginalBildPuffer;
 extern long Page_x,Page_y,Page_Bytes_pro_Zeile;
 extern long Max_x,Min_x,Min_y,Max_y;
 extern struct Objekt *ObjektListe;  
 extern Display *display;
 extern Window window;
 extern unsigned short int ByteIstGespiegelt[];
 extern struct BitBlockListe *BitBlockListeStartPtr;
 extern struct BitBlockListe *SegmentBitBlockListeStartPtr;
 extern struct LearndListe *ZeichenListeStart[35][16][16];
 extern long LastMouseX,LastMouseY;
 extern unsigned long color_black,color_white,color_red,color_blue; 


 struct Objekt *ZielBilder[20],*ZielBild[20],*ParameterWindow,*Kartei,*Copyright,*OeffneFileWindow,
               *Trigram,*Semantik,*Deutsch,*Englisch,*Nachfragen,*PfadTemp,*PfadOcr,*Faktor,
               *PfadZiel,*EditorName,*Dateiname,*Woerterbuch,*Alle,*UseEditor,*DateiSpeichern,
	       *SuchenNach,*Ordner,*Datei,*Notice,*NText,*Frage,*FrageBild,*FrageZeichen,*Wort,
	       *FEingabe,*FBild,*FZeichen,*WListe,*WEingabe,*FB1,*FB2,*FB3,*FZoom,*FLERNEN,*FWEITER;
 struct Menu_Element *MM[12];

 XImage Bilder[10],Orginal[10],Icon;
 long Filter=8;
 char *arg1;
 long Statu = 0;
 long Action = 0;
 long MarkerX[12],MoveX[20],MoveY[20];
 long GRENZWERT_RATE = 2000 ;
 long MarkerY[12] ;
 long Aktuell_t=0;
 struct BitBlockListe *SegmenteStart[10],*BlockListeStart[10],*Aktuell,*Aktuell_Zeile;
 float ZoomX[10],ZoomY[10];
 struct Parameter ParaAktuell;




 
void SpeichereParameter();
void LadeParameter();

/***************************************************************
Procedure        : void Zeige_alle_Bloecke_an()

Typ              : Wegwerf-Routine !  

Aufgabe:         Zeige alle Bitbloecke an .   
               
****************************************************************/
/*
void Zeige_alle_Bloecke_an()
 long GRENZWERT_RATE = 2000;
{
 struct BitBlockListe *P1,*P2,*P3;  
 for (P1=SegmentBitBlockListeStartPtr;P1!=NULL;P1=P1->NextSegmentBlockPtr)  
 {  
  if (P1->Geloescht==0)
  {
   XSetForeground(display,gc,color_green);
 XDrawRectangle(display,window,gc,(P1->x>>fa)+offx-1,offy+(P1->y>>fa)-1,(P1->dx>>fa)+2,((P1->dy)>>fa)+2);

 for (P2=P1->NextZeileInSegment;P2!=NULL;P2=P2->NextZeileInSegment)
   {     
    if (P2->Geloescht==0)
    {
     XSetForeground(display,gc,color_blue);
     XDrawRectangle(display,window,gc,(P2->x>>fa)+offx,offy+(P2->y>>fa),(P2->dx>>fa),((P2->dy)>>fa) );
     XSetForeground(display,gc,color_brown);
     XDrawLine(display,window,gc,(P2->x>>fa)+offx+1,(P2->Obere_Zeile>>fa)+offy,-1+offx+(P2->xx>>fa),offy+(P2->Obere_Zeile>>fa));
     XSetForeground(display,gc,color_yellow);  
     XDrawLine(display,window,gc,(P2->x>>fa)+offx+1,(P2->Untere_Zeile>>fa)+offy,-1+offx+(P2->xx>>fa),offy+(P2->Untere_Zeile>>fa));
     for (P3=P2->NextPtrInZeile;P3!=NULL;P3=P3->NextPtrInZeile)
     {
      if ((P3->Geloescht==0) && (P3->Elemente>1)) 
      {
       XSetForeground(display,gc,color_red);
       XDrawRectangle(display,window,gc,(P3->x>>fa)+offx,offy+(P3->y>>fa),(P3->dx>>fa),((P3->dy)>>fa) );
      }
     }
    }
   }
  }
 }
 XFlush(display);
}
*/


void BildKlick();


void LoescheAlleBloecke(t)
long t;
{
 struct BitBlockListe *P1,*P2,*P3,*Pa1,*Pa2,*Pa3;  
 for (P1=SegmenteStart[t];P1!=NULL;P1=Pa1)  
 {  
  for (P2=P1->NextZeileInSegment;P2!=NULL;P2=Pa2)
  {     
   for (P3=P2->NextPtrInZeile;P3!=NULL;P3=Pa3)
   {
    Pa3=P3->NextPtrInZeile;
    P3->NextPtrInZeile=NULL;
    P3->NextSegmentBlockPtr=NULL;
    P3->NextPtrInSegment=NULL;
    P3->NextZeileInSegment=NULL;
   } /* for elemente */
   Pa2=P2=P2->NextZeileInSegment;
   free(P2);
  } /* for zeilen */
  Pa1=P1->NextSegmentBlockPtr;
  free(P1);
 } /* for segmente */
 SegmenteStart[t]=NULL;

}


void ShowParameterWindow()
{

 SetObjektSichtbar(ParameterWindow,WAHR);
 SetWindow(ParameterWindow);
 WechsleKarteiKarte(Kartei,0,1);
}

void CloseParameterWindow() { SpeichereParameter(); SetObjektSichtbar(ParameterWindow,FALSCH);  LadeParameter(); }
void ShowCopyrightWindow()  { SetObjektSichtbar(Copyright,WAHR); SetWindow(Copyright); }
void CloseCopyrightWindow() { SetObjektSichtbar(Copyright,FALSCH); }
void HideParameterWindow()
{
 BerechneFensterCliping(ObjektListe);
 SetObjektSichtbar(ParameterWindow,FALSCH);
 BerechneFensterCliping(ObjektListe);
 LadeParameter();
}


void KlickAufSuchen()
{
 SetSuchString(Datei,GetString(SuchenNach));
}

void KlickAufOrdner()
{
if (Ordner!=NULL) SetPath(Datei,GetPath(Ordner)); 
}

/* Zoome das bild auf i Prozent */
void Zoom(i)
int i;
{
 long t,x,y;
 float Zoomx,Zoomy;
 long x1,y1,Zeile,s;
 char *P,*Q,*Q1;
 
 Zoomx=i/100.0;
 Zoomy=i/100.0;
 
 for (t=0;t<10;t++) 
 {
  if (ObjektListe==ZielBilder[t])
  {
   ZoomX[t]=Zoomx;
   ZoomY[t]=Zoomy;
   x=10+Orginal[t].width;
   y=10+Orginal[t].height;
   x1=Zoomx*x;
   y1=Zoomy*y;
   Bilder[t].width = x1;
   Bilder[t].height= y1;
   s=(x1*y1)>>3;
   if (Bilder[t].data!=NULL) { free(Bilder[t].data); }
   Bilder[t].data=calloc(1,s);
   Bilder[t].bytes_per_line=((8+Bilder[t].width)>>3);
   Zeile=0;  
   P=Orginal[t].data;
   for (y=0;y<Orginal[t].height;y++)
   { 
    y1=y*Zoomy;
    Q=y1*Bilder[t].bytes_per_line+Bilder[t].data;
    for (x=0;x<Orginal[t].width;x++)
    {
     if ((128>>(x&7)) & (*(P+Zeile+(x>>3)))) 
     { /* setze punkt. */
      x1=x*Zoomx;
      Q1=Q + (x1>>3);
      *Q1=*Q1 | (128>>(x1&7));
     } /* punkt */
    } /* for x */   
    Zeile+=Orginal[t].bytes_per_line;
   } /* for y */
  XSetForeground(display,ZielBild[t]->gc,color_white);
  XSetBackground(display,ZielBild[t]->gc,color_white);
  XFillRectangle(display,window,ZielBild[t]->gc,0,0,2000,2000); 

  } /* if t */
 } /* for t */
 
 BildKlick();
}

void SpeichereParameter()
{
FILE *file;
strcpy(ParaAktuell.PfadTemp,GetString(PfadTemp));
strcpy(ParaAktuell.PfadOcr,GetString(PfadOcr));
strcpy(ParaAktuell.Ziel,GetString(PfadZiel));
strcpy(ParaAktuell.Editor,GetString(EditorName));
strcpy(ParaAktuell.Dateiname,GetString(Dateiname));

ParaAktuell.Nachfragen=GetValue(Nachfragen);
ParaAktuell.Faktor=GetValue(Faktor);

ParaAktuell.Trigram			=FALSCH;
ParaAktuell.Semantik			=FALSCH;
ParaAktuell.DeutschSemantik		=FALSCH;
ParaAktuell.EnglischSemantik		=FALSCH;
ParaAktuell.UseEditor			=FALSCH;
ParaAktuell.AlleWoerterbuecher		=FALSCH;
ParaAktuell.Woerterbuch			=FALSCH; 


if (GetValue(Trigram)==WAHR) ParaAktuell.Trigram	 	        =WAHR;
if (GetValue(Semantik)==WAHR) ParaAktuell.Semantik			=WAHR;
if (GetValue(Deutsch)==WAHR) ParaAktuell.DeutschSemantik		=WAHR;
if (GetValue(Englisch)==WAHR) ParaAktuell.EnglischSemantik		=WAHR;
if (GetValue(UseEditor)==WAHR) ParaAktuell.UseEditor			=WAHR;
if (GetValue(Alle)==WAHR) ParaAktuell.AlleWoerterbuecher		=WAHR;
if (GetValue(Woerterbuch)==WAHR) ParaAktuell.Woerterbuch		=WAHR;  
GRENZWERT_RATE=GetValue(Faktor)*4;
file=fopen(".XOCRrc","w+");
fwrite(&ParaAktuell,1,sizeof(struct Parameter),file);
fclose(file);
}

void LadeParameter()
{
FILE *file;

file=fopen(".XOCRrc","a+b");
fseek(file,0,0);
if (sizeof(struct Parameter)!=fread(&ParaAktuell,1,sizeof(struct Parameter),file)) 
{  
 printf("XOCR: missing file [.XOCRrc]\nXOCR: create new file [.XOCRrc] \n");
 SpeichereParameter();
 fseek(file,0,0);
 fread(&ParaAktuell,1,sizeof(struct Parameter),file);
}
fclose(file);
if (ParaAktuell.Faktor>100) ParaAktuell.Faktor=99;
if (ParaAktuell.Faktor<1) ParaAktuell.Faktor=0;
PutValue(Faktor,ParaAktuell.Faktor);
PutValue(Nachfragen,FALSCH);
if (ParaAktuell.Nachfragen==WAHR) PutValue(Nachfragen,WAHR);
PutValue(Semantik,FALSCH);
if (ParaAktuell.Semantik==WAHR) PutValue(Semantik,WAHR);
PutValue(Deutsch,FALSCH);
if (ParaAktuell.DeutschSemantik==WAHR) PutValue(Deutsch,WAHR);
PutValue(Englisch,FALSCH);
if (ParaAktuell.EnglischSemantik==WAHR) PutValue(Englisch,WAHR);
PutValue(Trigram,FALSCH);
if (ParaAktuell.Trigram==WAHR) PutValue(Trigram,WAHR);
PutValue(UseEditor,FALSCH);
if (ParaAktuell.UseEditor==WAHR) PutValue(UseEditor,WAHR);
PutValue(DateiSpeichern,FALSCH);
if (ParaAktuell.UseEditor==FALSCH) PutValue(DateiSpeichern,WAHR); 
PutValue(Alle,FALSCH);
if (ParaAktuell.AlleWoerterbuecher==WAHR) PutValue(Alle,WAHR);
PutValue(Woerterbuch,FALSCH);
if (ParaAktuell.Woerterbuch==WAHR) PutValue(Woerterbuch,WAHR);
PutString(Dateiname,ParaAktuell.Dateiname);
PutString(EditorName,ParaAktuell.Editor);
PutString(PfadTemp,ParaAktuell.PfadTemp);
PutString(PfadZiel,ParaAktuell.Ziel);
PutString(PfadOcr,ParaAktuell.PfadOcr);
GRENZWERT_RATE=GetValue(Faktor)*4;
 
}

void XSpiegel()
{
 long t,y,x1,y1,x;
 unsigned char *P,*P1,c;
 for (t=0;t<10;t++) 
 {
  if (ObjektListe==ZielBilder[t])
  {
   y1=Orginal[t].height; 
   x1=Orginal[t].bytes_per_line>>1;
   P = Orginal[t].data;
   for (y=0;y<y1;y++)
   { 
    P1=P+x1+x1;
    for (x=0;x<x1;x++)
    {
     c=ByteIstGespiegelt[*P1];
     *P1=ByteIstGespiegelt[*P];
     *P=c;
     P1--; P++;
    }
    P=P+x1;
   }
   y1=(Bilder[t].height); 
   x1=Bilder[t].bytes_per_line>>1;
   P = Bilder[t].data;
   for (y=0;y<y1;y++)
   { 
    P1=P+x1+x1;
    for (x=0;x<x1;x++)
    {
     c=ByteIstGespiegelt[*P1];
     *P1=ByteIstGespiegelt[*P];
     *P=c;
     P1--; P++;
    }
    P=P+x1;
   }


  break;
  }
 }   
 BildKlick();





}

void YSpiegel()
{
 long t,y,x1,y1,x;
 unsigned char *P,*P1,c;
 for (t=0;t<10;t++) 
 {
  if (ObjektListe==ZielBilder[t])
  {
   y1=(Orginal[t].height>>1); 
   x1=Orginal[t].bytes_per_line;
   P = Orginal[t].data;
   P1= P + Orginal[t].height*Orginal[t].bytes_per_line - x1;
   for (y=0;y<y1;y++)
   { 
    for (x=0;x<x1;x++)
    {
     c=*P1;
     *P1=*P;
     *P=c;
     P1++; P++;
    }
    P1=P1-x1-x1;
   }
   y1=(Bilder[t].height>>1); 
   x1=Bilder[t].bytes_per_line;
   P = Bilder[t].data;
   P1= P + Bilder[t].height*Bilder[t].bytes_per_line  - x1;
   for (y=0;y<y1;y++)
   { 
    for (x=0;x<x1;x++)
    {
     c=*P1;
     *P1=*P;
     *P=c;
     P1++; P++;
    }
    P1=P1-x1-x1;
   }

  break;
  }
 }   
 BildKlick();

}

void anpassen()
{
 long t,x,y;
 float Zoomx,Zoomy;
 long x1,y1,Zeile,s;
 char *P,*Q,*Q1;
 
 
 for (t=0;t<10;t++) 
 {
  if (ObjektListe==ZielBilder[t])
  {
   Zoomx= (ZielBild[t]->Size.dx+0.0) / Orginal[t].width;
   Zoomy= (ZielBild[t]->Size.dy+0.0) / Orginal[t].height; 
   ZoomX[t]=Zoomx;
   ZoomY[t]=Zoomy;
   x=10+Orginal[t].width;
   y=10+Orginal[t].height;
   x1=Zoomx*x;
   y1=Zoomy*y;
   Bilder[t].width = x1;
   Bilder[t].height= y1;
   s=(x1*y1)>>3;
   if (Bilder[t].data!=NULL) { free(Bilder[t].data); }
   Bilder[t].data=calloc(1,s);
   Bilder[t].bytes_per_line=((8+Bilder[t].width)>>3);
   Zeile=0;  
   P=Orginal[t].data;
   for (y=0;y<Orginal[t].height;y++)
   { 
    y1=y*Zoomy;
    Q=y1*Bilder[t].bytes_per_line+Bilder[t].data;
    for (x=0;x<Orginal[t].width;x++)
    {
     if ((128>>(x&7)) & (*(P+Zeile+(x>>3)))) 
     { /* setze punkt. */
      x1=x*Zoomx;
      Q1=Q + (x1>>3);
      *Q1=*Q1 | (128>>(x1&7));
     } /* punkt */
    } /* for x */   
    Zeile+=Orginal[t].bytes_per_line;
   } /* for y */
  } /* if t */
 } /* for t */
 
 BildKlick();

}


void HideOeffneFileWindow()
{
SetObjektSichtbar(OeffneFileWindow,FALSCH);
}

void LadeBitmap();

void CloseOeffneFileWindow()
{
 char *Item;
 Item=GetSelected(Datei);
 if (Item!=NULL)
 {
  char dat[600];
  sprintf(dat,"%s%s",GetPath(Ordner),Item); 
  SetObjektSichtbar(OeffneFileWindow,FALSCH);
  LadeBitmap(dat);

 }
}

void invert()
{
 long t,y,s;
 char *P;
 for (t=0;t<10;t++) 
 {
  if (ObjektListe==ZielBilder[t])
  {
   s=Orginal[t].height*Orginal[t].bytes_per_line; 
   P=Orginal[t].data;
   for (y=0;y<s;y++)
   { 
    *P =  ~*P; P++;
   }
   s=Bilder[t].height*Bilder[t].bytes_per_line; 
   P=Bilder[t].data;
   for (y=0;y<s;y++)
   { 
    *P =  ~*P; P++;
   }

  }
 }   
 BildKlick();
}

void Seg_kill();
void SegmentStart();

void Seg_start()
{
 Seg_kill(); 
 SegmentStart();;
}

void Seg_kill()
{
 struct BitBlockListe *P1,*P2;  
 long t;
 for (t=0;t<10;t++)
 {
  if (ObjektListe==ZielBilder[t])
  {
   for (P1=SegmenteStart[t];P1!=NULL;P1=P2)  
   {  
    P2=P1->NextSegmentBlockPtr;
    free(P1);
   }
   SegmenteStart[t]=NULL;
  }
 }
 BildKlick();
}

void Seg_kill_one()
{
 Action=1;
}

void Seg_insert()
{
 Action=2;
}

void OeffneDatei()
{
SetObjektSichtbar(OeffneFileWindow,WAHR);
SetWindow(OeffneFileWindow);
}

void SchliesseDatei()
{
 long t; 
 struct BitBlockListe *P,*P1;
 for (t=0;t<10;t++)
 {
  if (ObjektListe==ZielBilder[t])
  {
    SetObjektSichtbar(ZielBilder[t],FALSCH);
    Seg_kill();
    if (Bilder[t].data!=NULL)  free(Bilder[t].data);
    if (Orginal[t].data!=NULL) free(Orginal[t].data);
    Bilder[t].data=NULL;
    Orginal[t].data=NULL;
    for (P=BlockListeStart[t];P!=NULL;)
    {
     P1=P->NextPtr;
     free(P);
     P=P1;  
   }
   BlockListeStart[t]=NULL;


  }
}

}

void Ende() 
{  
 exit(0);  /* Don't scream and die now ! */
}

void Info()
{
}

void MaleFBild()
{
 long x,y,x1,y1,x2,y2,rx,ry;
 if (GetValue(FZoom))
 {
  rx=0;
  ry=0;
  x=(ZoomX[Aktuell_t]*(Aktuell->x+(Aktuell->dx>>1)))-55;
  y=(ZoomY[Aktuell_t]*(Aktuell->y+(Aktuell->dy>>1)))-40;
  if (x<0) { rx=x; x=0; }
  if (y<0) { ry=y; y=0; }
  XSetBackground(display,FBild->gc,color_white);
  XSetForeground(display,FBild->gc,color_white);
  XFillRectangle(display,window,FBild->gc,FBild->Size.X,FBild->Size.Y,FBild->Size.dx,FBild->Size.dy);
  XSetForeground(display,FBild->gc,color_black); 
  XPutImage(display,window,FBild->gc,&Bilder[Aktuell_t],x,y,FBild->Size.X+1-rx,FBild->Size.Y+1-ry,109,79);
  XSetForeground(display,FBild->gc,color_red); 
  x1=ZoomX[Aktuell_t]*Aktuell->dx;
  y1=ZoomY[Aktuell_t]*Aktuell->dy; 
  x2=FBild->Size.X+55-(x1>>1);
  y2=FBild->Size.Y+40-(y1>>1); 
  XDrawRectangle(display,window,FBild->gc,x2,y2,x1,y1);

  if (Aktuell_Zeile->Untere_Zeile>0)
  {
   XSetForeground(display,FBild->gc,color_blue); 
   x=(ZoomY[Aktuell_t]*Aktuell_Zeile->Untere_Zeile) -y+FBild->Size.Y-ry;
   XDrawLine(display,window,FBild->gc,FBild->Size.X,x,110+FBild->Size.X,x);
  }
  if (Aktuell_Zeile->Obere_Zeile>0)
  {
   XSetForeground(display,FBild->gc,color_blue); 
   x=(ZoomY[Aktuell_t]*Aktuell_Zeile->Obere_Zeile) -y+FBild->Size.Y-ry;
   XDrawLine(display,window,FBild->gc,FBild->Size.X,x,110+FBild->Size.X,x);
  }


 } else
 {
  rx=0; ry=0;
  x=Aktuell->x-55+((Aktuell->dx)>>1);
  y=Aktuell->y-40+((Aktuell->dy)>>1);
  if (x<0) { rx=x; x=0; }
  if (y<0) { ry=y; y=0; }
  XSetBackground(display,FBild->gc,color_white);
  XSetForeground(display,FBild->gc,color_white);
  XFillRectangle(display,window,FBild->gc,FBild->Size.X,FBild->Size.Y,FBild->Size.dx,FBild->Size.dy);

  XSetForeground(display,FBild->gc,color_black); 
  XPutImage(display,window,FBild->gc,&Orginal[Aktuell_t],x,y,FBild->Size.X+1-rx,FBild->Size.Y+1-ry,109,79);
  XSetForeground(display,FBild->gc,color_red); 
  x1=FBild->Size.X+55-(Aktuell->dx>>1);
  y1=FBild->Size.Y+40-(Aktuell->dy>>1);
  XDrawRectangle(display,window,FBild->gc,x1,y1,Aktuell->dx,Aktuell->dy);

 

  if (Aktuell_Zeile->Untere_Zeile>0)
  {
   XSetForeground(display,FBild->gc,color_blue); 
   x=Aktuell_Zeile->Untere_Zeile-y+FBild->Size.Y;
   XDrawLine(display,window,FBild->gc,FBild->Size.X,x,110+FBild->Size.X,x);
  }
  if (Aktuell_Zeile->Obere_Zeile>0)
  {
   XSetForeground(display,FBild->gc,color_blue); 
   x=Aktuell_Zeile->Obere_Zeile-y+FBild->Size.Y;
   XDrawLine(display,window,FBild->gc,FBild->Size.X,x,110+FBild->Size.X,x);
  }

 }


 XFlush(display);
}



void MaleFrage()
{
 XSetBackground(display,FZeichen->gc,color_white);
 XSetForeground(display,FZeichen->gc,color_black); 
 XPutImage(display,window,FZeichen->gc,&Icon,0,0,FZeichen->Size.X+1,FZeichen->Size.Y+1,16,16);
 XFlush(display);
}

void FZoomOK()
{
 MaleFBild();
}

void BerechneAbstaende(t1)
long t1;
{
 long Wert,t,xx,xxx,minimum,l;
 struct LearndListe  *Ptr;
 struct BitBlockListe *P1,*P2,*P3;  
 FILE *output;
 short int Flag;
 struct Objekt *PErsatz,*PErsatz1,*PErsatz2;
 
 PErsatz=ObjektListe;
 PErsatz1=Frage->Bruder;
 PErsatz2=Notice->Bruder;
   
 Frage->Bruder=Notice;
 Notice->Bruder=NULL;
  
 ObjektListe=Frage;
 BerechneFensterCliping(ObjektListe);
 CheckRepaintArea(0,0,1000,1000);

 PutString(NText,TEXT1);
 SetWindow(NText);
 SetObjektSichtbar(NText,WAHR);
 output=fopen("tmp.dat","w+"); 
 for (P1=SegmenteStart[t1];P1!=NULL;P1=P1->NextSegmentBlockPtr)  
 {  
  if (P1->Geloescht==0)
  {
   minimum=P1->ddx*0.55;
   for (P2=P1->NextZeileInSegment;P2!=NULL;P2=P2->NextZeileInSegment)
   {     
    if (P2->Geloescht==0)
    {
     xx=0; xxx=0;
     Aktuell_Zeile=P2;
     for (P3=P2->NextPtrInZeile;P3!=NULL;P3=P3->NextPtrInZeile)
     {
      if (P3->Geloescht==0) 
      {
       xx=P3->x;
       if (((xx-xxx)>minimum) && (xxx!=0)) fprintf(output,"\n");
       xxx=P3->x+P3->dx;
       Wert=9999;
       Ptr=AnalysiereAlleWerteEinesSegments(P3,&Wert,&Flag);
       Aktuell=P3;
       if (Wert>GRENZWERT_RATE)
       { /* Frage den Benutzer, da zu ungenaue Berechnung */
        Statu=0;
        if (Ptr!=NULL) { PutString(FEingabe,Ptr->Daten.Zeichen); } else {  PutString(FEingabe,""); }
        Icon.data=P3->BildDaten;
        SetWindow(Frage);
        SetObjektSichtbar(Frage,WAHR);
        TakeControlUntil(FB1,FB2,FB3,FB1,FB1,FB1); 
        SetObjektSichtbar(Frage,FALSCH);
        if (Statu==1) 
        {
         struct LearndListe *ErgPtr;
         strncpy(P3->Text,GetString(FEingabe),3);  
         ErgPtr=(struct LearndListe *)calloc(1,sizeof(struct LearndListe));
         if (ErgPtr==NULL) MemoryError();
         ErgPtr->Daten.Klasse=P3->Klasse;
         ErgPtr->NextPtr=NULL;
         ErgPtr->Daten.Elemente=P3->Elemente;
         for (t=0;t<128;t++) ErgPtr->Daten.WsaAchsenWerte[t]=P3->WsaAchsenWerte[t];
         ErgPtr->Daten.Flag=Flag;
         strncpy(ErgPtr->Daten.Zeichen,GetString(FEingabe),3);  
          /* neues element in die liste einhaengen und abspeichern */
         ErgPtr->NextPtr=ZeichenListeStart[P3->Klasse][P3->Elemente][Flag];
         ZeichenListeStart[P3->Klasse][P3->Elemente][Flag]=ErgPtr;
         SpeichereGelerntesZeichen(ErgPtr);
        }
        if (Statu==2)
        {
         ObjektListe=PErsatz;
         Frage->Bruder=PErsatz1;
         Notice->Bruder=PErsatz2;
         BerechneFensterCliping(ObjektListe);
         CheckRepaintArea(0,0,1000,1000);
         return;
        }
        if (Statu==3)
        {
         strncpy(P3->Text,GetString(FEingabe),3);   
        } 
       } else 
       { /* yepp, voll erkannt */
       
        if (Ptr!=NULL) {  strncpy(P3->Text,Ptr->Daten.Zeichen,3); } else { strcpy(P3->Text,""); }  
       }       
        if (P3->NextPtrInZeile!=NULL)
        {
         fprintf(output,"%s",P3->Text); 
        } else
        { /* upps letztes zeichen !*/ 
         l=strlen(P3->Text)-1;
         if (l<0) l=0;
         if ((P3->Text[l]=='-') || (P3->Text[l]=='~'))
         { /* bindestich loeschen */
           P3->Text[l]=0;
           fprintf(output,"%s",P3->Text); 
         } else
         { /* normales ende */
           fprintf(output,"%s\n",P3->Text); 
         }  
        }
      }
     }
    }
   }
  }
 }
 for (t=0;t<65;t++) fprintf(output,"%c\n",1);
 fprintf(output,"END OF TMP-FILE\n"); 
 fclose(output); 
 ObjektListe=PErsatz;
 Frage->Bruder=PErsatz1;
 Notice->Bruder=PErsatz2;
 BerechneFensterCliping(ObjektListe);
 CheckRepaintArea(0,0,1000,1000);

}


void OcrStart()
{
 long t; 
 for (t=0;t<10;t++)
 {
  if (ObjektListe==ZielBilder[t])
  {
   if (SegmenteStart[t]==NULL)
   {
     long x,y,dx,dy;
     struct BitBlockListe *Ptr;
     x=0;
     y=0;
     dx=Orginal[t].width;
     dy=Orginal[t].height;
     /* erstelle Datenelement */
     Ptr=calloc(1,sizeof(struct BitBlockListe));    
     if (Ptr==NULL) { MemoryError(); }
     Ptr->Bytes_pro_Zeile=0;
     Ptr->x=x;
     Ptr->y=y;
     Ptr->Startx=x;
     Ptr->Starty=y;
     Ptr->Bild=0;
     Ptr->SegmentNummer=-1;
     Ptr->SpaltenNummer=-1;
     Ptr->XSpiegel=0;
     Ptr->YSpiegel=0;
     Ptr->Untere_Zeile=-1;
     Ptr->Obere_Zeile=-1;
     Ptr->Geloescht=0;
     Ptr->dx=dx;
     Ptr->dy=dy; 
     Ptr->xx=x+dx;
     Ptr->yy=y+dy;       
     Ptr->NextPtrInZeile=NULL;
     Ptr->NextSegmentBlockPtr=NULL;
     Ptr->NextPtrInSegment=NULL;
     Ptr->NextPtr=NULL;
     SegmenteStart[t]=Ptr;
     BildKlick();     
   }
   Aktuell_t=t;
   PutString(NText,TEXT6);
   SetWindow(Notice);
   SetObjektSichtbar(Notice,WAHR);

   SegmentBitBlockListeStartPtr=SegmenteStart[t];
   BitBlockListeStartPtr=BlockListeStart[t];
   Page_x= Orginal[t].width;
   Page_y= Orginal[t].height;
   Page_Bytes_pro_Zeile = Orginal[t].bytes_per_line ;
   OrginalBildPuffer = Orginal[t].data ;
   Bloecke_in_Segmente();
   PutString(NText,TEXT2);
   FindeZeilen() ;
   PutString(NText,TEXT3);
   VerschmelzeBitBloeckeInZeile();
   PutString(NText,TEXT4);
   VergleicheAufSymetrieUndWsa(); 
   BerechneAbstaende(t); 
   PutString(NText,TEXT5);
   LoescheAlleBloecke(t);
 {
   struct Objekt *PErsatz,*PErsatz1,*PErsatz2;

   PErsatz=ObjektListe;
   PErsatz1=Wort->Bruder;
   PErsatz2=Notice->Bruder;
   Wort->Bruder=Notice;
   Notice->Bruder=NULL;
   ObjektListe=Wort;

   BerechneFensterCliping(ObjektListe);
   CheckRepaintArea(0,0,1000,1000);

   WoerterbuchUndSemantikCheck();


  ObjektListe=PErsatz;
  Wort->Bruder=PErsatz1;
  Notice->Bruder=PErsatz2;
  BerechneFensterCliping(ObjektListe);
  CheckRepaintArea(0,0,1000,1000);

 }

   SetObjektSichtbar(Notice,FALSCH);
   SetWindow(ZielBilder[t]);
   BildKlick();
  }
 }
}

void SegmentStart()
{
 long t; 
 for (t=0;t<10;t++)
 {
  if (ObjektListe==ZielBilder[t])
  {
   PutString(NText,TEXT7);
   SetWindow(Notice);
   SetObjektSichtbar(Notice,WAHR);
   SegmentBitBlockListeStartPtr=SegmenteStart[t];
   BitBlockListeStartPtr=BlockListeStart[t];
   Page_x= Orginal[t].width;
   Page_y= Orginal[t].height;
   Page_Bytes_pro_Zeile = Orginal[t].bytes_per_line ;
   OrginalBildPuffer = Orginal[t].data ;
   Finde_SegmentBloecke();
   SegmenteStart[t]=SegmentBitBlockListeStartPtr;
   SetObjektSichtbar(Notice,FALSCH);
   SetWindow(ZielBilder[t]);
   BildKlick();
  }
 }
}

void Ocr_SegmentStart()
{
 SegmentStart(); 
 OcrStart();
}

void Zoom5()  { Zoom(5); }
void Zoom10()  { Zoom(10); }
void Zoom25()  { Zoom(25); }
void Zoom33() { Zoom(33); }
void Zoom50() { Zoom(50); }
void Zoom75() { Zoom(75); }
void Zoom100() { Zoom(100); }

void BildKlick()
{
 long t,x,y,dx,dy,i;
 char Nummern[10];
 struct BitBlockListe *P1;  
 
 for (t=0;t<10;t++) 
 {
 if (ZielBilder[t]->Sichtbar!=0)
 /* if (ObjektListe==ZielBilder[t]) */
  {
  if (Bilder[t].data!=NULL)
  { 
   XSetForeground(display,ZielBild[t]->gc,color_black);
   XSetBackground(display,ZielBild[t]->gc,color_white);
   XPutImage(display,window,ZielBild[t]->gc,&Bilder[t],0,0,ZielBild[t]->Size.X,ZielBild[t]->Size.Y,ZielBild[t]->Size.dx,ZielBild[t]->Size.dy);
   XSetForeground(display,ZielBild[t]->gc,color_blue);
   if (MarkerX[t]>=0)
   { long x,y;
    x=ZielBild[t]->Size.X;
    y=ZielBild[t]->Size.Y;
    XDrawLine(display,window,ZielBild[t]->gc,x+MarkerX[t]-5,y+MarkerY[t]  ,x+MarkerX[t]+5,y+MarkerY[t]  );
    XDrawLine(display,window,ZielBild[t]->gc,x+MarkerX[t]  ,y+MarkerY[t]-5,x+MarkerX[t]  ,y+MarkerY[t]+5);
   }
   i=0;
   
 for (P1=SegmenteStart[t];P1!=NULL;P1=P1->NextSegmentBlockPtr)  
 {  
  if (P1->Geloescht==0)
  {
   i++;
   sprintf(Nummern,"%ld",i);
   x=ZoomX[t]*P1->x+ZielBild[t]->Size.X;
   y=ZoomY[t]*P1->y+ZielBild[t]->Size.Y;
   dx=ZoomX[t]*P1->dx;
   dy=ZoomY[t]*P1->dy;
   XSetForeground(display,ZielBild[t]->gc,color_blue);
   XDrawString(display,window,ZielBild[t]->gc,x,y,Nummern,strlen(Nummern));
   XSetForeground(display,ZielBild[t]->gc,color_red);
   XDrawRectangle(display,window,ZielBild[t]->gc,x,y,dx,dy);
  }
 }
 XFlush(display);

   }
  }
 }


}

void LesePBM(datei,t)
char *datei;
long t;
{
}

void LesePPM(datei,t)
char *datei;
long t;
{
}

void LeseBMP(datei,tw)
char *datei;
long tw;
{
 long max_Bytes;
 char *Ptr,*Ptr1;
 long x,y,dx,dy,t;
 FILE *fd;
 unsigned char Header_Ptr[0x40];
 dx=0; dy=0;
 fd=fopen(datei,"rb"); 
 if (fd==NULL) return;
 fread(&Header_Ptr,  0x36, 1, fd);
 t=leselong(Header_Ptr+0x12);
 dx=t;
 if (t&31) { max_Bytes=(t>>5)*4+4; } else { max_Bytes=(t>>5)*4; }
 dy=leselong(Header_Ptr+0x16); 
 Orginal[tw].width=dx;
 Orginal[tw].height=dy;
 Orginal[tw].bytes_per_line=max_Bytes;
 Ptr=calloc(dy*max_Bytes+1000,1) ; 
 if (Ptr==NULL) return;
 Orginal[tw].data=Ptr;
 if (Ptr==NULL) { MemoryError(); } 
 
 t=leselong(Header_Ptr+0x0A);
 fseek(fd,t,SEEK_SET);
 fread(Ptr,1,dy*max_Bytes,fd);
 Ptr1=Ptr;
 for (t=0;t<dy*max_Bytes;t++) { *Ptr1=~*Ptr1; Ptr1++; } 
 {
  char *P,*P1;
  char z;
  P=Ptr;
  P1=Ptr+(dy-1)*max_Bytes;
  for (y=0;y<(dy>>1);y++)
  {
   for (x=0;x<max_Bytes;x++)
   {
    z=*P;
    *P=*P1;
    *P1=z;
    P++;
    P1++;
   } 
   P1=P1-max_Bytes-max_Bytes;
  } 
 }
 fclose(fd); 

}


void LadeBitmap(Pfad)
char *Pfad;
{
 char Aufruf[200]; 
 long t;

 for (t=0;;t++)
 {
  if (Orginal[t].data==NULL) break;
  if (t==9) return;
 }
 SetObjektSichtbar(ZielBilder[t],WAHR);
 SetWindow(ZielBilder[t]);
 PutString(NText,TEXT8);
 SetWindow(Notice);
 SetObjektSichtbar(Notice,WAHR);

switch(Filter)
{
 case 1: /* LesePBM(Pfad,t); */ break;

 case 9:  sprintf(Aufruf,"giftoppm %s > %s/xocr.tmp",Pfad,GetString(PfadTemp)); 
          system(Aufruf);
          sprintf(Aufruf,"%s/xocr.tmp",GetString(PfadTemp)); 
          LesePPM(Aufruf,t); 
          sprintf(Aufruf,"> %s/xocr.tmp",GetString(PfadTemp)); 
          system(Aufruf); 
          break;

 case 3: sprintf(Aufruf,"xbmtopbm %s > %s/xocr.tmp",Pfad,GetString(PfadTemp)); 
          system(Aufruf);
          sprintf(Aufruf,"%s/xocr.tmp",GetString(PfadTemp)); 
          LesePBM(Aufruf,t); 
          sprintf(Aufruf,"> %s/xocr.tmp",GetString(PfadTemp)); 
          system(Aufruf); 
          break;

 case 4: 
         sprintf(Aufruf,"pgmtopbm %s > %s/xocr.tmp",Pfad,GetString(PfadTemp)); 
          system(Aufruf);
          sprintf(Aufruf,"%s/xocr.tmp",GetString(PfadTemp)); 
          LesePBM(Aufruf,t); 
          sprintf(Aufruf,"> %s/xocr.tmp",GetString(PfadTemp)); 
          system(Aufruf); 
          break;


 case 5: sprintf(Aufruf,"pcxtoppm %s > %s/xocr.tmp",Pfad,GetString(PfadTemp)); 
          system(Aufruf);
          sprintf(Aufruf,"%s/xocr.tmp",GetString(PfadTemp)); 
          LesePPM(Aufruf,t); 
          sprintf(Aufruf,"> %s/xocr.tmp",GetString(PfadTemp)); 
          system(Aufruf); 
          break;

 case 6: sprintf(Aufruf,"imgtoppm %s > %s/xocr.tmp",Pfad,GetString(PfadTemp)); 
          system(Aufruf);
          sprintf(Aufruf,"%s/xocr.tmp",GetString(PfadTemp)); 
          LesePPM(Aufruf,t); 
          sprintf(Aufruf,"> %s/xocr.tmp",GetString(PfadTemp)); 
          system(Aufruf); 
          break;

 case 2: sprintf(Aufruf,"tgatoppm %s > %s/xocr.tmp",Pfad,GetString(PfadTemp)); 
          system(Aufruf);
          sprintf(Aufruf,"%s/xocr.tmp",GetString(PfadTemp)); 
          LesePPM(Aufruf,t); 
          sprintf(Aufruf,"> %s/xocr.tmp",GetString(PfadTemp)); 
          system(Aufruf); 
          break;

 case 0:
          LesePPM(Pfad,t); 
          break;

 case 8:  LeseBMP(Pfad,t); 
          break;

}
 
 PutString(NText,TEXT9);
 BitBlockListeStartPtr=NULL;
 Page_x= Orginal[t].width;
 Page_y= Orginal[t].height;
 Page_Bytes_pro_Zeile = Orginal[t].bytes_per_line ;
 OrginalBildPuffer = Orginal[t].data ;
 Finde_Bloecke();
 BlockListeStart[t]=BitBlockListeStartPtr;
 BitBlockListeStartPtr=NULL;
 PutString(NText,TEXT10);
 SetObjektSichtbar(Notice,FALSCH);
 SetWindow(ZielBilder[t]);
 anpassen();
 
}

void FLernen()
{
 Statu=1;
}

void FAbbruch()
{
 Statu=2;
}

void FWeiter()
{
 Statu=3;
}

void WLernen()
{
 Statu=1;
}

void WAbbruch()
{
 Statu=2;
}

void WWeiter()
{
 Statu=3;
}



void F_PPM()
{
 Filter=0;
 { long t; for (t=1;t<10;t++) MM[t]->Flag=0; MM[9]->Flag=1; }
 PutString(SuchenNach,"*.ppm");
 SetSuchString(Datei,"*.ppm");
 Male_Objekt(SuchenNach); 
}

void F_PBM()
{
 Filter=1;
 { long t; for (t=1;t<10;t++) MM[t]->Flag=0; MM[8]->Flag=1; }
 PutString(SuchenNach,"*.pbm");
 SetSuchString(Datei,"*.pbm");
 Male_Objekt(SuchenNach); 
}

void F_TARGA()
{
 Filter=2;
 { long t; for (t=1;t<10;t++) MM[t]->Flag=0; MM[7]->Flag=1; }
 PutString(SuchenNach,"*.tga");
 SetSuchString(Datei,"*.tga");
 Male_Objekt(SuchenNach); 
}

void F_XBM()
{
 Filter=3;
 { long t; for (t=1;t<10;t++) MM[t]->Flag=0; MM[6]->Flag=1; }
 PutString(SuchenNach,"*.xbm");
 SetSuchString(Datei,"*.xbm");
 Male_Objekt(SuchenNach); 
}

void F_PGM()
{
 PutString(SuchenNach,"*.pgm");
 { long t; for (t=1;t<10;t++) MM[t]->Flag=0; MM[1]->Flag=1; }
 SetSuchString(Datei,"*.pgm");
 Male_Objekt(SuchenNach); 
 Filter=4;
}

void F_PCX()
{
 PutString(SuchenNach,"*.pcx");
 { long t; for (t=1;t<10;t++) MM[t]->Flag=0; MM[4]->Flag=1; }
 SetSuchString(Datei,"*.pcx");
 Male_Objekt(SuchenNach); 
 Filter=5;
}

void F_IMG()
{
 PutString(SuchenNach,"*.img");
 { long t; for (t=1;t<10;t++) MM[t]->Flag=0; MM[2]->Flag=1; }
 SetSuchString(Datei,"*.img");
 Male_Objekt(SuchenNach); 
 Filter=6;
}


void F_BMP()
{
 PutString(SuchenNach,"*.bmp");
 SetSuchString(Datei,"*.bmp");
 Male_Objekt(SuchenNach); 
 { long t; for (t=1;t<10;t++) MM[t]->Flag=0; MM[5]->Flag=1; }
 Filter=8;
}

void F_GIF()
{
 PutString(SuchenNach,"*.gif");
 SetSuchString(Datei,"*.gif");
 { long t; for (t=1;t<10;t++) MM[t]->Flag=0; MM[3]->Flag=1; }
 Male_Objekt(SuchenNach); 
 Filter=9;
}

void DontUseEditorProc()
{
 PutValue(DateiSpeichern,WAHR);
 PutValue(UseEditor,FALSCH);
}

void UseEditorProc()
{
 PutValue(DateiSpeichern,FALSCH);
 PutValue(UseEditor,WAHR);
 
}

void BildK()
{
 long t,x,y,dx,dy;
 struct BitBlockListe *P1,*Ptr;
 P1=NULL;
 Ptr=NULL;
 for (t=0;t<10;t++)
 
 {
  if ((ZielBilder[t]->Sichtbar!=0) && (ObjektListe==ZielBilder[t])) 
  {
  if (Action==3)
  {
   /* erstelle neues Element */
   long x1,y1;
   x1=((1.0/ZoomX[t])*MarkerX[t]);
   y1=((1.0/ZoomY[t])*MarkerY[t]);
   x=(1.0/ZoomX[t])* (LastMouseX-ZielBild[t]->Size.X);
   y=(1.0/ZoomY[t])* (LastMouseY-ZielBild[t]->Size.Y);
   dx=x1-x;
   dy=y1-y;
   if (dx<0) dx=0-dx;
   if (dy<0) dy=0-dy;
   if (x>x1) x=x1;
   if (y>y1) y=y1;
     
   Ptr=calloc(1,sizeof(struct BitBlockListe));    
   if (Ptr==NULL) { MemoryError(); }
   Ptr->Bytes_pro_Zeile=0;
   Ptr->x=x;
   Ptr->y=y;
   Ptr->Startx=x;
   Ptr->Starty=y;
   Ptr->Bild=0;
   Ptr->SegmentNummer=-1;
   Ptr->SpaltenNummer=-1;
   Ptr->XSpiegel=0;
   Ptr->YSpiegel=0;
   Ptr->Untere_Zeile=-1;
   Ptr->Obere_Zeile=-1;
   Ptr->Geloescht=0;
   Ptr->dx=dx;
   Ptr->dy=dy; 
   Ptr->xx=x+dx;
   Ptr->yy=y+dy;       
   Ptr->NextPtrInZeile=NULL;
   Ptr->NextSegmentBlockPtr=NULL;
   Ptr->NextPtrInSegment=NULL;
   Ptr->NextPtr=NULL;
   Ptr->NextSegmentBlockPtr=SegmenteStart[t];
   SegmenteStart[t]=Ptr;
   MarkerX[t]=-10;
   MarkerY[t]=-10;
   Action=0;
   BildKlick();
  }
  if (Action==1)
  {
   x=(1.0/ZoomX[t])* (LastMouseX-ZielBild[t]->Size.X);
   y=(1.0/ZoomY[t])* (LastMouseY-ZielBild[t]->Size.Y);
   for (P1=SegmenteStart[t];P1!=NULL;P1=P1->NextSegmentBlockPtr)
   {
    if ((P1->x<=x) && (P1->y<=y) && ((P1->y+P1->dy)>=y) && ((P1->x+P1->dx)>x))
    {
     P1->Geloescht=1;
    }
   }
   BildKlick();
   Action=0;
  }
  if (Action==2)
  {
   MarkerX[t]=LastMouseX-ZielBild[t]->Size.X;
   MarkerY[t]=LastMouseY-ZielBild[t]->Size.Y;
   BildKlick();
   Action=3; break;
  }
  }
 }
}

void HSliderProc()
{
 
}

void VSliderProc()
{

}

 
void WinInit(argc,argv)
 int  argc;
 char *argv[];
 
{
 long t;
 struct Objekt *Vater,*PtrListe,*Kartei_Sohn[20],*Menu;
 struct Eingabeliste *P;

 struct Menu_Element *M1,*M3;
 char Leiste[6][100];
  
 InstallWindowsToolkit(TEXT11,0,0,600,640,argc,argv);           /* installiere Toolkit */


 Frage=CreateWindow(SMALLBORDER,TEXT12,80,105,300,172,FALSCH,WAHR,NULL);
 CreateText(Frage,TEXT13            ,100,130,WAHR);
 CreateText(Frage,TEXT14                  ,220,130,WAHR);
 FBild=CreateBild(Frage,100,150,110,80,FALSCH,FALSCH,WAHR,FALSCH,NULL,MaleFBild);
 FZeichen=CreateBild(Frage,220,150,16,16,FALSCH,FALSCH,WAHR,FALSCH,NULL,MaleFrage);
 CreateText(Frage,TEXT15,220,175,WAHR);
 FEingabe=CreateEingabe(Frage,"?",ZEICHEN,"",220,195,140,WAHR,FALSCH,NULL);
 FB1=CreateButton(Frage,TEXT22,100,240 ,80,26,WAHR,FALSCH,FLernen);
 FB2=CreateButton(Frage,TEXT23,190,240,80,26,WAHR,FALSCH,FWeiter);
 FB3=FB2;
  /* CreateButton(Frage,TEXT16,280,240,80,26,WAHR,FALSCH,FAbbruch); */
 FZoom=CreateCheckbox(Frage,TEXT17,265,150,WAHR,FALSCH,FALSCH,FZoomOK);

 Wort=CreateWindow(SMALLBORDER,TEXT18,80,105,300,230,FALSCH,WAHR,NULL);
 CreateText(Wort,TEXT19            ,100,128,WAHR);
 CreateText(Wort,TEXT20            ,100,270,WAHR);
 FLERNEN=CreateButton(Wort,TEXT21,100,300 ,80,26,WAHR,FALSCH,WLernen);
 FWEITER=CreateButton(Wort,TEXT24,190,300,80,26,WAHR,FALSCH,WWeiter);
 /* CreateButton(Wort,TEXT16,280,300,80,26,WAHR,FALSCH,NULL); */
 WListe=CreateListbox(Wort,100,147,245,100,WAHR,WAHR,WAHR,FALSCH,NULL);
 WEingabe=CreateEingabe(Wort,"?",ZEICHEN,"",170,270,190,WAHR,FALSCH,NULL);
 

 Notice=CreateWindow(NOBORDER,"",80 ,80,200,40,FALSCH,WAHR,NULL);
 NText=CreateText   (Notice,"ooo"                  ,100,90,WAHR);

 Copyright=CreateWindow(NOBORDER,TEXT25,80,80,350,350,FALSCH,WAHR,NULL);
 CreateBox(Copyright,"",130,100,260,60,WAHR);

 CreateButton(Copyright ,TEXT26,95,376,320,40,WAHR,FALSCH,CloseCopyrightWindow);
 CreateText   (Copyright,TEXT27                              ,230,115,WAHR);
 CreateText   (Copyright,TEXT28                   ,190,135,WAHR);
 CreateText   (Copyright,TEXT29          ,120,180,WAHR);
 CreateText   (Copyright,TEXT30,120,200,WAHR);
 CreateText   (Copyright,TEXT31               ,120,220,WAHR);
 CreateText   (Copyright,TEXT32                        ,120,245,WAHR);
 CreateText   (Copyright,TEXT33                          ,120,280,WAHR);
 CreateText   (Copyright,TEXT34                       ,120,300,WAHR);
 CreateText   (Copyright,TEXT35          ,120,320,WAHR);
 CreateText   (Copyright,TEXT36                     ,120,340,WAHR);

 
   
 /** Definiere die Menues **/
 strcpy(Leiste[0],TEXT37);
 strcpy(Leiste[1],TEXT38);
 strcpy(Leiste[2],TEXT39);
 strcpy(Leiste[3],TEXT40);
 strcpy(Leiste[4],TEXT41);    
 Menu=CreateMenu(NULL,Leiste[0],6);
 CreateMenuEintrag(Menu,NULL,NULL,0,1,WAHR,TEXT42,EINTRAG,FALSCH,Ende);
 CreateMenuEintrag(Menu,NULL,NULL,0,1,WAHR,"",STRICH,FALSCH,NULL);
 CreateMenuEintrag(Menu,NULL,NULL,0,1,WAHR,TEXT43,EINTRAG,FALSCH,SchliesseDatei);
 CreateMenuEintrag(Menu,NULL,NULL,0,1,WAHR,TEXT44,EINTRAG,FALSCH,OeffneDatei);
 CreateMenuEintrag(Menu,NULL,NULL,0,1,WAHR,"",STRICH,FALSCH,NULL);
 CreateMenuEintrag(Menu,NULL,NULL,0,1,FALSCH,TEXT45,EINTRAG,WAHR,Info);
 M1=CreateMenuEintrag(Menu,NULL,NULL,1,1,WAHR,TEXT46,EINTRAG,FALSCH,NULL);
 M3=CreateMenuEintrag(Menu,NULL,NULL,1,1,WAHR,TEXT47,EINTRAG,FALSCH,NULL);
 CreateMenuEintrag(Menu,NULL,NULL,1,1,WAHR,"",STRICH,FALSCH,NULL);
 CreateMenuEintrag(Menu,NULL,NULL,1,1,WAHR,TEXT48,EINTRAG,WAHR,NULL);
 CreateMenuEintrag(Menu,NULL,NULL,1,1,WAHR,TEXT49,EINTRAG,WAHR,NULL);
 CreateMenuEintrag(NULL,M1,NULL,1,1,FALSCH,TEXT50,EINTRAG,FALSCH,Seg_insert);
 CreateMenuEintrag(NULL,M1,NULL,1,1,FALSCH,TEXT51,EINTRAG,FALSCH,Seg_kill_one);
 CreateMenuEintrag(NULL,M1,NULL,1,1,FALSCH,TEXT52,EINTRAG,FALSCH,Seg_kill);
 CreateMenuEintrag(NULL,M1,NULL,1,1,FALSCH,TEXT53,EINTRAG,FALSCH,Seg_start);
 CreateMenuEintrag(NULL,M3,NULL,1,1,FALSCH,TEXT54,EINTRAG,FALSCH,YSpiegel);
 CreateMenuEintrag(NULL,M3,NULL,1,1,FALSCH,TEXT55,EINTRAG,FALSCH,XSpiegel);
 CreateMenuEintrag(NULL,M3,NULL,1,1,FALSCH,TEXT56,EINTRAG,FALSCH,anpassen);
 CreateMenuEintrag(NULL,M3,NULL,1,1,FALSCH,TEXT57,EINTRAG,FALSCH,invert);
 M1=CreateMenuEintrag(NULL,M3,NULL,1,1,FALSCH,TEXT58,EINTRAG,FALSCH,NULL);
 CreateMenuEintrag(NULL,M1,NULL,1,1,FALSCH,"100 %",EINTRAG,FALSCH,Zoom100);
 CreateMenuEintrag(NULL,M1,NULL,1,1,FALSCH,"75 %",EINTRAG,FALSCH,Zoom75);
 CreateMenuEintrag(NULL,M1,NULL,1,1,FALSCH,"50 %",EINTRAG,FALSCH,Zoom50);
 CreateMenuEintrag(NULL,M1,NULL,1,1,FALSCH,"33 %",EINTRAG,FALSCH,Zoom33);
 CreateMenuEintrag(NULL,M1,NULL,1,1,FALSCH,"25 %",EINTRAG,FALSCH,Zoom25);
 CreateMenuEintrag(NULL,M1,NULL,1,1,FALSCH,"10 %",EINTRAG,FALSCH,Zoom10);
 CreateMenuEintrag(NULL,M1,NULL,1,1,FALSCH,"5 %",EINTRAG,FALSCH,Zoom5);
 CreateMenuEintrag(Menu,NULL,NULL,3,1,WAHR,TEXT59,EINTRAG,FALSCH,ShowParameterWindow);
 CreateMenuEintrag(Menu,NULL,NULL,2,1,WAHR,TEXT60,EINTRAG,FALSCH,OcrStart);
 CreateMenuEintrag(Menu,NULL,NULL,2,1,WAHR,TEXT61,EINTRAG,FALSCH,SegmentStart);
 CreateMenuEintrag(Menu,NULL,NULL,2,1,WAHR,"",STRICH,FALSCH,NULL);
 CreateMenuEintrag(Menu,NULL,NULL,2,1,WAHR,TEXT62,EINTRAG,FALSCH,Ocr_SegmentStart);
 CreateMenuEintrag(Menu,NULL,NULL,4,1,WAHR,TEXT63,EINTRAG,WAHR,NULL);
 CreateMenuEintrag(Menu,NULL,NULL,4,1,WAHR,TEXT64,EINTRAG,WAHR,NULL);
 CreateMenuEintrag(Menu,NULL,NULL,4,1,WAHR,TEXT65,EINTRAG,WAHR,NULL);
 CreateMenuEintrag(Menu,NULL,NULL,4,1,WAHR,TEXT66,EINTRAG,WAHR,NULL); 
 CreateMenuEintrag(Menu,NULL,NULL,4,1,WAHR,"",STRICH,FALSCH,NULL);
 CreateMenuEintrag(Menu,NULL,NULL,4,1,WAHR,TEXT67,EINTRAG,FALSCH,ShowCopyrightWindow);
 /** Definiere das Parameter-Window **/       

 OeffneFileWindow=CreateWindow(SMALLBORDER,TEXT68,80,50,400,300,FALSCH,FALSCH,NULL);
 Datei=CreateDateiListbox(OeffneFileWindow,100,120,140,140,WAHR,WAHR,WAHR,FALSCH,NULL);
 Ordner=CreateOrdnerListbox(OeffneFileWindow,260,120,185,140,WAHR,WAHR,WAHR,FALSCH,KlickAufOrdner);

 CreateButton (OeffneFileWindow,TEXT69          ,90,320,120,23,WAHR,FALSCH,CloseOeffneFileWindow);
 CreateButton (OeffneFileWindow,TEXT70     ,350,320,120,23,WAHR,FALSCH,HideOeffneFileWindow);
 CreateText   (OeffneFileWindow,TEXT71      ,260,100,WAHR);
 CreateText   (OeffneFileWindow,TEXT72     ,100,100,WAHR);
 CreateText   (OeffneFileWindow,TEXT73 ,100,280,WAHR);

 SuchenNach=CreateEingabe(OeffneFileWindow,"*.bmp",ZEICHEN,"",160,280,300,WAHR,WAHR,KlickAufSuchen);
 Vater=CreateButton(OeffneFileWindow,TEXT74          ,220,320,120,23,WAHR,FALSCH,NULL); 
 SetSuchString(Datei,"*.bmp");

 MM[1]=CreateMenuEintrag(NULL,NULL,Vater,1,1,FALSCH,"PGM",EINTRAG_FLAG,WAHR,F_PGM);
 MM[2]=CreateMenuEintrag(NULL,NULL,Vater,1,1,FALSCH,"IMG",EINTRAG_FLAG,WAHR,F_IMG);
 MM[3]=CreateMenuEintrag(NULL,NULL,Vater,1,1,FALSCH,"GIF",EINTRAG_FLAG,WAHR,F_GIF);
 MM[4]=CreateMenuEintrag(NULL,NULL,Vater,1,1,FALSCH,"PCX",EINTRAG_FLAG,WAHR,F_PCX);
 MM[5]=CreateMenuEintrag(NULL,NULL,Vater,1,1,WAHR,"BMP",EINTRAG_FLAG,FALSCH,F_BMP);
 MM[6]=CreateMenuEintrag(NULL,NULL,Vater,1,1,FALSCH,"XBM",EINTRAG_FLAG,WAHR,F_XBM);
 MM[7]=CreateMenuEintrag(NULL,NULL,Vater,1,1,FALSCH,"TARBA",EINTRAG_FLAG,WAHR,F_TARGA);
 MM[8]=CreateMenuEintrag(NULL,NULL,Vater,1,1,FALSCH,"PBM",EINTRAG_FLAG,WAHR,F_PBM);
 MM[9]=CreateMenuEintrag(NULL,NULL,Vater,1,1,FALSCH,"PPM",EINTRAG_FLAG,WAHR,F_PPM);


 Vater=CreateWindow(SMALLBORDER,TEXT75,80,50,400,350,FALSCH,FALSCH,NULL);
 ParameterWindow=Vater;
 CreateButton(Vater,TEXT69         ,90,370,120,23,WAHR,FALSCH,CloseParameterWindow); 
 CreateButton(Vater,TEXT70     ,350,370,120,23,WAHR,FALSCH,HideParameterWindow);

 Kartei=CreateKartei(Vater,&(Kartei_Sohn[0]),100,80,370,280,3,2,WAHR,FALSCH,NULL);

 SetKarteiKarteText(Kartei_Sohn[1],TEXT76);
 SetKarteiKarteText(Kartei_Sohn[0],TEXT77);
 SetKarteiKarteText(Kartei_Sohn[2],TEXT78);
 SetKarteiKarteText(Kartei_Sohn[3],"");
 SetKarteiKarteText(Kartei_Sohn[4],"");
 SetKarteiKarteText(Kartei_Sohn[5],"");



 UseEditor=CreateCheckbox(Kartei_Sohn[2],TEXT79,120,146,FALSCH,FALSCH,WAHR,UseEditorProc);
 CreateText(Kartei_Sohn[2],TEXT80,140,170,FALSCH);
 EditorName=CreateEingabe(Kartei_Sohn[2],"textedit ",ZEICHEN,"",210,170,180,FALSCH,WAHR,NULL);
 DateiSpeichern=CreateCheckbox(Kartei_Sohn[2],TEXT81,120,235,FALSCH,FALSCH,FALSCH,DontUseEditorProc);
 Nachfragen=CreateCheckbox(Kartei_Sohn[2],TEXT82,140,263,FALSCH,FALSCH,FALSCH,NULL);
 CreateText(Kartei_Sohn[2],TEXT83,140,285,FALSCH);
 Dateiname=CreateEingabe(Kartei_Sohn[2],TEXT84,ZEICHEN,"",210,285,180,FALSCH,WAHR,NULL);
 PtrListe=CreateEingabeListe(Kartei_Sohn[3],"D",530,570,200,110,FALSCH,FALSCH,NULL);
 P=(struct Eingabeliste *)PtrListe->Pointer;

 Woerterbuch=PtrListe;
 AddListElement(P->ListePtr,"D");
 AddListElement(P->ListePtr,"U");
 CreateText(Kartei_Sohn[1]   ,TEXT85             ,120,290,FALSCH);

 Alle=CreateCheckbox(Kartei_Sohn[3],"A",530,510,FALSCH,FALSCH,FALSCH,NULL);
 CreateText(Kartei_Sohn[1]   ,"Temp"           ,120,150,FALSCH);
 PfadTemp=CreateEingabe(Kartei_Sohn[1],"",ZEICHEN,"",220,150,200,FALSCH,WAHR,NULL);
 CreateText(Kartei_Sohn[1]   ,TEXT86      ,120,195,FALSCH);
 PfadOcr=CreateEingabe(Kartei_Sohn[1],"",ZEICHEN,"",220,195,200,FALSCH,WAHR,NULL);
 CreateText(Kartei_Sohn[1]   ,TEXT87,120,240,FALSCH);
 PfadZiel=CreateEingabe(Kartei_Sohn[1],"",ZEICHEN,"",220,240,200,FALSCH,WAHR,NULL);


 Trigram=CreateCheckbox(Kartei_Sohn[0],TEXT88       ,120,150,FALSCH,FALSCH,WAHR,NULL);
 Semantik=CreateCheckbox(Kartei_Sohn[0],TEXT89          ,120,180,FALSCH,FALSCH,WAHR,NULL);
 Deutsch=CreateCheckbox(Kartei_Sohn[0],TEXT90 ,120,210,FALSCH,FALSCH,WAHR,NULL);
 Englisch=CreateCheckbox(Kartei_Sohn[0],TEXT91,120,240,FALSCH,FALSCH,FALSCH,NULL);
 Faktor=CreateSliderH(Kartei_Sohn[0]  ,230,290,120,0,30,100,FALSCH,WAHR,NULL);     
 CreateText(Kartei_Sohn[0]   ,TEXT92             ,120,290,FALSCH);
 CreateText(Kartei_Sohn[0]   ,TEXT93                  ,360,290,FALSCH);    

 for (t=0;t<10;t++)
 {
  char aha[100];
  sprintf(aha,TEXT94,t);
  ZielBilder[t]=CreateWindow(NORMALBORDER,aha,t*20,20+t*20,420,520,FALSCH,FALSCH,SchliesseDatei);
  ZielBild[t]=CreateBild(ZielBilder[t],t*20+1,40+t*20,416,450,WAHR,FALSCH,FALSCH,FALSCH,BildK,BildKlick);
  Vater=CreateButton(ZielBilder[t],"Zoom"          ,120+t*20,t*20+510,150,23,WAHR,FALSCH,NULL); 
 CreateMenuEintrag(NULL,NULL,Vater,1,1,FALSCH,"100 %",EINTRAG,FALSCH,Zoom100);
 CreateMenuEintrag(NULL,NULL,Vater,1,1,FALSCH,"75 %",EINTRAG,FALSCH,Zoom75);
 CreateMenuEintrag(NULL,NULL,Vater,1,1,FALSCH,"50 %",EINTRAG,FALSCH,Zoom50);
 CreateMenuEintrag(NULL,NULL,Vater,1,1,FALSCH,"33 %",EINTRAG,FALSCH,Zoom33);
 CreateMenuEintrag(NULL,NULL,Vater,1,1,FALSCH,"25 %",EINTRAG,FALSCH,Zoom25);
 CreateMenuEintrag(NULL,NULL,Vater,1,1,FALSCH,"10 %",EINTRAG,FALSCH,Zoom10);
 CreateMenuEintrag(NULL,NULL,Vater,1,1,FALSCH,"5 %",EINTRAG,FALSCH,Zoom5);
 CreateMenuEintrag(NULL,NULL,Vater,1,1,FALSCH,TEXT95,EINTRAG,FALSCH,anpassen);
 SetObjektSichtbar(ZielBilder[t],FALSCH);
}
 SetObjektSichtbar(OeffneFileWindow,FALSCH);
 SetObjektSichtbar(ParameterWindow,FALSCH);
 SetObjektSichtbar(Notice,FALSCH);
 BerechneFensterCliping(ObjektListe);
 LadeParameter();
}


void MainInit()
{
 long t;
 for (t=0;t<10;t++)
 {
   SegmenteStart[t]=NULL;
   BlockListeStart[t]=NULL;
   ZoomX[t]=0.0;
   ZoomY[t]=0.0;
   Bilder[t].width=0;
   Bilder[t].height=0;
   Bilder[t].data=NULL;
   Bilder[t].xoffset=0;
   Bilder[t].format=XYBitmap;
   Bilder[t].byte_order=MSBFirst;
   Bilder[t].bitmap_unit=8;
   Bilder[t].bitmap_bit_order=MSBFirst;
   Bilder[t].bitmap_pad=8;
   Bilder[t].depth=1;
   Bilder[t].bytes_per_line=0;
   Bilder[t].bits_per_pixel=1;
   Bilder[t].obdata=NULL;
   Bilder[t].red_mask=0;
   Bilder[t].blue_mask=0;
   Bilder[t].green_mask=0;
   Orginal[t].width=0;
   Orginal[t].height=0;
   Orginal[t].data=NULL;
   Orginal[t].xoffset=0;
   Orginal[t].format=XYBitmap;
   Orginal[t].byte_order=MSBFirst;
   Orginal[t].bitmap_unit=8;
   Orginal[t].bitmap_bit_order=MSBFirst;
   Orginal[t].bitmap_pad=8;
   Orginal[t].depth=1;
   Orginal[t].bytes_per_line=0;
   Orginal[t].bits_per_pixel=1;
   Orginal[t].obdata=NULL;
   Orginal[t].red_mask=0;
   Orginal[t].blue_mask=0;
   Orginal[t].green_mask=0;
   MarkerX[t]=-10;
   MoveX[t]=0;
   MoveY[t]=0;
 }
   Icon.width=16;
   Icon.height=16;
   Icon.data=NULL;
   Icon.xoffset=0;
   Icon.format=XYBitmap;
   Icon.byte_order=MSBFirst;
   Icon.bitmap_unit=8;
   Icon.bitmap_bit_order=MSBFirst;
   Icon.bitmap_pad=8;
   Icon.depth=1;
   Icon.bytes_per_line=2;
   Icon.bits_per_pixel=1;
   Icon.obdata=NULL;
   Icon.red_mask=0;
   Icon.blue_mask=0;
   Icon.green_mask=0;
}





/***************************************************************
Procedure        : void main()
   
               
****************************************************************/

int main (argc,argv)
 int  argc;        
 char *argv[];
{
 if (argc!=2)
 { 
  printf(TEXT96); 
  printf(TEXT100,argv[0]);
  exit(-1);
 }
 makeBaum(argv[1]);
 arg1=argv[1];
 MainInit(); 
 OcrInit(); 
 WinInit(argc,argv); 
 ShowCopyrightWindow();
 TakeControl();
 /* will never reached ! */
 return(0);
 }
