' $! File: Build_Frontport_Source_Kit.com  $!N $! This routine builds the directory holding the Frontport Source Kit from the( $! CMS repository that holds the source. $!? $! P1 is the reason for building the kit.  It must be in quotes  $!    and is manditory.  $!) $! P2 is the class name (CMS class name). 0 $!    The default is the highest alphabetically. $!7 $! P3 is the destination directory to build the kit in. + $!    The default is the current directory.  $!@ $! If the CMS library is not set, then this procedure will exit. $! $! 22-Sep-2000	J. Malmberg $!M $!===========================================================================  $!8 $! Copyright 2000, John E. Malmberg, All Rights Reserved $!I $!   This program is free software; you can redistribute it and/or modify I $!   it under the terms of the GNU General Public License as published by F $!   the Free Software Foundation; either version 2 of the License, or( $!   (at your option) any later version. $!D $!   This program is distributed in the hope that it will be useful,C $!   but WITHOUT ANY WARRANTY; without even the implied warranty of B $!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 $!   GNU General Public License for more details.  $!F $!   You should have received a copy of the GNU General Public License@ $!   along with this program; if not, write to the Free Software> $!   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. $!M $!===========================================================================  $! $! $! Initial setup $!-----------------  $ss_normal = 1 $ss_abort = 44 $ss_controly = 1554  $exit_stat = ss_normal& $my_default = f$environment("DEFAULT") $on warning then goto all_exit$ $on control_y then goto do_control_y $pid = f$getjpi("","pid") @ $tempfile = "SYS$SCRATCH:build_frontport_source_kit_''pid'.temp" $! $! $! Make sure a reason was given   $!------------------------------$ $if p1 .eqs. "" then goto no_comment $! $! $! Find out the CMS library. $!--------------------------- " $cms_logical = f$trnlnm("CMS$LIB")) $if cms_logical .eqs. "" then goto no_cms  $! $!1 $! Find out what the release (class) requested is 2 $!------------------------------------------------
 $fflag = 0 $rq_class = p2 $test_class = "" $test_class_comment = ""8 $if f$search(tempfile) .nes. "" then delete 'tempfile';*" $define/user sys$output 'tempfile' $cms show class  $open tf 'tempfile'  $class_loop:& $   read/end=class_loop_end tf line_in/ $   line_in1 = f$edit(line_in, "COMPRESS,TRIM") , $   if line_in .eqs. "" then goto class_loop) $   test_class = f$element(0," ",line_in)  $! $!  Skip the title line  $!----------------------! $   if test_class .eqs. "Classes"  $   then9 $	if f$locate("Classes in CMS Library ", line_in1) .eq. 0  $	then $	    goto class_loop  $	endif 	 $   endif - $   test_class_comment = line_in - test_class ; $   test_class_comment = f$edit(test_class_comment, "TRIM") + $   test_len = f$length(test_class_comment) G $   test_class_comment = f$extract(1, test_len - 2, test_class_comment)  $!  $!  Test for a specific revision! $!-------------------------------  $   if (rq_class .nes. "") $   then, $	test_class_u = f$edit(test_class,"UPCASE") $	tlen = f$length(test_class_u) ( $	tst = f$locate(rq_class, test_class_u) $	if (tst .lt. tlen) $	then $	   fflag = 1 $	   fclass = test_class( $	   fclass_comment = test_class_comment $	endif 	 $   endif  $   goto class_loop  $class_loop_end:	 $close tf 8 $if f$search(tempfile) .nes. "" then delete 'tempfile';* $! $if fflag .eq. 0 $then  $   if rq_class .eqs. "" $   then $	class = test_class$ $	class_comment = test_class_comment $   else $	goto not_exist_class	 $   endif  $else  $   class = fclass" $   class_comment = fclass_comment $endif $!% $if class .eqs. "" then goto no_class  $! $! $!% $! Find out where the destination is. % $!-----------------------------------  $if p3 .eqs. ""  $then  $   dst_path = my_default  $else A $   dst_path = f$parse(p3,,,"DEVICE") + f$parse(p3,,,"DIRECTORY")  $endif; $if f$search("''dst_path'*.*") .nes. "" then goto not_empty  $! $!% $! Fetch the kit from the CMS library & $!------------------------------------$ $myproc = f$environment("PROCEDURE")# $mydev = f$parse(myproc,,,"DEVICE") & $mydir = f$parse(myproc,,,"DIRECTORY") $mypath = mydev + mydir < $@'mypath'fetch_source_kit.com "''p1'" "''p2'" "''dst_path'" $! $! $! $! Build up the ZIP file name  $!---------------------------- $char = f$extract(0, 1, class) $class_len = f$length(class)A $class_ver = f$element(0, ".", f$extract(1, class_len -1, class)) % $class_rel = f$element(1, ".", class) 4 $version_name = "_''char'_''class_ver'_''class_rel'"4 $zip_archive = "FRONTPORT_SOURCE''version_name'.ZIP" $! $! $! ZIP it up
 $!-----------  $set default 'dst_path'  $zip "-V" -9 'zip_archive' *.* $set default 'my_default'  $! $! $! clean up and exit $!------------------ $exit_stat = $status
 $all_exit: $   set noon( $   if f$type(my_default) .eqs. "STRING" $   then $	set default 'my_default'	 $   endif A $   if f$trnlnm("TF", "LNM$PROCESS_TABLE",,"SUPERVISOR") .nes. ""  $   then
 $	close tf	 $   endif & $   if f$type(tempfile) .eqs. "STRING" $   then9 $	if f$search(tempfile) .nes. "" then delete 'tempfile';* 	 $   endif  $   exit $! $! $not_empty: B $   write sys$output "Target directory for building is not empty!" $   exit_stat = ss_abort $   goto all_exit  $! $! $no_comment:; $   write sys$output "No explaination for building the kit"  $   exit_stat = ss_abort $   goto all_exit  $! $no_cms:* $   write sys$output "No CMS library set." $   exit_stat = ss_abort $   goto all_exit  $! $do_control_y:@ $   write sys$output "Control Y pressed.  Kit may be incomplete! $   exit_stat = ss_controly  $   goto all_exit  $!
 $no_class:; $   write sys$output "No classes registered in the library"  $   exit_stat = ss_abort $   goto all_exit  $! $not_exist_class: ; $   write sys$output "The requested class ''p2' not found."  $   cms show class $   exit_stat = ss_abort $   goto all_exit  $! $no_binary_dir: F $   write sys$output "The [.RELEASE] directory for binaries not found"+ $   dir 'cms_path'*.dir/exclude=cms$000.dir  $   exit_stat = ss_abort $   goto all_exit 