/* File: FPORT___SET_USER.C adapted from SETUID.C described below.
**
** This module implements the SETUID functionality needed for SAMBA and other
** programs ported to OpenVMS.
**
** 05-Sep-1999	J. Malmberg
**
******************************************************************************/
/*
   Unix SMB/Netbios implementation.
   Version 1.9.
   Copyright (C) Andrew Tridgell 1994-1997

   This file is part of the port to OpenVMS
   Routines to set user environment
   Copyright (C) Eckart Meyer 1996-1997

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*	setuid.c
 *	V1.1			3-Feb-1997		IfN/Mey
 *
 *	Copyright E. Meyer <meyer@ifn.ing.tu-bs.de>
 *+
 * Setting the UID in VMS involves:
 *
 *	- setting process and job UIC to that value
 *	- setting process username to the corresponding user
 *	- setting user's privileges
 *	- setting user's rights identifiers
 *-
 */
#include <string.h>

#include <ssdef.h>
#include <descrip.h>
#include <prvdef.h>
#include <uaidef.h>

unsigned long sys_set_username(const struct dsc$descriptor_s * usr);

unsigned long sys_set_uic(const unsigned long * uic);

unsigned long SYS$SETPRV
   (unsigned long enbflg,
    const void * prvadr,
    unsigned long prmflg,
    void * prvprv);

#pragma member_alignment save
#pragma nomember_alignment longword
struct itemlst_st {
  short int buffer_length;
  short int item_code;
  char *buffer;
  short int *ret_length;
  };
#pragma member_alignment restore

unsigned long SYS$GETUAI
       (unsigned long nullarg1,
	unsigned long * context,
	const struct dsc$descriptor_s *usrnam,
	const struct itemlst_st * itmlst,
	unsigned long nullarg5,
	unsigned long nullarg6,
	unsigned long nullarg7);

unsigned long SYS$FIND_HELD
       (const unsigned long * holder,
	unsigned long * id,
	unsigned long * attrib,
	unsigned long * context);

unsigned long SYS$GRANTID
       (unsigned long * process_id,
	const struct dsc$descriptor_s * procname,
	unsigned long * id,
	const struct dsc$descriptor_s * name,
	unsigned long * prvatr);

unsigned long SYS$IDTOASC
       (unsigned long id,
	unsigned short * namelen,
	struct dsc$descriptor_s * namebuf,
	unsigned long * resid,
	unsigned long * attrib,
	unsigned long * context);

unsigned long SYS$REVOKID
       (unsigned long * process_id,
	const struct dsc$descriptor_s * procname,
	unsigned long * id,
	const struct dsc$descriptor_s * name,
	unsigned long * prvatr);


static void grant_identifiers(unsigned long uid)
{
unsigned long call_stat;
unsigned long contxt;
unsigned long holder[2];

    call_stat = SS$_NORMAL;
    contxt = 0;
    holder[0] = uid;
    holder[1] = 0;

    do
    {
    unsigned long id[2];

	call_stat = SYS$FIND_HELD(holder, id, &id[1], &contxt);
	if (call_stat == SS$_NORMAL)
	{
	unsigned long call_stat2;

	    call_stat2 = SYS$GRANTID(0, 0, id, 0, 0);
	}

    } while (call_stat == SS$_NORMAL);

}

static void revoke_identifiers(unsigned long uid)
{
unsigned long call_stat;
unsigned long contxt;
unsigned long holder[2];

    call_stat = SS$_NORMAL;
    contxt = 0;
    holder[0] = uid;
    holder[1] = 0;

    do
    {
    unsigned long id[2];

	call_stat = SYS$FIND_HELD(holder, id, &id[1], &contxt);
	if (call_stat == SS$_NORMAL)
	{
	unsigned long call_stat2;

	    call_stat2 = SYS$REVOKID(0, 0, id, 0, 0);
	}

    } while (call_stat == SS$_NORMAL);

}


unsigned long fport___set_user
   (unsigned long old_uid,
    unsigned long uid,
    unsigned long * old_context,
    unsigned long * new_context)
{
int call_stat;
struct dsc$descriptor_s userdesc;
unsigned long login_priv[2];
struct itemlst_st itmlst[2];
char username[33];
unsigned short username_len;

 /* Use const instead of #DEFINE makes symbols available to debugger */
/*------------------------------------------------------------------*/
const unsigned long PRIV_ENABLE = 1;
const unsigned long PRIV_DISABLE = 0;
const unsigned long cmkrnl_priv[2] =
   { PRV$M_CMKRNL | PRV$M_SYSPRV | PRV$M_NETMBX | PRV$M_TMPMBX, 0 };
#ifdef __ALPHA
const unsigned long root_priv[2] =
   { PRV$M_SYSPRV | PRV$M_BYPASS , ((PRV$M_READALL | PRV$M_GRPPRV) >> 32)};
#else
  /* VAX can not do that :-( */
#define PRV_M_READALL 0x8
#define PRV_M_GRPPRV 0x4
const unsigned long root_priv[2] =
   { PRV$M_SYSPRV | PRV$M_BYPASS , PRV_M_READALL | PRV_M_GRPPRV };
#endif

      /* Set new use user name, UIC and privileges.		    */
     /*	- clear all privs and set CMKRNL for setting username/uic. */
    /*------------------------------------------------------------*/
    call_stat = SYS$SETPRV(PRIV_ENABLE, cmkrnl_priv, 0, 0);
    if ((call_stat & SS$_NORMAL) == SS$_NORMAL)
    {
	 /* revoke current user's identifiers and setup new */
	/*-------------------------------------------------*/
	revoke_identifiers(old_uid);
	grant_identifiers(uid);

	 /* Give the new users information */
	/*--------------------------------*/
	userdesc.dsc$w_length = sizeof(username);
	userdesc.dsc$a_pointer = (char *) username;
	userdesc.dsc$b_class = DSC$K_CLASS_S;
	userdesc.dsc$b_dtype = DSC$K_DTYPE_T;

	call_stat = SYS$IDTOASC(uid, &username_len, &userdesc, 0, 0, 0);
	if ((call_stat & SS$_NORMAL) == SS$_NORMAL)
	{
	    userdesc.dsc$w_length = username_len;


	     /* set username/uic - this is kernel mode hacking! */
	    /*-------------------------------------------------*/
	    call_stat = sys_set_username(&userdesc);
	    if ((call_stat & SS$_NORMAL) == SS$_NORMAL)
	    {

		 /* do this after $GRANTID */
		/*------------------------*/
		call_stat = sys_set_uic(&uid);
		if ((call_stat & SS$_NORMAL) == SS$_NORMAL)
		{
		     /* clear privileges required for hacking... */
		    /*------------------------------------------*/
		    call_stat = SYS$SETPRV(PRIV_DISABLE, root_priv, 0, 0);
		    if ((call_stat == SS$_NORMAL) == SS$_NORMAL)
		    {

			itmlst[0].item_code = UAI$_DEF_PRIV;
			itmlst[0].buffer_length = 8;
			itmlst[0].buffer = (char *) login_priv;
			itmlst[0].ret_length = 0;

			itmlst[1].item_code = 0;
			itmlst[1].buffer_length = 0;

			call_stat = SYS$GETUAI
				( 0, 0, &userdesc, itmlst, 0, 0, 0);

			 /* finally set new users privs */
			/*-----------------------------*/
			if ((call_stat & SS$_NORMAL) == SS$_NORMAL)
			{
			    call_stat = SYS$SETPRV
				(PRIV_ENABLE, login_priv, 0, 0);
			}
		    }
		}
	    }
	}
    }

     /* flag to show that we are not using persona services */
    /*-----------------------------------------------------*/
    if (old_context != NULL)
	*old_context = 0;

    if (new_context != NULL)
	*new_context = 0;

    return call_stat;
}
