 /* File: FPORT__CLOSE.C  **M ** This implements a wrapper for the close() routine.  The wrapper implements / ** cleanup for the faking of the fcntl routine.  ** ** 19-Mar-1999	J. Malmberg **O ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/  4  /* Make sure the prototype matches the real code */3 /*-----------------------------------------------*/  #include "frontport.h" #include "frontport_private.h"   #include <stdlib.h>  #include <socket.h>  #include <errno.h>   int fport__close(int filedesc) { 
 int ret_stat;  short int chan;  int filedesc2; struct stat stbuf; int cur_pos; int errno_save;  char filename[FPORT__C_MAXRSS]; ' struct fport___rms_filenos_st rms_info;  char *ret_name;          /* Close the lock stream */      /*------------------------*/     cur_pos = 0;     stbuf.st_size = 0;  )      /* Any unfinished business to do? */ (     /*--------------------------------*/.     fport___get_rms_info(filedesc, &rms_info);  )      /* Finish writing out last buffer */ (     /*--------------------------------*/     if (rms_info.wrtindx != 0)     { * 	fport___flush_write(filedesc, &rms_info);     }        errno_save = errno; "     chan = decc$get_sdc(filedesc);     errno = errno_save;   .     ret_name = getname(filedesc, filename, 1);       filedesc2 = -1;      if (chan == 0)     {      int retval;     F 	 /* Last one to close get's to set EOF, and in SAMBA will be wrong */E 	/*----------------------------------------------------------------*/ ( 	cur_pos = lseek(filedesc, 0, SEEK_END);! 	retval = stat(filename, &stbuf);   , 	 /* Move the EOF marker to real location */+ 	/*--------------------------------------*/  	if (cur_pos < stbuf.st_size)  	{
 	int mode;   	    filedesc2 = open 3 		(filename, O_RDWR, 0, "shr=upd,del,put,get,upi");  	}  0 	fport___close_lock_stream(filedesc, &rms_info);     }             /* Close the file */      /*----------------*/     ret_stat = close(filedesc);        if (filedesc2 >= 0)      { B 	 /* Preserve the new EOF, hope this does not break ftruncate() */A 	/*------------------------------------------------------------*/  	if (cur_pos < stbuf.st_size)  	    close(filedesc2);     }   @      /* ftruncate broken beyond hope, truncate after unlocked */?     /*-------------------------------------------------------*/ E     if ((rms_info.bufptr != 0) && (stbuf.st_size > rms_info.hiwater)) & 	truncate(filename, rms_info.hiwater);  2     rms_info.idcode = FPORT___RMS_FILENOS_VERSION;     rms_info.fab1 = 0;     rms_info.rab1 = 0;     if (rms_info.bufptr != 0)      {  	free((void *)rms_info.bufptr);  	rms_info.bufptr = 0;  	rms_info.offset = 0;      }   .     fport___put_rms_info(filedesc, &rms_info);       return ret_stat; } 