 /* File: FPORT__FCLOSE.C **N ** This implements a wrapper for the fclose() routine.  The wrapper implements/ ** cleanup for the faking of the fcntl routine.  ** ** 19-Mar-1999	J. Malmberg **O ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/  4  /* Make sure the prototype matches the real code */3 /*-----------------------------------------------*/  #include "frontport.h" #include "frontport_private.h"   #include <stdlib.h>  #include <stat.h>  #include <errno.h>  ! int fport__fclose(FILE * fileptr)  { 
 int ret_stat; 
 int filedesc;  short int chan;  int filedesc2; struct stat stbuf; int cur_pos; int errno_save; ' struct fport___rms_filenos_st rms_info;  char *ret_name;  char filename[FPORT__C_MAXRSS];  int retval;          /* Close the lock stream */     /*-----------------------*/      cur_pos = 0;     stbuf.st_size = 0;     filedesc = fileno(fileptr);        errno_save = errno;   I      /* Last one to close get's to set EOF, and in SAMBA will be wrong */ H     /*----------------------------------------------------------------*/+     cur_pos = lseek(filedesc, 0, SEEK_END); .     ret_name = getname(filedesc, filename, 1);$     retval = stat(filename, &stbuf);       filedesc2 = -1;   /      /* Move the EOF marker to real location */ .     /*--------------------------------------*/      if (cur_pos < stbuf.st_size)     { 
     int mode;   B 	filedesc2 = open(filename, O_RDWR, 0, "shr=upd,del,put,get,upi");     }   )      /* Any unfinished business to do? */ (     /*--------------------------------*/.     fport___get_rms_info(filedesc, &rms_info);  )      /* Finish writing out last buffer */ (     /*--------------------------------*/     if (rms_info.wrtindx != 0)     { * 	fport___flush_write(filedesc, &rms_info);     }   3     fport___close_lock_stream(filedesc, &rms_info);           /* Close the file */      /*----------------*/     ret_stat = fclose(fileptr);   E      /* Preserve the new EOF, hope this does not break ftruncate() */ D     /*------------------------------------------------------------*/     if (filedesc2 >= 0)  	close(filedesc2);  @      /* ftruncate broken beyond hope, truncate after unlocked */?     /*-------------------------------------------------------*/ E     if ((rms_info.bufptr != 0) && (stbuf.st_size > rms_info.hiwater)) & 	truncate(filename, rms_info.hiwater);  2     rms_info.idcode = FPORT___RMS_FILENOS_VERSION;     rms_info.fab1 = 0;     rms_info.rab1 = 0;     if (rms_info.bufptr != 0)      {  	free((void *)rms_info.bufptr);  	rms_info.bufptr = 0;  	rms_info.offset = 0;      }   .     fport___put_rms_info(filedesc, &rms_info);       return ret_stat; } 