 /* File: FPORT__FSTAT.C  **G ** This wraps the DECC stat.c to provide extended file name support and  ** utc time support. **F ** It should also optionally set the protection mask according to ACLs7 ** and optionally provide the mangling needed for SAMBA  ** ** 19-Mar-1999	J. Malmberg **O ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/   #ifndef _VMS_V6_SOURCE #define _VMS_V6_SOURCE 1 #endif  4  /* Make sure the prototype matches the real code */3 /*-----------------------------------------------*/  #include "frontport_private.h" #include "frontport.h"  8 int fport__fstat(int file_desc, fport__stat_t * statbuf) { 
 int ret_stat;   $      /* use fstat to get the data */"     /*--------------------------*/4     ret_stat = fstat(file_desc, (stat_t *) statbuf);       if (ret_stat >= 0)     {      unsigned long stat_options;     	 /* Convert the times to utc */ 	/*--------------------------*/ . 	fport___to_utc((time_t *)&statbuf->st_ctime);. 	fport___to_utc((time_t *)&statbuf->st_mtime);/  	fport___to_utc((time_t *)&statbuf->st_atime);   # 	 /* Translate the uid as needed */ " 	/*-----------------------------*/? 	statbuf->st_uid = fport__convert_uid_to_root(statbuf->st_uid);   * 	stat_options = fport__get_stat_options(); 	if (stat_options != 0)  	{ 	char filebuf[FPORT__C_MAXRSS]; 
 	char *fnptr;  	FILE * fileptr;  % 	     /* Get the name for the file */ $ 	    /*---------------------------*/, 	    fnptr = getname(file_desc, filebuf, 1);  E 	     /* As an alternative to the above, use LIB$FID_TO_FILENAME() */ D 	    /*-----------------------------------------------------------*/  & 	     /* Use ACLs for the user bits */% 	    /*----------------------------*/ G 	    if ((stat_options & FPORT__M_STAT_USEACL) == FPORT__M_STAT_USEACL)  	    {( 		statbuf->st_mode = fport__get_acl_mode 			(fnptr, statbuf->st_mode);  	    }  / 	     /* SAMBA has some special requirements */ . 	    /*-------------------------------------*/E 	    if ((stat_options & FPORT__M_STAT_SAMBA) == FPORT__M_STAT_SAMBA)  	    {* 		statbuf->st_mode = fport__get_samba_mode 			(fnptr,statbuf->st_mode); 	    }  * 	     /* Swap the st_ctime and st_rtime */) 	    /*--------------------------------*/ 8 	    if ((stat_options & FPORT__M_STAT_SWAP_CTIME) != 0) 	    { 	    time_t temp_time;    		temp_time = statbuf->st_ctime;( 		statbuf->st_ctime = statbuf->st_mtime;  		statbuf->st_mtime = temp_time; 	    } 	}     }      return(ret_stat);  } 