 /* File: FPORT__GET_ACL_MODE.C **K ** This procedure looks up to see what access that ACLs grant the effective & ** current user to the specified file. **D ** It is assumed that the filename has already been converted to VMS* ** acceptable format, and the file exists. ** ** 28-Mar-1999	J. Malmberg **O ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/   #include "frontport.h" #include "frontport_private.h"   #include <stat.h>  #include <string.h>  #include <chpdef.h>  #include <armdef.h>  #include <acldef.h>  #include <ssdef.h> #include <prvdef.h>    /* #include <lib$routines.h> */  #include <descrip.h>   #pragma member_alignment save # #pragma nomember_alignment longword  struct item_list { 	unsigned short len; 	unsigned short code;  	void *bufadr; 	unsigned short *retlen; };  #pragma member_alignment restore  &  /* protoype for sys$check_access() */% /*---------------------------------*/  unsigned long sys$check_access&        (const unsigned long * objtype,( 	const struct dsc$descriptor_s * objnam,( 	const struct dsc$descriptor_s * usrnam,! 	const struct item_list * itmlst,  	unsigned long * context, ( 	const struct dsc$descriptor_s * clsnam, 	const void * objpro,  	const void * usrpro);   unsigned long SYS$SETPRV    (unsigned long enbflg,      const void * prvadr,     unsigned long prmflg,      void * prvprv);   @ mode_t fport__get_acl_mode(const char * file_spec, mode_t umode) {  unsigned long acc_test; " struct item_list acc_item_list[2];' struct dsc$descriptor_s file_name_desc; & struct dsc$descriptor_s cur_user_desc; unsigned long call_stat; unsigned long objtype; mode_t ret_mode; int len; unsigned long old_priv[2];  G  /* Use const instead of #DEFINE makes symbols available to debugger */ F /*------------------------------------------------------------------*/$ const unsigned long PRIV_ENABLE = 1;% const unsigned long PRIV_DISABLE = 0; 8 const unsigned long root_priv[2] = { PRV$M_SYSPRV  , 0};       ret_mode = umode;      len = strlen(file_spec);     if (len > 0)     {      char * login_name;  * 	 /* Get the current user specification */) 	/*------------------------------------*/ $ 	login_name = fport___getusername();  ( 	 /* Elevate the privilege if you can */' 	/*----------------------------------*/ = 	call_stat = SYS$SETPRV(PRIV_ENABLE, root_priv, 0, old_priv); , 	if ((call_stat & SS$_NORMAL) == SS$_NORMAL) 	{7 	     /* Now look up the access modes, one at a time */ 6 	    /*---------------------------------------------*/ 	    objtype = ACL$C_FILE;  ) 	    acc_item_list[0].code = CHP$_ACCESS; ) 	    acc_item_list[0].bufadr = &acc_test;  	    acc_item_list[0].len = 4;$ 	    acc_item_list[0].retlen = NULL;   	    acc_item_list[1].code = 0;  	    acc_item_list[1].len = 0;  6 	    file_name_desc.dsc$a_pointer = (char *)file_spec;5 	    file_name_desc.dsc$w_length = strlen(file_spec); 0 	    file_name_desc.dsc$b_class = DSC$K_CLASS_S;0 	    file_name_desc.dsc$b_dtype = DSC$K_DTYPE_T;  . 	    cur_user_desc.dsc$a_pointer = login_name;5 	    cur_user_desc.dsc$w_length = strlen(login_name); / 	    cur_user_desc.dsc$b_class = DSC$K_CLASS_S; / 	    cur_user_desc.dsc$b_dtype = DSC$K_DTYPE_T;    	    acc_test = ARM$M_READ; ! 	    call_stat = sys$check_access 
 			(&objtype,  			 &file_name_desc, 			 &cur_user_desc,  			 acc_item_list,	 			 NULL, 	 			 NULL, 	 			 NULL, 
 			 NULL);  0 	    if ((call_stat & SS$_NORMAL) == SS$_NORMAL) 	    { 		ret_mode |= S_IREAD; 	    }	 	    else  	    { 		ret_mode &= ~S_IREAD;  	    }  + 	    acc_test = ARM$M_WRITE & ARM$M_DELETE; ! 	    call_stat = sys$check_access 
 			(&objtype,  			 &file_name_desc, 			 &cur_user_desc,  			 acc_item_list,	 			 NULL, 	 			 NULL, 	 			 NULL, 
 			 NULL);  0 	    if ((call_stat & SS$_NORMAL) == SS$_NORMAL) 	    { 		ret_mode |= S_IWRITE;  	    }	 	    else  	    { 		ret_mode &= ~S_IWRITE; 	    }     	    acc_test = ARM$M_EXECUTE;! 	    call_stat = sys$check_access 
 			(&objtype,  			 &file_name_desc, 			 &cur_user_desc,  			 acc_item_list,	 			 NULL, 	 			 NULL, 	 			 NULL, 
 			 NULL);  0 	    if ((call_stat & SS$_NORMAL) == SS$_NORMAL) 	    { 		ret_mode |= S_IEXEC; 	    }	 	    else  	    { 		ret_mode &= ~S_IEXEC;  	    }   	}  & 	 /* Drop back to the old privilege */% 	/*--------------------------------*/ ' 	if ((old_priv[1] & PRV$M_SYSPRV) != 0)  	{; 	    call_stat = SYS$SETPRV(PRIV_DISABLE, root_priv, 0, 0);  	}     }      return ret_mode; } 