 /* File: FPORT__GETPWNAM.C **I ** This implements the getpwnam() routine differently then the DEC C RTL. H ** Some additional fields are filled in.  This was mainly done to better ** support a port of SAMBA.  ** ** 19-Mar-1999	J. Malmberg **O ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/  4  /* Make sure the prototype matches the real code */3 /*-----------------------------------------------*/  #include "frontport.h" #include "frontport_private.h"   /* #include <pwd.h> */ #include <string.h>   . static struct fport__passwd_st fport___passwd;' static char fport___username[33] = {0}; , static char fport___pw_dir[FPORT__C_MAXRSS];! static char fport___pw_shell[33]; ' static char fport___pw_crypt[17] = {0}; % static char fport___pw_vms_owner[33]; + static long fport___vms_priv[2];	/* Why? */       /* VMS system services */ /*---------------------*/  #include <descrip.h> #include <ssdef.h> #include <uaidef.h>     /* Getuai routine */  /*----------------*/ #ifdef sys$getuai  #undef sys$getuai  #endif   #pragma member_alignment save # #pragma nomember_alignment longword  struct itemlst_st {    short int buffer_length;   short int item_code;   char *buffer;    short int *ret_length;   };  #pragma member_alignment restore   unsigned long SYS$GETUAI        (unsigned long nullarg1,  	unsigned long * context, ' 	const struct dsc$descriptor_s *usrnam, " 	const struct itemlst_st * itmlst, 	unsigned long nullarg5, 	unsigned long nullarg6, 	unsigned long nullarg7);        #define UAI_CNT 15  -  /* Allow a peek at the username structure */ , /*----------------------------------------*/  char * fport___getusername(void) {      return fport___username; }   3  /* allow a quick peek at the password structure */ 2 /*----------------------------------------------*/4 struct fport__passwd_st * fport___getpasswd_st(void) {   B      /* first time only, make sure the structure is initialized */A     /*---------------------------------------------------------*/ !     if (fport___username[0] == 0)      {  	fport___passwd.pw_uid = 0;  	fport___passwd.pw_gid = 0; + 	fport___passwd.pw_name = fport___username;      }      return &fport___passwd;  }     E  /* Get the UAF information for this user in an extended structure */ D /*----------------------------------------------------------------*/@ struct fport__passwd_st * fport__getpwnam(const char * username) {  unsigned long call_stat;& struct itemlst_st itmlst[UAI_CNT + 1]; short retlen[UAI_CNT];  % struct dsc$descriptor_s username_dsc;  int username_len;  char user_dir[66]; char user_dev[33]; char uaf_defcli[32]; char uaf_owner[32]; 
 int temp_len;   2      /* Copy the username to the static storage */1     /*-----------------------------------------*/ ,     strncpy(fport___username, username, 12);      fport___username[12] = '\0';  #     itmlst[0].item_code = UAI$_PWD;       itmlst[0].buffer_length = 8;<     itmlst[0].buffer = (char *)fport___passwd.pw_vms_passwd;&     itmlst[0].ret_length = &retlen[0];  &     itmlst[1].item_code = UAI$_DEFDIR;!     itmlst[1].buffer_length = 64;       itmlst[1].buffer = user_dir;&     itmlst[1].ret_length = &retlen[1];  &     itmlst[2].item_code = UAI$_DEFDEV;!     itmlst[2].buffer_length = 64;       itmlst[2].buffer = user_dev;&     itmlst[2].ret_length = &retlen[2];  #     itmlst[3].item_code = UAI$_UIC;       itmlst[3].buffer_length = 4;7     itmlst[3].buffer = (char *) &fport___passwd.pw_uid; &     itmlst[3].ret_length = &retlen[3];  $     itmlst[4].item_code = UAI$_PRIV;      itmlst[4].buffer_length = 8;5     itmlst[4].buffer = (char *) &fport___vms_priv[0]; &     itmlst[4].ret_length = &retlen[4];  H  /* 07-Jun-1998	J. Malmberg	Additional items needed for Password Test */K /*-----------------------------------------------------------------------*/ '     itmlst[5].item_code = UAI$_ENCRYPT;       itmlst[5].buffer_length = 1;?     itmlst[5].buffer = (char *) &fport___passwd.pw_vms_encrypt; &     itmlst[5].ret_length = &retlen[5];  $     itmlst[6].item_code = UAI$_SALT;      itmlst[6].buffer_length = 2;<     itmlst[6].buffer = (char *) &fport___passwd.pw_vms_salt;&     itmlst[6].ret_length = &retlen[6];  ?  /* 08-Jun-1998	J. Malmberg	Need flags, Network, account exp */ B /*--------------------------------------------------------------*/*     itmlst[7].item_code = UAI$_EXPIRATION;      itmlst[7].buffer_length = 8;@     itmlst[7].buffer = (char *)&fport___passwd.pw_vms_expire[0];&     itmlst[7].ret_length = &retlen[7];  %     itmlst[8].item_code = UAI$_FLAGS;       itmlst[8].buffer_length = 4;<     itmlst[8].buffer = (char *)&fport___passwd.pw_vms_flags;&     itmlst[8].ret_length = &retlen[8];  I  /* 09-Jun-1998	J. Malmberg	Also access permitted times to be complete */ L /*------------------------------------------------------------------------*/0     itmlst[9].item_code = UAI$_NETWORK_ACCESS_P;      itmlst[9].buffer_length = 3;A     itmlst[9].buffer = (char *)&fport___passwd.pw_vms_net_pri[0]; &     itmlst[9].ret_length = &retlen[9];  1     itmlst[10].item_code = UAI$_NETWORK_ACCESS_S; !     itmlst[10].buffer_length = 3; B     itmlst[10].buffer = (char *)&fport___passwd.pw_vms_net_sec[0];(     itmlst[10].ret_length = &retlen[10];  *     itmlst[11].item_code = UAI$_PRIMEDAYS;!     itmlst[11].buffer_length = 4; A     itmlst[11].buffer = (char *)&fport___passwd.pw_vms_primedays; (     itmlst[11].ret_length = &retlen[11];  F  /* 11-Dec-1998	J. Malmberg	Get minimum password length for setting */I /*---------------------------------------------------------------------*/ +     itmlst[12].item_code = UAI$_PWD_LENGTH; !     itmlst[12].buffer_length = 1; ?     itmlst[12].buffer = (char *)&fport___passwd.pw_vms_pwd_len; (     itmlst[12].ret_length = &retlen[12];  '     itmlst[13].item_code = UAI$_DEFCLI; "     itmlst[13].buffer_length = 32;#     itmlst[13].buffer = uaf_defcli; (     itmlst[13].ret_length = &retlen[13];  &     itmlst[14].item_code = UAI$_OWNER;"     itmlst[14].buffer_length = 32;"     itmlst[14].buffer = uaf_owner;(     itmlst[14].ret_length = &retlen[14];      /* End the request list */  /*----------------------*/"     itmlst[UAI_CNT].item_code = 0;&     itmlst[UAI_CNT].buffer_length = 0;  1     username_dsc.dsc$w_length = strlen(username); 2     username_dsc.dsc$a_pointer = (char *)username;-     username_dsc.dsc$b_dtype = DSC$K_DTYPE_T; -     username_dsc.dsc$b_class = DSC$K_CLASS_S;   B     call_stat = SYS$GETUAI( 0, 0, &username_dsc, itmlst, 0, 0, 0);  /     if ((call_stat & SS$_NORMAL) != SS$_NORMAL)      {  	return(NULL);     }      else     {      long fileopts;     int dirlen;   % 	 /* Put the default path together */ $ 	/*-------------------------------*/ 	user_dev[user_dev[0]+1] = 0;  	user_dir[user_dir[0]+1] = 0; & 	strcpy(fport___pw_dir, &user_dev[1]);& 	strcat(fport___pw_dir, &user_dir[1]);  & 	 /* And return it in a UNIX format */% 	/*--------------------------------*/ ' 	fileopts = fport__get_fname_options(); + 	fileopts = fileopts | FPORT__M_FNAME_UNIX; D 	fport__vms_fname_to_unix(fport___pw_dir, fport___pw_dir, fileopts);! 	dirlen = strlen(fport___pw_dir);   % 	 /* SAMBA expects no trailing '/' */ $ 	/*-------------------------------*/" 	fport___pw_dir[dirlen -1] = '\0';     	 /* Set the shell field */  	/*---------------------*/ 	temp_len = uaf_defcli[0]; 	if (temp_len > 0) 	{9 	    strncpy(fport___pw_shell, &uaf_defcli[1], temp_len); ( 	    fport___pw_shell[temp_len + 1] = 0; 	} 	else  	    fport___pw_shell[0] = 0;    	 /* Set the owner field */  	/*---------------------*/ 	temp_len = uaf_owner[0];  	if (temp_len > 0) 	{< 	    strncpy(fport___pw_vms_owner, &uaf_owner[1], temp_len);, 	    fport___pw_vms_owner[temp_len + 1] = 0; 	}! 	    fport___pw_vms_owner[0] = 0;    	 /* Fix the uid */  	/*-------------*/3 	fport___passwd.pw_uid = fport__convert_uid_to_root  					(fport___passwd.pw_uid);    	 /* Fix the gid */  	/*-------------*/E 	fport___passwd.pw_gid = ((fport___passwd.pw_uid &0xFFFF0000) >> 16);      	 /* Fix the structure */  	/*-------------------*/+ 	fport___passwd.pw_name = fport___username; ( 	fport___passwd.pw_dir = fport___pw_dir;, 	fport___passwd.pw_shell = fport___pw_shell;- 	fport___passwd.pw_passwd = fport___pw_crypt; 0 	fport___passwd.pw_gecos = fport___pw_vms_owner;     	sprintf 	       (fport___pw_crypt, 		"%8x%8x", " 		fport___passwd.pw_vms_passwd[0],# 		fport___passwd.pw_vms_passwd[1]);    	return &fport___passwd;     }    } 