 /* File: FPORT__KILL.C **H ** This implements the kill() function for the signal of 0 to return the ** current process ID. **I ** This wrapper function allows this function to work at OpenVMS versions  ** below 7.0 **F ** This code derived from Eckart Meyer's patches to SAMBA for OpenVMS. ** ** 14-DEC-1999	J. Malmberg **O ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/   #include "frontport.h"    /* C routines */  /*------------*/ #include <signal.h>  #include <descrip.h> #include <errno.h>  !  /* System Service Definitions */   /*----------------------------*/ #include <ssdef.h> #include <jpidef.h>    unsigned long lib$getjpi        (const long * item_code,  	unsigned long * process_id,. 	const struct dsc$descriptor_s * process_name, 	void * resultant_value,, 	struct dsc$descriptor_s * resultant_string,$ 	unsigned short * resultant_length);  ! int fport__kill(int pid, int sig)  { 
 int ret_stat;  unsigned long call_stat; unsigned long result;  const long item = JPI$_PID;        if (sig != 0)      {  	ret_stat = kill(pid, sig);      }      else     {  	ret_stat = -1; I 	call_stat = lib$getjpi(&item, (unsigned long *) &pid, 0, &result, 0, 0); , 	if ((call_stat & SS$_NORMAL) == SS$_NORMAL) 	{ 	    ret_stat = 0;   	     /* Clear out errno */  	    /*-----------------*/ 	    errno = 0;  	} 	else  	    errno = ESRCH;      }    return ret_stat; } 