 /* File: FPORT__lseek.C  **F ** This is a wrapper for the lseek() function, so that it would handle+ ** processing a stream file in record mode.  ** ** 06-Mar-2000	J. Malmberg **M ****************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/   #include "frontport.h" #include "frontport_private.h"   #include <rms.h>   #include <unixio.h>  #include <stdlib.h>    #include <devdef.h>   = off_t fport__lseek(int filedesc, off_t offset, int direction)  {  unsigned long stat_options;  off_t ret_stat;  char * cbufptr;   ;      /* Get the stat options, is fcntl() locking active? */ :     /*--------------------------------------------------*/     ret_stat = 0; -     stat_options = fport__get_stat_options(); 7     if ((stat_options & FPORT__M_STAT_FCNTL_LOCK) != 0)      {      unsigned long call_stat;+     struct fport___rms_filenos_st rms_info;      struct FAB *fab1;      struct RAB *rab1;   - 	 /* Get the RMS attributes for the stream */ , 	/*---------------------------------------*/7 	call_stat = fport___get_rms_info(filedesc, &rms_info); $ 	fab1 = (struct FAB *)rms_info.fab1;$ 	rab1 = (struct RAB *)rms_info.rab1;  5 	if ((fab1 != NULL) && (fab1->fab$l_dev & DEV$M_RND))  	{ 	off_t n_offset; 	off_t x_offset;
 	int ret_val;  	stat_t stbuf;         off_t cur_end;  % 	     /* Find physical end of file */ $ 	    /*---------------------------*/' 	    ret_val = fstat(filedesc, &stbuf);  	    if (ret_val < 0)  		stbuf.st_size = 0; 	    cur_end = stbuf.st_size;   < 	     /* Normalize the direction to be from Start of File */; 	    /*--------------------------------------------------*/  	    switch(direction) 	    {, 	    case SEEK_SET:	/* Offset is absolute */ 		n_offset = offset; 		break;  1 	    case SEEK_CUR:	/* Offset is delta current */ & 		n_offset = offset + rms_info.offset; 		break;  - 	    case SEEK_END:	/* Offset is delta eof */ & 		if (rms_info.offset > stbuf.st_size)& 		    stbuf.st_size = rms_info.offset;$ 		n_offset = offset + stbuf.st_size; 	    }  % 	    if (rms_info.offset == n_offset)  	    {! 		 /* Clear out a trivial case */   		/*--------------------------*/ 		ret_stat = offset; 	    }	 	    else  	    { 	    int new_pos;   " 	 	 /* Flush any pending writes */  		/*--------------------------*/ 		if (rms_info.wrtindx != 0) 		{ / 		    fport___flush_write(filedesc, &rms_info);  		}    		rms_info.wrtindx = 0;  		rms_info.readindx = 0; 		rms_info.bufend = 0;  # 		if (fab1->fab$b_rfm == FAB$C_FIX)  		{  		int rec_size;   ! 		    rec_size = fab1->fab$w_mrs;  		    if ((rec_size & 1) == 1) 			rec_size++;  5 		     /* Truncate it to the beginning of a record */ 4 		    /*------------------------------------------*/2 		    x_offset = (n_offset / rec_size) * rec_size;4 		    new_pos = lseek(filedesc, x_offset, SEEK_SET); 		}  		else 		{ 3 		    new_pos = lseek(filedesc, offset, direction);  		}    		if (new_pos >= 0)  		{   		    rms_info.offset = new_pos;  8 		     /* lseek() does not extend STREAM-LF + ctx=rec */7 		    /*---------------------------------------------*/ % 		    if (cur_end > rms_info.hiwater)  			rms_info.hiwater = cur_end;   		    if (new_pos < n_offset)  		    {  		    int r_offset;  		    int delta;   			delta = n_offset - new_pos;! 			if (delta <= FPORT___C_MAXREC)  			{  . 			     /* Do we need to allocate a buffer? */- 			    /*----------------------------------*/ + 			    if ((char *)rms_info.bufptr == NULL)  			    {  % 				if (fab1->fab$b_rfm == FAB$C_FIX)  				{  				int rec_size;  				int num_bufs;   0 				     /* Special case, use a bigger buffer *// 				    /*-----------------------------------*/ # 				    rec_size = fab1->fab$w_mrs;   				    if ((rec_size & 1) == 1) 					rec_size++;   				    if (rec_size != 0)	 				    { , 					num_bufs = FPORT___C_MAXREC / rec_size;, 					rms_info.bufsize = rec_size * num_bufs;	 				    }  				    else	 				    {  					 /* Should not occur! */  					/*-------------------*/) 					rms_info.bufsize = FPORT___C_MAXREC; 	 				    }  				}  				else 				{ + 				    rms_info.bufsize = fab1->fab$w_mrs;  				}  				if (rms_info.bufsize == 0), 				    rms_info.bufsize = FPORT___C_MAXREC;  + 				rms_info.bufptr = (unsigned long)malloc  						    (rms_info.bufsize);  			    }  : 			     /* Store the partial buffer, read before update */9 			    /*----------------------------------------------*/ * 			    cbufptr = (char *) rms_info.bufptr;1 			    r_offset = read(filedesc, cbufptr, delta);    			    if (r_offset >= 0)  			    { 				rms_info.bufend = r_offset; ! 				rms_info.readindx = r_offset;   				rms_info.offset += r_offset; 				new_pos = rms_info.offset; 			    } 			} 		    }  		}  		ret_stat = new_pos;  	    }  ) 	     /* Save the position information */ ( 	    /*-------------------------------*/; 	    call_stat = fport___put_rms_info(filedesc, &rms_info);    	} 	else  	{! 	     /* No special processing */   	    /*-----------------------*/3 	    ret_stat = lseek(filedesc, offset, direction);  	}       }      else     {  	 /* No special processing */  	/*-----------------------*// 	ret_stat = lseek(filedesc, offset, direction);      }        return ret_stat; } 