 /* File: FPORT__RENAME.C **N ** This implements a wrapper for the rename() routine.  The wrapper implements ** extended filename support.  ** ** 19-Mar-1999	J. Malmberg **O ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/    4  /* Make sure the prototype matches the real code */3 /*-----------------------------------------------*/  #include "frontport.h"    /* Standard C library */  /*--------------------*/ #include <unixlib.h> #include <stat.h>  #include <unistd.h>   < int fport__rename(const char *oldname, const char * newname) { ! char vmsoldname[FPORT__C_MAXRSS]; ! char vmsnewname[FPORT__C_MAXRSS]; 
 int ret_stat; 
 int tst_stat;  int tst_stat1;  0      /* Convert the file specification to VMS *//     /*---------------------------------------*/      ret_stat = -1;/     if ((oldname[0] != 0) && (newname[0] != 0))      {      unsigned long options;     unsigned long option1;     int fixprotflag;     int dirflag;     int namlen;      stat_t statbuf;      int xstat;     uid_t my_uid;      gid_t my_gid;      mode_t old_prot;  & 	options = fport__get_fname_options();  - 	 /* Convert the file specification to VMS */ , 	/*---------------------------------------*/C 	tst_stat = fport__unix_fname_to_vms(vmsoldname, oldname, options);    	if (tst_stat < 0) 	{ 	unsigned long option1;   $ 	     /* Try again as a directory */# 	    /*--------------------------*/ 2 	    option1 = options | FPORT__M_FNAME_DIRECTORY;G 	    tst_stat = fport__unix_fname_to_vms(vmsoldname, oldname, option1);   H 	    if ((tst_stat < 0) && ((options & FPORT__M_FNAME_EXTLASTDOT) != 0)) 	    {1 		option1 = options & ~FPORT__M_FNAME_EXTLASTDOT; % 		tst_stat = fport__unix_fname_to_vms $ 					(vmsoldname, oldname, option1); 	    }   	}   	fixprotflag = 0;   - 	 /* Convert the file specification to VMS */ , 	/*---------------------------------------*/D 	tst_stat1 = fport__unix_fname_to_vms(vmsnewname, newname, options);     	if (tst_stat == 2)  	{5 	    fport__vms_dir_to_fname(vmsoldname, vmsoldname);   H 	      /* Now we have a protection issue.  VMS protects directories   */G 	     /*  Against a rename.  This is not expected by ported programs */ F 	    /*-------------------------------------------------------------*/  0 	     /* Get the current owner and protection *// 	    /*--------------------------------------*/ + 	    tst_stat = stat(vmsoldname, &statbuf);     	    my_uid = getuid() & 0xFFFF; 	    my_gid = getgid();    	     /* If it is ours, */ 	    /*----------------*/ . 	    if ((my_uid == (statbuf.st_uid & 0xFFFF))  		&& (my_gid == statbuf.st_gid)) 	    { 		fixprotflag = 1;   		 /* Unprotect it */  		/*--------------*/$ 		old_prot = statbuf.st_mode & 0777;  > 		/* This is something that looks strange, so lets explain it.9 		** OpenVMS has a Delete protection bit in addition to a 9 		** Write protection bit.  You need Delete protection to ; 		** rename a file.  Directories are created with owner not : 		** having delete permission because of a problem in very9 		** early versions of VMS that allowed a directory to be 4 		** deleted that had files in it, causing problems.9 		** Now that can not happen, but the convention remains.  		**= 		** Now the CRTL, when you set the W mode bit, also sets the  		** the D mode bit. 		**= 		** So while it appears that we are not changing the mode of $ 		** the directory, actually we are. 		**> 		** Unfortunately, with out going to native OpenVMS I/O I can< 		** not get the old status of the D mode bit so must jam it- 		** here.  Not perfection, but a compromise.  		*/   		if ((old_prot & 0600) != 0)  		{ ) 		    chmod(vmsoldname, old_prot | 0600);  		}  	    } 	}  + 	ret_stat = rename(vmsoldname, vmsnewname);    	if (fixprotflag != 0) 	{, 	     /* Put the existing protection back */+ 	    /*----------------------------------*/   : 	    /* Actually, we can not do this as we do not know the; 	    ** if the owner had delete permission.  This will need : 	    ** further work if someone decides that it is needed. 	    */  	}       }        return ret_stat; } 