 /* File: FPORT__RMS_LOCK.C **& ** This module implements RMS locking. ** ** 24-Sep-1999	J. Malmberg5 ** 04-Mar-2000	J. Malmberg	Fix potential memory leaks N *****************************************************************************/N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/  4  /* Make sure the prototype matches the real code */3 /*-----------------------------------------------*/  #include "frontport.h" #include "frontport_private.h"    /* C Library */ /*-----------*/  #include <errno.h> #ifndef EOVERFLOW  #define EOVERFLOW EINVAL #endif #include <stdlib.h>  #include <string.h>   %  /* VMS System Service definitions */ $ /*--------------------------------*/ #include <ssdef.h> #include <devdef.h>  #include <lckdef.h>     /* RMS Definitions */ /*-----------------*/  #include <rms.h> #ifdef __GNUC__  #include <rms$routines.h>  #else   $      /* Prototype these correctly */#     /*---------------------------*/  unsigned long SYS$CONNECT         (struct RAB * rab,  	void (*err)(struct RAB *rab), 	void (*suc)(struct RAB *rab));    unsigned long SYS$EXTEND        (struct FAB * fab,  	void (*err)(struct FAB *fab), 	void (*suc)(struct FAB *fab));    unsigned long SYS$FIND        (struct RAB * rab,  	void (*err)(struct RAB *rab), 	void (*suc)(struct RAB *rab));    unsigned long SYS$GET         (struct RAB * rab,  	void (*err)(struct RAB *rab), 	void (*suc)(struct RAB *rab));    unsigned long SYS$OPEN        (struct FAB * fab,  	void (*err)(struct FAB *fab), 	void (*suc)(struct FAB *fab));    unsigned long SYS$RELEASE         (struct RAB * rab,  	void (*err)(struct RAB *rab), 	void (*suc)(struct RAB *rab));    unsigned long SYS$CLOSE         (struct FAB * fab,  	void (*err)(struct FAB *fab), 	void (*suc)(struct FAB *fab));    #endif  / void call_stat_to_errno(unsigned int call_stat)  {      switch (call_stat)     {      case RMS$_DEADLOCK:  	errno = EDEADLK;  	break;      case RMS$_RLK:     case RMS$_WLK: 	errno = EACCES; 	break;      case RMS$_EXENQLM:     case RMS$_DME: 	errno = ENOLCK; 	break;      default: 	errno = EBADF;      }   A      /* Give VMS programs some clue as to what really happened */ @     /*--------------------------------------------------------*/     vaxc$errno = call_stat;  }       /* Lock the record */ /*=================*/  int fport__rms_lock         (int filedesc,  	unsigned long flag, 	struct flock * lock_info) { 
 int ret_stat;  unsigned long call_stat; unsigned long call_stat2;  struct FAB * fab1; struct FAB * fab2; struct RAB * rab2; char buffer[FPORT___C_MAXREC]; unsigned short lock_save[4]; unsigned long rop_flag;  int locked_range;  struct stat stbuf; int restore_flag;  int file_size; int lock_offset; int lock_length; off_t seek_start;  unsigned long rqmode;  unsigned short rab_rfa[4]; char filename[FPORT__C_MAXRSS];  char * ret_name; char * ctx_opt;  off_t cur_pos; int cur_pos_valid; int errno_save; ' struct fport___rms_filenos_st rms_info;        cur_pos_valid = 0;     ctx_opt = "ctx=rec";     filename[0] = 0;     ret_stat = 0;      restore_flag = 0;      file_size = 0;     lock_offset = 0;     lock_length = 0;     rop_flag = 0;      rqmode = LCK$K_NLMODE;     fab1 = NULL;     fab2 = NULL;     rab2 = NULL;  %      /* Sanity check the arguments */ $     /*----------------------------*/     switch (flag)      {      case F_SETLK:      case F_SETLKW:     case F_GETLK:  	switch (lock_info->l_type)  	{ 	case F_RDLCK: 	    rop_flag = RAB$M_REA; 	    rqmode = LCK$K_PRMODE;  	    break;  	case F_WRLCK: 	    rop_flag = 0; 	    rqmode = LCK$K_EXMODE;  	    break;  	case F_UNLCK: 	    break; 	 	default:  	    ret_stat = -1;  	    errno = EINVAL; 	}  # 	 /* Set a lock on these records */ " 	/*-----------------------------*/ 	if (flag == F_SETLK)  	{1 	    rop_flag = rop_flag | RAB$M_ULK | RAB$M_RRL;  	    break;  	}   	 /* Wait for a lock */  	/*-----------------*/ 	if (flag == F_SETLKW) 	{= 	    rop_flag = rop_flag | RAB$M_ULK | RAB$M_WAT | RAB$M_RRL;  	    break;  	}   	 /* Look up the lock */ 	/*------------------*/ ! 	rop_flag = rop_flag | RAB$M_RRL;  	break;        default: 	ret_stat = -1;  	errno = EINVAL; 	break;      }        if (filedesc >= 0)     { & 	 /* Get the fab and rab structures */% 	/*--------------------------------*/ 7 	call_stat = fport___get_rms_info(filedesc, &rms_info); , 	if ((call_stat & SS$_NORMAL) == SS$_NORMAL) 	{( 	    fab1 = (struct FAB *)rms_info.fab1;( 	    fab2 = (struct FAB *)rms_info.fab2;( 	    rab2 = (struct RAB *)rms_info.rab2; 	} 	else  	{ 	    ret_stat = -1;  	    errno = EINVAL; 	}     }      else     {  	ret_stat = -1;  	errno = EINVAL;     }        if (fab1 == NULL)      {  	ret_stat = -1;  	errno = EINVAL;     }   %      /* Some initial sanity checks */ $     /*----------------------------*/     if (ret_stat == 0)     {      int ret_val;     int file_stat;     int lock_from;    < 	 /* Make sure we see the current view of the file system */; 	/*------------------------------------------------------*/  	errno_save = errno;( 	cur_pos = lseek(filedesc, 0, SEEK_CUR); 	cur_pos_valid = 1;   5 	 /* We need the current file size and device name */ 4 	/*-----------------------------------------------*/$ 	ret_stat = fstat(filedesc, &stbuf); 	file_size = 0;  	if (ret_stat >= 0)  	{ 	    file_size = stbuf.st_size;   > 	     /* We need to guess about force record mode or binary */= 	    /*----------------------------------------------------*/ ( 	    if ((stbuf.st_fab_rfm == FAB$C_FIX)& 		 || (stbuf.st_fab_rfm == FAB$C_UDF)) 		ctx_opt = "ctx=bin"; 	}  ' 	 /* Calculate the lock record range */ & 	/*---------------------------------*/ 	lock_from = 0; % 	if (lock_info->l_whence == SEEK_CUR)  	{% 	     /* Find the current position */ $ 	    /*---------------------------*/. 	    lock_from = lseek(filedesc, 0, SEEK_CUR);   	} 	else  	{) 	    if (lock_info->l_whence == SEEK_END)  	    { 		lock_from = file_size; 	    } 	}    ; 	 /* Calculate the locking range in a positive direction */ : 	/*-----------------------------------------------------*/. 	lock_offset = lock_from + lock_info->l_start;   	if (lock_info->l_len < 0) 	{2 	    lock_offset = lock_offset - lock_info->l_len;& 	    lock_length = - lock_info->l_len; 	} 	else  	{ 	    if (lock_info->l_len == 0)  	    {" 		 /* Lock the rest of the file */! 		/*---------------------------*/ ( 		lock_length = file_size - lock_length; 	    }	 	    else ! 		lock_length = lock_info->l_len;  	} 	errno = errno_save;  $ 	 /* lock offset must be positive */# 	/*------------------------------*/ , 	if ((lock_offset < 0) && (lock_length > 0)) 	{ 	    ret_stat = -1;  	    errno = EOVERFLOW;  	}    $     } /* End of valid FAB and RAB */     else     { - 	 /* File descriptor is not valid for this */ , 	/*---------------------------------------*/ 	errno = EBADF;  	ret_stat = -1;      }   "      /* Continue if all is well */!     /*-------------------------*/      if (ret_stat == 0)     {    	 /* Extend file if needed */  	/*-----------------------*/- 	if (file_size < (lock_offset + lock_length))    	{ 	int file_delta;
 	int left; 	int wrt_stat;	 	int fd2; 
 	int end_pos;  	unsigned long new_blks; 	unsigned long old_fab_alq;   / 	    ret_name = getname(filedesc, filename, 1);   7 	     /* this has to be done on it's own record stream! > 	     ** We do not want to disturb the context of the existing9 	     ** primary file stream.  There is no way to save or 5 	     ** restore the context for some types of files.  	     **B 	     ** We also do not have a good way of finding the end of fileD 	     ** on the secondary locking stream and still preserving any ofD 	     ** the existing locks.  The secondary stream can also not lock  	     ** beyond the end of file. 	     */   	    fd2 = open  		       (filename, 
 			O_RDWR, 			0,  			ctx_opt,  			"shr=upd,del,put,get");  ' 	    end_pos = lseek(fd2, 0, SEEK_END);   ) 	     /* Make sure the buffer is clear */ ( 	    /*-------------------------------*/) 	    memset(buffer, 0, FPORT___C_MAXREC);   C 	     /* Calculate how much to extend the file to start of range */ B 	    /*---------------------------------------------------------*/( 	    file_delta = lock_offset - end_pos; 	    left = file_delta;     8 	     /* First extend the file up to the locked range */7 	    /*----------------------------------------------*/  	    while (left > 0)  	    {$ 		if (left > (FPORT___C_MAXREC - 1))" 		    left = FPORT___C_MAXREC - 1;  & 		wrt_stat = write(fd2, buffer, left); 		if (wrt_stat > 0)  		{ ) 		    file_delta = file_delta - wrt_stat;  		    left = file_delta; 		}  		else 		{  		    break; 		}  	    }  B 	     /* Calculate how much to extend the file for locked range */A 	    /*--------------------------------------------------------*/ 6 	    file_delta = lock_offset + lock_length - end_pos; 	    left = file_delta;   $ 	     /* Create record(s) to lock */# 	    /*--------------------------*/  	    while (left > 0)  	    {$ 		if (left > (FPORT___C_MAXREC - 1))" 		    left = FPORT___C_MAXREC - 1;  & 		wrt_stat = write(fd2, buffer, left); 		if (wrt_stat > 0)  		{ ) 		    file_delta = file_delta - wrt_stat;l 		    left = file_delta; 		}i 		else 		{e 		    break; 		}  	    }     	    close(fd2);   	    if (cur_pos_valid == 1)/ 		cur_pos = lseek(filedesc, cur_pos, SEEK_SET);*   	}     }  /* ret_stat was OK */  "      /* Continue if all is well */!     /*-------------------------*/=     if (ret_stat == 0)     {* 	if (fab2 == NULL) 	{ 	int ret_stat2;g    ? 	     /* Create and connect up a 2nd record stream for locks */i> 	    /*-----------------------------------------------------*/ 	    if (filename[0] == 0), 		ret_name = getname(filedesc, filename, 1);   	    if (ret_name != NULL) 	    {& 		 /* Allocate the FAB / RAB blocks */% 		/*-------------------------------*/h$ 		fab2 = malloc(sizeof(struct FAB)); 		if (fab2 != NULL)T 		{t( 		    rab2 = malloc(sizeof(struct RAB)); 		    if (rab2 == NULL)  		    {T 			ret_stat = -1;e 			free(fab2); 		    }b 		}i 		else 		{e 		    ret_stat = -1; 		}o   		 /* Populate the FAB block */  		/*------------------------*/ 		if (ret_stat == 0) 		{t 		    *fab2 = cc$rms_fab;e  ! 		    fab2->fab$l_fna = filename;,) 		    fab2->fab$b_fns = strlen(filename);= 		    fab2->fab$l_dna = 0; 		    fab2->fab$b_dns = 0;0 		    /* fab2->fab$b_fac = FAB$M_DEL | FAB$M_GET, 			  | FAB$M_PUT | FAB$M_UPD | FAB$M_TRN; */( 		    fab2->fab$b_fac = fab2->fab$b_fac; 		    fab2->fab$l_fop = 0; 		    fab2->fab$w_ifi = 0; 		    fab2->fab$l_nam = 0;3 		    fab2->fab$b_shr = FAB$M_SHRDEL | FAB$M_SHRGETI! 			| FAB$M_SHRPUT | FAB$M_SHRUPD;  		    fab2->fab$l_xab = 0;  ' 		    call_stat = SYS$OPEN(fab2, 0, 0);-1 		    if ((call_stat & SS$_NORMAL) == SS$_NORMAL)i 		    {e4 			 /* Make sure this is a block structure device */3 			/*--------------------------------------------*/_* 			if ((fab2->fab$l_dev & DEV$M_RND) == 0) 			{+ 			     /* File does not support locking */-* 			    /*-------------------------------*/ 			    errno = EINVAL; 			    ret_stat = -1;*) 			    call_stat = SYS$CLOSE(fab2, 0, 0);  			    free(fab2); 			    fab2 = NULL;  			} 		    }F
 		    else 		    {r 			free(fab2); 			fab2 = NULL;) 			ret_stat = -1;  			errno = ENOLCK; 		    }  		}(   		if (ret_stat == 0) 		{r 		unsigned long call_stat2;*   		    *rab2 = cc$rms_rab;n 		    rab2->rab$l_fab = fab2;t 		    rab2->rab$w_isi = 0; 		    rab2->rab$l_rop = 0;  * 		    call_stat = SYS$CONNECT(rab2, 0, 0);  1 		    if ((call_stat & SS$_NORMAL) != SS$_NORMAL)c 		    {b$ 			 /* Something failed, clean up */# 			/*----------------------------*/( 			errno = ENOLCK; 			ret_stat = -1; % 			call_stat = SYS$CLOSE(fab2, 0, 0);b 			free(fab2); 			fab2 = NULL;  			free(rab2); 			rab2 = NULL;  		    }r
 		    else 		    { ' 			rms_info.fab2 = (unsigned long)fab2;o' 			rms_info.rab2 = (unsigned long)rab2;t  $ 			call_stat2 = fport___put_rms_info  			       (filedesc, &rms_info);  " 			 /* Establish an RFA context */! 			/*--------------------------*/E 			rab2->rab$b_rac = RAB$C_SEQ;X6 			rab2->rab$l_rop = RAB$M_NLK | RAB$M_NXR | RAB$M_RLK 				| RAB$M_RRL;$ 			call_stat = SYS$FIND(rab2, 0, 0); 		    }m 		}e 	    }& 	}  /* RAB2 was already initialized */       }  /* ret_stat was OK */      !      /* Proceed if all is well */c      /*------------------------*/     if (ret_stat == 0)     { 
     int left;s  " 	 /* Assume at the first Record */! 	/*----------------------------*/k! 	rab_rfa[0] = rab2->rab$w_rfa[0];d! 	rab_rfa[1] = rab2->rab$w_rfa[1];l! 	rab_rfa[2] = rab2->rab$w_rfa[2];t> 	rab_rfa[3] = rab2->rabdef$$_fill_4;  /* Presently not used */ 	rab2->rab$b_rac = RAB$C_RFA;     2 	 /* Position at the start of the locking range */1 	/*--------------------------------------------*/o 	restore_flag = 1;     	rab2->rab$l_ubf = buffer;) 	rab2->rab$l_rop = RAB$M_NXR | RAB$M_RRL;a   	left = lock_offset; 	while (left > 0)r 	{ 	    if (left > 65535) 	    { 		rab2->rab$w_usz = 65535; 	    }	 	    else  	    { 		rab2->rab$w_usz = left;_ 	    }% 	    call_stat = SYS$GET(rab2, 0, 0); 1 	    if (((call_stat & SS$_NORMAL) == SS$_NORMAL)  		|| (call_stat == RMS$_RTB))i 	    {  		left = left - rab2->rab$w_usz; 		rab2->rab$b_rac = RAB$C_SEQ; 	    }	 	    elseK 	    { 		ret_stat = -1; 		errno = EINVAL;; 		break; 	    }6 	} /* file is now positioned at start of lock range */     }-  $      /* Attempt to lock the range */#     /*---------------------------*/S     if (ret_stat == 0)     {i
     int left;>     int check_stat;_   	rab2->rab$b_rac = RAB$C_RFA;; 	locked_range = 0;  3 	 /* If any part of lock fails, must unlock rest */ 2 	/*---------------------------------------------*/# 	lock_save[0] = rab2->rab$w_rfa[0]; # 	lock_save[1] = rab2->rab$w_rfa[1];E# 	lock_save[2] = rab2->rab$w_rfa[2];e& 	lock_save[3] = rab2->rabdef$$_fill_4; 	check_stat = -1;   ( 	rab2->rab$l_rop = rop_flag | RAB$M_NXR;    ' 	 /* If RMS will lock it, then do it */ & 	/*---------------------------------*/ 	left = lock_length; 	while (left > 0)  	{ 	    if (left > 65535) 	    { 		rab2->rab$w_usz = 65535; 	    }	 	    else* 	    { 		rab2->rab$w_usz = left;- 	    }  % 	    call_stat = SYS$GET(rab2, 0, 0);b  = 	     /* Buffer overruns are ok as we just need to lock it */k< 	    /*---------------------------------------------------*/1 	    if (((call_stat & SS$_NORMAL) == SS$_NORMAL)- 		|| (call_stat == RMS$_RTB))_ 	    {% 		 /* Set up for next part of file */l$ 		/*------------------------------*/  		left = left - rab2->rab$w_rsz;  : 		if ((lock_info->l_type == F_UNLCK) || (flag == F_GETLK)) 		{r+ 		    call_stat2 = SYS$RELEASE(rab2, 0, 0);   % 		} /* Special Lock processing end */}   		if (flag == F_GETLK) 		{t( 		    check_stat = fport__check_rms_lock 		       (&stbuf,L 			(unsigned long *)rab2, 
 			rqmode,( 			(unsigned long *) &lock_info->l_pid);   		    if (check_stat != 0) 		    {-	 			break;/ 		    }( 		}t 		rab2->rab$b_rac = RAB$C_SEQ;  ( 	    } /* end of successful operation */	 	    elsek 	    { 		ret_stat = -1;  		call_stat_to_errno(call_stat); 		locked_range = left; 		break; 	    }   	} /* End of lock the range */  " 	 /* Was a blocking lock found? */! 	/*----------------------------*/W 	if (check_stat <= 0)  	{ 	    if (flag == F_GETLK)- 	    { 		lock_info->l_type = F_UNLCK; 	    } 	}  , 	 /* If the lock request failed, clean up */+ 	/*--------------------------------------*/=+ 	if ((ret_stat == -1) && (flag == F_SETLK))  	{
 	int left; 	off_t seek_stat;/  ' 	    rab2->rab$w_rfa[0] = lock_save[0];-' 	    rab2->rab$w_rfa[1] = lock_save[1];f' 	    rab2->rab$w_rfa[2] = lock_save[2];_* 	    rab2->rabdef$$_fill_4 = lock_save[3];! 	    rab2->rab$b_rac = RAB$C_RFA;d& 	    call_stat = SYS$FIND(rab2, 0, 0);   	    left = lock_length;  	    while (left > locked_range) 	    { 		if (left > 65535)  		{n 		    rab2->rab$w_usz = 65535; 		}- 		else 		{/ 		     rab2->rab$w_usz = left; 		} " 		call_stat = SYS$GET(rab2, 0, 0);  . 		if (((call_stat & SS$_NORMAL) == SS$_NORMAL)  		   || (call_stat == RMS$_RTB)) 		{ ) 		     /* Set up for next part of file */e( 		    /*------------------------------*/$ 		    left = left - rab2->rab$w_rsz;+ 		    call_stat2 = SYS$RELEASE(rab2, 0, 0);   " 		    rab2->rab$b_rac = RAB$C_SEQ;  % 		} /* Special Lock processing end */e  ( 	    } /* end of successful operation */   	} /* End of lock the range */       }=  %      /* Clean up for the next time */f$     /*----------------------------*/     if (restore_flag == 1)     {o/ 	 /* Put the record stream back to the start */o. 	/*-----------------------------------------*/! 	rab2->rab$w_rfa[0] = rab_rfa[0]; ! 	rab2->rab$w_rfa[1] = rab_rfa[1]; ! 	rab2->rab$w_rfa[2] = rab_rfa[2];e$ 	rab2->rabdef$$_fill_4 = rab_rfa[3]; 	rab2->rab$b_rac = RAB$C_RFA; " 	call_stat = SYS$FIND(rab2, 0, 0);     }          return ret_stat; }i