 /* File: FPORT__SETUID.C **, ** This will implement the setuid() routine. **, ** EINVAL - An invalid UID has been selected **K ** EPERM - The process does not have the appropriate privileges and the uid 2 **	   does not match the real or saved set-user-id ** ** 19-Mar-1999	J. Malmberg **O ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/  4  /* Make sure the prototype matches the real code */3 /*-----------------------------------------------*/  #include "frontport.h" #include <unistd.h>  #include <errno.h> #include <signal.h>    #include <descrip.h> #include <ssdef.h> #include <rmsdef.h>  #include <prvdef.h>    unsigned long SYS$SETPRV    (unsigned long enbflg,      const void * prvadr,     unsigned long prmflg,      void * prvprv);    #pragma message save" #pragma message disable noparmlist unsigned long LIB$SIG_TO_RET();   # unsigned long LIB$FIND_IMAGE_SYMBOL -    (const struct dsc$descriptor_s * filename, +     const struct dsc$descriptor_s * symbol, &     unsigned long (* * externproc) (),/     const struct dsc$descriptor_s * imagename);  #pragma message restore   ) void LIB$SIGNAL(unsigned long call_stat);    #pragma member_alignment save # #pragma nomember_alignment longword  struct item_list_3 {     unsigned short buflen;     unsigned short item_code;      char * buffer;     unsigned short * retlen; };  #pragma member_alignment restore    " unsigned long fport___old_uid = 0;" unsigned long fport___cur_uid = 0;     unsigned long (*uicproc)        (unsigned long old_uid, 	unsigned long uid,  	unsigned long * old_context, " 	unsigned long * new_context) = 0;    " unsigned long fport___old_priv[2];  .  /* Placeholders for future PERSONA version */- /*-----------------------------------------*/  unsigned long old_context; unsigned long new_context;      #  /* Get and save the current uic */ " /*------------------------------*/+ unsigned long fport___get_current_uic(void)  {  unsigned long temp_uid;  unsigned long temp_gid;   6      /* We need to find out what the current UID is */5     /*---------------------------------------------*/      temp_uid = getuid();     temp_gid = getgid();  A     fport___cur_uid = (temp_uid & 0xFFFF) + (temp_gid * 0x10000);        return fport___cur_uid;  }   #  /* Get or save the original uic */ " /*------------------------------*/, unsigned long fport___get_original_uic(void) {  unsigned long current_uic;        /* Get the current uic */     /*---------------------*/ ,     current_uic = fport___get_current_uic();  9      /* Make sure that the old UID code is initialized */ 8     /*------------------------------------------------*/     if (fport___old_uid == 0)      { # 	fport___old_uid = fport___cur_uid;      }        return fport___old_uid;  }        int fport__setuid(uid_t uid) { 
 int ret_stat;  unsigned long call_stat;  2 $DESCRIPTOR(filename_dsc, "FRONTPORT___SET_USER");, $DESCRIPTOR(symbol_dsc, "FPORT___SET_USER");  G  /* Use const instead of #DEFINE makes symbols available to debugger */ F /*------------------------------------------------------------------*/$ const unsigned long PRIV_ENABLE = 1;% const unsigned long PRIV_DISABLE = 0;  #ifdef __ALPHA" const unsigned long root_priv[2] =K    { PRV$M_SYSPRV | PRV$M_BYPASS , ((PRV$M_READALL | PRV$M_GRPPRV) >> 32)};  #else    /* VAX can not do that :-( */  #define PRV_M_READALL 0x8  #define PRV_M_GRPPRV 0x4" const unsigned long root_priv[2] =B    { PRV$M_SYSPRV | PRV$M_BYPASS , PRV_M_READALL | PRV_M_GRPPRV }; #endifH const unsigned long cmkrnl_priv[2] = { PRV$M_CMKRNL | PRV$M_SYSPRV, 0 };2 const unsigned long sysprv[2] = {PRV$M_SYSPRV, 0}; unsigned long norm_priv[2];  unsigned long curr_uid;  unsigned long base_uid;  unsigned short retlen;    :      /* LIB$FIND_IMAGE_SIGNAL needs a handler sometimes */9     /*-------------------------------------------------*/ J     /* VAXC$ESTABLISH((__vms_handler)LIB$SIG_TO_RET); here let it crash */          /* Convert the root */      /*------------------*/*     uid = fport__convert_root_to_uid(uid);  $      /* This is to change the UID */#     /*---------------------------*/      ret_stat = 0;      call_stat = SS$_NORMAL;   ?      /* Check to see if this routine should even do anything */ >     /*------------------------------------------------------*/)     curr_uid = fport___get_current_uic(); *     base_uid = fport___get_original_uic();     if (uid != curr_uid)     {   # 	 /* A save or restore is needed */ " 	/*-----------------------------*/ 	if (uicproc == 0) 	{ 	unsigned long call_stat1;  . 	     /* Locate the external SETUID routine */- 	    /*------------------------------------*/ & 	    call_stat = LIB$FIND_IMAGE_SYMBOL 			       (&filename_dsc,  				&symbol_dsc,
 				&uicproc,  				0);  	}  5 	 /* Proceed only if an external routine was found */ 4 	/*-----------------------------------------------*/, 	if ((call_stat & SS$_NORMAL) == SS$_NORMAL) 	{ 	    if (uid == base_uid)  	    {  9 		 /* We only care about the file permission bits here */ 8 		/*--------------------------------------------------*/  : 		 /* This is to restore everything to the original UID */9 		/*---------------------------------------------------*/ 8 		call_stat = SYS$SETPRV(PRIV_DISABLE, root_priv, 0, 0);  B 		 /* These errors can not happen under normal programing logic */A 		/*-----------------------------------------------------------*/ - 		if ((call_stat & SS$_NORMAL) != SS$_NORMAL)  		    LIB$SIGNAL(call_stat);  > 		call_stat = SYS$SETPRV(PRIV_ENABLE, fport___old_priv, 0, 0);- 		if ((call_stat & SS$_NORMAL) != SS$_NORMAL)  		    LIB$SIGNAL(call_stat);  ( 		 /* Call the external image routine */' 		/*---------------------------------*/  		call_stat = (*uicproc) 		       (fport___cur_uid, 			uid,  			&old_context, 			&new_context);  	    }	 	    else  	    { 	    unsigned long * prv_ptr;   " 		 /* This is to change the UID */! 		/*---------------------------*/   9 		 /* Validate that the user has sufficient privileges */ 8 		/*--------------------------------------------------*/ 		if (base_uid == curr_uid) ! 		    prv_ptr = fport___old_priv;  		else 		    prv_ptr = 0;  ? 		call_stat = SYS$SETPRV(PRIV_ENABLE, cmkrnl_priv, 0, prv_ptr);   - 		if ((call_stat & SS$_NORMAL) == SS$_NORMAL)  		{ , 		     /* Call the external image routine */+ 		    /*---------------------------------*/  		    call_stat = (*uicproc) 		       (fport___cur_uid, 			uid,  			&old_context, 			&new_context);    		}  	    }   	}   	 /* Error handling */ 	/*----------------*/ , 	if ((call_stat & SS$_NORMAL) != SS$_NORMAL) 	{( 	     /* Check for NOPRIV or NOTFOUND */' 	    /*------------------------------*/ @ 	    if ((call_stat == RMS$_FNF) || (call_stat == SS$_NOSUCHID)) 	    { 	        ret_stat = -1;  		errno = EINVAL;  	    }	 	    else  	    { 		if (call_stat == SS$_NOPRIV) 		{  		    ret_stat = -1; 		    errno = EPERM; 		}  		else 		{ * 		     /* Something is configured wrong */) 		    /*-------------------------------*/  		    LIB$SIGNAL(call_stat); 		}  	    } 	}       }      else     { $ 	 /* No change in UIC, do nothing */# 	/*------------------------------*/  	ret_stat = 0;     }      return ret_stat; } 