 /* File: FPORT__SYSTEM.C **H ** This will implement the system() routine.  The UNIX code for SAMBA isM ** expecting that the child subprocess will be executing in the same original K ** security context of the parent before any setuid() call has taken place.  **M ** On OpenVMS since the setuid() call is not implemented, there is no code to / ** deal with it, or any documentation about it.  **L ** On The Open Group's Single Unix Specification Web pages, the UID that theI ** child inherits in this case is not specified.  It may be considered an # ** implementation specific feature.  **N ** Also when the older SYS_SETUSER routine (pre-SYS$PERSONA), changes the userG ** the READALL privilege seems to be needed or the SPAWN will not work.  **M ** So this wrapper code will restore the UID to the original, do the system() L ** call, and then put the UID back to what it was when the call this routine ** was made. ** ** ** 18-May-2000	J. Malmberg **O ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/  4  /* Make sure the prototype matches the real code */3 /*-----------------------------------------------*/  #include "frontport.h" #include <unistd.h>  #include <processes.h> #include <signal.h>   ' int fport__system(const char * command)  { 
 int ret_stat;  unsigned long curr_uic;  unsigned long orig_uic;   7      /* Are we in SETUID()?  Become the original UID */ 6     /*----------------------------------------------*/)     curr_uic = fport___get_current_uic(); *     orig_uic = fport___get_original_uic();       if (curr_uic != orig_uic)   	fport__setuid((uid_t)orig_uic);       ret_stat = system(command);   +      /* Now restore the SETUID() context */ *     /*----------------------------------*/     if (curr_uic != orig_uic)   	fport__setuid((uid_t)curr_uic);       return ret_stat; } 