7 /* File: FPORT__UTC_SUPPORT.C  Derived from: posixtim.c  **C ** Routines to provide the UTC support for VMS versions before 7.0.  **; ** 27-Mar-1999	J. Malmberg	Restructure for backport library  **7 ** 14-Jul-1996	Eckart Meyer	IfN/Mey		V1.1	Original code  ** **	POSIX time routines.  **6 **	(c) Eckart Meyer, 1995,1996		meyer@ifn.ing.tu-bs.de **+ K ** Here are some routines replacing C RTL routines to implement time zones. H ** Since VMS has local time, all related RTL routines return local time,, ** (gmtime() even returns the NULL pointer). **E ** The following routines replaces the RTL routines and implement the  ** POSIX time scheme.  **B ** NOTE: To obtain timezone information, the logicals in the order ** **	SYS$TIMEZONE_RULE	 **	UCX$TZ  **	TZ  **	POSIX_TZ  **	POSIX$DEFAULT_TZ  **E ** are read until the first of them is found. The translation is then A ** used the same way VMS POSIX uses it. For me (Germany) this is:  **N ** $ DEFINE/SYS/EXE POSIX$DEFAULT_TZ "CET-1:00CET DST,M3.5.0/2:00,M9.5.0/3:00" **I ** This means: The time zone designator is normally CET, -1:00 hours must D ** be added to get UTC time. Daylight saving time has the designatorK ** "CET DST" and begins at the last (5) sunday (0) in march (3) at 2:00 and @ ** ends at the last sunday in september at 3:00 (24 hour times). **B ** For more information see SYS$MANAGER:POSIX$LOCALIZATION.COM andN ** the International Standard ISO/IEC 9945-1:1990 (also IEEE Std 1003.1-1990). **I ** Also see the OpenVMS Guide to System Management for VMS versions after ' ** 7.0, or the TCP/IP management guide.  **H ** Note: This implementation relies on the time_t type to be an integer.A **	 If this will ever change, some of the code must be rewritten.  **N *****************************************************************************/   #ifndef _VMS_V6_SOURCE #define _VMS_V6_SOURCE 1 #endif   #include "frontport_private.h" #include "frontport.h"     #include <stdio.h> #include <time.h>  #include <ctype.h> #include <stdlib.h>  #include <string.h>  #include <sys/stat.h>  #include <utime.h>     #ifndef TRUE #define TRUE 1 #endif  
 #ifndef FALSE  #define FALSE 0  #endif   #pragma member_alignment save # #pragma nomember_alignment longword  struct fport___timezone_st {' 	int tz_minuteswest; /* of Greenwich */ : 	int tz_dsttime;     /* type of dst correction to apply */ };  #pragma member_alignment restore   /*  * static storage   */  static char s_tzname1[15]; static char s_tzname2[15];" static char *s_pdston, *s_pdstoff;  ; static time_t s_dston;			/* stored DST begin/end time... */ 3 static time_t s_dstoff;			/* ...in seconds (UTC) */ D static time_t s_year_begin = 0;		/* time_t value of next new year */ static time_t s_year_end = 0;   = static time_t this_dston;		/* stored DST begin/end time... */ 6 static time_t this_dstoff; 		/* ...in seconds (UTC) */F static time_t this_year_begin = 0;	/* time_t value of next new year */  static time_t this_year_end = 0;   #pragma __extern_model __save & #pragma __extern_model __strict_refdef extern int fport__daylight = 1; ' extern long fport__timezone = 8 * 3600; / extern char * fport__tzname[2] = {"PST","PDT"};   #pragma __extern_model __restore   /*@  * For historical reasons the default is US Pacific (I believe):  */ $ char *dston_default = "M4.1.0/2:00";& char *dstoff_default = "M10.5.0/2:00";       /* ** fport___bintime **P ** convert a time string "[+|-]dd hh:mm:ss" into a time_t value, i.e. in seconds ** **	00:01	-> +00 00:01:00 **	::1	-> +00 00:00:01 **	1 1	-> +01 01:00:00 **	-1	-> -00 01:00:00  **/ 3 static time_t fport___bintime(const char * timestr)  {  int mul = 1; char *p; char *q; char *s;
 int t = 0; int i;
 int sign = 1;   
     i = 0;     s = (char *)timestr;       if (s == NULL) 	return(0);      if (*s == '\0')  	return(0);         /* trim leading blanks */     /*---------------------*/ %     while (*s != '\0'  &&  *s == ' ')  	s++;        if (*s == '+')     {  	s++;      }      if (*s == '-')     {  	s++;  	sign = -1;      }         /* remove blanks */     /*---------------*/ %     while (*s != '\0'  &&  *s == ' ')  	s++;        p = s + strlen(s);         /* trim trainling blanks */     /*-----------------------*/ %     while (p != s  &&  *(p-1) == ' ')  	--p;         /* empty string */      /*--------------*/     if (p == s)  	return(0);         /* time digits loop */      /*------------------*/     while(TRUE)      {   1 	 /* q: preview character in front of this one */ 0 	/*-------------------------------------------*/ 	q = p - 1;     	if ((p == s) || (!isdigit(*q))) 	{0 	    if ((p == s) || (*q == ':') || (*q == ' ')) 	    { 		i = atoi(p); 		t += i * mul;  		if (i < 0 || i > 59) 		    return(0); 		if (mul == 1)  		    mul = 60;  		else 		{  		    if (mul == 60) 			mul = 3600;
 		    else 		    {  			if (mul == 3600)  			    mul = 0;  			else  			    return(0);  		    }  		}  	    }	 	    else  	    { 		return(0); 	    } 	} 	if (p == s) 	    break;  	if (*q == ' ')  	    break;  	--p;      }   '      /* last scanned number is hours */ &     /*------------------------------*/     if (i > 23)  	return(0);         /* "hh" */      /*------*/     if (mul == 60) 	t = t * 3600;        /* "hh:mm" */     /*---------*/      if (mul == 3600) 	t = t * 60;       if (p == s)  	return(sign * t);        /* Now for the days... */     /*---------------------*/         /* trim */      /*------*/'     while ((p != s) && (*(p-1) == ' '))  	 --p;  /     for (; (p != s) && (isdigit(*(p-1))); --p);        i = atoi(p);  )      /* must now be at start of string */ (     /*--------------------------------*/     if (p != s)  	return(0);         /* days */      /*------*/     t += i * 3600 * 24;        return(sign * t);  }      /*& ** Decode the DST begin and end dates. **/ **	Format:	<start>/<time>		(<time> is optional)  **B **	<start>		Is the date when summer time starts. The <start> field$ **			can be in the following format: **$ **			Jn	The Julian day n (1<=n<=365). **			n	The zero-based Julian day n (0<=n<=365)3 **			Mm.n.d	The day d of the week n of the month m,  **				where: **				0<=d<=6; d=0 is Sunday6 **				1<=n<=5; n=5 means the last d day in the month m- **					 n=1 means the first week in which the  **					     d'th day occurs  **				1<=m<=12; m=1 is January **< **	<time>		Describes when, in current local time, the change8 **			to the other time is made. The <time> field has the6 **			same format as the <offset> field except that the **			sign is not allowed.  **/  static int fport___decode_dst         (time_t *dstclock,  	const char *timestr,  	const time_t *clock)  {  char *p; char *s; struct tm tmp; int i;	 time_t t; 	 int jday;  int dstmon;  int dstweek; int dstwday; int dsttime = 0;       s = (char *)timestr;     if (s == NULL) 	return(-1);       p = strchr(s,'/');     if (p != NULL)     {   	dsttime = fport___bintime(p+1);     }   ,     t = (clock == NULL) ? time(&t) : *clock;  "      /* only to obtain the year */!     /*-------------------------*/      tmp = *localtime(&t);   %     if ((*s == 'J') || (isdigit(*s)))      {  	if (*s == 'J')  	{	 	    s++;  	    jday = atoi(s); 	} 	else  	{ 	    jday = atoi(s) + 1; 	} 	tmp.tm_sec = 0; 	tmp.tm_min = 0; 	tmp.tm_hour = 0;  	tmp.tm_mon = 0;   	 /* set the day here */ 	/*------------------*/  	tmp.tm_mday = jday; 	tmp.tm_isdst = 0;, 	*dstclock = mktime(&tmp) + fport__timezone;     }      else     {  	if (*s == 'M')  	{% 	     /* parse the string "Mm.n.d" */ $ 	    /*---------------------------*/	 	    s++; < 	    i = sscanf(s, "%d.%d.%d", &dstmon, &dstweek, &dstwday); 	    if (i != 3)
 		return(-1); ' 	    if ((dstmon < 1) || (dstmon > 12)) 
 		return(-1); ( 	    if ((dstweek < 1) || (dstweek > 5))
 		return(-1); ( 	    if ((dstwday < 0) || (dstwday > 6))
 		return(-1);  	    tmp.tm_sec = dsttime; 	    tmp.tm_min = 0; 	    tmp.tm_hour = 0;  	    tmp.tm_mday = 1;    	     /* months start with 0 */  	    /*---------------------*/ 	    tmp.tm_mon = dstmon - 1;  	    tmp.tm_isdst = 0; 	    if (dstweek == 5) 	    { 		tmp.tm_mday = 0; 		tmp.tm_mon++;  		t = mktime(&tmp);  		i = dstwday - tmp.tm_wday; 		if (i > 0)
 		    i -= 7;  		tmp.tm_mday += i;  	    }	 	    else  	    { 		t = mktime(&tmp);  		i = dstwday - tmp.tm_wday; 		if (i < 0)
 		    i += 7; ' 		tmp.tm_mday += ((dstweek-1) * 7) + i;  	    }0 	    *dstclock = mktime(&tmp) + fport__timezone; 	} 	else  	{ 	    return(-1); 	}     }      return(0); }      /*C  * dst_setup calculates dst times and start/end of year of the year A  * represented by the given clock value. If known values for this @  * year are present, use them (current year and last used year).  */  * Also, tzset() is called if not already done.   */ 2 static void fport___dst_setup(const time_t *clock) { 	 time_t t; 
 struct tm tm;  int i;  &      /* Set up the global variables */%     /*-----------------------------*/ ,     t = (clock == NULL) ? time(&t) : *clock;  O        /* If we have already setup for the year represented by clock value t */ M       /*  we just return (we also return if s_year_end == 1 to prevent	    */ %      /*   infinite loops).						   */ L     /*--------------------------------------------------------------------*/H     if ((s_year_end == 1) || ((t >= s_year_begin) && (t <= s_year_end))) 	return;  @       /* Check if tzset() was called at all in this process.  */?      /*  tzset() also setup the values for the current year. */ >     /*------------------------------------------------------*/     if (this_year_end == 0)      {  	 /* prevent infinite loop */  	/*-----------------------*/ 	this_year_end = 1;   0 	 /* calls fport___dst_setup for current year *// 	/*------------------------------------------*/  	fport__tzset();     }   F       /* Check for current year. If so, just use the stored values. */9      /*  This should speed up the time() function.		   */ D     /*------------------------------------------------------------*/7     if ((t >= this_year_begin) && (t <= this_year_end))      {   	s_year_begin = this_year_begin; 	s_year_end = this_year_end; 	s_dston = this_dston; 	s_dstoff = this_dstoff; 	return;     }r  4      /* Nothing available, we have to do the work.*/3     /*-------------------------------------------*/9         /* prevent infinite loop */     /*-----------------------*/n     s_year_end = 1;r  I       /* Setup the clock values for dst begin and dst end for the year */e5      /*  represented by the clock value t.			      */nG     /*---------------------------------------------------------------*/m3     i = fport___decode_dst(&s_dston, s_pdston, &t);l     if (i < 0)1 	fport___decode_dst(&s_dston, dston_default, &t);S5     i = fport___decode_dst(&s_dstoff, s_pdstoff, &t);m     if (i < 0)3 	fport___decode_dst(&s_dstoff, dstoff_default, &t);   P        /* Setup the clock values for begin and end of the year represented    */O       /*  by the clock value t. This way we can later check if still using a */ N      /*   date in the same year and avoid recalculation of the dst values.  */M     /*---------------------------------------------------------------------*/a        /*  - January, 1st. */b     /*------------------*/     tm = *fport__localtime(&t);t     tm.tm_sec = 0;     tm.tm_min = 0;     tm.tm_hour = 0;c     tm.tm_mday = 1;*     tm.tm_mon = 0;     tm.tm_isdst = -1;0&     s_year_begin = fport__mktime(&tm);        /* - December, 31th. */     /*-------------------*/t     tm.tm_sec = 59;S     tm.tm_min = 59;s     tm.tm_hour = 23;     tm.tm_mday = 31;     tm.tm_mon = 11;s     tm.tm_isdst = -1;v$     s_year_end = fport__mktime(&tm); }a     /*C ** Decide if a clock value (seconds since 1-JAN-1970 UTC) is in the " ** the daylight saving time range. **B ** Note that at the end of DST we will have one hour "twice", e.g.F ** 2:10 DST and one our later 2:10 again normal time. The clock values? ** will be 3600 different of course. SunOS decides that withoutpF ** specifying tm_isdst, 2:10:59 is DST and 2:11:00 is normal, i.e. one6 ** hour later (if the the DST end time is ".../3:00"). **/e static long fport___dst_offset        (const time_t *clock, 	const time_t *dston,R 	const time_t *dstoff) {S long retval; double dtime1; double dtime2;       if (!fport__daylight)e
 	return 0;  &     dtime1 = difftime(*clock, *dston);<     dtime2 = difftime(*clock, (*dstoff) - 3600 + (11 * 60));9     retval = ((dtime1 >= 0) && (dtime2 < 0)) ? -3600 : 0;r       return (retval); }*     /*. ** convert clock value from local time to UTC. */" void fport___to_utc(time_t *clock) {o@     fport___dst_setup(clock);  /* setup timezone and dst info */     *clock += fport__timezone;=     *clock += fport___dst_offset(clock, &s_dston, &s_dstoff);= }	   /*. ** convert clock value from UTC to local time. */$ void fport___from_utc(time_t *clock) {/?     fport___dst_setup(clock); /* setup timezone and dst info *//     clock -= fport__timezone;c<     clock -= fport___dst_offset(clock, &s_dston, &s_dstoff); }      /* ** tzset **I ** Set global variables daylight, timezone and tzname[2] from the logicalc ** TZ or POSIX$DEFAULT_TZ.L ***************************************************************************/   void fport__tzset(void)  {p char *p; char *q; char c;e
 char *ptz; char tbuf[20];  !     fport__tzname[0] = s_tzname1;l!     fport__tzname[1] = s_tzname2;      *s_tzname1 = '\0';     *s_tzname2 = '\0';       p = getenv("TZ");t     if (p == NULL)! 	p = getenv("SYS$TIMEZONE_RULE");:     if (p == NULL) 	p = getenv("UCX$TZ");     if (p == NULL) 	p = getenv("POSIX_TZ");     if (p == NULL)  	p = getenv("POSIX$DEFAULT_TZ");  )     /* printf("Time zone = {%s}\n",p); */r  K       /* parse into the three possible tokens "time zone", "DST begin",  */;.      /*  "DST end", separated by comma.					*/I     /*-----------------------------------------------------------------*/(     ptz = NULL;r     s_pdston = NULL;     s_pdstoff = NULL;-     if (p == NULL) 	return;  
     q = p;     do     {  	c = *p;! 	if ((*p == ',') || (*p == '\0'))  	{ 	     /* terminate string */ 	    /*------------------*/  	    *p = '\0';  	    if (ptz == NULL) 
 		ptz = q;	 	    else  	    { 		if (s_pdston == NULL)  		    s_pdston = q;  		else 		{a 		    if (s_pdstoff == NULL) 			s_pdstoff = q;  		}  	    }
 	    q = p+1;1 	}     } while (p++, c != '\0');        if (s_pdston == NULL)- 	s_pdston = dston_default;     if (s_pdstoff == NULL) 	s_pdstoff = dstoff_default;        /* Parse time zone */     /*-----------------*/h         /* - timezone designator */     /*-----------------------*/-     p = ptz;
     q = p;       for (; isalpha(*p); p++);)       strncpy(s_tzname1,q,p-q);=     s_tzname1[p-q] = '\0';        /* - timezone value */m     /*------------------*/
     q = p;  L     for (; (isdigit(*p)) || (*p == '-') || (*p == '+') || (*p == ':'); p++);       strncpy(tbuf,q,p-q);     tbuf[p-q] = '\0'; ,     fport__timezone = fport___bintime(tbuf);  5      /* - daylight saving time designator and flag */e4     /*--------------------------------------------*/     strcpy(s_tzname2,p);<     fport__daylight = (s_tzname2[0] != '\0') ? TRUE : FALSE;     if (!fport__daylight)- 	return;  <      /* Decode the DST begin and end dates for this year. */;     /*---------------------------------------------------*//  ,      /* prevent recursive call of tzset() */+     /*-----------------------------------*/t     this_year_end = 1;        /* setup for this year */     /*---------------------*/      fport___dst_setup(NULL);     this_dston = s_dston;      this_dstoff = s_dstoff; #     this_year_begin = s_year_begin;      this_year_end = s_year_end;      return;t }g     /*  * localtime  *5  * Adjust the clockvalue from UTC to posix localtime. .  * We have to set the DST flag correctly here.  */ 1 struct tm * fport__localtime(const time_t *clock)d {h struct tm *local; 	 time_t t;  int dstoff;t  &      /* setup timezone and dst info */%     /*-----------------------------*/s     fport___dst_setup(clock);c     t = *clock;o9     dstoff = fport___dst_offset(&t, &s_dston, &s_dstoff);	,     if (difftime(t - dstoff, s_dstoff) >= 0) 	dstoff = 0;     t -= dstoff;     t -= fport__timezone;h     local = localtime(&t);$     local->tm_isdst = (dstoff != 0);     return(local); }m     /*	  * gmtime   *1  * UTC is generated just by system's localtime().r  * UTC has no DST (??).s  */a. struct tm * fport__gmtime(const time_t *clock) {      struct tm *local;t       local = localtime(clock);m     local->tm_isdst = 0;     return(local); }>     /*	  * mktimet  *  * is the inverse of localtime. D  * returns the clock value (seconds since 1-JAN-1970 UTC) and brings(  * the time struct into its normal form.  *H  * In fact, the clock value is corrected according the dst flag and then  * passed to localtime().a  */n# time_t fport__mktime(struct tm *tm)e {;	 time_t t; 
 int isdst; int dstoff;         /* remember the flag */     /*-------------------*/=     isdst = tm->tm_isdst;   5      /* assume system's mktime does not handle DST */ 4     /*--------------------------------------------*/     tm->tm_isdst = 0;      t = mktime(tm);   "      /* must know timezone info */!     /*-------------------------*/s     if (this_year_end == 0)} 	fport__tzset();       t += fport__timezone;p  *      /* now the dst values for the year */)     /*---------------------------------*/h     fport___dst_setup(&t);  9     dstoff = fport___dst_offset(&t, &s_dston, &s_dstoff);m8     tm->tm_isdst = (isdst >= 0) ? isdst : (dstoff != 0);  "      /* make our own correction */!     /*-------------------------*/-     if (tm->tm_isdst)/ 	t += -3600;  %      /* re-make the time structure */d$     /*----------------------------*/      *tm = *fport__localtime(&t);     return(t); })     /*  * ctime  *5  * First call localtime(), then convert via asctime()   */i' char *fport__ctime(const time_t *clock)u {- 	struct tm tm;   	tm = *fport__localtime(clock);  	return(asctime(&tm)); }      /*  * time=  *'  * returns seconds since 1-JAN-1970 UTC   *K  * time() calls tzset() since we must have the timezone and DST information;G  * here. This is different to UNIX systems, where time() simply returns	#  * the system time, which *is* UTC.m  */w! time_t fport__time(time_t *clock)  {m	 time_t t;=       if (this_year_end == 0){ 	fport__tzset();  4      /* system returns from 1-JAN-1970 local time */3     /*-------------------------------------------*/ 
     time(&t);c     t += fport__timezone;_;     t += fport___dst_offset(&t, &this_dston, &this_dstoff);      if (clock != NULL) 	*clock = t;     return(t); }     # void fport__ftime(struct timeb *tb)p {e	 time_t t;        if (this_year_end == 0)u 	fport__tzset();     ftime(tb);     t = tb->time;y      tb->time += fport__timezone;B     tb->time += fport___dst_offset(&t, &this_dston, &this_dstoff);(     tb->timezone = fport__timezone / 60;"     tb->dstflag = fport__daylight; }      /*  * gettimeofdayi  *K  * Note that the tz_dsttime element is not fully supported, we don't return&F  * the DST values from sys/time.h here, only the dstflag from ftime().  */y5 int fport__gettimeofday(struct timeval *tv, void *tz)e {n struct timeb tb;       fport__ftime(&tb);%     if ((tv == NULL) && (tz == NULL))  	return(-1);       if (tv != NULL)-     {- 	tv->tv_sec = tb.time;! 	tv->tv_usec = tb.millitm * 1000;t     }e     if (tz != NULL)y     {)'     struct fport___timezone_st * tzptr;   * 	tzptr = (struct fport___timezone_st *)tz;% 	tzptr->tz_minuteswest = tb.timezone;e  	tzptr->tz_dsttime = tb.dstflag;     }-     return(0); }-