 /* File: FPORT___UTIME.C **D ** This routine implements interal support for the utime() function. ** ** 09-Nov-1999	J. Malmberg **N *****************************************************************************/N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/     #include "frontport.h" #include "frontport_private.h"   #include <utime.h> #include <errno.h>   #include <ssdef.h> #include <rmsdef.h>   *  /* Prototype OpenVMS Routines properly */) /*-------------------------------------*/ ( unsigned long SYS$GETTIM(void * timadr);  - void LIB$SIGNAL(unsigned long statcode, ...);     @ int fport__utime(const char *fname, const struct utimbuf *times) { 	 time_t t;  unsigned long call_stat; char vmsfname[FPORT__C_MAXRSS]; 
 int ret_stat; 
 int tst_stat;  unsigned long vms_modtime[2];   H      /* As VMS does not have an ACCESS time only modtime will be used */G     /*---------------------------------------------------------------*/      ret_stat = -1;  D      /* First check the times structure and convert to VMS format */C     /*-----------------------------------------------------------*/      if (times == NULL)     { % 	call_stat = SYS$GETTIM(vms_modtime);   = 	 /* Only possible error is access violation, so signal it */ < 	/*-------------------------------------------------------*/, 	if ((call_stat & SS$_NORMAL) != SS$_NORMAL) 	    LIB$SIGNAL(call_stat);      }      else     {      time_t utc_modtime;   / 	 /* Convert the time from UTC to local time */ . 	/*-----------------------------------------*/  	fport___from_utc(&utc_modtime);  3 	 /* Convert the time from UNIX time to VMS time */ 2 	/*---------------------------------------------*/5 	fport__unix_time_t_to_vms(vms_modtime, utc_modtime);      }        if (fname == NULL)     {  	errno = ENOENT; 	ret_stat = -1;      }      else     {      unsigned long options;   	 /* convert to VMS filespec */  	/*-------------------------*/& 	options = fport__get_fname_options();? 	tst_stat = fport__unix_fname_to_vms(vmsfname, fname, options);  	if (tst_stat < 0) 	{ 	unsigned long option1;   $ 	     /* Try again as a directory */# 	    /*--------------------------*/ 2 	    option1 = options | FPORT__M_FNAME_DIRECTORY;C 	    tst_stat = fport__unix_fname_to_vms(vmsfname, fname, option1);   H 	    if ((tst_stat < 0) && ((options & FPORT__M_FNAME_EXTLASTDOT) != 0)) 	    {1 		option1 = options & ~FPORT__M_FNAME_EXTLASTDOT; @ 		tst_stat = fport__unix_fname_to_vms(vmsfname, fname, option1); 	    } 	}   	if (tst_stat == 2) 1 	    fport__vms_dir_to_fname(vmsfname, vmsfname);    	 /* Do the work.. */  	/*---------------*/< 	call_stat = fport__set_file_modtime(vmsfname, vms_modtime);   	 /* Deal with errors */ 	/*------------------*/ , 	if ((call_stat & SS$_NORMAL) != SS$_NORMAL) 	{ 	    errno = EACCES; 	    if (call_stat == RMS$_FNF)  		errno = ENOENT;  	    if (call_stat == RMS$_SYN)  		errno = ENOTDIR; 	    ret_stat = -1;  	} 	else  	{ 	    ret_stat = 0; 	}     }      return ret_stat; } 