 /* File: FPORT__VMS_STATVFS.C  **J ** This module implements getting statvfs information from a SYS$GETDVIW() ** routine.  **K ** It is used internally to both the fport__statvfs and the fport__fstatvfs  ** routine.  **H ** It's input is a null terminated VMS format device name and the statfs
 ** structure.  **> ** Based on Eckart Meyer's statfs() routine in the SAMBA port. **@ ** According to X/Open, statfs has been superceeded by statvfs() ** ** 12-Nov-1999	J. Malmberg **O ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/   #include "frontport.h"   #include <string.h>    #pragma member_alignment save # #pragma nomember_alignment longword  struct item_list_3 { 	unsigned short len; 	unsigned short code;  	void * bufadr;  	unsigned short * retadr;  };  #pragma member_alignment restore   #include <dvidef.h>  #ifndef DVI$C_ACP_F11V5  #define DVI$C_ACP_F11V5 (11) #endif   #include <devdef.h>  #include <descrip.h>  (  /* Prototype the OpenVMS definitions */' /*-----------------------------------*/  unsigned long SYS$GETDVIW         (unsigned long efn, 	unsigned short chan, ( 	const struct dsc$descriptor_s * devnam,# 	const struct item_list_3 * itmlst, 
 	void * iosb,   	void * (astadr)(unsigned long), 	unsigned long astprm, 	void * nullarg);   F unsigned long fport__vms_statvfs(char * devname, struct statvfs * buf) {  unsigned long call_stat; struct item_list_3 dvi_item[7]; $ struct dsc$descriptor_s devname_dsc; unsigned short f_bsize_len;  unsigned short f_blocks_len; unsigned short f_bfree_len;  unsigned short f_files_len;  unsigned long devchar; unsigned short devchar_len;  unsigned long acptype; unsigned short acptype_len;  unsigned short iosb[4];   (     devname_dsc.dsc$a_pointer = devname;/     devname_dsc.dsc$w_length = strlen(devname); ,     devname_dsc.dsc$b_dtype = DSC$K_DTYPE_T;,     devname_dsc.dsc$b_class = DSC$K_CLASS_S;    &     dvi_item[0].code = DVI$_DEVBUFSIZ;     dvi_item[0].len = 4;'     dvi_item[0].bufadr = &buf->f_bsize; &     dvi_item[0].retadr = &f_bsize_len;  %     dvi_item[1].code = DVI$_MAXBLOCK;      dvi_item[1].len = 4;(     dvi_item[1].bufadr = &buf->f_blocks;'     dvi_item[1].retadr = &f_blocks_len;   '     dvi_item[2].code = DVI$_FREEBLOCKS;      dvi_item[2].len = 4;'     dvi_item[2].bufadr = &buf->f_bfree; &     dvi_item[2].retadr = &f_bfree_len;  %     dvi_item[3].code = DVI$_MAXFILES;      dvi_item[3].len = 4;'     dvi_item[3].bufadr = &buf->f_files; &     dvi_item[3].retadr = &f_files_len;  $     dvi_item[4].code = DVI$_DEVCHAR;     dvi_item[4].len = 4;"     dvi_item[4].bufadr = &devchar;&     dvi_item[4].retadr = &devchar_len;  $     dvi_item[5].code = DVI$_ACPTYPE;     dvi_item[5].len = 4;"     dvi_item[5].bufadr = &acptype;&     dvi_item[5].retadr = &acptype_len;       dvi_item[6].code = 0;      dvi_item[6].len = 0;  I     call_stat = SYS$GETDVIW(0, 0, &devname_dsc, dvi_item, iosb, 0, 0, 0);   !     buf->f_frsize = buf->f_bsize; D     buf->f_bavail = buf->f_bfree;	/* Hack, should check diskquota */6     buf->f_ffree = -1;			/* free files, unsupported */"     buf->f_favail = buf->f_favail;.     buf->f_fsid = acptype;	/* Unimplemented */     buf->f_flag = 0;  %     buf->f_namemax = 255; /* ODS 2 */         /* ODS5 support */      /*--------------*/#     if (acptype == DVI$C_ACP_F11V5) % 	buf->f_namemax = FPORT__C_MAXRSS -1;        if (devchar & DEV$M_SWL)' 	buf->f_flag = buf->f_flag = ST_RDONLY;        return call_stat;  } 