 /* File: FRONTPORT_PRIVATE.H **7 ** These are hidden functions in the Front port library  **N ** While these functions may be in the transfer vector, there is no commitment. ** for the data structures to remain the same. ** ** 26-Mar-1999	J. Malmberg **N *****************************************************************************/N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/   #ifndef _FRONTPORT_PRIVATE_H #define _FRONTPORT_PRIVATE_H # ifdef __cplusplus  extern "C" { # endif    #include <time.h>  #include <fcntl.h> #include <stat.h>   L    /* Sanity check on structure format.  Increment each time a change is  */K   /*  made to it, the routines use the structure should check the number */ <  /*   and if it does not match, it means a build error.			*/I /*---------------------------------------------------------------------*/ ' #define FPORT___RMS_FILENOS_VERSION (1)     #define FPORT___C_MAXREC (32767)    .  /* Structure to hold saved RMS information */- /*-----------------------------------------*/  #pragma member_alignment save # #pragma nomember_alignment longword    struct fport___rms_filenos_st { - unsigned long idcode;	/* Sanity check code */  unsigned long fab1;  unsigned long rab1; & unsigned long fab2;		/* Lock stream */& unsigned long rab2;		/* Lock stream */, unsigned long bufsize;		/* Size of buffer */. unsigned long bufptr;		/* Address of buffer */= unsigned long wrtindx;		/* Ammount of data not yet written */ E unsigned long readindx;		/* End of data currently read from buffer */ / unsigned long bufend;		/* Max data in buffer */ 1 unsigned long offset;		/* Offset into the file */ G unsigned long hiwater;		/* High Water limit of file (truncate issue) */ & 				/* Also need for file extending */F unsigned long lrecsz;		/* Largest record seen when writing the file */ 				/* Currently not used */ };  #pragma member_alignment restore      '  /* RMS call back to get information */ & /*----------------------------------*/ void fport___rms_acc_callback "        (unsigned long * first_arg, 	unsigned long * fab,  	unsigned long * rab);    8  /* Store the RMS structures associated with a fileno */7 /*---------------------------------------------------*/ " unsigned long fport___put_rms_info@        (int filedesc, struct fport___rms_filenos_st * rms_info);  :  /* Return the RMS structures associated with a channel */9 /*-----------------------------------------------------*/ " unsigned long fport___get_rms_info@        (int filedesc, struct fport___rms_filenos_st * rms_info);    )  /* Internal implementation of fcntl() */ ( /*====================================*/ int fport__rms_lock         (int filedesc,  	unsigned long flag, 	struct flock * lock_info);     -  /* Check out who is blocking the RMS lock */ , /*========================================*/ int fport__check_rms_lock         (struct stat * statbuf, 	unsigned long * rab2ptr,  	unsigned int rqmode,  	unsigned long * blkpid);     !  /* Flush out the write stream */   /*----------------------------*/ int fport___flush_write         (int filedesc, + 	struct fport___rms_filenos_st * rms_info);       /* Close the locking stream */  /*--------------------------*/ void fport___close_lock_stream@        (int filedesc, struct fport___rms_filenos_st * rms_info);      %  /* Convert from local time to UTC */ $ /*--------------------------------*/$ void fport___to_utc(time_t * clock);  %  /* Convert from UTC to local time */ $ /*--------------------------------*/& void fport___from_utc(time_t * clock);    A  /* Get the username last looked up with getpwuid()/getpwnam() */ @ /*------------------------------------------------------------*/! char * fport___getusername(void);     5  /* Get the last password info structure looked up */ 4 /*------------------------------------------------*/5 struct fport__passwd_st * fport___getpasswd_st(void);     2  /* Set the current working directory for cache */1 /*---------------------------------------------*/ 2 void fport___set_cwd_cache(const char * unixpath);  2  /* Get the current working directory for cache */1 /*---------------------------------------------*/ # char * fport___get_cwd_cache(void);   +  /* Get a translated filename from cache */ * /*--------------------------------------*/H int fport___get_fname_from_cache(char * vmsname, const char * unixname);  +  /* Put a translated filename into cache */ * /*--------------------------------------*/M void fport___set_fname_in_cache(const char * vmsname, const char * unixname);      # ifdef __cplusplus  }  # endif  #endif