 $! File: Create_SAMBA_ROOT.COM $!6 $! This procedure creates the root directory for SAMBA $!? $! p1: Physical disk and directory to put the rooted device on.  $!G $! If P1 is not specified, and an existing SAMBA_ROOT definition exists J $! then it will be used.  If no existing SAMBA_ROOT definition exists then, $! SYS$SYSDEVICE:[SAMBA_ROOT.] will be used. $!H $! P2: The logical name table to define SAMBA_ROOT in.  If not specifed,M $! the SYSTEM table will be used.  Logical names will be created in executive  $! mode. $!3 $! The directories will be created owned by SYSTEM.  $! $! 30-Nov-1999	J. Malmberg $!N $!---------------------------------------------------------------------------- $!$ $! Do we have the proper privileges?% $!----------------------------------- " $old_priv = f$getjpi("","CURPRIV") $needed_priv = "SYSNAM,BYPASS"2 $set proc/priv=(NOALL,TMPMBX,NETMBX,'needed_priv')4 $if .not. f$privilege(needed_priv) then goto no_priv $! $!( $! Calculate out the base root directory) $!--------------------------------------- " $old_root = f$trnlnm("SAMBA_ROOT")" $old_root_len = f$length(old_root) $if old_root_len .gt. 0  $then 4 $   rdelim = f$extract(old_root_len -1, 1, old_root)8 $   if f$extract(old_root_len -2, 1, old_root) .eqs. "." $   then= $	old_root = f$extract(0,old_root_len - 2, old_root) + rdelim 	 $   endif  $endif $target_root = f$parse- I    (P1, old_root, "SYS$SYSDEVICE:[SAMBA_ROOT]",,"NO_CONCEAL,SYNTAX_ONLY") L $   if target_root .eqs. "" then target_root = "SYS$SYSDEVICE:[SAMBA_ROOT.]"I $target_dev = f$parse(target_root,,, "DEVICE", "NO_CONCEAL, SYNTAX_ONLY") L $target_dir = f$parse(target_root,,, "DIRECTORY", "NO_CONCEAL, SYNTAX_ONLY")< $rdelim = f$extract(f$length(target_dir) - 1, 1, target_dir)3 $target_root_dir = f$element(0, rdelim, target_dir) 0 $target_root_dir_len = f$length(target_root_dir)D $if f$extract(target_root_dir_len - 1, 1, target_root_dir) .eqs. "." $then K $   target_root_dir = f$extract(0, target_root_dir_len -1, target_root_dir)  $endif4 $!write sys$output target_dev,target_root_dir,rdelim $! $! $! $! What table should be used?  $!---------------------------- $table = "SYSTEM/EXEC", $tables = "/SYSTEM /GROUP  /JOB    /PROCESS" $tables_len = f$length(tables)) $testtbl = "/" + f$edit(p2,"UPCASE,TRIM") # $tblindx = f$locate(testtbl,tables)  $if tblindx .lt. tables_len  $then 9 $   tabnam = f$edit(f$extract(tblindx+1,7,tables),"TRIM") " $   table = "/" + tabnam + "/EXEC" $endif $!write sys$output table $! $! $! $! Directory owner $!------------------ $dir_owner = "SYSTEM"  $! $! $! $! Create the base directory $!--------------------------( $ldelim = f$extract(0,1,target_root_dir)' $target_path = target_root_dir - ldelim  $i = 0 $base_dir = "" $prev_part = ""  $base_loop: ' $   part = f$element(i,".",target_path) - $   if part .eqs. "." then goto base_loop_end  $   if (prev_part .nes. "")  $   then7 $	if (base_dir .nes. "") then base_dir = base_dir + "." ! $	base_dir = base_dir + prev_part 	 $   endif  $   prev_part = part
 $   i = i + 1  $   goto base_loop $base_loop_end:  $!. $if base_dir .eqs. "" then base_dir = "000000" $!
 $if f$search- J    ("''target_dev'''ldelim'''base_dir'''rdelim'''prev_part'.dir") .eqs. "" $then 5 $   create/dir 'target_dev''target_root_dir''rdelim'-  	/owner='dir_owner'/prot=w:re  $endif $! $!! $! Create the rooted logical name ! $!------------------------------- P $define samba_root'table' 'target_dev''target_root_dir'.'rdelim'/trans=concealed $! $!) $! Now create the rest of the directories * $!----------------------------------------3 $if f$search("SAMBA_ROOT:[000000]BIN.DIR") .eqs. ""  $then ; $   create/dir SAMBA_ROOT:[BIN]/owner='dir_owner'/prot=w:re  $endif $!8 $if f$search("SAMBA_ROOT:[000000]CODEPAGE.DIR") .eqs. "" $then @ $   create/dir SAMBA_ROOT:[CODEPAGE]/owner='dir_owner'/prot=w:re $endif $!6 $if f$search("SAMBA_ROOT:[000000]DRIVER.DIR") .eqs. "" $then > $   create/dir SAMBA_ROOT:[DRIVER]/owner='dir_owner'/prot=w:re $endif $!> $if f$search("SAMBA_ROOT:[000000]FILE_TEMPLATES.DIR") .eqs. "" $then G $    create/dir samba_root:[FILE_TEMPLATES]/owner='dir_owner'/prot=w:re  $endif $!3 $if f$search("SAMBA_ROOT:[000000]LIB.DIR") .eqs. ""  $then ; $   create/dir SAMBA_ROOT:[LIB]/owner='dir_owner'/prot=w:re  $endif $!3 $if f$search("SAMBA_ROOT:[000000]VAR.DIR") .eqs. ""  $then < $   create/dir SAMBA_ROOT:[VAR]/owner='dir_owner'/prot=w:rwe $endif $!2 $if f$search("SAMBA_ROOT:[VAR]LOCKS.DIR") .eqs. "" $then A $   create/dir SAMBA_ROOT:[VAR.LOCKS]/owner='dir_owner'/prot=w:re  $endif $!2 $if f$search("SAMBA_ROOT:[VAR]LOCKS.DIR") .eqs. "" $then A $   create/dir SAMBA_ROOT:[VAR.LOCKS]/owner='dir_owner'/prot=w:re  $endif $!4 $if f$search("SAMBA_ROOT:[VAR]PRIVATE.DIR") .eqs. "" $then @ $   create/dir SAMBA_ROOT:[VAR.PRIVATE]/owner='dir_owner'/prot=w $endif $!4 $if f$search("SAMBA_ROOT:[000000]SWAT.DIR") .eqs. "" $then < $   create/dir SAMBA_ROOT:[SWAT]/owner='dir_owner'/prot=w:re $endif $! $! $! $! $! Clean up and exit $!====================
 $all_exit: $exit  $! $!' $! No privilege for attempted operation ' $!------------------------------------- 	 $no_priv:  $! $ind = 0
 $prv_loop:& $priv = f$element(ind,",",needed_priv)) $if priv .eqs. "," then goto prv_loop_end  $IF .NOT. F$PRIVILEGE(priv)  $THEN I $    WRITE SYS$OUTPUT "You need ''priv' privilege to run this procedure."  $ENDIF $ind = ind + 1 $goto prv_loop $prv_loop_end:7 $    WRITE SYS$OUTPUT "Please see your system manager."  $goto all_exit