% $! File: MAKE_SAMBA_GUEST_ACCOUNT.COM  $!L $! This procedure creates a Guest account for SAMBA.  To accept a connectionH $! from a client that is using encrypted passwords, a guest account must	 $! exist.  $! $! 15-Jan-2000	J. Malmberg $!M $!===========================================================================  $! $! Some assumptions  $!---------------------  $user = "SAMBA__GUEST" $group = "SMBGUEST"  $owner="Samba Guest" $account=group $device="SAMBA_ROOT:"  $!K $! The procedure will start with [base_group+1, Base_user+1] to find a free  $! UICM $!---------------------------------------------------------------------------  $base_group=%o200  $base_user=7 $! $!2 $! Make sure system management symbols are defined4 $!-------------------------------------------------- $ss_normal = 1 $ss_abort = 44 $ss_nopriv = 36  $vms_stat = ss_normal H $if f$trnlnm("SYSUAF") .eqs. "" then define sysuaf sys$system:sysuaf.dat" $if f$trnlnm("SYSUAFALT") .eqs. "" $then - $   define sysuafalt sys$system:sysuafalt.dat  $endif $!N $if f$trnlnm("NETPROXY") .eqs. "" then define netproxy sys$system:netproxy.dat" $if f$trnlnm("NET$PROXY") .eqs. "" $then - $   define net$proxy sys$system:net$proxy.dat  $endif $! $uaf := $authorize $! $!. $! Make sure that all needed privileges are on0 $!----------------------------------------------" $old_priv = f$getjpi("","CURPRIV") $needed_priv= "SYSPRV,BYPASS"  $set proc/priv=('needed_priv')4 $if .not. f$privilege(needed_priv) then goto no_priv $! $! $! Garbage up a password $!-----------------------  $pid = f$getjpi("","pid") # $logintim = f$getjpi("","logintim") , $logintim2 = f$element(2,":",logintim) - "." $mmm = f$extract(4,1,logintim)# $pindex = f$getjpi("","proc_index") , $passwd = "''logintim2'''pid'''mmm'''pindex' $! $! $! Find a free UIC $!----------------------- 4 $samba_groupx = f$identifier(group,"NAME_TO_NUMBER")0 $samba_uic = f$identifier(user,"NAME_TO_NUMBER") $! $tst_group = base_group  $try_group:  $tst_user = base_user  $if samba_uic .eq. 0 $then  $! $!    Find a free group  $!--------------------- 5 $   if (samba_uic .eq. 0) .and. (samba_groupx .eq. 0)  $   then
 $grp_loop: $	    tst_group = tst_group + 1 < $	    if (tst_group .ge. %o300) .and. (tst_group .lt. %o377)
 $	    then $		tst_group = %o400 $	    endif  $	    if tst_group .ge. %x7fff
 $	    then7 $		write sys$output "No unused group number available."  $		goto bad_exit $	    endif - $	    tst_id = (tst_group * %x10000) + %xFFFF 6 $	    tst_name = f$identifier(tst_id,"number_to_name")- $	    if tst_name .nes. "" then goto grp_loop  $grp_loop_end: $	samba_group = tst_group  $   else& $	samba_group = samba_groupx / %x10000	 $   endif  $! $! $!  Find a free user number  $!------------------------- 
 $usr_loop: $	tst_user = tst_user + 1  $	if tst_user .ge. %xFFFF  $	then $	    if samba_groupx .eq. 0
 $	    then $		goto try_group 
 $	    else> $		write sys$output "No unique UIC is available for ''group'!" $		goto bad_exit $	    endif  $	endif + $	tst_id = (tst_group * %x10000) + tst_user 2 $	tst_name = f$identifier(tst_id,"number_to_name")) $	if tst_name .nes. "" then goto usr_loop  $usr_loop_end: $   uaf_flag = "ADD" $   samba_user = tst_user  $else  $!+ $!  Check for any name of an existing group + $!----------------------------------------- % $   samba_group = samba_uic / %x10000 ' $   samba_user = samba_uic .and. %xFFFF  $   if samba_groupx .eq. 0 $   then# $	tst_group = samba_uic .or. %xFFFF 7 $	tst_grpnam = f$identifier(tst_group,"name_to_number")  $	if tst_grpnam .nes. "" $	then $	    samba_groupx = tst_group $	endif 	 $   endif  $   uaf_flag = "MODIFY"  $endif $! $! $!' $! Put the value in a proper UIC format - $!------------------------------------------- 1 $samba_uic = (samba_group * %x10000) + samba_user  $uic = f$fao("!%U",samba_uic)  $! $! $! Create or modify the account ! $!------------------------------- F $UAF 'uaf_flag' 'user'/device='device'/dir=['user']/password='passwd'-- /uic='uic'/owner="''owner'"/account='account' I $UAF mod 'user'/fillm=18/biolm=18/prclm=15/diolm=18/astlm=20/bytlm=32000- > /jtquota=4096/wsdef=2000/wsquo=4000/wsextent=16/pgflqou=150000< $UAF mod 'user'/priv=(tmpmbx,netmbx)/defpriv=(tmpmbx,netmbx) $! $!- $! Create a group identifier if one is needed - $!-------------------------------------------  $if samba_groupx .eq. 0  $then  $!K $!  Need to test again, newer versions of OpenVMS create this automagically K $!------------------------------------------------------------------------- . $   tst_group = samba_group * %x10000 + %xFFFF= $   tst_group_name = f$identifier(tst_group,"NUMBER_TO_NAME")  $   if tst_group_name .eqs. "" $   then% $	guic = f$fao("[!OW,*]",samba_group) + $	uaf add/identifier 'group'/val=uic='guic' 	 $   endif  $endif $! $!& $! Make sure the home directory exists' $!------------------------------------- 5 $if f$search("''device'[000000]''user'.DIR") .eqs. ""  $then  $! $!  Create the home directory  $!----------------------------, $   create/dir 'device'['user']/owner='user' $else  $!. $!  Make sure the files are owned by the owner/ $!--------------------------------------------- 4 $   set file/owner='user' 'device'[000000]'user'.dir6 $   if f$search("''device'[''user'...]*.*;*") .nes. "" $   then0 $	set file/owner='user' 'device'['user'...]*.*;*	 $   endif  $endif $! $!	 $! (not!) 2 $! Make sure that there is a proxy for the account3 $!------------------------------------------------- 4 $!mynode = f$edit(f$getsyi("SCSNODE"),"UPCASE,TRIM")+ $!uaf add/proxy 'mynode'::'user' 'user'/def + $!uaf add/proxy 'mynode'::system system/def ' $!uaf add/proxy 'mynode'::system 'user'  $! $! $! $! Report success  $!---------------- $vms_stat = ss_normal  $! $!
 $all_exit: $! $! Clean up privileges $!--------------------- I $if f$type(old_priv) .eqs. "STRING" then set proc/priv=(NOALL,'old_priv')  $exit 'vms_stat' $! $! $! Abort $!--------- 
 $bad_exit:, $write sys$output "Account was not created!" $vms_stat = ss_abort $goto all_exit $! $!' $! No privilege for attempted operation ' $!------------------------------------- 	 $no_priv:  $! $ind = 0
 $prv_loop:& $priv = f$element(ind,",",needed_priv)) $if priv .eqs. "," then goto prv_loop_end  $if .not. f$privilege(priv)  $then I $    write sys$output "You need ''priv' privilege to run this procedure."  $endif $ind = ind + 1 $goto prv_loop $prv_loop_end:3 $write sys$output "Please see your system manager."  $vms_stat = ss_nopriv  $goto all_exit