 /*#    Unix SMB/Netbios implementation.     Version 1.9. 
    SMB client *    Copyright (C) Andrew Tridgell 1994-1998  G    This program is free software; you can redistribute it and/or modify G    it under the terms of the GNU General Public License as published by D    the Free Software Foundation; either version 2 of the License, or&    (at your option) any later version.  B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software<    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */   #define NO_SYSLOG    #include "includes.h"    #ifndef REGISTER #define REGISTER 0 #endif   struct cli_state *cli; extern BOOL in_client; static int port = SMB_PORT;  pstring cur_dir = "\\";  pstring cd_path = "";  static pstring service;  static pstring desthost; extern pstring global_myname;  static pstring password; static pstring username; static pstring workgroup;  static char *cmdstr; static BOOL got_pass;  static int io_bufsize = 65520; extern struct in_addr ipzero;  extern pstring scope;    static int name_type = 0x20;  # extern pstring user_socket_options;   $ static int process_tok(fstring tok); static void cmd_help(void);   ( /* 30 second timeout on most commands */  #define CLIENT_TIMEOUT (30*1000) #define SHORT_TIMEOUT (5*1000)  < /* value for unused fid field in trans2 secondary request */ #define FID_UNUSED (0xFFFF)    time_t newer_than = 0; int archive_level = 0;   extern pstring debugf; extern int DEBUGLEVEL;   BOOL translation = False;    static BOOL have_ip;   /* clitar bits insert */ extern int blocksize;  extern BOOL tar_inc; extern BOOL tar_reset; /* clitar bits end */      mode_t myumask = 0755;   BOOL prompt = True;    int printmode = 1;   static BOOL recurse = False; BOOL lowercase = False;    struct in_addr dest_ip;    #define SEPARATORS " \t\n\r"   BOOL abort_mget = True;    pstring fileselection = "";    extern file_info def_finfo;    /* timing globals */ int get_total_size = 0;  int get_total_time_ms = 0; int put_total_size = 0;  int put_total_time_ms = 0;   /* totals globals */ static double dir_total;   #define USENMB  ( #define CNV_LANG(s) dos_to_unix(s,False)( #define CNV_INPUT(s) unix_to_dos(s,True)    M /**************************************************************************** K write to a local file with CR/LF->LF translation if appropriate. return the D number taken from the buffer. This may not equal the number written.M ****************************************************************************/ + static int writefile(int f, char *b, int n)  {  	int i;    	if (!translation) { 		return write(f,b,n); 	}   	i = 0;  	while (i < n) {2 		if (*b == '\r' && (i<(n-1)) && *(b+1) == '\n') { 			b++;i++;  		}  		if (write(f, b, 1) != 1) {	 			break;  		}  		b++; 		i++; 	}   	return(i);  }   M /**************************************************************************** H   read from a file with LF->CR/LF translation if appropriate. return the#   number read. read approx n bytes. M ****************************************************************************/ 6 static int readfile(char *b, int size, int n, FILE *f) {  	int i;  	int c;   ! 	if (!translation || (size != 1))  		return(fread(b,size,n,f));   	i = 0; + 	while (i < (n - 1) && (i < BUFFER_SIZE)) {  		if ((c = getc(f)) == EOF) { 	 			break;  		}   0 		if (c == '\n') { /* change all LFs to CR/LF */ 			b[i++] = '\r';  		}   
 		b[i++] = c;  	}   	return(i);  }     M /****************************************************************************  send a messageM ****************************************************************************/  static void send_message(void) {  	int total_len = 0;  	int grp_id;  < 	if (!cli_message_start(cli, desthost, username, &grp_id)) {4 		DEBUG(0,("message start: %s\n", cli_errstr(cli)));	 		return;  	}     #ifndef CLIENT_CONNECT_MSG #define CLIENT_CONNECT_MSG \?   "Connected.  Type your message, ending it with a Control-D\n"  #endif 	printf(CLIENT_CONNECT_MSG);  + 	while (!feof(stdin) && total_len < 1600) { ) 		int maxlen = MIN(1600 - total_len,127);  		pstring msg;
 		int l=0; 		int c;   		ZERO_ARRAY(msg);  3 		for (l=0;l<maxlen && (c=fgetc(stdin))!=EOF;l++) {  			if (c == '\n')  				msg[l++] = '\r'; 			msg[l] = c; 		}   / 		if (!cli_message_text(cli, msg, l, grp_id)) { 6 			printf("SMBsendtxt failed (%s)\n",cli_errstr(cli));
 			return; 		}    		total_len += l;  	}   	if (total_len >= 1600) 6 		printf("the message was truncated to 1600 bytes\n"); 	else & 		printf("sent %d bytes\n",total_len);  % 	if (!cli_message_end(cli, grp_id)) { 5 		printf("SMBsendend failed (%s)\n",cli_errstr(cli)); 	 		return;  	} }       M /****************************************************************************  check the space on a device M ****************************************************************************/  static void do_dskattr(void) {  	int total, bsize, avail;   1 	if (!cli_dskattr(cli, &bsize, &total, &avail)) { 6 		DEBUG(0,("Error in dskattr: %s\n",cli_errstr(cli)));	 		return;  	}  > 	DEBUG(0,("\n\t\t%d blocks of size %d. %d blocks available\n", 		 total, bsize, avail));  }   M /****************************************************************************  show cd/pwd M ****************************************************************************/  static void cmd_pwd(void)  { 8 	DEBUG(0,("Current directory is %s",CNV_LANG(service)));% 	DEBUG(0,("%s\n",CNV_LANG(cur_dir)));  }     M /****************************************************************************   change directory - inner sectionM ****************************************************************************/  static void do_cd(char *newdir)  {  	char *p = newdir; 	pstring saved_dir;  	pstring dname;    	dos_format(newdir);  * 	/* Save the current directory in case the 	   new directory is invalid */  	pstrcpy(saved_dir, cur_dir);  	if (*p == '\\') 		pstrcpy(cur_dir,p);  	else  		pstrcat(cur_dir,p); , 	if (*(cur_dir+strlen(cur_dir)-1) != '\\') { 		pstrcat(cur_dir, "\\");  	} 	dos_clean_name(cur_dir);  	pstrcpy(dname,cur_dir); 	pstrcat(cur_dir,"\\");  	dos_clean_name(cur_dir);    	if (!strequal(cur_dir,"\\")) { ! 		if (!cli_chkpath(cli, dname)) { 4 			DEBUG(0,("cd %s: %s\n", dname, cli_errstr(cli))); 			pstrcpy(cur_dir,saved_dir); 		}  	}   	pstrcpy(cd_path,cur_dir); }   M /****************************************************************************  change directoryM ****************************************************************************/  static void cmd_cd(void) { 
 	fstring buf;   + 	if (next_token(NULL,buf,NULL,sizeof(buf))) 
 		do_cd(buf);  	else ; 		DEBUG(0,("Current directory is %s\n",CNV_LANG(cur_dir)));  }     D /*******************************************************************(   decide if a file should be operated onG   ********************************************************************/ ) static BOOL do_this_one(file_info *finfo)  { & 	if (finfo->mode & aDIR) return(True);   	if (*fileselection &&: 	    !mask_match(finfo->name,fileselection,False,False)) {4 		DEBUG(3,("match_match %s failed\n", finfo->name)); 		return False;  	}  / 	if (newer_than && finfo->mtime < newer_than) { 3 		DEBUG(3,("newer_than %s failed\n", finfo->name));  		return(False); 	}  H 	if ((archive_level==1 || archive_level==2) && !(finfo->mode & aARCH)) {0 		DEBUG(3,("archive %s failed\n", finfo->name)); 		return(False); 	}   	return(True); }   M /****************************************************************************    display info about a file O   ****************************************************************************/ + static void display_finfo(file_info *finfo)  {  	if (do_this_one(finfo)) {H 		time_t t = finfo->mtime; /* the time is assumed to be passed as GMT */$ 		DEBUG(0,("  %-30s%7.7s %8.0f  %s", 			 CNV_LANG(finfo->name), 			 attrib_string(finfo->mode),  			 (double)finfo->size, 			 asctime(LocalTime(&t))));  		dir_total += finfo->size;  	} }     M /****************************************************************************     accumulate size of a fileO   ****************************************************************************/ # static void do_du(file_info *finfo)  {  	if (do_this_one(finfo)) { 		dir_total += finfo->size;  	} }    static BOOL do_list_recurse; static BOOL do_list_dirs;  static char *do_list_queue = 0; # static long do_list_queue_size = 0; $ static long do_list_queue_start = 0;" static long do_list_queue_end = 0;' static void (*do_list_fn)(file_info *);   M /****************************************************************************  functions for do_list_queue O   ****************************************************************************/    /*C  * The do_list_queue is a NUL-separated list of strings stored in a C  * char*.  Since this is a FIFO, we keep track of the beginning and C  * ending locations of the data in the queue.  When we overflow, we C  * double the size of the char*.  When the start of the data passes A  * the midpoint, we move everything back.  This is logically more B  * complex than a linked list, but easier from a memory managementA  * angle.  In any memory error condition, do_list_queue is reset. B  * Functions check to ensure that do_list_queue is non-NULL before  * accessing it.  */ % static void reset_do_list_queue(void)  {  	if (do_list_queue)  	{ 		free(do_list_queue); 	} 	do_list_queue = 0;  	do_list_queue_size = 0; 	do_list_queue_start = 0;  	do_list_queue_end = 0;  }   $ static void init_do_list_queue(void) {  	reset_do_list_queue();  	do_list_queue_size = 1024; , 	do_list_queue = malloc(do_list_queue_size); 	if (do_list_queue == 0) {' 		DEBUG(0,("malloc fail for size %d\n",  			 (int)do_list_queue_size)); 		reset_do_list_queue();	 	} else { / 		memset(do_list_queue, 0, do_list_queue_size);  	} }   & static void adjust_do_list_queue(void) {n 	/* E 	 * If the starting point of the queue is more than half way through, ) 	 * move everything toward the beginning.u 	 */A 	if (do_list_queue && (do_list_queue_start == do_list_queue_end))e 	{( 		DEBUG(4,("do_list_queue is empty\n"));. 		do_list_queue_start = do_list_queue_end = 0; 		*do_list_queue = '\0'; 	}9 	else if (do_list_queue_start > (do_list_queue_size / 2))t 	{0 		DEBUG(4,("sliding do_list_queue backward\n")); 		memmove(do_list_queue,' 			do_list_queue + do_list_queue_start, , 			do_list_queue_end - do_list_queue_start);+ 		do_list_queue_end -= do_list_queue_start;o 		do_list_queue_start = 0; 	}   }e  3 static void add_to_do_list_queue(const char* entry)t {r> 	long new_end = do_list_queue_end + ((long)strlen(entry)) + 1;% 	while (new_end > do_list_queue_size)O 	{ 		do_list_queue_size *= 2;- 		DEBUG(4,("enlarging do_list_queue to %d\n",d 			 (int)do_list_queue_size));= 		do_list_queue = Realloc(do_list_queue, do_list_queue_size);_ 		if (! do_list_queue) {< 			DEBUG(0,("failure enlarging do_list_queue to %d bytes\n", 				 (int)do_list_queue_size));  			reset_do_list_queue();t 		}p 		else 		{m1 			memset(do_list_queue + do_list_queue_size / 2,;% 			       0, do_list_queue_size / 2);_ 		}z 	} 	if (do_list_queue)  	{4 		pstrcpy(do_list_queue + do_list_queue_end, entry); 		do_list_queue_end = new_end;< 		DEBUG(4,("added %s to do_list_queue (start=%d, end=%d)\n",> 			 entry, (int)do_list_queue_start, (int)do_list_queue_end)); 	} }   % static char *do_list_queue_head(void)f { , 	return do_list_queue + do_list_queue_start; }   + static void remove_do_list_queue_head(void)I {N- 	if (do_list_queue_end > do_list_queue_start)r 	{: 		do_list_queue_start += strlen(do_list_queue_head()) + 1; 		adjust_do_list_queue();l@ 		DEBUG(4,("removed head of do_list_queue (start=%d, end=%d)\n",7 			 (int)do_list_queue_start, (int)do_list_queue_end));e 	} }c  $ static int do_list_queue_empty(void) {5. 	return (! (do_list_queue && *do_list_queue)); }   M /****************************************************************************  a helper for do_listO   ****************************************************************************/f: static void do_list_helper(file_info *f, const char *mask) {e 	if (f->mode & aDIR) {' 		if (do_list_dirs && do_this_one(f)) {  			do_list_fn(f);  		}  		if (do_list_recurse && 		    !strequal(f->name,".") &&S  		    !strequal(f->name,"..")) { 			pstring mask2;f 			char *p;(   			pstrcpy(mask2, mask); 			p = strrchr(mask2,'\\');* 			if (!p) return; 			p[1] = 0; 			pstrcat(mask2, f->name);c 			pstrcat(mask2,"\\*"); 			add_to_do_list_queue(mask2);h 		}u	 		return;f 	}   	if (do_this_one(f)) { 		do_list_fn(f); 	} }     M /****************************************************************************t- a wrapper around cli_list that adds recursioniO   ****************************************************************************/ [ void do_list(const char *mask,uint16 attribute,void (*fn)(file_info *),BOOL rec, BOOL dirs), {  	static int in_do_list = 0;    	if (in_do_list && rec)r 	{b 		fprintf(stderr, "INTERNAL ERROR: do_list called recursively when the recursive flag is true\n");
 		exit(1); 	}   	in_do_list = 1;   	do_list_recurse = rec;  	do_list_dirs = dirs;r 	do_list_fn = fn;*  	 	if (rec)* 	{ 		init_do_list_queue();* 		add_to_do_list_queue(mask);t  ! 		while (! do_list_queue_empty())i 		{  			/*)1 			 * Need to copy head so that it doesn't becomei0 			 * invalid inside the call to cli_list.  This, 			 * would happen if the list were expanded 			 * during the call.- 			 * Fix from E. Jay Berkenbilt (ejb@ql.org)) 			 */ 			pstring head;' 			pstrcpy(head, do_list_queue_head());+2 			cli_list(cli, head, attribute, do_list_helper); 			remove_do_list_queue_head();*: 			if ((! do_list_queue_empty()) && (fn == display_finfo)) 			{+ 				char* next_file = do_list_queue_head();* 				char* save_ch = 0;# 				if ((strlen(next_file) >= 2) &&l4 				    (next_file[strlen(next_file) - 1] == '*') &&3 				    (next_file[strlen(next_file) - 2] == '\\'))g 				{: 					save_ch = next_file + 						strlen(next_file) - 2; 					*save_ch = '\0';n 				}T, 				DEBUG(0,("\n%s\n",CNV_LANG(next_file))); 				if (save_ch) 				{r 					*save_ch = '\\';t 				}T 			} 		}G 	} 	elsee 	{; 		if (cli_list(cli, mask, attribute, do_list_helper) == -1)  		{_8 			DEBUG(0, ("%s listing %s\n", cli_errstr(cli), mask)); 		}Y 	}   	in_do_list = 0; 	reset_do_list_queue();! }F  M /****************************************************************************(   get a directory listing O   ****************************************************************************/; static void cmd_dir(void)  {}- 	uint16 attribute = aDIR | aSYSTEM | aHIDDEN;s 	pstring mask;
 	fstring buf;\
 	char *p=buf;	   	dir_total = 0;e 	pstrcpy(mask,cur_dir);! 	if(mask[strlen(mask)-1]!='\\')  		pstrcat(mask,"\\");i  - 	if (next_token(NULL,buf,NULL,sizeof(buf))) {  		dos_format(p); 		if (*p == '\\')* 			pstrcpy(mask,p);* 		else 			pstrcat(mask,p);h 	} 	else {  		pstrcat(mask,"*"); 	}  8 	do_list(mask, attribute, display_finfo, recurse, True);   	do_dskattr();  5 	DEBUG(3, ("Total bytes listed: %.0f\n", dir_total));  }l    M /****************************************************************************_   get a directory listing O   ****************************************************************************/s static void cmd_du(void) {*- 	uint16 attribute = aDIR | aSYSTEM | aHIDDEN;* 	pstring mask;
 	fstring buf;/
 	char *p=buf;*   	dir_total = 0;* 	pstrcpy(mask,cur_dir);* 	if(mask[strlen(mask)-1]!='\\')i 		pstrcat(mask,"\\");D  - 	if (next_token(NULL,buf,NULL,sizeof(buf))) {e 		dos_format(p); 		if (*p == '\\')i 			pstrcpy(mask,p);* 		else 			pstrcat(mask,p);*	 	} else {* 		pstrcat(mask,"*"); 	}  0 	do_list(mask, attribute, do_du, recurse, True);   	do_dskattr();  8 	DEBUG(0, ("Total number of bytes: %.0f\n", dir_total)); }o    M /****************************************************************************     get a file from rname to lnameO   ****************************************************************************/v+ static void do_get(char *rname,char *lname)p {u 	int handle=0,fnum;	 	BOOL newhandle = False; 	char *data; 	struct timeval tp_start;  	int read_size = io_bufsize;
 	uint16 attr;m
 	size_t size;p 	off_t nread = 0;r   	GetTimeOfDay(&tp_start);    	if (lowercase) {i 		strlower(lname); 	}  2 	fnum = cli_open(cli, rname, O_RDONLY, DENY_NONE);   	if (fnum == -1) {K 		DEBUG(0,("%s opening remote file %s\n",cli_errstr(cli),CNV_LANG(rname)));p	 		return;a 	}   	if(!strcmp(lname,"-")) {* 		handle = fileno(stdout);	 	} else {*9 		handle = sys_open(lname,O_WRONLY|O_CREAT|O_TRUNC,0644);* 		newhandle = True;* 	} 	if (handle < 0) {3 		DEBUG(0,("Error opening local file %s\n",lname));i	 		return;  	}     	if (!cli_qfileinfo(cli, fnum,4 			   &attr, &size, NULL, NULL, NULL, NULL, NULL) && 	    !cli_getattrE(cli, fnum,)' 			  &attr, &size, NULL, NULL, NULL)) {*/ 		DEBUG(0,("getattrib: %s\n",cli_errstr(cli)));e	 		return;s 	}  0 	DEBUG(2,("getting file %s of size %.0f as %s ",  		 lname, (double)size, lname));  * 	if(!(data = (char *)malloc(read_size))) {4 		DEBUG(0,("malloc fail for size %d\n", read_size)); 		cli_close(cli, fnum);!	 		return;f 	}   	while (1) {6 		int n = cli_read(cli, fnum, data, nread, read_size);   		if (n <= 0) break;  ' 		if (writefile(handle,data, n) != n) {o+ 			DEBUG(0,("Error writing local file\n"));h	 			break;d 		}f  
 		nread += n;	 	}   	if (nread < size) {F 		DEBUG (0, ("Short read when getting file %s. Only got %ld bytes.\n",.                CNV_LANG(rname), (long)nread)); 	}   	free(data);   	if (!cli_close(cli, fnum)) {*> 		DEBUG(0,("Error %s closing remote file\n",cli_errstr(cli))); 	}   	if (newhandle) {t 		close(handle); 	}  , 	if (archive_level >= 2 && (attr & aARCH)) {3 		cli_setatr(cli, rname, attr & ~(uint16)aARCH, 0);i 	}   	{ 		struct timeval tp_end; 		int this_time;   		GetTimeOfDay(&tp_end);
 		this_time =o+ 			(tp_end.tv_sec - tp_start.tv_sec)*1000 +s, 			(tp_end.tv_usec - tp_start.tv_usec)/1000;! 		get_total_time_ms += this_time;d 		get_total_size += nread;  + 		DEBUG(2,("(%g kb/s) (average %g kb/s)\n",i' 			 nread / (1.024*this_time + 1.0e-4),*1 			 get_total_size / (1.024*get_total_time_ms)));* 	} }a    M /*****************************************************************************   get a fileO   ****************************************************************************/	 static void cmd_get(void)  {  	pstring lname;  	pstring rname; 	 	char *p;    	pstrcpy(rname,cur_dir); 	pstrcat(rname,"\\");t   	p = rname + strlen(rname);0  < 	if (!next_token(NULL,p,NULL,sizeof(rname)-strlen(rname))) {  		DEBUG(0,("get <filename>\n"));	 		return;i 	} 	pstrcpy(lname,p); 	dos_clean_name(rname);*  + 	next_token(NULL,lname,NULL,sizeof(lname));i   	do_get(rname, lname); }*    M /*****************************************************************************!   do a mget operation on one fileeO   ****************************************************************************/ % static void do_mget(file_info *finfo)  {t 	pstring rname;e 	pstring quest;f 	pstring saved_curdir; 	pstring mget_mask;h  = 	if (strequal(finfo->name,".") || strequal(finfo->name,".."))h	 		return;T   	if (abort_mget)	{ 		DEBUG(0,("mget aborted\n"));	 		return;  	}   	if (finfo->mode & aDIR)# 		slprintf(quest,sizeof(pstring)-1,o0 			 "Get directory %s? ",CNV_LANG(finfo->name)); 	else # 		slprintf(quest,sizeof(pstring)-1,a+ 			 "Get file %s? ",CNV_LANG(finfo->name));_  % 	if (prompt && !yesno(quest)) return;{   	if (!(finfo->mode & aDIR)) {_ 		pstrcpy(rname,cur_dir);q 		pstrcat(rname,finfo->name);s 		do_get(rname,finfo->name);	 		return;  	}   	/* handle directories */v 	pstrcpy(saved_curdir,cur_dir);    	pstrcat(cur_dir,finfo->name); 	pstrcat(cur_dir,"\\");l   	unix_format(finfo->name); 	if (lowercase)	 		strlower(finfo->name);  . 	if (!dos_directory_exist(finfo->name,NULL) &&( 	    dos_mkdir(finfo->name,0777) != 0) {E 		DEBUG(0,("failed to create directory %s\n",CNV_LANG(finfo->name)));d  		pstrcpy(cur_dir,saved_curdir);	 		return;t 	}  # 	if (dos_chdir(finfo->name) != 0) {yG 		DEBUG(0,("failed to chdir to directory %s\n",CNV_LANG(finfo->name)));t  		pstrcpy(cur_dir,saved_curdir);	 		return;u 	}   	pstrcpy(mget_mask,cur_dir); 	pstrcat(mget_mask,"*");  B 	do_list(mget_mask, aSYSTEM | aHIDDEN | aDIR,do_mget,False, True);
 	chdir("..");l 	pstrcpy(cur_dir,saved_curdir);s }     M /****************************************************************************u view the file using the pagerqM ****************************************************************************/  static void cmd_more(void) {l' 	fstring rname,lname,tmpname,pager_cmd;v
 	char *pager;i   	fstrcpy(rname,cur_dir); 	fstrcat(rname,"\\");o 	slprintf(tmpname, 		 sizeof(fstring)-1,;+ 		 "%s/smbmore.%d",tmpdir(),(int)getpid());  	fstrcpy(lname,tmpname);  N 	if (!next_token(NULL,rname+strlen(rname),NULL,sizeof(rname)-strlen(rname))) {! 		DEBUG(0,("more <filename>\n"));u	 		return;t 	} 	dos_clean_name(rname);s   	do_get(rname,lname);f   	pager=getenv("PAGER");e  ( 	slprintf(pager_cmd,sizeof(pager_cmd)-1,* 		 "%s %s",(pager? pager:PAGER), tmpname); 	system(pager_cmd);e 	unlink(tmpname);o }s      M /****************************************************************************e do a mget command(M ****************************************************************************/E static void cmd_mget(void) {u& 	uint16 attribute = aSYSTEM | aHIDDEN; 	pstring mget_mask;,
 	fstring buf;u
 	char *p=buf;    	*mget_mask = 0;  
 	if (recurse)( 		attribute |= aDIR;   	abort_mget = False;  . 	while (next_token(NULL,p,NULL,sizeof(buf))) { 		pstrcpy(mget_mask,cur_dir);q* 		if(mget_mask[strlen(mget_mask)-1]!='\\') 			pstrcat(mget_mask,"\\");l   		if (*p == '\\'); 			pstrcpy(mget_mask,p); 		else 			pstrcat(mget_mask,p);3 		do_list(mget_mask, attribute,do_mget,False,True);q 	}   	if (!*mget_mask) {e 		pstrcpy(mget_mask,cur_dir);t* 		if(mget_mask[strlen(mget_mask)-1]!='\\') 			pstrcat(mget_mask,"\\");u 		pstrcat(mget_mask,"*");*3 		do_list(mget_mask, attribute,do_mget,False,True);* 	} }     M /***************************************************************************** make a directory of name "name" M ****************************************************************************/f  static BOOL do_mkdir(char *name) {  	if (!cli_mkdir(cli, name)) {(- 		DEBUG(0,("%s making remote directory %s\n",)% 			 cli_errstr(cli),CNV_LANG(name)));  		return(False); 	}   	return(True); }c    M /****************************************************************************	
  Exit client. M ****************************************************************************/	 static void cmd_quit(void) {e 	cli_shutdown(cli);f	 	exit(0);  }     M /****************************************************************************r   make a directoryO   ****************************************************************************/* static void cmd_mkdir(void)d {i 	pstring mask;
 	fstring buf;i
 	char *p=buf;(   	pstrcpy(mask,cur_dir);   , 	if (!next_token(NULL,p,NULL,sizeof(buf))) { 		if (!recurse)c" 			DEBUG(0,("mkdir <dirname>\n"));	 		return;i 	} 	pstrcat(mask,p);h   	if (recurse) {a 		pstring ddir;	 		pstring ddir2;
 		*ddir2 = 0;    		pstrcpy(ddir,mask);  		trim_string(ddir,".",NULL);i 		p = strtok(ddir,"/\\"); 
 		while (p) {i 			pstrcat(ddir2,p);" 			if (!cli_chkpath(cli, ddir2)) { 				do_mkdir(ddir2); 			} 			pstrcat(ddir2,"\\");  			p = strtok(NULL,"/\\"); 		}m	 	} else {n 		do_mkdir(mask);l 	} }i    M /****************************************************************************    put a single file O   ****************************************************************************/e+ static void do_put(char *rname,char *lname)  {l
 	int fnum;	 	FILE *f;_
 	int nread=0;e 	char *buf=NULL; 	int maxwrite=io_bufsize;f   	struct timeval tp_start;	 	GetTimeOfDay(&tp_start);_  B 	fnum = cli_open(cli, rname, O_WRONLY|O_CREAT|O_TRUNC, DENY_NONE);   	if (fnum == -1) {K 		DEBUG(0,("%s opening remote file %s\n",cli_errstr(cli),CNV_LANG(rname)));-	 		return;) 	}  * 	/* allow files to be piped into smbclient 	   jdblair 24.jun.98 */ 	if (!strcmp(lname, "-")) {	 		f = stdin;! 		/* size of file is not known */(	 	} else {	 		f = sys_fopen(lname,"r");  	}  
 	if (!f) {3 		DEBUG(0,("Error opening local file %s\n",lname));,	 		return;l 	}    ) 	DEBUG(1,("putting file %s as %s ",lname,  		 CNV_LANG(rname)));;    	buf = (char *)malloc(maxwrite); 	while (!feof(f)) {  		int n = maxwrite;*
 		int ret;  & 		if ((n = readfile(buf,1,n,f)) < 1) {+ 			DEBUG(0,("Error reading local file\n"));*	 			break;* 		}*  / 		ret = cli_write(cli, fnum, 0, buf, nread, n);*   		if (n != ret) {i: 			DEBUG(0,("Error writing file: %s\n", cli_errstr(cli)));	 			break;m 		}   
 		nread += n;c 	}   	if (!cli_close(cli, fnum)) {tK 		DEBUG(0,("%s closing remote file %s\n",cli_errstr(cli),CNV_LANG(rname)));i 		fclose(f); 		if (buf) free(buf);e	 		return;  	}     	fclose(f);	 	if (buf) free(buf);   	{ 		struct timeval tp_end; 		int this_time;   		GetTimeOfDay(&tp_end);
 		this_time =_+ 			(tp_end.tv_sec - tp_start.tv_sec)*1000 + , 			(tp_end.tv_usec - tp_start.tv_usec)/1000;! 		put_total_time_ms += this_time;  		put_total_size += nread;  + 		DEBUG(1,("(%g kb/s) (average %g kb/s)\n",*' 			 nread / (1.024*this_time + 1.0e-4), 1 			 put_total_size / (1.024*put_total_time_ms)));* 	}   	if (f == stdin) { 		cli_shutdown(cli);
 		exit(0); 	} }       M /*****************************************************************************   put a fileO   ****************************************************************************/k static void cmd_put(void)( {L 	pstring lname;b 	pstring rname;o
 	fstring buf;(
 	char *p=buf;	   	pstrcpy(rname,cur_dir); 	pstrcat(rname,"\\");}  , 	if (!next_token(NULL,p,NULL,sizeof(buf))) {  		DEBUG(0,("put <filename>\n"));	 		return;_ 	} 	pstrcpy(lname,p);  ) 	if (next_token(NULL,p,NULL,sizeof(buf))); 		pstrcat(rname,p);* 	else* 		pstrcat(rname,lname);*   	dos_clean_name(rname);*   	{ 		SMB_STRUCT_STAT st; ! 		/* allow '-' to represent stdin* 		   jdblair, 24.jun.98 */ 		if (!file_exist(lname,&st) &&c 		    (strcmp(lname,"-"))) {* 			DEBUG(0,("%s does not exist\n",lname));
 			return; 		}  	}   	do_put(rname,lname);  }s    M /****************************************************************************=O   seek in a directory/file list until you get something that doesn't start with    the specified nameO   ****************************************************************************/t) static BOOL seek_list(FILE *f,char *name)) {p 	pstring s;  	while (!feof(f)) {m+ 		if (fscanf(f,"%s",s) != 1) return(False);s 		trim_string(s,"./",NULL);m* 		if (strncmp(s,name,strlen(name)) != 0) { 			pstrcpy(name,s);  			return(True); 		}( 	}   	return(False);  }e    M /****************************************************************************&   set the file selection maskUO   ****************************************************************************/  static void cmd_select(void) {e 	pstrcpy(fileselection,"");}; 	next_token(NULL,fileselection,NULL,sizeof(fileselection));e }d    M /****************************************************************************l   mput some files\O   ****************************************************************************/  static void cmd_mput(void) {r 	pstring lname;  	pstring rname;r
 	fstring buf;r
 	char *p=buf;d  . 	while (next_token(NULL,p,NULL,sizeof(buf))) { 		SMB_STRUCT_STAT st;d 		pstring cmd; 		pstring tmpname;
 		FILE *f;  % 		slprintf(tmpname,sizeof(pstring)-1,n+ 			 "%s/ls.smb.%d",tmpdir(),(int)getpid());  		if (recurse)" 			slprintf(cmd,sizeof(pstring)-1,2 				 "find . -name \"%s\" -print > %s",p,tmpname); 		else" 			slprintf(cmd,sizeof(pstring)-1," 				 "/bin/ls %s > %s",p,tmpname); 		system(cmd);   		f = sys_fopen(tmpname,"r");( 		if (!f) continue;l   		while (!feof(f)) { 			pstring quest;   ( 			if (fscanf(f,"%s",lname) != 1) break;  			trim_string(lname,"./",NULL);  	 		again1:h  " 			/* check if it's a directory */$ 			if (directory_exist(lname,&st)) { 				if (!recurse) continue;	% 				slprintf(quest,sizeof(pstring)-1,_" 					 "Put directory %s? ",lname);" 				if (prompt && !yesno(quest)) { 					pstrcat(lname,"/"); 					if (!seek_list(f,lname))e 						break; 					goto again1;  				}    				pstrcpy(rname,cur_dir);* 				pstrcat(rname,lname);*7 				if (!cli_chkpath(cli, rname) && !do_mkdir(rname)) {* 					pstrcat(lname,"/"); 					if (!seek_list(f,lname))* 						break; 					goto again1;  				}i
 				continue;t 			} else { # 				slprintf(quest,sizeof(quest)-1,; 					 "Put file %s? ",lname);=* 				if (prompt && !yesno(quest)) continue;   				pstrcpy(rname,cur_dir);e 				pstrcat(rname,lname);e 			}   			dos_format(rname);    			do_put(rname,lname);s 		}n 		fclose(f); 		unlink(tmpname); 	} }N    M /*****************************************************************************   cancel a print jobO   ****************************************************************************/* static void do_cancel(int job) {*" 	if (cli_printjob_del(cli, job)) {# 		printf("Job %d cancelled\n",job); 	 	} else {a? 		printf("Error calcelling job %d : %s\n",job,cli_errstr(cli));k 	} }i    M /****************************************************************************o   cancel a print jobO   ****************************************************************************/t static void cmd_cancel(void) {r
 	fstring buf;V	 	int job;-  . 	if (!next_token(NULL,buf,NULL,sizeof(buf))) {! 		printf("cancel <jobid> ...\n");f	 		return;) 	} 	do {p 		job = atoi(buf); 		do_cancel(job); 1 	} while (next_token(NULL,buf,NULL,sizeof(buf)));) }     M /****************************************************************************    print a fileO   ****************************************************************************/c static void cmd_print(void)o {t 	pstring lname;i 	pstring rname;		 	char *p;n  3 	if (!next_token(NULL,lname,NULL, sizeof(lname))) {L" 		DEBUG(0,("print <filename>\n"));	 		return;  	}   	pstrcpy(rname,lname); 	p = strrchr(rname,'/');	 	if (p) {)@ 		slprintf(rname, sizeof(rname)-1, "%s-%d", p+1, (int)getpid()); 	}   	if (strequal(lname,"-")) {(> 		slprintf(rname, sizeof(rname)-1, "stdin-%d", (int)getpid()); 	}   	do_put(rname, lname); };    M /****************************************************************************i  show a print queue entryDM ****************************************************************************/). static void queue_fn(struct print_job_info *p) {*E 	DEBUG(0,("%-6d   %-9d    %s\n", (int)p->id, (int)p->size, p->name));  }*  M /****************************************************************************c  show a print queue M ****************************************************************************/c static void cmd_queue(void)) {   	cli_print_queue(cli, queue_fn); })  M /****************************************************************************i delete some files,M ****************************************************************************/e$ static void do_del(file_info *finfo) {n 	pstring mask;   	pstrcpy(mask,cur_dir);p 	pstrcat(mask,finfo->name);p   	if (finfo->mode & aDIR)	 		return;	   	if (!cli_unlink(cli, mask)) {K 		DEBUG(0,("%s deleting remote file %s\n",cli_errstr(cli),CNV_LANG(mask)));* 	} }*  M /***************************************************************************** delete some files*M ****************************************************************************/  static void cmd_del(void)S {  	pstring mask;
 	fstring buf;,& 	uint16 attribute = aSYSTEM | aHIDDEN;  
 	if (recurse)i 		attribute |= aDIR;   	pstrcpy(mask,cur_dir);   . 	if (!next_token(NULL,buf,NULL,sizeof(buf))) {  		DEBUG(0,("del <filename>\n"));	 		return;f 	} 	pstrcat(mask,buf);s  - 	do_list(mask, attribute,do_del,False,False);f }p  M /****************************************************************************(M ****************************************************************************/p static void cmd_open(void) {e 	pstring mask;
 	fstring buf;\   	pstrcpy(mask,cur_dir);\  . 	if (!next_token(NULL,buf,NULL,sizeof(buf))) {  		DEBUG(0,("del <filename>\n"));	 		return;  	} 	pstrcat(mask,buf);*  ' 	cli_open(cli, mask, O_RDWR, DENY_ALL);* }*    M /***************************************************************************** remove a directoryM ****************************************************************************/n static void cmd_rmdir(void)n {e 	pstring mask;
 	fstring buf;_   	pstrcpy(mask,cur_dir);)  . 	if (!next_token(NULL,buf,NULL,sizeof(buf))) {! 		DEBUG(0,("rmdir <dirname>\n"));*	 		return;* 	} 	pstrcat(mask,buf);*   	if (!cli_rmdir(cli, mask)) {*4 		DEBUG(0,("%s removing remote directory file %s\n",% 			 cli_errstr(cli),CNV_LANG(mask)));i 	} }   M /***************************************************************************** rename some files*M ****************************************************************************/* static void cmd_rename(void) {* 	pstring src,dest; 	fstring buf,buf2;   	pstrcpy(src,cur_dir); 	pstrcpy(dest,cur_dir);   . 	if (!next_token(NULL,buf,NULL,sizeof(buf)) ||1 	    !next_token(NULL,buf2,NULL, sizeof(buf2))) {0% 		DEBUG(0,("rename <src> <dest>\n"));}	 		return;m 	}   	pstrcat(src,buf); 	pstrcat(dest,buf2);  # 	if (!cli_rename(cli, src, dest)) {s3 		DEBUG(0,("%s renaming files\n",cli_errstr(cli)));		 		return;d 	} }\    M /****************************************************************************	 toggle the prompt flagM ****************************************************************************/d static void cmd_prompt(void) {* 	prompt = !prompt;6 	DEBUG(2,("prompting is now %s\n",prompt?"on":"off")); }i    M /***************************************************************************** set the newer than timepM ****************************************************************************/  static void cmd_newer(void)b {i
 	fstring buf; 	 	BOOL ok;s 	SMB_STRUCT_STAT sbuf;  , 	ok = next_token(NULL,buf,NULL,sizeof(buf));( 	if (ok && (dos_stat(buf,&sbuf) == 0)) { 		newer_than = sbuf.st_mtime;e) 		DEBUG(1,("Getting files newer than %s",L& 			 asctime(LocalTime(&newer_than))));	 	} else {o 		newer_than = 0;l 	}   	if (ok && newer_than == 0) / 		DEBUG(0,("Error setting newer-than time\n"));  }f  M /****************************************************************************  set the archive levelnM ****************************************************************************/  static void cmd_archive(void)) {;
 	fstring buf;r  - 	if (next_token(NULL,buf,NULL,sizeof(buf))) {  		archive_level = atoi(buf); 	} else=3 		DEBUG(0,("Archive level is %d\n",archive_level));i }l  M /****************************************************************************  toggle the lowercaseflagM ****************************************************************************/  static void cmd_lowercase(void)_ {s 	lowercase = !lowercase;D 	DEBUG(2,("filename lowercasing is now %s\n",lowercase?"on":"off")); }c        M /****************************************************************************; toggle the recurse flagtM ****************************************************************************/d static void cmd_recurse(void)  {  	recurse = !recurse;A 	DEBUG(2,("directory recursion is now %s\n",recurse?"on":"off"));o }_  M /****************************************************************************4 toggle the translate flag M ****************************************************************************/_ static void cmd_translate(void)  {  	translation = !translation;; 	DEBUG(2,("CR/LF<->LF and print text translation now %s\n",  		 translation?"on":"off")); }*    M /****************************************************************************L do a printmode commandM ****************************************************************************/c static void cmd_printmode(void)k {N
 	fstring buf;o 	fstring mode;  - 	if (next_token(NULL,buf,NULL,sizeof(buf))) {t 		if (strequal(buf,"text")) {e 			printmode = 0;f
 		} else {  			if (strequal(buf,"graphics")) 				printmode = 1; 			elsee 				printmode = atoi(buf); 		}U 	}   	switch(printmode) 		{ 	 		case 0:t 			fstrcpy(mode,"text");	 			break;f	 		case 1:s 			fstrcpy(mode,"graphics");	 			break;)
 		default:0 			slprintf(mode,sizeof(mode)-1,"%d",printmode);	 			break;  		}u  - 	DEBUG(2,("the printmode is now %s\n",mode));* }*  M /****************************************************************************s do the lcd commandM ****************************************************************************/* static void cmd_lcd(void)* {*
 	fstring buf;* 	pstring d;c  + 	if (next_token(NULL,buf,NULL,sizeof(buf)))i
 		chdir(buf);(; 	DEBUG(2,("the local directory is now %s\n",sys_getwd(d)));	 }m  M /****************************************************************************m list a share namerM ****************************************************************************/*F static void browse_fn(const char *name, uint32 m, const char *comment) {          fstring typestr;           *typestr=0;*           switch (m)	         {t           case STYPE_DISKTREE:+             fstrcpy(typestr,"Disk"); break;L           case STYPE_PRINTQ:.             fstrcpy(typestr,"Printer"); break;           case STYPE_DEVICE:-             fstrcpy(typestr,"Device"); break;            case STYPE_IPC:**             fstrcpy(typestr,"IPC"); break;	         }t  (         printf("\t%-15.15s%-10.10s%s\n",&                name, typestr,comment); }p    M /****************************************************************************	. try and browse available connections on a hostM ****************************************************************************/(" static BOOL browse_host(BOOL sort) {i9         printf("\n\tSharename      Type      Comment\n");t7         printf("\t---------      ----      -------\n");	  * 	return cli_RNetShareEnum(cli, browse_fn); }   M /****************************************************************************p list a server nameM ****************************************************************************/gF static void server_fn(const char *name, uint32 m, const char *comment) {&5         printf("\t%-16.16s     %s\n", name, comment);t }z  M /****************************************************************************e. try and browse available connections on a hostM ****************************************************************************/,& static BOOL list_servers(char *wk_grp) {	' 	if (!cli->server_domain) return False;(  5         printf("\n\tServer               Comment\n");(3         printf("\t---------            -------\n");   D 	cli_NetServerEnum(cli, cli->server_domain, SV_TYPE_ALL, server_fn);  4         printf("\n\tWorkgroup            Master\n");3         printf("\t---------            -------\n");s  L 	cli_NetServerEnum(cli, cli->server_domain, SV_TYPE_DOMAIN_ENUM, server_fn);
 	return True;e };   #if defined(HAVE_LIBREADLINE) A #  if defined(HAVE_READLINE_HISTORY_H) || defined(HAVE_HISTORY_H)*M /***************************************************************************** history*M ****************************************************************************/_ static void cmd_history(void)  {c 	HIST_ENTRY **hlist; 	register int i;  ; 	hlist = history_list ();	/* Get pointer to history list */i  % 	if (hlist)			/* If list not empty */* 	{2 		for (i = 0; hlist[i]; i++)	/* then display it */- 			DEBUG(0, ("%d: %s\n", i, hlist[i]->line));* 	} }* #  endif #endif  6 /* Some constants for completing filename arguments */  9 #define COMPL_NONE        0          /* No completions */(C #define COMPL_REMOTE      1          /* Complete remote filename */ B #define COMPL_LOCAL       2          /* Complete local filename */  8 /* This defines the commands supported by this client */ struct {*
   char *name;*   void (*fn)(void);    char *description;9   char compl_args[2];      /* Completion argument info */* } commands[] = {t_   {"ls",cmd_dir,"<mask> list the contents of the current directory",{COMPL_REMOTE,COMPL_NONE}},n`   {"dir",cmd_dir,"<mask> list the contents of the current directory",{COMPL_REMOTE,COMPL_NONE}},d   {"du",cmd_du,"<mask> computes the total size of the current directory",{COMPL_REMOTE,COMPL_NONE}},k   {"lcd",cmd_lcd,"[directory] change/report the local current working directory",{COMPL_LOCAL,COMPL_NONE}},e[   {"cd",cmd_cd,"[directory] change/report the remote directory",{COMPL_REMOTE,COMPL_NONE}},*f   {"pwd",cmd_pwd,"show current remote directory (same as 'cd' with no args)",{COMPL_NONE,COMPL_NONE}},U   {"get",cmd_get,"<remote name> [local name] get a file",{COMPL_REMOTE,COMPL_LOCAL}},*R   {"mget",cmd_mget,"<mask> get all the matching files",{COMPL_REMOTE,COMPL_NONE}},U   {"put",cmd_put,"<local name> [remote name] put a file",{COMPL_LOCAL,COMPL_REMOTE}},nN   {"mput",cmd_mput,"<mask> put all matching files",{COMPL_REMOTE,COMPL_NONE}},U   {"rename",cmd_rename,"<src> <dest> rename some files",{COMPL_REMOTE,COMPL_REMOTE}},*a   {"more",cmd_more,"<remote name> view a remote file with your pager",{COMPL_REMOTE,COMPL_NONE}},*Y   {"mask",cmd_select,"<mask> mask all filenames against this",{COMPL_REMOTE,COMPL_NONE}},dO   {"del",cmd_del,"<mask> delete all matching files",{COMPL_REMOTE,COMPL_NONE}},sC   {"open",cmd_open,"<mask> open a file",{COMPL_REMOTE,COMPL_NONE}},_N   {"rm",cmd_del,"<mask> delete all matching files",{COMPL_REMOTE,COMPL_NONE}},M   {"mkdir",cmd_mkdir,"<directory> make a directory",{COMPL_NONE,COMPL_NONE}},*J   {"md",cmd_mkdir,"<directory> make a directory",{COMPL_NONE,COMPL_NONE}},O   {"rmdir",cmd_rmdir,"<directory> remove a directory",{COMPL_NONE,COMPL_NONE}}, L   {"rd",cmd_rmdir,"<directory> remove a directory",{COMPL_NONE,COMPL_NONE}},c   {"prompt",cmd_prompt,"toggle prompting for filenames for mget and mput",{COMPL_NONE,COMPL_NONE}},za   {"recurse",cmd_recurse,"toggle directory recursion for mget and mput",{COMPL_NONE,COMPL_NONE}},s]   {"translate",cmd_translate,"toggle text translation for printing",{COMPL_NONE,COMPL_NONE}},*`   {"lowercase",cmd_lowercase,"toggle lowercasing of filenames for get",{COMPL_NONE,COMPL_NONE}},I   {"print",cmd_print,"<file name> print a file",{COMPL_NONE,COMPL_NONE}},p^   {"printmode",cmd_printmode,"<graphics or text> set the print mode",{COMPL_NONE,COMPL_NONE}},E   {"queue",cmd_queue,"show the print queue",{COMPL_NONE,COMPL_NONE}},,U   {"cancel",cmd_cancel,"<jobid> cancel a print queue entry",{COMPL_NONE,COMPL_NONE}},*@   {"quit",cmd_quit,"logoff the server",{COMPL_NONE,COMPL_NONE}},=   {"q",cmd_quit,"logoff the server",{COMPL_NONE,COMPL_NONE}},v@   {"exit",cmd_quit,"logoff the server",{COMPL_NONE,COMPL_NONE}},l   {"newer",cmd_newer,"<file> only mget files newer than the specified local file",{COMPL_LOCAL,COMPL_NONE}},   {"archive",cmd_archive,"<level>\n0=ignore archive bit\n1=only get archive files\n2=only get archive files and reset archive bit\n3=get all files and reset archive bit",{COMPL_NONE,COMPL_NONE}},*g   {"tar",cmd_tar,"tar <c|x>[IXFqbgNan] current directory to/from <file name>",{COMPL_NONE,COMPL_NONE}},*T   {"blocksize",cmd_block,"blocksize <number> (default 20)",{COMPL_NONE,COMPL_NONE}},   {"tarmode",cmd_tarmode,f^      "<full|inc|reset|noreset> tar's behaviour towards archive bits",{COMPL_NONE,COMPL_NONE}},e   {"setmode",cmd_setmode,"filename <setmode string> change modes of file",{COMPL_REMOTE,COMPL_NONE}},}O   {"help",cmd_help,"[command] give help on a command",{COMPL_NONE,COMPL_NONE}},cL   {"?",cmd_help,"[command] give help on a command",{COMPL_NONE,COMPL_NONE}}, #ifdef HAVE_LIBREADLINE*Q   {"history",cmd_history,"displays the command history",{COMPL_NONE,COMPL_NONE}},e #endifO   {"!",NULL,"run a shell command on the local system",{COMPL_NONE,COMPL_NONE}},*(   {"",NULL,NULL,{COMPL_NONE,COMPL_NONE}} };    D /*******************************************************************<   lookup a command string in the list of commands, including   abbreviations*E   ******************************************************************/*# static int process_tok(fstring tok)t {c 	int i = 0, matches = 0; 	int cmd=0;f 	int tok_len = strlen(tok);T  ! 	while (commands[i].fn != NULL) {,' 		if (strequal(commands[i].name,tok)) {b 			matches = 1;{ 			cmd = i;n	 			break;m9 		} else if (strnequal(commands[i].name, tok, tok_len)) {t
 			matches++;n 			cmd = i;; 		}e 		i++; 	}   	if (matches == 0)
 		return(-1);r 	else if (matches == 1)" 		return(cmd); 	elsen
 		return(-2);f }   M /****************************************************************************e helpM ****************************************************************************/* static void cmd_help(void) {_ 	int i=0,j;)
 	fstring buf;b  - 	if (next_token(NULL,buf,NULL,sizeof(buf))) {)" 		if ((i = process_tok(buf)) >= 0)L 			DEBUG(0,("HELP %s:\n\t%s\n\n",commands[i].name,commands[i].description));	 	} else {*# 		while (commands[i].description) {*5 			for (j=0; commands[i].description && (j<5); j++) {*( 				DEBUG(0,("%-15s",commands[i].name)); 				i++; 			} 			DEBUG(0,("\n"));v 		}m 	} }c   #ifndef HAVE_LIBREADLINEM /****************************************************************************)6 wait for keyboard activity, swallowing network packetsM ****************************************************************************/* static void wait_keyboard(void)* {* 	fd_set fds; 	struct timeval timeout;   	while (1) { 		FD_ZERO(&fds); 		FD_SET(cli->fd,&fds);r 		FD_SET(fileno(stdin),&fds);e   		timeout.tv_sec = 20; 		timeout.tv_usec = 0;9 		sys_select(MAX(cli->fd,fileno(stdin))+1,&fds,&timeout);o  # 		if (FD_ISSET(fileno(stdin),&fds))*
 			return;  / 		/* We deliberately use receive_smb instead of_- 		   client_receive_smb as we want to receivea0 		   session keepalives and then drop them here. 		*/ 		if (FD_ISSET(cli->fd,&fds))t% 			receive_smb(cli->fd,cli->inbuf,0);*   		cli_chkpath(cli, "\\");* 	} }* #endif  M /***************************************************************************** process a -c command string*M ****************************************************************************/i- static void process_command_string(char *cmd)f {f 	pstring line; 	char *ptr;e   	while (cmd[0] != '\0')    {
 		char *p; 		fstring tok; 		int i;  $ 		if ((p = strchr(cmd, ';')) == 0) { 			strncpy(line, cmd, 999);  			line[1000] = '\0';) 			cmd += strlen(cmd);
 		} else {$ 			if (p - cmd > 999) p = cmd + 999; 			strncpy(line, cmd, p - cmd);k 			line[p - cmd] = '\0'; 			cmd = p + 1;e 		}%  + 		/* input language code to internal one */t 		CNV_INPUT (line);s  - 		/* and get the first part of the command */*
 		ptr = line;*7 		if (!next_token(&ptr,tok,NULL,sizeof(tok))) continue;*  $ 		if ((i = process_tok(tok)) >= 0) { 			commands[i].fn(); 		} else if (i == -2) { C 			DEBUG(0,("%s: command abbreviation ambiguous\n",CNV_LANG(tok)));U
 		} else {6 			DEBUG(0,("%s: command not found\n",CNV_LANG(tok))); 		}y 	} }   M /***************************************************************************** process commands on stdin M ****************************************************************************/* static void process_stdin(void)r {e 	pstring line; 	char *ptr;m   #ifdef HAVE_LIBREADLINE C /* Minimal readline support, 29Jun1999, s.xenitellis@rhbnc.ac.uk */) 	const int PromptSize = 2048;YI 	char prompt_str[PromptSize];	/* This holds the buffer "smb: \dir1\> " */S  ;         char *temp;			/* Gets the buffer from readline() */  	temp = (char *)NULL;C #endif 	while (!feof(stdin)) {D 		fstring tok; 		int i; #ifdef HAVE_LIBREADLINE  		if ( temp != (char *)NULL )r 		{ E 			free( temp );	/* Free memory allocated every time by readline() */n 			temp = (char *)NULL;p 		}   I 		snprintf( prompt_str, PromptSize - 1, "smb: %s> ", CNV_LANG(cur_dir) );	  = 		temp = readline( prompt_str );		/* We read the line here */*   		if ( !temp ) 			break;		/* EOF occured */  8 		if ( *temp )		/* If non-empty line, save to history */ 			add_history (temp);  X 		strncpy( line, temp, 1023 ); /* Maximum size of (pstring)line. Null is guarranteed. */ #else  		/* display a prompt */, 		DEBUG(0,("smb: %s> ", CNV_LANG(cur_dir))); 		dbgflush( );   		wait_keyboard();   		/* and get a response */ 		if (!fgets(line,1000,stdin))	 			break;* #endif  + 		/* input language code to internal one */r 		CNV_INPUT (line);   & 		/* special case - first char is ! */ 		if (*line == '!') {  			system(line + 1); 			continue; 		}*  - 		/* and get the first part of the command */*
 		ptr = line;*7 		if (!next_token(&ptr,tok,NULL,sizeof(tok))) continue;*  $ 		if ((i = process_tok(tok)) >= 0) { 			commands[i].fn(); 		} else if (i == -2) {iC 			DEBUG(0,("%s: command abbreviation ambiguous\n",CNV_LANG(tok)));(
 		} else {6 			DEBUG(0,("%s: command not found\n",CNV_LANG(tok))); 		}f 	} }-    6 /***************************************************** return a connection to a serverr8 *******************************************************/7 struct cli_state *do_connect(char *server, char *share)) {  	struct cli_state *c;i! 	struct nmb_name called, calling;N 	char *server_n; 	struct in_addr ip;  	extern struct in_addr ipzero;   	if (*share == '\\') { 		server = share+2;i 		share = strchr(server,'\\'); 		if (!share) return NULL;
 		*share = 0;*
 		share++; 	}   	server_n = server;*  
 	ip = ipzero;*  1 	make_nmb_name(&calling, global_myname, 0x0, "");*0 	make_nmb_name(&called , server, name_type, "");    again: 
 	ip = ipzero;; 	if (have_ip) ip = dest_ip;	  $ 	/* have to open a new connection */A 	if (!(c=cli_initialise(NULL)) || (cli_set_port(c, port) == 0) ||+& 	    !cli_connect(c, server_n, &ip)) {3 		DEBUG(0,("Connection to %s failed\n", server_n));e 		return NULL; 	}  2 	if (!cli_session_request(c, &calling, &called)) {
 		char *p;1 		DEBUG(0,("session request to %s failed (%s)\n",P! 			 called.name, cli_errstr(c)));e 		cli_shutdown(c);% 		if ((p=strchr(called.name, '.'))) {/
 			*p = 0; 			goto again; 		}** 		if (strcmp(called.name, "*SMBSERVER")) {3 			make_nmb_name(&called , "*SMBSERVER", 0x20, "");v 			goto again; 		}i 		return NULL; 	}  $ 	DEBUG(4,(" session request ok\n"));   	if (!cli_negprot(c)) { - 		DEBUG(0,("protocol negotiation failed\n"));e 		cli_shutdown(c); 		return NULL; 	}   	if (!got_pass) {d% 		char *pass = getpass("Password: ");u
 		if (pass) {" 			pstrcpy(password, pass);  		}u 	}  $ 	if (!cli_session_setup(c, username,% 			       password, strlen(password),M% 			       password, strlen(password),y 			       workgroup)) { 9 		DEBUG(0,("session setup failed: %s\n", cli_errstr(c)));" 		return NULL; 	}   	/*n. 	 * These next two lines are needed to emulate, 	 * old client behaviour for people who have# 	 * scripts based on client output. 9 	 * QUESTION ? Do we want to have a 'client compatibility $ 	 * mode to turn these on/off ? JRA. 	 */  ; 	if (*c->server_domain || *c->server_os || *c->server_type)n/ 		DEBUG(1,("Domain=[%s] OS=[%s] Server=[%s]\n",d2 			c->server_domain,c->server_os,c->server_type));  " 	DEBUG(4,(" session setup ok\n"));  ' 	if (!cli_send_tconX(c, share, "?????",_' 			    password, strlen(password)+1)) {a8 		DEBUG(0,("tree connect failed: %s\n", cli_errstr(c))); 		cli_shutdown(c); 		return NULL; 	}   	DEBUG(4,(" tconx ok\n"));  
 	return c; }R    M /****************************************************************************,"   process commands from the clientM ****************************************************************************/") static BOOL process(char *base_directory)R {T% 	cli = do_connect(desthost, service);k 	if (!cli) { 		return(False); 	}  , 	if (*base_directory) do_cd(base_directory);   	if (cmdstr) {! 		process_command_string(cmdstr); 	 	} else {_ 		process_stdin(); 	}   	cli_shutdown(cli);E 	return(True); }"  M /****************************************************************************" usage on the programM ****************************************************************************/g static void usage(char *pname) { =   DEBUG(0,("Usage: %s service <password> [options]", pname));"  &   DEBUG(0,("\nVersion %s\n",VERSION));C   DEBUG(0,("\t-s smb.conf           pathname to smb.conf file\n"));t?   DEBUG(0,("\t-O socket_options     socket options to use\n"));eQ   DEBUG(0,("\t-R name resolve order use these name resolution services only\n"));NM   DEBUG(0,("\t-M host               send a winpopup message to the host\n"));p@   DEBUG(0,("\t-i scope              use this NetBIOS scope\n"));B   DEBUG(0,("\t-N                    don't ask for a password\n"));J   DEBUG(0,("\t-n netbios name.      Use this name as my netbios name\n"));<   DEBUG(0,("\t-d debuglevel         set the debuglevel\n"));I   DEBUG(0,("\t-P                    connect to service as a printer\n")); G   DEBUG(0,("\t-p port               connect to the specified port\n"));rF   DEBUG(0,("\t-l log basename.      Basename for log/debug files\n"));B   DEBUG(0,("\t-h                    Print this help message.\n"));C   DEBUG(0,("\t-I dest IP            use this IP to connect to\n")); T   DEBUG(0,("\t-E                    write messages to stderr instead of stdout\n"));B   DEBUG(0,("\t-U username           set the network username\n"));R   DEBUG(0,("\t-L host               get a list of shares available on a host\n"));Z   DEBUG(0,("\t-t terminal code      terminal i/o code {sjis|euc|jis7|jis8|junet|hex}\n"));D   DEBUG(0,("\t-m max protocol       set the max protocol level\n"));@   DEBUG(0,("\t-W workgroup          set the workgroup name\n"));:   DEBUG(0,("\t-T<c|x>IXFqgbNan      command line tar\n"));>   DEBUG(0,("\t-D directory          start from directory\n"));N   DEBUG(0,("\t-c command string     execute semicolon separated commands\n"));[   DEBUG(0,("\t-b xmit/send buffer   changes the transmit/send buffer (default: 65520)\n"));i   DEBUG(0,("\n")); }o    M /****************************************************************************a/ get a password from a a file or file descriptorN exit on failureOM ****************************************************************************/*# static void get_password_file(void)n {e
 	int fd = -1;d	 	char *p;g 	BOOL close_it = False;* 	pstring spec; 	char pass[128];  ) 	if ((p = getenv("PASSWD_FD")) != NULL) {o 		pstrcpy(spec, "descriptor ");i 		pstrcat(spec, p);i 		sscanf(p, "%d", &fd);= 		close_it = False;i2 	} else if ((p = getenv("PASSWD_FILE")) != NULL) {  		fd = sys_open(p, O_RDONLY, 0); 		pstrcpy(spec, p);	 		if (fd < 0) {e8 			fprintf(stderr, "Error opening PASSWD_FILE %s: %s\n", 				spec, strerror(errno));  			exit(1);  		}m 		close_it = True; 	}  C 	for(p = pass, *p = '\0'; /* ensure that pass is null-terminated */ % 	    p && p - pass < sizeof(pass);) {* 		switch (read(fd, p, 1)) {*	 		case 1:*" 			if (*p != '\n' && *p != '\0') {9 				*++p = '\0'; /* advance p, and null-terminate pass */c
 				break; 			}	 		case 0:t 			if (p - pass) {7 				*p = '\0'; /* null-terminate it, just in case... */	A 				p = NULL; /* then force the loop condition to become false */c
 				break; 			} else {i@ 				fprintf(stderr, "Error reading password from file %s: %s\n", 					spec, "empty password\n");p 				exit(1); 			}  
 		default:? 			fprintf(stderr, "Error reading password from file %s: %s\n",) 				spec, strerror(errno));A 			exit(1);E 		}* 	} 	pstrcpy(password, pass);* 	if (close_it) 		close(fd); }*      M /***************************************************************************** handle a -L query*M ****************************************************************************/f* static int do_host_query(char *query_host) {(& 	cli = do_connect(query_host, "IPC$");
 	if (!cli) 		return 1;(   	browse_host(True);e 	list_servers(workgroup);.   	cli_shutdown(cli);e   	return(0);f }n    M /****************************************************************************  handle a tar operationM ****************************************************************************/s* static int do_tar_op(char *base_directory) {/	 	int ret;I% 	cli = do_connect(desthost, service);i
 	if (!cli) 		return 1;	   	recurse=True;  , 	if (*base_directory) do_cd(base_directory);   	ret=process_tar();*   	cli_shutdown(cli);*  
 	return(ret);  }c  M /***************************************************************************** handle a message operationM ****************************************************************************/( static int do_message_op(void) {	 	struct in_addr ip;;! 	struct nmb_name called, calling;   
 	ip = ipzero;l  1 	make_nmb_name(&calling, global_myname, 0x0, "");t2 	make_nmb_name(&called , desthost, name_type, "");  
 	ip = ipzero;c 	if (have_ip) ip = dest_ip;l  G 	if (!(cli=cli_initialise(NULL)) || !cli_connect(cli, desthost, &ip)) { 3 		DEBUG(0,("Connection to %s failed\n", desthost));t 		return 1;r 	}  4 	if (!cli_session_request(cli, &calling, &called)) {( 		DEBUG(0,("session request failed\n")); 		cli_shutdown(cli); 		return 1;	 	}   	send_message(); 	cli_shutdown(cli);   
 	return 0; }c    M /****************************************************************************m   main programM ****************************************************************************/*   int main(int argc,char *argv[]) {r 	fstring base_directory; 	char *pname = argv[0];*	 	int opt;* 	extern FILE *dbf; 	extern char *optarg;t 	extern int optind;i 	pstring query_host; 	BOOL message = False; 	BOOL explicit_user = False; 	extern char tar_type;' 	static pstring servicesf = CONFIGFILE;  	pstring term_code;   	pstring new_name_resolve_order;	 	char *p;i   #ifdef KANJI 	pstrcpy(term_code, KANJI);  #else /* KANJI */* 	*term_code = 0; #endif /* KANJI */   	*query_host = 0;C 	*base_directory = 0;(   	*new_name_resolve_order = 0;    	DEBUGLEVEL = 2;   #ifdef HAVE_LIBREADLINEh8 	/* Allow conditional parsing of the ~/.inputrc file. */  	rl_readline_name = "smbclient"; #endif 	setup_logging(pname,True);n   	/* ? 	 * If the -E option is given, be careful not to clobber stdout @ 	 * before processing the options.  28.Feb.99, richard@hacom.nl.> 	 * Also pre-parse the -s option to get the service file name. 	 */  # 	for (opt = 1; opt < argc; opt++) {a# 		if (strcmp(argv[opt], "-E") == 0), 			dbf = stderr;- 		else if(strncmp(argv[opt], "-s", 2) == 0) {e 			if(argv[opt][2] != '\0')a& 				pstrcpy(servicesf, &argv[opt][2]);! 			else if(argv[opt+1] != NULL) {  				/*" 				 * At least one more arg left. 				 */f$ 				pstrcpy(servicesf, argv[opt+1]); 			} else {	 				usage(pname);o 				exit(1); 			} 		}	 	}   	TimeInit(); 	charset_initialise();  @ 	in_client = True;   /* Make sure that we tell lp_load we are */  , 	if (!lp_load(servicesf,True,False,False)) {K 		fprintf(stderr, "Can't load %s - run testparm to debug it\n", servicesf);) 	}  , 	codepage_initialise(lp_client_code_page());   #ifdef WITH_SSL( 	sslutil_init(0);= #endif  # 	pstrcpy(workgroup,lp_workgroup());    	load_interfaces();o 	myumask = umask(0); 	umask(myumask);   	if (getenv("USER")) {# 		pstrcpy(username,getenv("USER"));*  A 		/* modification to support userid%passwd syntax in the USER vara" 		   25.Aug.97, jdblair@uab.edu */  ! 		if ((p=strchr(username,'%'))) {t
 			*p = 0; 			pstrcpy(password,p+1);a 			got_pass = True;c= 			memset(strchr(getenv("USER"),'%')+1,'X',strlen(password));r 		}; 		strupper(username);  	}  4 	/* modification to support PASSWD environmental var! 	   25.Aug.97, jdblair@uab.edu */r 	if (getenv("PASSWD")) {% 		pstrcpy(password,getenv("PASSWD"));r 		got_pass = True; 	}  4 	if (getenv("PASSWD_FD") || getenv("PASSWD_FILE")) { 		get_password_file(); 		got_pass = True; 	}  + 	if (*username == 0 && getenv("LOGNAME")) {p& 		pstrcpy(username,getenv("LOGNAME")); 		strupper(username);c 	}   	if (*username == 0) { 		pstrcpy(username,"GUEST"); 	}   	if (argc < 2) { 		usage(pname);,
 		exit(1); 	}   	if (*argv[1] != '-') {t 		pstrcpy(service,argv[1]); H 		/* Convert any '/' characters in the service name to '\' characters */% 		string_replace( service, '/','\\'); 	 		argc--;d	 		argv++;   & 		if (count_chars(service,'\\') < 3) { 			usage(pname);C 			printf("\n%s: Not enough '\\' characters in service\n",service);  			exit(1);c 		}.  & 		if (argc > 1 && (*argv[1] != '-')) { 			got_pass = True;, 			pstrcpy(password,argv[1]);	' 			memset(argv[1],'X',strlen(argv[1]));s
 			argc--;
 			argv++; 		}! 	}   	while ((opt =L 		getopt(argc, argv,"s:O:R:M:i:Nn:d:Pp:l:hI:EU:L:t:m:W:T:D:c:b:")) != EOF) { 		switch (opt) { 		case 's':	 			pstrcpy(servicesf, optarg);	 			break;( 		case 'O':p' 			pstrcpy(user_socket_options,optarg); 	 			break;o 		case 'R':e+ 			pstrcpy(new_name_resolve_order, optarg);M	 			break;  		case 'M':lE 			name_type = 0x03; /* messages are sent to NetBIOS name type 0x3 */l 			pstrcpy(desthost,optarg); 			message = True;	 			break;  		case 'i':o 			pstrcpy(scope,optarg);e	 			break;l 		case 'N':r 			got_pass = True; 	 			break;  		case 'n':n! 			pstrcpy(global_myname,optarg);n	 			break;  		case 'd':t 			if (*optarg == 'A') 				DEBUGLEVEL = 10000;  			else  				DEBUGLEVEL = atoi(optarg);	 			break;s 		case 'P':  			/* not needed anymore */s	 			break;s 		case 'p':> 			port = atoi(optarg);s	 			break;t 		case 'l':B9 			slprintf(debugf,sizeof(debugf)-1, "%s.client",optarg);h	 			break;" 		case 'h':s 			usage(pname); 			exit(0); 	 			break;" 		case 'I':f 			{' 				dest_ip = *interpret_addr2(optarg);c 				if (zero_ip(dest_ip))D
 					exit(1);  				have_ip = True;; 			}	 			break;* 		case 'E':* 			dbf = stderr;	 			break;* 		case 'U':* 			{
 				char *lp;s 				explicit_user = True;  				pstrcpy(username,optarg);*$ 				if ((lp=strchr(username,'%'))) {
 					*lp = 0;c 					pstrcpy(password,lp+1); 					got_pass = True;o7 					memset(strchr(optarg,'%')+1,'X',strlen(password));; 				}  			}	 			break;o 		case 'L':e 			p = optarg;! 			while(*p == '\\' || *p == '/')t 				p++; 			pstrcpy(query_host,p);_   			if(!explicit_user)d 				*username = '\0';e	 			break;* 		case 't':* 			pstrcpy(term_code, optarg);	 			break;* 		case 'm':* 			/* no longer supported */	 			break;* 		case 'W':* 			pstrcpy(workgroup,optarg);*	 			break;* 		case 'T':c4 			if (!tar_parseargs(argc, argv, optarg, optind)) { 				usage(pname);p 				exit(1); 			}	 			break;, 		case 'D':s" 			pstrcpy(base_directory,optarg);	 			break;  		case 'c':t 			cmdstr = optarg;t 			got_pass = True;c	 			break;  		case 'b':t% 			io_bufsize = MAX(1, atoi(optarg));m	 			break;r
 		default: 			usage(pname); 			exit(1);\ 		}N 	}  1 	get_myname((*global_myname)?NULL:global_myname);s   	if(*new_name_resolve_order)4 		lp_set_name_resolve_order(new_name_resolve_order);   	if (*term_code)% 		interpret_coding_system(term_code);s  : 	if (!tar_type && !*query_host && !*service && !message) { 		usage(pname);e
 		exit(1); 	}  ; 	DEBUG( 3, ( "Client started (version %s).\n", VERSION ) );,   	if (tar_type) {# 		return do_tar_op(base_directory);\ 	}  " 	if ((p=strchr(query_host,'#'))) {	 		*p = 0;o 		p++; 		sscanf(p, "%x", &name_type); 	}   	if (*query_host) {e# 		return do_host_query(query_host);U 	}   	if (message) {  		return do_message_op();g 	}    	if (!process(base_directory)) { 		return(1); 	}   	return(0);" } 