 /*#    Unix SMB/Netbios implementation.     Version 1.9.     Samba utility functions*    Copyright (C) Andrew Tridgell 1992-19988    Copyright (C) Luke Kenneth Caseson Leighton 1998-1999%    Copyright (C) Jeremy Allison  1999   G    This program is free software; you can redistribute it and/or modify G    it under the terms of the GNU General Public License as published by D    the Free Software Foundation; either version 2 of the License, or&    (at your option) any later version.  B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software<    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */   #include "includes.h"      extern int DEBUGLEVEL; DOM_SID global_sam_sid;  extern pstring global_myname; " extern fstring global_myworkgroup;   /*  * Some useful sids   */   < DOM_SID global_sid_S_1_5_0x20; /* local well-known domain */2 DOM_SID global_sid_World_Domain;    /* everyone */+ DOM_SID global_sid_World;    /* everyone */ ? DOM_SID global_sid_Creator_Owner_Domain;    /* Creator Owner */ 8 DOM_SID global_sid_Creator_Owner;    /* Creator Owner */6 DOM_SID global_sid_NT_Authority;    /* NT Authority */  ! typedef struct _known_sid_users {  	uint32 rid; 	uint8 sid_name_use; 	char *known_user_name;  } known_sid_users;  9 /* static known_sid_users no_users[] = {{0, 0, NULL}}; */ ^ static known_sid_users everyone_users[] = {{ 0, SID_NAME_WKN_GRP, "Everyone" }, {0, 0, NULL}};f static known_sid_users creator_owner_users[] = {{ 0, SID_NAME_ALIAS, "Creator Owner" }, {0, 0, NULL}};O static known_sid_users nt_authority_users[] = {{ 1, SID_NAME_ALIAS, "Dialup" }, . 											   { 2, SID_NAME_ALIAS, "Network"},, 											   { 3, SID_NAME_ALIAS, "Batch"},2 											   { 4, SID_NAME_ALIAS, "Interactive"},. 											   { 6, SID_NAME_ALIAS, "Service"},5 											   { 7, SID_NAME_ALIAS, "AnonymousLogon"}, , 											   { 8, SID_NAME_ALIAS, "Proxy"},2 											   { 9, SID_NAME_ALIAS, "ServerLogon"}, 											   {0, 0, NULL}};   static struct sid_name_map_info  {  	DOM_SID *sid; 	char *name; 	known_sid_users *known_users; }  sid_name_map[] = { ) 	{ &global_sam_sid, global_myname, NULL}, . 	{ &global_sam_sid, global_myworkgroup, NULL},, 	{ &global_sid_S_1_5_0x20, "BUILTIN", NULL},6 	{ &global_sid_World_Domain, "", &everyone_users[0] },C 	{ &global_sid_Creator_Owner_Domain, "", &creator_owner_users[0] }, F 	{ &global_sid_NT_Authority, "NT Authority", &nt_authority_users[0] }, 	{ NULL, NULL, NULL} };  M /**************************************************************************** $  Creates some useful well known sidsM ****************************************************************************/   " void generate_wellknown_sids(void) { 3 	string_to_sid(&global_sid_S_1_5_0x20, "S-1-5-32"); 2 	string_to_sid(&global_sid_World_Domain, "S-1-1");- 	string_to_sid(&global_sid_World, "S-1-1-0"); : 	string_to_sid(&global_sid_Creator_Owner_Domain, "S-1-3");5 	string_to_sid(&global_sid_Creator_Owner, "S-1-3-0"); 2 	string_to_sid(&global_sid_NT_Authority, "S-1-5"); }   K /************************************************************************** D  Turns a domain SID into a name, returned in the nt_domain argument.L ***************************************************************************/  : BOOL map_domain_sid_to_name(DOM_SID *sid, char *nt_domain) {  	fstring sid_str;  	int i = 0;  	sid_to_string(sid_str, sid);   4 	DEBUG(5,("map_domain_sid_to_name: %s\n", sid_str));   	if (nt_domain == NULL)  		return False;   & 	while (sid_name_map[i].sid != NULL) {. 		sid_to_string(sid_str, sid_name_map[i].sid);> 		DEBUG(5,("map_domain_sid_to_name: compare: %s\n", sid_str));, 		if (sid_equal(sid_name_map[i].sid, sid)) {, 			fstrcpy(nt_domain, sid_name_map[i].name);@ 			DEBUG(5,("map_domain_sid_to_name: found '%s'\n", nt_domain)); 			return True;  		}  		i++; 	}  J 	DEBUG(5,("map_domain_sid_to_name: mapping for %s not found\n", sid_str));       return False;  }   K /************************************************************************** 9  Looks up a known username from one of the known domains. L ***************************************************************************/  Q BOOL lookup_known_rid(DOM_SID *sid, uint32 rid, char *name, uint8 *psid_name_use)  {  	int i = 0;   	struct sid_name_map_info *psnm;  / 	for(i = 0; sid_name_map[i].sid != NULL; i++) {  		psnm = &sid_name_map[i];! 		if(sid_equal(psnm->sid, sid)) { 	 			int j; W 			for(j = 0; psnm->known_users && psnm->known_users[j].known_user_name != NULL; j++) { ) 				if(rid == psnm->known_users[j].rid) { K 					DEBUG(5,("lookup_builtin_rid: rid = %u, domain = '%s', user = '%s'\n", M 						(unsigned int)rid, psnm->name, psnm->known_users[j].known_user_name )); : 					fstrcpy( name, psnm->known_users[j].known_user_name);8 					*psid_name_use = psnm->known_users[j].sid_name_use; 					return True;  				}  			} 		}  	}   	return False; }   K /**************************************************************************    Turns a domain name into a SID.I  *** side-effect: if the domain name is NULL, it is set to our domain *** L ***************************************************************************/  : BOOL map_domain_name_to_sid(DOM_SID *sid, char *nt_domain) {  	int i = 0;    	if (nt_domain == NULL) { I 		DEBUG(5,("map_domain_name_to_sid: mapping NULL domain to our SID.\n")); ! 		sid_copy(sid, &global_sam_sid);  		return True; 	}   	if (nt_domain[0] == 0) { $ 		fstrcpy(nt_domain, global_myname);P 		DEBUG(5,("map_domain_name_to_sid: overriding blank name to %s\n", nt_domain));! 		sid_copy(sid, &global_sam_sid);  		return True;     }   6 	DEBUG(5,("map_domain_name_to_sid: %s\n", nt_domain));  ' 	while (sid_name_map[i].name != NULL) { K 		DEBUG(5,("map_domain_name_to_sid: compare: %s\n", sid_name_map[i].name)); 2 		if (strequal(sid_name_map[i].name, nt_domain)) { 			fstring sid_str; & 			sid_copy(sid, sid_name_map[i].sid);/ 			sid_to_string(sid_str, sid_name_map[i].sid); < 			DEBUG(5,("map_domain_name_to_sid: found %s\n", sid_str)); 			return True;  		}  		i++; 	}  L 	DEBUG(0,("map_domain_name_to_sid: mapping to %s not found.\n", nt_domain)); 	return False; }   K /************************************************************************** F  Splits a name of format \DOMAIN\name or name into its two components.D  Sets the DOMAIN name to global_myname if it has not been specified.L ***************************************************************************/  F void split_domain_name(const char *fullname, char *domain, char *name) {  	pstring full_name; 	 	char *p;    	*domain = *name = '\0';   	if (fullname[0] == '\\') 
 		fullname++;    	pstrcpy(full_name, fullname); 	p = strchr(full_name+1, '\\');    	if (p != NULL) { 	 		*p = 0;  		fstrcpy(domain, full_name);  		fstrcpy(name, p+1); 	 	} else { ! 		fstrcpy(domain, global_myname);  		fstrcpy(name, full_name);  	}  R 	DEBUG(10,("split_domain_name:name '%s' split into domain :'%s' and user :'%s'\n", 			fullname, domain, name)); }   B /*****************************************************************"  Convert a SID to an ascii string.B *****************************************************************/  5 char *sid_to_string(fstring sidstr_out, DOM_SID *sid)  {    char subauth[16];    int i;Q   /* BIG NOTE: this function only does SIDS where the identauth is not >= 2^32 */ !   uint32 ia = (sid->id_auth[5]) + '               (sid->id_auth[4] << 8 ) + '               (sid->id_auth[3] << 16) + &               (sid->id_auth[2] << 24);  k   slprintf(sidstr_out, sizeof(fstring) - 1, "S-%u-%lu", (unsigned int)sid->sid_rev_num, (unsigned long)ia);   (   for (i = 0; i < sid->num_auths; i++) {S     slprintf(subauth, sizeof(subauth)-1, "-%lu", (unsigned long)sid->sub_auths[i]); !     pstrcat(sidstr_out, subauth);    }   8   DEBUG(7,("sid_to_string returning %s\n", sidstr_out));   return sidstr_out; }   B /*****************************************************************C  Convert a string to a SID. Returns True on success, False on fail. B *****************************************************************/  1 BOOL string_to_sid(DOM_SID *sidout, char *sidstr)  {    pstring tok;   char *p = sidstr; Q   /* BIG NOTE: this function only does SIDS where the identauth is not >= 2^32 */    uint32 ia;  0   memset((char *)sidout, '\0', sizeof(DOM_SID));  &   if (StrnCaseCmp( sidstr, "S-", 2)) {K     DEBUG(0,("string_to_sid: Sid %s does not start with 'S-'.\n", sidstr));      return False;    }   	   p += 2; /   if (!next_token(&p, tok, "-", sizeof(tok))) { K     DEBUG(0,("string_to_sid: Sid %s is not in a valid format.\n", sidstr));      return False;    }       /* Get the revision number. */6   sidout->sid_rev_num = (uint8)strtoul(tok, NULL, 10);  /   if (!next_token(&p, tok, "-", sizeof(tok))) { K     DEBUG(0,("string_to_sid: Sid %s is not in a valid format.\n", sidstr));      return False;    }   .   /* identauth in decimal should be <  2^32 */&   ia = (uint32)strtoul(tok, NULL, 10);  4   /* NOTE - the ia value is in big-endian format. */   sidout->id_auth[0] = 0;    sidout->id_auth[1] = 0; /   sidout->id_auth[2] = (ia & 0xff000000) >> 24; /   sidout->id_auth[3] = (ia & 0x00ff0000) >> 16; .   sidout->id_auth[4] = (ia & 0x0000ff00) >> 8;)   sidout->id_auth[5] = (ia & 0x000000ff);      sidout->num_auths = 0;  0   while(next_token(&p, tok, "-", sizeof(tok)) &&# 	sidout->num_auths < MAXSUBAUTHS) {      /*D      * NOTE - the subauths are in native machine-endian format. TheyD      * are converted to little-endian when linearized onto the wire.      */ 8 	sid_append_rid(sidout, (uint32)strtoul(tok, NULL, 10));   }   <   DEBUG(7,("string_to_sid: converted SID %s ok\n", sidstr));     return True; }   B /*****************************************************************  Add a rid to the end of a sidB *****************************************************************/  - BOOL sid_append_rid(DOM_SID *sid, uint32 rid)r {n$ 	if (sid->num_auths < MAXSUBAUTHS) {) 		sid->sub_auths[sid->num_auths++] = rid;  		return True; 	} 	return False; }g  B /*****************************************************************+  Removes the last rid from the end of a sid B *****************************************************************/  - BOOL sid_split_rid(DOM_SID *sid, uint32 *rid)t {; 	if (sid->num_auths > 0) { 		sid->num_auths--; ( 		*rid = sid->sub_auths[sid->num_auths]; 		return True; 	} 	return False; }w  B /*****************************************************************
  Copies a sid B *****************************************************************/  ) void sid_copy(DOM_SID *dst, DOM_SID *src)  {  	int i;l  % 	dst->sid_rev_num = src->sid_rev_num; ! 	dst->num_auths = src->num_auths;p  B 	memcpy(&dst->id_auth[0], &src->id_auth[0], sizeof(src->id_auth));  % 	for (i = 0; i < src->num_auths; i++) ( 		dst->sub_auths[i] = src->sub_auths[i]; }E  B /*****************************************************************'  Duplicates a sid - mallocs the target.mB *****************************************************************/   DOM_SID *sid_dup(DOM_SID *src) {W   DOM_SID *dst;*  
   if(!src)     return NULL;  /   if((dst = malloc(sizeof(DOM_SID))) != NULL) {t$ 	memset(dst, '\0', sizeof(DOM_SID)); 	sid_copy( dst, src);C   }r  
   return dst;a }   B /*****************************************************************)  Write a sid out into on-the-wire format.iB *****************************************************************/  : BOOL sid_linearize(char *outbuf, size_t len, DOM_SID *sid) { 
 	size_t i;   	if(len < sid_size(sid)) 		return False;W  " 	SCVAL(outbuf,0,sid->sid_rev_num);  	SCVAL(outbuf,1,sid->num_auths);% 	memcpy(&outbuf[2], sid->id_auth, 6);a$ 	for(i = 0; i < sid->num_auths; i++). 		SIVAL(outbuf, 8 + (i*4), sid->sub_auths[i]);  
 	return True;u }}  B /*****************************************************************  Compare two sids.B *****************************************************************/  , BOOL sid_equal(DOM_SID *sid1, DOM_SID *sid2) {  	int i;D  B 	/* compare most likely different rids, first: i.e start at end */) 	for (i = sid1->num_auths-1; i >= 0; --i),/ 		if (sid1->sub_auths[i] != sid2->sub_auths[i])  			return False;  ( 	if (sid1->num_auths != sid2->num_auths) 		return False;u, 	if (sid1->sid_rev_num != sid2->sid_rev_num) 		return False;d   	for (i = 0; i < 6; i++)+ 		if (sid1->id_auth[i] != sid2->id_auth[i])  			return False;  
 	return True;" }U    B /*****************************************************************  Calculates size of a sid.B *****************************************************************/   size_t sid_size(DOM_SID *sid), {{ 	if (sid == NULL)  		return 0;*  , 	return sid->num_auths * sizeof(uint32) + 8; }*