 /* File: VMS_SYS_SELECT.C  **K ** This function implements the SYS_SELECT function for the SAMBA SMBClient B ** routine.  It basically just waits for an unsolicited keystroke. ** ** 19-Sep-1999	J. Malmberg **O ******************************************************************************/   A /* Much of this module lifted directly from SAMBA module SYSTEM.C ' ** That contained the following notice:  */ /*#    Unix SMB/Netbios implementation.     Version 1.9.     Samba system utilities *    Copyright (C) Andrew Tridgell 1992-1998  G    This program is free software; you can redistribute it and/or modify G    it under the terms of the GNU General Public License as published by D    the Free Software Foundation; either version 2 of the License, or&    (at your option) any later version.  B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software<    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */     #include <socket.h>  #include <string.h>  #include <descrip.h> #include <errno.h> #include <stdio.h> #include <unistd.h>  #include <unixio.h>    #include <iodef.h> #include <ssdef.h>   unsigned long sys$assign/        (const struct dsc$descriptor_s * devnam,  	unsigned short * chan,  	unsigned long acmode,( 	const struct dsc$descriptor_s * mbxnam, 	unsigned long flags);     unsigned long sys$qiow        (unsigned long efn,; 	unsigned short chan,	/* This is right, 7.0 doc is wrong */  	unsigned long func,
 	void * iosb,   	void (* astadr)(unsigned long), 	...);    O const unsigned long vms_sys_select_char_mask[2] = {0, ((1 << 13) | (1 << 26))};   7 static unsigned short vms_sys_select_termchan = 0xffff; 0 static unsigned long vms_sys_select_astrun_flag;  3 void vms_sys_select_read_ast(unsigned long astparm)  { "    vms_sys_select_astrun_flag = 1;       /* Cancel the timer */    /*------------------*/  }   @ int vms_sys_select(int maxfd, fd_set *fds, struct timeval *tval) {  struct timeval t2; int selrtn;  unsigned long call_stat;F const unsigned long funct = IO$_SETMODE | IO$M_OUTBAND | IO$M_INCLUDE; unsigned short iosb[4];   #     vms_sys_select_astrun_flag = 0;        call_stat = SS$_NORMAL;   $     if (FD_ISSET(STDIN_FILENO, fds))     {  	FD_CLR(STDIN_FILENO, fds);    	if (isatty(STDIN_FILENO)) 	{+ 	    if (vms_sys_select_termchan == 0xffff)  	    { 	    char termname[256]; 	    char * retname;' 	    struct dsc$descriptor_s term_desc;   / 		retname = getname(STDIN_FILENO, termname, 1);    		if (retname != NULL) 		{ ) 		    term_desc.dsc$a_pointer = termname; 0 		    term_desc.dsc$w_length = strlen(termname);, 		    term_desc.dsc$b_dtype = DSC$K_DTYPE_T;, 		    term_desc.dsc$b_class = DSC$K_CLASS_S;   		    call_stat = sys$assign3 			(&term_desc, &vms_sys_select_termchan, 0, 0, 0);  		}    	    }  - 	     /* Post a QIO for a notification AST */ , 	    /*-----------------------------------*/0 	    if ((call_stat & SS$_NORMAL) == SS$_NORMAL) 	    { 		call_stat = sys$qiow 		       (0, 			vms_sys_select_termchan, 	 			funct,  			iosb, 			0,  			0,  			vms_sys_select_read_ast,  			vms_sys_select_char_mask, 			0,  			0,  			0,  			0);  - 		if ((call_stat & SS$_NORMAL) != SS$_NORMAL)  		{ % 		    vms_sys_select_astrun_flag = 1;  		}  	    }	 	    else ! 		vms_sys_select_astrun_flag = 1;  	} 	else  	{I 	     /* Standard input has been redirected to a file so is always rdy */ H 	    /*---------------------------------------------------------------*/$ 	    vms_sys_select_astrun_flag = 1; 	}     }   
     if (tval)      { / 	memcpy((void *)&t2, (void *)tval, sizeof(t2));      }   5      /* 1 second delay, waiting for keyboard input */ 4     /*--------------------------------------------*/     t2.tv_sec = 1;  (     if (vms_sys_select_astrun_flag == 0)     {  	do  	{   	    errno = 0;    	    selrtn = select. 			(maxfd, fds, NULL, NULL, tval ? &t2: NULL);  - 	} while ((selrtn < 0) && (errno == EINTR) && & 		 (vms_sys_select_astrun_flag == 0));     }     /     if ((call_stat & SS$_NORMAL) == SS$_NORMAL)      {      unsigned long call_stat2;   % 	 /* Cancel the AST notifications! */ $ 	/*-------------------------------*/ 	call_stat2 = sys$qiow 	       (0,  		vms_sys_select_termchan, 		funct, 		iosb,  		0, 		0, 		0, 		0, 		0, 		0, 		0, 		0);   % 	if (vms_sys_select_astrun_flag != 0)  	{ 	    FD_SET(STDIN_FILENO, fds);  	    if (selrtn >= 0)  		selrtn++;   H 	 /* else would be a coding error, so let the program handle the bomb */G 	/*------------------------------------------------------------------*/  	}     }      else     { ( 	 /* We could not handle the terminal */' 	/*----------------------------------*/ 
 	selrtn = -1;  	errno = EBADF;      }        return (selrtn); } 