 /* File: VMS_LP_LOAD.C **M ** This is a wrapper for the SAMBA LP_LOAD procedure.  It sets global options  ** for the SAMBA programs. ** ** 01-Dec-1999	J. Malmberg **N *****************************************************************************/N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/   #include "includes.h"   = const char samba_swap_file_times[] = "SAMBA_SWAP_FILE_TIMES"; = const char samba_filespec_encode[] = "SAMBA_FILESPEC_ENCODE"; 5 const char samba_case_encode[] = "SAMBA_CASE_ENCODE"; C /* const char samba_no_ods2_deepdir[] = "SAMBA_NO_ODS2_DEEPDIR"; */ ? const char samba_announce_version[] = "SAMBA_ANNOUNCE_VERSION"; 3 const char samba_cvt_dunder[] = "SAMBA_CVT_DUNDER";      /* Prototype the real module */ /*---------------------------*/  BOOL samba_lp_load    (char *pszFname,      BOOL global_only,      BOOL save_defaults,      BOOL add_ipc);    /* And now the wrapper */ /*---------------------*/  BOOL lp_load    (char *pszFname,      BOOL global_only,      BOOL save_defaults,      BOOL add_ipc)  {  BOOL ret_stat; unsigned long stat_options;  unsigned long fname_options; char * tmpstr;  7      /* Report the FRONTPORT version for diagnostics */ 6     /*----------------------------------------------*/:     tmpstr = fport__getenv_trnlnm(samba_announce_version);     if (tmpstr != NULL)      {  	switch(tmpstr[0]) 	{
 	case 't':
 	case 'T':
 	case 'Y':
 	case 'y':
 	case '1': 	    fport__report_version();  	    break; 	 	default:  	    break;  	}     }         /* Overall defaults */      /*------------------*/      fport__set_global_options();  2      /* Set the file report and locking options */1     /*-----------------------------------------*/ -     stat_options = fport__get_stat_options(); ;     stat_options = stat_options | FPORT__M_STAT_FCNTL_LOCK; 6     stat_options = stat_options | FPORT__M_STAT_SAMBA;7     stat_options = stat_options | FPORT__M_STAT_USEACL;   ,     /* FPORT__M_STAT_SET_SAMBA_SYSTEM_ACE */  9     tmpstr = fport__getenv_trnlnm(samba_swap_file_times);      if (tmpstr != NULL)      {  	switch(tmpstr[0]) 	{
 	case 't':
 	case 'T':
 	case 'Y':
 	case 'y':
 	case '1':. 	    stat_options |= FPORT__M_STAT_SWAP_CTIME; 	    break; 	 	default:  	    break;  	}     }   *     fport__set_stat_options(stat_options);    /      /* Set the file name processing options */ .     /*--------------------------------------*//     fname_options = fport__get_fname_options();     /* Feature removed */ /*-----------------*/  #if 0 9     tmpstr = fport__getenv_trnlnm(samba_no_ods2_deepdir);      if (tmpstr != NULL)      {  	switch(tmpstr[0]) 	{
 	case '1':
 	case 'Y':
 	case 'y':
 	case 'T':
 	case 't':< 	    fname_options = fname_options | FPORT__M_FNAME_DEEPDIR; 	    break; 	 	default:  	    break;  	}     }  #endif  4     tmpstr = fport__getenv_trnlnm(samba_cvt_dunder);     if (tmpstr != NULL)      {  	switch(tmpstr[0]) 	{
 	case '1':
 	case 'Y':
 	case 'y':
 	case 'T':
 	case 't':; 	    fname_options = fname_options | FPORT__M_FNAME_DUNDER;  	    break; 	 	default:  	    break;  	}     }   >     fname_options = fname_options | FPORT__M_FNAME_EXTLASTDOT;9     fname_options = fname_options | FPORT__M_FNAME_TILDE;     5     tmpstr = fport__getenv_trnlnm(samba_case_encode);      if (tmpstr != NULL)      {  	switch(tmpstr[0]) 	{
 	case '0':
 	case 'N':
 	case 'n': 	    fname_options &= : 			~(FPORT__M_FNAME_CASE_ACE | FPORT__M_FNAME_CASE_MEYER); 	    break; 
 	case 'Y':
 	case 'y':8 	    if ((fname_options & FPORT__M_FNAME_CASE_ACE) != 0)- 		fname_options |= FPORT__M_FNAME_CASE_MEYER;  	    break; 
 	case '1':
 	case 'A':
 	case 'a':. 	    fname_options |= FPORT__M_FNAME_CASE_ACE; 	    break; 
 	case '2':
 	case 'M':
 	case 'm':0 	    fname_options |= FPORT__M_FNAME_CASE_MEYER; 	    break; 	 	default:  	    break;  	}     }   3     /* FPORT__M_FNAME_CASE_ACE - Not implemented */ 5     /* FPORT__M_FNAME_CASE_MEYER - Not implemented */ 3     /* FPORT__M_FNAME_MULTINET - Not implemented */ /     /* FPORT__M_FNAME_ODS5 - Not implemented */       8     fname_options = fname_options | FPORT__M_FNAME_PWRK;8     fname_options = fname_options | FPORT__M_FNAME_UNIX;  ,     fport__set_fname_options(fname_options);  3      /* FDL Template directory for file creation */ 2     /*------------------------------------------*/F     fport__set_template_prefix("SAMBA_ROOT:[FILE_TEMPLATES]TEMPLATE");  +      /* Set the unix device alias naming */ *     /*----------------------------------*/0     fport__set_unix_device_prefix("SAMBA_DEV_");  L     ret_stat = samba_lp_load(pszFname, global_only, save_defaults, add_ipc);   return ret_stat; } 