 /*#    Unix SMB/Netbios implementation.     Version 1.9. '    Password and authentication handling )    Copyright (C) Jeremy Allison 1996-1998 7    Copyright (C) Luke Kenneth Casson Leighton 1996-1998   G    This program is free software; you can redistribute it and/or modify G    it under the terms of the GNU General Public License as published by D    the Free Software Foundation; either version 2 of the License, or&    (at your option) any later version.  B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software<    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */   #include "includes.h"  #include "nterr.h"   extern int DEBUGLEVEL;   /*7  * This is set on startup - it defines the SID for this :  * machine, and therefore the SAM database for which it is  * responsible.   */    extern DOM_SID global_sam_sid; extern pstring global_myname; " extern fstring global_myworkgroup;   /*<  * NOTE. All these functions are abstracted into a structureF  * that points to the correct function for the selected database. JRA.  *I  * NOTE.  for the get/mod/add functions, there are two sets of functions. H  * one supports struct sam_passwd, the other supports struct smb_passwd.@  * for speed optimisation it is best to support both these sets.  *G  * it is, however, optional to support one set but not the other: there D  * is conversion-capability built in to passdb.c, and run-time error,  * detection for when neither are supported.  *H  * password database writers are recommended to implement the sam_passwd@  * functions in a first pass, as struct sam_passwd contains more0  * information, needed by the NT Domain support.  *G  * a full example set of derivative functions are listed below.  an API C  * writer is expected to cut/paste these into their module, replace F  * either one set (struct smb_passwd) or the other (struct sam_passwd)>  * OR both, and optionally also to write display info routines   * (struct sam_disp_info).  lkcl  *  */   " static struct passdb_ops *pdb_ops;  @ /***************************************************************'  Initialize the password db operations. @ ***************************************************************/  ! BOOL initialize_password_db(void)  {    if (pdb_ops)   {      return True;   }    #ifdef WITH_NISPLUS .   pdb_ops =  nisplus_initialize_password_db(); #elif defined(WITH_LDAP)*   pdb_ops = ldap_initialize_password_db(); #else *   pdb_ops = file_initialize_password_db(); #endif     return (pdb_ops != NULL);  }    /*8  * Functions that return/manipulate a struct smb_passwd.  */   I /************************************************************************ .  Utility function to search smb passwd by rid.J *************************************************************************/  7 struct smb_passwd *iterate_getsmbpwrid(uint32 user_rid)  { ; 	return iterate_getsmbpwuid(pdb_user_rid_to_uid(user_rid));  }   I /************************************************************************ I  Utility function to search smb passwd by uid.  use this if your database !  does not have search facilities. J *************************************************************************/  8 struct smb_passwd *iterate_getsmbpwuid(uid_t smb_userid) {  	struct smb_passwd *pwd = NULL;  	void *fp = NULL;   < 	DEBUG(10, ("search by smb_userid: %x\n", (int)smb_userid));  7 	/* Open the smb password database - not for update. */  	fp = startsmbpwent(False);    	if (fp == NULL) 	{8 		DEBUG(0, ("unable to open smb password database.\n")); 		return NULL; 	}  I 	while ((pwd = getsmbpwent(fp)) != NULL && pwd->smb_userid != smb_userid)        ;    	if (pwd != NULL)  	{< 		DEBUG(10, ("found by smb_userid: %x\n", (int)smb_userid)); 	}   	endsmbpwent(fp);  	return pwd; }   I /************************************************************************ J  Utility function to search smb passwd by name.  use this if your database!  does not have search facilities. J *************************************************************************/  2 struct smb_passwd *iterate_getsmbpwnam(char *name) {  	struct smb_passwd *pwd = NULL;  	void *fp = NULL;   + 	DEBUG(10, ("search by name: %s\n", name));   3 	/* Open the sam password file - not for update. */  	fp = startsmbpwent(False);    	if (fp == NULL) 	{8 		DEBUG(0, ("unable to open smb password database.\n")); 		return NULL; 	}  J 	while ((pwd = getsmbpwent(fp)) != NULL && !strequal(pwd->smb_name, name))       ;    	if (pwd != NULL)  	{+ 		DEBUG(10, ("found by name: %s\n", name));  	}   	endsmbpwent(fp);  	return pwd; }   @ /***************************************************************F  Start to enumerate the smb or sam passwd list. Returns a void pointer/  to ensure no modification outside this module.   @  Note that currently it is being assumed that a pointer returned>  from this function may be used to enumerate struct sam_passwd<  entries as well as struct smb_passwd entries. This may need  to change. JRA.  A ****************************************************************/     void *startsmbpwent(BOOL update) { (   return pdb_ops->startsmbpwent(update); }   @ /***************************************************************/  End enumeration of the smb or sam passwd list.   @  Note that currently it is being assumed that a pointer returned>  from this function may be used to enumerate struct sam_passwd<  entries as well as struct smb_passwd entries. This may need  to change. JRA.  A ****************************************************************/    void endsmbpwent(void *vp) {    pdb_ops->endsmbpwent(vp);  }   J /*************************************************************************9  Routine to return the next entry in the smb passwd list. K  *************************************************************************/   ( struct smb_passwd *getsmbpwent(void *vp) { ! 	return pdb_ops->getsmbpwent(vp);  }   I /************************************************************************ 0  Routine to add an entry to the smb passwd file.J *************************************************************************/  0 BOOL add_smbpwd_entry(struct smb_passwd *newpwd) { +  	return pdb_ops->add_smbpwd_entry(newpwd);  }   I /************************************************************************ J  Routine to search the smb passwd file for an entry matching the username.F  and then modify its password entry. We can't use the startsampwent()/D  getsampwent()/endsampwent() interfaces here as we depend on lookingB  in the actual file to decide how much room we have to write data.  override = False, normal =  override = True, override XXXXXXXX'd out password or NO PASS I ************************************************************************/   < BOOL mod_smbpwd_entry(struct smb_passwd* pwd, BOOL override) { 2  	return pdb_ops->mod_smbpwd_entry(pwd, override); }   I /************************************************************************ &  Routine to search smb passwd by name.J *************************************************************************/  * struct smb_passwd *getsmbpwnam(char *name) { # 	return pdb_ops->getsmbpwnam(name);  }   I /************************************************************************ *  Routine to search smb passwd by user rid.J *************************************************************************/  / struct smb_passwd *getsmbpwrid(uint32 user_rid)  { ' 	return pdb_ops->getsmbpwrid(user_rid);  }   I /************************************************************************ %  Routine to search smb passwd by uid. J *************************************************************************/  0 struct smb_passwd *getsmbpwuid(uid_t smb_userid) { ) 	return pdb_ops->getsmbpwuid(smb_userid);  }    /*1  * Functions that manupulate a struct sam_passwd.   */   I /************************************************************************ J  Utility function to search sam passwd by name.  use this if your database!  does not have search facilities. J *************************************************************************/  4 struct sam_passwd *iterate_getsam21pwnam(char *name) {  	struct sam_passwd *pwd = NULL;  	void *fp = NULL;   + 	DEBUG(10, ("search by name: %s\n", name));   7 	/* Open the smb password database - not for update. */  	fp = startsmbpwent(False);    	if (fp == NULL) 	{8 		DEBUG(0, ("unable to open sam password database.\n")); 		return NULL; 	}  L 	while ((pwd = getsam21pwent(fp)) != NULL && !strequal(pwd->smb_name, name)) 	{B 		DEBUG(10, ("iterate: %s 0x%x\n", pwd->smb_name, pwd->user_rid)); 	}   	if (pwd != NULL)  	{+ 		DEBUG(10, ("found by name: %s\n", name));  	}   	endsmbpwent(fp);  	return pwd; }   I /************************************************************************ I  Utility function to search sam passwd by rid.  use this if your database !  does not have search facilities.   D  search capability by both rid and uid are needed as the rid <-> uid  mapping may be non-monotonic.  J *************************************************************************/  4 struct sam_passwd *iterate_getsam21pwrid(uint32 rid) {  	struct sam_passwd *pwd = NULL;  	void *fp = NULL;   ) 	DEBUG(10, ("search by rid: %x\n", rid));   3 	/* Open the smb password file - not for update. */  	fp = startsmbpwent(False);    	if (fp == NULL) 	{8 		DEBUG(0, ("unable to open sam password database.\n")); 		return NULL; 	}  B 	while ((pwd = getsam21pwent(fp)) != NULL && pwd->user_rid != rid) 	{B 		DEBUG(10, ("iterate: %s 0x%x\n", pwd->smb_name, pwd->user_rid)); 	}   	if (pwd != NULL)  	{. 		DEBUG(10, ("found by user_rid: %x\n", rid)); 	}   	endsmbpwent(fp);  	return pwd; }   I /************************************************************************ I  Utility function to search sam passwd by uid.  use this if your database !  does not have search facilities.   D  search capability by both rid and uid are needed as the rid <-> uid  mapping may be non-monotonic.  J *************************************************************************/  3 struct sam_passwd *iterate_getsam21pwuid(uid_t uid)  {  	struct sam_passwd *pwd = NULL;  	void *fp = NULL;   . 	DEBUG(10, ("search by uid: %x\n", (int)uid));  3 	/* Open the smb password file - not for update. */t 	fp = startsmbpwent(False);p   	if (fp == NULL) 	{8 		DEBUG(0, ("unable to open sam password database.\n")); 		return NULL; 	}  D 	while ((pwd = getsam21pwent(fp)) != NULL && pwd->smb_userid != uid)       ;o   	if (pwd != NULL)C 	{5 		DEBUG(10, ("found by smb_userid: %x\n", (int)uid));o 	}   	endsmbpwent(fp);o 	return pwd; }   J /*************************************************************************3  Routine to return a display info structure, by ridMK  *************************************************************************/t/ struct sam_disp_info *getsamdisprid(uint32 rid)s {t$ 	return pdb_ops->getsamdisprid(rid); }   J /*************************************************************************9  Routine to return the next entry in the sam passwd list.oK  *************************************************************************/n  * struct sam_passwd *getsam21pwent(void *vp) {o# 	return pdb_ops->getsam21pwent(vp);s }c    I /************************************************************************s&  Routine to search sam passwd by name.J *************************************************************************/  , struct sam_passwd *getsam21pwnam(char *name) {i% 	return pdb_ops->getsam21pwnam(name);s }b  I /************************************************************************n%  Routine to search sam passwd by rid. J *************************************************************************/  , struct sam_passwd *getsam21pwrid(uint32 rid) {a$ 	return pdb_ops->getsam21pwrid(rid); }*    ; /**********************************************************m;  ***********************************************************  ?  utility routines which are likely to be useful to all password 
  databases  ;  **********************************************************O<  **********************************************************/  > /*************************************************************$  initialises a struct sam_disp_info.@  **************************************************************/  9 static void pdb_init_dispinfo(struct sam_disp_info *user)* {* 	if (user == NULL) return;+ 	memset((char *)user, '\0', sizeof(*user));p }   > /*************************************************************!  initialises a struct smb_passwd. @  **************************************************************/  * void pdb_init_smb(struct smb_passwd *user) {d 	if (user == NULL) return;+ 	memset((char *)user, '\0', sizeof(*user)); * 	user->pass_last_set_time    = (time_t)-1; }   > /*************************************************************!  initialises a struct sam_passwd.c@  **************************************************************/* void pdb_init_sam(struct sam_passwd *user) {s 	if (user == NULL) return;+ 	memset((char *)user, '\0', sizeof(*user));i* 	user->logon_time            = (time_t)-1;* 	user->logoff_time           = (time_t)-1;* 	user->kickoff_time          = (time_t)-1;* 	user->pass_last_set_time    = (time_t)-1;* 	user->pass_can_change_time  = (time_t)-1;* 	user->pass_must_change_time = (time_t)-1; }*  J /*************************************************************************9  Routine to return the next entry in the sam passwd list.vK  *************************************************************************/)  B struct sam_disp_info *pdb_sam_to_dispinfo(struct sam_passwd *user) {r' 	static struct sam_disp_info disp_info;{   	if (user == NULL) return NULL;a   	pdb_init_dispinfo(&disp_info);L  & 	disp_info.smb_name  = user->smb_name;' 	disp_info.full_name = user->full_name; & 	disp_info.user_rid  = user->user_rid;   	return &disp_info;b }e  > /*************************************************************;  converts a sam_passwd structure to a smb_passwd structure.*@  **************************************************************/  : struct smb_passwd *pdb_sam_to_smb(struct sam_passwd *user) {i! 	static struct smb_passwd pw_buf;*   	if (user == NULL) return NULL;*   	pdb_init_smb(&pw_buf);w  . 	pw_buf.smb_userid         = user->smb_userid;, 	pw_buf.smb_name           = user->smb_name;. 	pw_buf.smb_passwd         = user->smb_passwd;1 	pw_buf.smb_nt_passwd      = user->smb_nt_passwd; - 	pw_buf.acct_ctrl          = user->acct_ctrl;L6 	pw_buf.pass_last_set_time = user->pass_last_set_time;   	return &pw_buf; };    > /*************************************************************;  converts a smb_passwd structure to a sam_passwd structure.0@  **************************************************************/  : struct sam_passwd *pdb_smb_to_sam(struct smb_passwd *user) {*! 	static struct sam_passwd pw_buf;    	if (user == NULL) return NULL;    	pdb_init_sam(&pw_buf);n  . 	pw_buf.smb_userid         = user->smb_userid;, 	pw_buf.smb_name           = user->smb_name;. 	pw_buf.smb_passwd         = user->smb_passwd;1 	pw_buf.smb_nt_passwd      = user->smb_nt_passwd;t- 	pw_buf.acct_ctrl          = user->acct_ctrl; 6 	pw_buf.pass_last_set_time = user->pass_last_set_time;   	return &pw_buf; }o  ; /**********************************************************w/  Encode the account control bits into a string.*@  length = length of string to encode into (including terminating&  null). length *MUST BE MORE THAN 2* !<  **********************************************************/  ; char *pdb_encode_acct_ctrl(uint16 acct_ctrl, size_t length)e {a   static fstring acct_str;   size_t i = 0;t     acct_str[i++] = '[';  5   if (acct_ctrl & ACB_PWNOTREQ ) acct_str[i++] = 'N'; 5   if (acct_ctrl & ACB_DISABLED ) acct_str[i++] = 'D';e5   if (acct_ctrl & ACB_HOMDIRREQ) acct_str[i++] = 'H';*5   if (acct_ctrl & ACB_TEMPDUP  ) acct_str[i++] = 'T';t5   if (acct_ctrl & ACB_NORMAL   ) acct_str[i++] = 'U';*5   if (acct_ctrl & ACB_MNS      ) acct_str[i++] = 'M';*5   if (acct_ctrl & ACB_WSTRUST  ) acct_str[i++] = 'W';r5   if (acct_ctrl & ACB_SVRTRUST ) acct_str[i++] = 'S';*5   if (acct_ctrl & ACB_AUTOLOCK ) acct_str[i++] = 'L';*5   if (acct_ctrl & ACB_PWNOEXP  ) acct_str[i++] = 'X';*5   if (acct_ctrl & ACB_DOMTRUST ) acct_str[i++] = 'I';*  7   for ( ; i < length - 2 ; i++ ) { acct_str[i] = ' '; }      i = length - 2;n   acct_str[i++] = ']';   acct_str[i++] = '\0';*     return acct_str; }*  ; /**********************************************************t/  Decode the account control bits from a string.n  F  this function breaks coding standards minimum line width of 80 chars.E  reason: vertical line-up code clarity - all case statements fit intog#  15 lines, which is more important.u<  **********************************************************/  * uint16 pdb_decode_acct_ctrl(const char *p) {o 	uint16 acct_ctrl = 0; 	BOOL finished = False;*   	/**> 	 * Check if the account type bits have been encoded after the+ 	 * NT password (in the form [NDHTUWSLXI]).b 	 */   	if (*p != '[') return 0;e    	for (p++; *p && !finished; p++) 	{
 		switch (*p)* 		{*H 			case 'N': { acct_ctrl |= ACB_PWNOTREQ ; break; /* 'N'o password. */ }E 			case 'D': { acct_ctrl |= ACB_DISABLED ; break; /* 'D'isabled. */ }uM 			case 'H': { acct_ctrl |= ACB_HOMDIRREQ; break; /* 'H'omedir required. */ } I 			case 'T': { acct_ctrl |= ACB_TEMPDUP  ; break; /* 'T'emp account. */ }*R 			case 'U': { acct_ctrl |= ACB_NORMAL   ; break; /* 'U'ser account (normal). */ }b 			case 'M': { acct_ctrl |= ACB_MNS      ; break; /* 'M'NS logon user account. What is this ? */ }P 			case 'W': { acct_ctrl |= ACB_WSTRUST  ; break; /* 'W'orkstation account. */ }K 			case 'S': { acct_ctrl |= ACB_SVRTRUST ; break; /* 'S'erver account. */ }dK 			case 'L': { acct_ctrl |= ACB_AUTOLOCK ; break; /* 'L'ocked account. */ }/P 			case 'X': { acct_ctrl |= ACB_PWNOEXP  ; break; /* No 'X'piry on password */ }V 			case 'I': { acct_ctrl |= ACB_DOMTRUST ; break; /* 'I'nterdomain trust account. */ }              case ' ': { break; } 			case ':':
 			case '\n':*
 			case '\0':U 			case ']':! 			default:  { finished = True; }e 		}  	}   	return acct_ctrl; }a  D /*******************************************************************2  gets password-database-format time from a string.F  ********************************************************************/  1 static time_t get_time_from_string(const char *p)" {a 	int i;    	for (i = 0; i < 8; i++) 	{2 		if (p[i] == '\0' || !isxdigit((int)(p[i]&0xFF))) 		break; 	} 	if (i == 8) 	{ 		/*- 		 * p points at 8 characters of hex digits - , 		 * read into a time_t as the seconds since- 		 * 1970 that the password was last changed.a 		 */{% 		return (time_t)strtol(p, NULL, 16);d 	} 	return (time_t)-1;) }   D /*******************************************************************  gets password last set timeF  ********************************************************************/  + time_t pdb_get_last_set_time(const char *p)a { % 	if (*p && StrnCaseCmp(p, "LCT-", 4))t 	{% 		return get_time_from_string(p + 4);  	} 	return (time_t)-1;o }r    D /*******************************************************************0  sets password-database-format time in a string.F  ********************************************************************/J static void set_time_in_string(char *p, int max_len, char *type, time_t t) {14 	slprintf(p, max_len, ":%s-%08X:", type, (uint32)t); }s  D /*******************************************************************  sets logon timeF  ********************************************************************/7 void pdb_set_logon_time(char *p, int max_len, time_t t)s {r* 	set_time_in_string(p, max_len, "LNT", t); }n  D /*******************************************************************  sets logoff timeeF  ********************************************************************/8 void pdb_set_logoff_time(char *p, int max_len, time_t t) {** 	set_time_in_string(p, max_len, "LOT", t); }d  D /*******************************************************************  sets kickoff timeF  ********************************************************************/9 void pdb_set_kickoff_time(char *p, int max_len, time_t t)* {** 	set_time_in_string(p, max_len, "KOT", t); }   D /*******************************************************************  sets password can change timeF  ********************************************************************/< void pdb_set_can_change_time(char *p, int max_len, time_t t) {=* 	set_time_in_string(p, max_len, "CCT", t); }s  D /*******************************************************************  sets password last set timeF  ********************************************************************/= void pdb_set_must_change_time(char *p, int max_len, time_t t)r {w* 	set_time_in_string(p, max_len, "MCT", t); }*  D /*******************************************************************  sets password last set timeF  ********************************************************************/: void pdb_set_last_set_time(char *p, int max_len, time_t t) {p* 	set_time_in_string(p, max_len, "LCT", t); }*    > /*************************************************************@  Routine to set 32 hex password characters from a 16 byte array.? **************************************************************/tA void pdb_sethexpwd(char *p, unsigned char *pwd, uint16 acct_ctrl)a {p 	if (pwd != NULL)  	{ 		int i; 		for (i = 0; i < 16; i++) 		{*( 			slprintf(&p[i*2], 3, "%02X", pwd[i]); 		}s 	} 	elsey 	{/ 		if (IS_BITS_SET_ALL(acct_ctrl, ACB_PWNOTREQ))* 		{*: 			safe_strcpy(p, "NO PASSWORDXXXXXXXXXXXXXXXXXXXXX", 33); 		}n 		else 		{t: 			safe_strcpy(p, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", 33); 		}* 	} }*> /*************************************************************3  Routine to get the 32 hex characters and turn them*  into a 16 byte array.? **************************************************************/ / BOOL pdb_gethexpwd(char *p, unsigned char *pwd)  {* 	int i;*$ 	unsigned char   lonybble, hinybble;/ 	char           *hexchars = "0123456789ABCDEF";* 	char           *p1, *p2;i   	for (i = 0; i < 32; i += 2) 	{ 		hinybble = toupper(p[i]);t 		lonybble = toupper(p[i + 1]);*  " 		p1 = strchr(hexchars, hinybble);" 		p2 = strchr(hexchars, lonybble);   		if (!p1 || !p2)* 		{  			return (False); 		}*  $ 		hinybble = PTR_DIFF(p1, hexchars);$ 		lonybble = PTR_DIFF(p2, hexchars);  * 		pwd[i / 2] = (hinybble << 4) | lonybble; 	} 	return (True);t }c  D /*******************************************************************-  Group and User RID username mapping functionfF  ********************************************************************/  C BOOL pdb_name_to_rid(char *user_name, uint32 *u_rid, uint32 *g_rid)* {*4     struct passwd *pw = Get_Pwnam(user_name, False);  9 	if (u_rid == NULL || g_rid == NULL || user_name == NULL)m 	{ 		return False;\ 	}  	 	if (!pw)) 	{B 		DEBUG(1,("Username %s is invalid on this system\n", user_name)); 		return False;* 	}  6 	if (user_in_list(user_name, lp_domain_guest_users())) 	{! 		*u_rid = DOMAIN_USER_RID_GUEST;* 	}; 	else if (user_in_list(user_name, lp_domain_admin_users()))u 	{! 		*u_rid = DOMAIN_USER_RID_ADMIN;m 	} 	else  	{A 		/* turn the unix UID into a Domain RID.  this is what the posix-. 		   sub-system does (adds 1000 to the uid) */+ 		*u_rid = pdb_uid_to_user_rid(pw->pw_uid);u 	}  M 	/* absolutely no idea what to do about the unix GID to Domain RID mapping */ + 	*g_rid = pdb_gid_to_group_rid(pw->pw_gid);*  
 	return True;* }*  M /****************************************************************************n"  Read the machine SID from a file.M ****************************************************************************/   6 static BOOL read_sid_from_file(int fd, char *sid_file) {u   fstring fline;  %   memset(fline, '\0', sizeof(fline));u  .   if(read(fd, fline, sizeof(fline) -1 ) < 0) {6     DEBUG(0,("unable to read file %s. Error was %s\n",(            sid_file, strerror(errno) ));     return False;    }e     /*     * Convert to the machine SID.    */*      fline[sizeof(fline)-1] = '\0';/   if(!string_to_sid( &global_sam_sid, fline)) {c3     DEBUG(0,("unable to generate machine SID.\n"));*     return False;*   }*     return True; }   M /****************************************************************************bI  Generate the global machine sid. Look for the MACHINE.SID file first, ifuK  not found then look in smb.conf and use it to create the MACHINE.SID file. M ****************************************************************************/. BOOL pdb_generate_sam_sid(void)_ {s 	int fd;	 	char *p;r 	pstring sid_file; 	fstring sid_string; 	SMB_STRUCT_STAT st;  	BOOL overwrite_bad_sid = False;   	generate_wellknown_sids();*  ) 	pstrcpy(sid_file, lp_smb_passwd_file());* 	p = strrchr(sid_file, '/'); 	if(p != NULL) { 		*++p = '\0'; 	}  ( 	if (!directory_exist(sid_file, NULL)) {# 		if (mkdir(sid_file, 0700) != 0) {w7 			DEBUG(0,("can't create private directory %s : %s\n",t! 				 sid_file, strerror(errno)));e 			return False; 		}  	}  " 	pstrcat(sid_file, "MACHINE.SID");  > 	if((fd = sys_open(sid_file, O_RDWR | O_CREAT, 0644)) == -1) {> 		DEBUG(0,("unable to open or create file %s. Error was %s\n",! 			 sid_file, strerror(errno) ));- 		return False;  	}   	/*t$ 	 * Check if the file contains data. 	 */   	if(sys_fstat( fd, &st) < 0) {4 		DEBUG(0,("unable to stat file %s. Error was %s\n",! 			 sid_file, strerror(errno) ));* 		close(fd); 		return False;  	}   	if(st.st_size > 0) {  		/*# 		 * We have a valid SID - read it.i 		 */g* 		if(!read_sid_from_file( fd, sid_file)) {5 			DEBUG(0,("unable to read file %s. Error was %s\n",*" 				 sid_file, strerror(errno) ));
 			close(fd);  			return False; 		}h   		/*9 		 * JRA. Reversed the sense of this test now that I havei: 		 * actually done this test *personally*. One more reason8 		 * to never trust third party information you have not* 		 * independently verified.... sigh. JRA. 		 */+  K 		if(global_sam_sid.num_auths > 0 && global_sam_sid.sub_auths[0] == 0x21) {c 			/*C 			 * Fix and re-write...= 			 */ 			overwrite_bad_sid = True;$ 			global_sam_sid.sub_auths[0] = 21;J 			DEBUG(5,("pdb_generate_sam_sid: Old (incorrect) sid id_auth of hex 21 \6 detected - re-writing to be decimal 21 instead.\n" ));. 			sid_to_string(sid_string, &global_sam_sid);3 			if(sys_lseek(fd, (SMB_OFF_T)0, SEEK_SET) != 0) {_; 				DEBUG(0,("unable to seek file file %s. Error was %s\n",;# 					 sid_file, strerror(errno) ));  				close(fd); 				return False;] 			}
 		} else {
 			close(fd);  			return True;  		} 	 	} else {* 		/*8 		 * The file contains no data - we need to generate our
 		 * own sid.i7 		 * Generate the new sid data & turn it into a string.r 		 */m 		int i; 		uchar raw_sid_data[12];v 		DOM_SID mysid;  0 		memset((char *)&mysid, '\0', sizeof(DOM_SID)); 		mysid.sid_rev_num = 1; 		mysid.id_auth[5] = 5;* 		mysid.num_auths = 0;* 		mysid.sub_auths[mysid.num_auths++] = 21;  2 		generate_random_buffer( raw_sid_data, 12, True); 		for( i = 0; i < 3; i++) @ 			mysid.sub_auths[mysid.num_auths++] = IVAL(raw_sid_data, i*4);  $ 		sid_to_string(sid_string, &mysid); 	}   	fstrcat(sid_string, "\n");e   	/*r  	 * Ensure our new SID is valid. 	 */  3 	if(!string_to_sid( &global_sam_sid, sid_string)) {Q1 		DEBUG(0,("unable to generate machine SID.\n"));c 		return False;A 	}   	/*k. 	 * Do an exclusive blocking lock on the file. 	 */  & 	if(!do_file_lock( fd, 60, F_WRLCK)) {4 		DEBUG(0,("unable to lock file %s. Error was %s\n",! 			 sid_file, strerror(errno) ));s 		close(fd); 		return False;L 	}   	if(!overwrite_bad_sid) {r 		/*5 		 * At this point we have a blocking lock on the SID 7 		 * file - check if in the meantime someone else wrote : 		 * SID data into the file. If so - they were here first, 		 * use their data. 		 */a   		if(sys_fstat( fd, &st) < 0) {*5 			DEBUG(0,("unable to stat file %s. Error was %s\n",C" 				 sid_file, strerror(errno) ));
 			close(fd);c 			return False; 		}    #ifdef __VMS 		if(st.st_size > 2) { #else  		if(st.st_size > 0) { #endif 			/*O* 			 * Unlock as soon as possible to reduce' 			 * contention on the exclusive lock.} 			 */" 			do_file_lock( fd, 60, F_UNLCK);   			/*s$ 			 * We have a valid SID - read it. 			 */  + 			if(!read_sid_from_file( fd, sid_file)) {*6 				DEBUG(0,("unable to read file %s. Error was %s\n",# 					 sid_file, strerror(errno) ));  				close(fd); 				return False;* 			}
 			close(fd);* 			return True;* 		}* 	}   	/*t? 	 * The file is still empty and we have an exlusive lock on it,f' 	 * or we're fixing an earlier mistake. ) 	 * Write out out SID data into the file.a 	 */   	/*i1 	 * Use chmod here as some (strange) UNIX's don'th 	 * have fchmod. JRA.  	 */    	if(chmod(sid_file, 0644) < 0) {; 		DEBUG(0,("unable to set correct permissions on file %s. \i. Error was %s\n", sid_file, strerror(errno) ));! 		do_file_lock( fd, 60, F_UNLCK);* 		close(fd); 		return False;* 	}  G 	if(write( fd, sid_string, strlen(sid_string)) != strlen(sid_string)) {*5 		DEBUG(0,("unable to write file %s. Error was %s\n",s! 			 sid_file, strerror(errno) )); ! 		do_file_lock( fd, 60, F_UNLCK);  		close(fd); 		return False;n 	}   	/*  	 * Unlock & exit. 	 */    	do_file_lock( fd, 60, F_UNLCK); 	close(fd);*
 	return True;* }*  D /*******************************************************************$  Converts NT user RID to a UNIX uid.F  ********************************************************************/  * uid_t pdb_user_rid_to_uid(uint32 user_rid) { F 	return (uid_t)(((user_rid & (~USER_RID_TYPE))- 1000)/RID_MULTIPLIER); }*  D /*******************************************************************$  Converts NT user RID to a UNIX gid.F  ********************************************************************/  * gid_t pdb_user_rid_to_gid(uint32 user_rid) { G 	return (uid_t)(((user_rid & (~GROUP_RID_TYPE))- 1000)/RID_MULTIPLIER);s }   D /*******************************************************************%  converts UNIX uid to an NT User RID.cF  ********************************************************************/  % uint32 pdb_uid_to_user_rid(uid_t uid)* {*B 	return (((((uint32)uid)*RID_MULTIPLIER) + 1000) | USER_RID_TYPE); }*  D /*******************************************************************%  converts NT Group RID to a UNIX uid.tF  ********************************************************************/  & uint32 pdb_gid_to_group_rid(gid_t gid) {*D   return (((((uint32)gid)*RID_MULTIPLIER) + 1000) | GROUP_RID_TYPE); }*  D /*******************************************************************&  Decides if a RID is a well known RID.F  ********************************************************************/  - static BOOL pdb_rid_is_well_known(uint32 rid)  {s   return (rid < 1000); }*  D /*******************************************************************)  Decides if a RID is a user or group RID. F  ********************************************************************/    BOOL pdb_rid_is_user(uint32 rid) {*?   /* lkcl i understand that NT attaches an enumeration to a RID*?    * such that it can be identified as either a user, group etcpA    * type.  there are 5 such categories, and they are documented._    */n#    if(pdb_rid_is_well_known(rid)) {*       /*@        * The only well known user RIDs are DOMAIN_USER_RID_ADMIN#        * and DOMAIN_USER_RID_GUEST.b	        */ E      if(rid == DOMAIN_USER_RID_ADMIN || rid == DOMAIN_USER_RID_GUEST)p        return True; 6    } else if((rid & RID_TYPE_MASK) == USER_RID_TYPE) {      return True;;    }    return False; })  D /*******************************************************************7  Convert a rid into a name. Used in the lookup SID rpc.	F  ********************************************************************/  C BOOL lookup_local_rid(uint32 rid, char *name, uint8 *psid_name_use)  {   % 	BOOL is_user = pdb_rid_is_user(rid);*  I 	DEBUG(5,("lookup_local_rid: looking up %s RID %u.\n", is_user ? "user" :*  			"group", (unsigned int)rid));   	if(is_user) {$ 		if(rid == DOMAIN_USER_RID_ADMIN) { 			pstring admin_users;  			char *p = admin_users;*2 			pstrcpy( admin_users, lp_domain_admin_users());3 			if(!next_token(&p, name, NULL, sizeof(fstring))) # 				fstrcpy(name, "Administrator");i, 		} else if (rid == DOMAIN_USER_RID_GUEST) { 			pstring guest_users;p 			char *p = guest_users;(2 			pstrcpy( guest_users, lp_domain_guest_users());3 			if(!next_token(&p, name, NULL, sizeof(fstring)))  				fstrcpy(name, "Guest");(
 		} else {( 			uid_t uid = pdb_user_rid_to_uid(rid);+ 			struct passwd *pass = sys_getpwuid(uid);   " 			*psid_name_use = SID_NAME_USER;  J 			DEBUG(5,("lookup_local_rid: looking up uid %u %s\n", (unsigned int)uid,% 				pass ? "succeeded" : "failed" ));*   			if(!pass) {I 				slprintf(name, sizeof(fstring)-1, "unix_user.%u", (unsigned int)uid);e 				return True; 			}    			fstrcpy(name, pass->pw_name);  A 			DEBUG(5,("lookup_local_rid: found user %s for rid %u\n", name,= 				(unsigned int)rid ));m 		}   	 	} else {e' 		gid_t gid = pdb_user_rid_to_gid(rid);r# 		struct group *gr = getgrgid(gid);   " 		*psid_name_use = SID_NAME_ALIAS;  I 		DEBUG(5,("lookup_local_rid: looking up gid %u %s\n", (unsigned int)gid,_" 			gr ? "succeeded" : "failed" ));   		if(!gr) {aI 			slprintf(name, sizeof(fstring)-1, "unix_group.%u", (unsigned int)gid);  			return True;t 		}h   		fstrcpy( name, gr->gr_name);  A 		DEBUG(5,("lookup_local_rid: found group %s for rid %u\n", name,  			(unsigned int)rid )); 	}  
 	return True;} }   D /*******************************************************************8  Convert a name into a SID. Used in the lookup name rpc.F  ********************************************************************/  U BOOL lookup_local_name(char *domain, char *user, DOM_SID *psid, uint8 *psid_name_use)* {*( 	extern DOM_SID global_sid_World_Domain; 	struct passwd *pass = NULL; 	DOM_SID local_sid;a  ' 	sid_copy(&local_sid, &global_sam_sid);s  N 	if(!strequal(global_myname, domain) && !strequal(global_myworkgroup, domain)) 		return False;n   	/* < 	 * Special case for MACHINE\Everyone. Map to the world_sid. 	 */  ! 	if(strequal(user, "Everyone")) {*, 		sid_copy( psid, &global_sid_World_Domain); 		sid_append_rid(psid, 0);" 		*psid_name_use = SID_NAME_ALIAS; 		return True; 	}   	(void)map_username(user);  ' 	if(!(pass = Get_Pwnam(user, False))) {  		/* 		 * Maybe it was a group ?* 		 */*% 		struct group *grp = getgrnam(user);*  
 		if(!grp) 			return False;  A 		sid_append_rid( &local_sid, pdb_gid_to_group_rid(grp->gr_gid)); " 		*psid_name_use = SID_NAME_ALIAS;	 	} else {c  A 		sid_append_rid( &local_sid, pdb_uid_to_user_rid(pass->pw_uid));*! 		*psid_name_use = SID_NAME_USER;* 	}   	sid_copy( psid, &local_sid);   
 	return True;a }p