" $! File: SETUP_SAMBA_VMS_BUILD.COM $!F $! This file sets up logical names for building SAMBA 2.0.6 on OpenVMS $! using the frontport library.  $!N $! This file should reside at the base directory where the VMS specific sourceK $! is stored in.  It will assume that the SAMBA distribution is on the same 
 $! device. $!I $! Your default directory should be the tree where the binary modules and & $! source modules that are under test. $!G $! Logical names will be used to find the different SAMBA components to & $! keep the command line lengths down. $!J $! The goal is not to add or modify any files in the SAMBA Source tree for2 $! this port, so that upgrades are faster to port. $!I $! You will need a JTQUOTA of at least 20480 for all of the logical names  $! needed for the build. $! $! 13-Sep-1999	J. Malmberg $!M $!===========================================================================  $! $!, $! First find out what type of CPU we are on- $!-------------------------------------------   $hw_model = f$getsyi("HW_MODEL") $if hw_model .ge. 1000 $then  $    arch = "AXP"  $    __ALPHA__ == "TRUE" $else  $    arch = "VAX"  $    __VAX__ == "TRUE" $endif $! $! $! Where are the sources?  $!----------------------- ' $procedure = f$environment("PROCEDURE") ' $device = f$parse(procedure,,,"DEVICE") * $direct = f$parse(procedure,,,"DIRECTORY") $!& $my_default = f$environment("DEFAULT")( $my_dev = f$parse(my_default,,,"DEVICE")+ $my_dir = f$parse(my_default,,,"DIRECTORY")  $source_dir = my_dev + my_dir & $source_dir_len = f$length(source_dir)5 $delim = f$extract(source_dir_len - 1, 1, source_dir) ; $source_path = f$extract(0, source_dir_len - 1, source_dir)  $! $!7 $! The local source/object/library/include/binary files  $!-----------------------   $local_src = f$trnlnm("LCL_SRC") $if local_src .eqs. "" $then # $   define/job lcl_src 'source_dir'  $endif $!  $local_obj = f$trnlnm("LCL_OBJ") $if local_obj .eqs. "" $then # $   define/job lcl_obj 'source_dir'  $endif $!  $local_bin = f$trnlnm("LCL_BIN") $if local_bin .eqs. "" $then  $   sdir = "bin"5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!  $local_inc = f$trnlnm("LCL_INC") $if local_inc .eqs. "" $then # $   define/job lcl_inc 'source_dir'  $endif $!& $local_client = f$trnlnm("LCL_CLIENT") $if local_client .eqs. ""  $then  $   sdir = "client" 5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $! $!, $local_codepages = f$trnlnm("LCL_codepages") $if local_client .eqs. ""  $then  $   sdir = "codepages"5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!( $local_groupdb = f$trnlnm("LCL_GROUPDB") $if local_groupdb .eqs. "" $then  $   sdir = "groupdb"5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!( $local_include = f$trnlnm("LCL_INCLUDE") $if local_include .eqs. "" $then  $   sdir = "include"5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!  $local_lib = f$trnlnm("LCL_LIB") $if local_lib .eqs. "" $then  $   sdir = "lib"5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!& $local_libsmb = f$trnlnm("LCL_LIBSMB") $if local_libsmb .eqs. ""  $then  $   sdir = "libsmb" 5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!( $local_locking = f$trnlnm("LCL_LOCKING") $if local_locking .eqs. "" $then  $   sdir = "locking"5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!( $local_mem_man = f$trnlnm("LCL_MEM_MAN") $if local_mem_man .eqs. "" $then  $   sdir = "mem_man"5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!" $local_nmbd = f$trnlnm("LCL_NMBD") $if local_nmbd .eqs. ""  $then  $   sdir = "nmbd" 5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!$ $local_param = f$trnlnm("LCL_PARAM") $if local_param .eqs. "" $then  $   sdir = "param"5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!& $local_passdb = f$trnlnm("LCL_PASSDB") $if local_passdb .eqs. ""  $then  $   sdir = "passdb" 5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!* $local_printing = f$trnlnm("LCL_PRINTING") $if local_printing .eqs. ""  $then  $   sdir = "printing" 5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!, $local_rpcclient = f$trnlnm("LCL_RPCCLIENT") $if local_rpcclient .eqs. "" $then  $   sdir = "rpcclient"5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!. $local_rpc_client = f$trnlnm("LCL_RPC_CLIENT") $if local_rpc_client .eqs. ""  $then  $   sdir = "rpc_client" 5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!, $local_rpc_parse = f$trnlnm("LCL_RPC_PARSE") $if local_rpc_parse .eqs. "" $then  $   sdir = "rpc_parse"5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!. $local_rpc_server = f$trnlnm("LCL_RPC_SERVER") $if local_rpc_server .eqs. ""  $then  $   sdir = "rpc_server" 5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!" $local_smbd = f$trnlnm("LCL_SMBD") $if local_smbd .eqs. ""  $then  $   sdir = "smbd" 5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!. $local_smbwrapper = f$trnlnm("LCL_SMBWRAPPER") $if local_smbwrapper .eqs. ""  $then  $   sdir = "smbwrapper" 5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!# $local_test = f$trnlnm("LCL_TESTS")  $if local_test .eqs. ""  $then  $   sdir = "tests"5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!$ $local_ubiqx = f$trnlnm("LCL_UBIQX") $if local_ubiqx .eqs. "" $then  $   sdir = "ubiqx"5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!$ $local_utils = f$trnlnm("LCL_UTILS") $if local_utils .eqs. "" $then  $   sdir = "utils"5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $!  $local_web = f$trnlnm("LCL_WEB") $if local_web .eqs. "" $then  $   sdir = "web"5 $   define/job lcl_'sdir' 'source_path'.'sdir''delim' 4 $   if f$search("''source_dir'''sdir'.dir") .eqs. "" $   then( $	create/dir 'source_path'.'sdir''delim'	 $   endif  $endif $! $!# $! Samba VMS CMS Source directories $ $!---------------------------------- $base_vdev = device 5 $if (device .eqs. my_dev) .and. (direct .eqs. my_dir)  $then  $!. $!   A separate source directory was not found/ $!---------------------------------------------  $    goto samba_vms_loop_end $endif/ $delim = f$extract(f$length(direct)-1,1,direct) ? $base_vdir = f$extract(0, f$length(direct) - 1, direct) + delim  $!! $if f$trnlnm("VSMB_SRC") .eqs. ""  $then . $   define/job VSMB_SRC 'base_vdev''base_vdir'9 $   if f$trnlnm("SMB_SRC") .nes. "" then deas/job smb_src  $endif $! $samba_vms_loop:: $   dir_spec = f$search("''base_vdev'''base_vdir'*.dir",1)5 $   if dir_spec .eqs. "" then goto samba_vms_loop_end ) $   dir_name = f$parse(dir_spec,,,"NAME") 4 $   if dir_name .eqs. "CMS" then goto samba_vms_loop+ $   dir_test = f$trnlnm("VSMB_''dir_name'")  $   if (dir_test) .eqs. "" $   thenJ $	vsmb_dir= f$parse(dir_spec,,,"DIRECTORY") - delim +"."+ dir_name + delim2 $	define/job VSMB_'dir_name' 'base_vdev''vsmb_dir' $!- $!	Cancel the search list from a previous run 3 $!------------------------------------------------- ) $	if f$trnlnn("SMB_''dir_name'") .nes. ""  $	then $	    deas/job smb_'dir_name'  $	endif 	 $   endif  $   goto samba_vms_loop  $samba_vms_loop_end: $! $! $! Samba Source directories  $!---------------------------  $base_dev = device $!base_dev = "CMS_ROOT:" $base_dir = "[samba.source]"/ $delim = f$extract(f$length(direct)-1,1,direct)  $!  $if f$trnlnm("SMB_SRC") .eqs. "" $then $ $   if f$trnlnm("VSMB_SRC") .eqs. "" $   then, $	define/job VSMB_SRC 'base_vdev''base_vdir' $   else< $	define/job SMB_SRC lcl_src:,vsmb_src:,'base_dev''base_dir'	 $   endifi $endif $! $samba_loop:8 $   dir_spec = f$search("''base_dev'''base_dir'*.dir",1)1 $   if dir_spec .eqs. "" then goto samba_loop_endn) $   dir_name = f$parse(dir_spec,,,"NAME") 0 $   if dir_name .eqs. "CMS" then goto samba_loop* $   dir_test = f$trnlnm("SMB_''dir_name'") $   if (dir_test) .eqs. "" $   thenJ $	smb_dir = f$parse(dir_spec,,,"DIRECTORY") - delim +"."+ dir_name + delim* $	if f$trnlnm("VSMB_''dir_name'") .eqs. "" $	thenC $	    define/job SMB_'dir_name' lcl_'dir_name':,'base_dev''smb_dir'a $	else! $	    define/job SMB_'dir_name' -J5 		lcl_'dir_name':,VSMB_'dir_name','base_dev''smb_dir'  $	endif 	 $   endifl $   goto samba_loop9 $samba_loop_end: $! $! Symbols needed= $!----------------- $make_samba :== mms/descrip=SMB_SRC:SAMBA.MMSF $!
 $all_exit: $  exitf