/*
 * if-generic.c by Dave Curry
 */

#if defined(BSD) || defined(HPUX) || defined(SUNOS4)

#include <sys/param.h>
#include <sys/socket.h>
#ifdef SUNOS4
#include <sys/sockio.h>
#endif
#include <sys/ioctl.h>
#include <net/if.h>
#include <stdio.h>

extern char	*hostName;

extern int	verbose;

checkInterfaces()
{
	int n, s;
	char cbuf[1024];
	struct ifconf ifc;
	struct ifreq ifr, *ifrp;

	if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
		fatal("socket", NULL);

	ifc.ifc_buf = cbuf;
	ifc.ifc_len = sizeof(cbuf);

	if (ioctl(s, SIOCGIFCONF, (char *) &ifc) < 0)
		fatal("ioctl: SIOCGIFCONF", NULL);

	close(s);
	ifrp = ifc.ifc_req;

	for (n = ifc.ifc_len / sizeof(struct ifreq); n > 0; n--, ifrp++) {
		if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
			fatal("socket", NULL);

		strcpy(ifr.ifr_name, ifrp->ifr_name);

		if (ioctl(s, SIOCGIFFLAGS, (char *) &ifr) < 0)
			fatal("ioctl: SIOCGIFFLAGS", NULL);

		if (verbose) {
			printf("Interface %s: flags=0x%x\n", ifr.ifr_name,
			       ifr.ifr_flags);
		}

		if (ifr.ifr_flags & IFF_PROMISC) {
			printf("WARNING: %s INTERFACE %s IS IN PROMISCUOUS MODE.\n",
			       hostName, ifr.ifr_name);
		}

		if (ifr.ifr_flags & IFF_DEBUG) {
			printf("WARNING: %s INTERFACE %s IS IN DEBUG MODE.\n",
			       hostName, ifr.ifr_name);
		}

		close(s);
	}
}
#endif /* BSD || HPUX || SUNOS4 */
