/*
 * ifstatus.c by Dave Curry
 */

#include <sys/param.h>
#include <ctype.h>
#include <stdio.h>

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN	64
#endif

char	*hostName	= NULL;
char	*programName	= NULL;

int	verbose		= 0;

main(argc, argv)
char **argv;
int argc;
{
	char *p;
	char hostNameBuf[MAXHOSTNAMELEN+1];

	programName = *argv;
	hostName = hostNameBuf;

	while (--argc) {
		if (**++argv != '-')
			usage();

		switch (*++*argv) {
		case 'v':
			verbose++;
			break;
		default:
			usage();
			break;
		}
	}

	if (gethostname(hostNameBuf, sizeof(hostNameBuf)) < 0)
		fatal("gethostname", NULL);

	for (p = hostName; *p != '\0'; p++) {
		if (islower(*p))
			*p = toupper(*p);
	}

	checkInterfaces();
	exit(0);
}

fatal(s1, s2)
char *s1, *s2;
{
	fprintf(stderr, "%s: ", programName);

	if (s2 != NULL)
		fprintf(stderr, "%s: ", s2);

	perror(s1);
	exit(1);
}

usage()
{
	fprintf(stderr, "Usage: %s [-v]\n", programName);
	exit(1);
}
