$!
$! BUILD_CVS.COM
$! Written By:  Robert Alan Byer
$!              byer@mail.ourservers.net
$!
$!
$! This script is used to compile and link CVS v1.11 for OpenVMS using 
$! DEC C v6.0.
$!
$! The script accepts the following parameters.
$!
$!	P1	ALL		Just Build "Everything".
$!              ZLIB		Just Build The ZLIB-xxx.OLB Library.
$!	 	DIFFLIB 	Just Build The DIFFLIB-xxx.OLB Library.
$!		GNULIB		Just Build The GNULIB-xxx.OLB Library.
$!		VMSLIB		Just Build The VMSLIB-xxx.OLB Library.
$!		CVSLIB		Just Build The CVSLIB-xx.OLB Library.
$!		CVS		Just Build CVS Executable.
$!
$!	P2	DEBUG		Link With Debugger Information.
$!		NODEBUG		Link Withoug Debugger Information.
$!
$! The default is "ALL" and "NODEBUG".
$!
$!
$! Check To Make Sure We Have Valid Command Line Parameters.
$!
$ GOSUB CHECK_OPTIONS
$!
$! Check To See If We Are On An AXP Machine.
$!
$ IF (F$GETSYI("CPU").LT.128)
$ THEN
$!
$!  We Are On A VAX Machine So Tell The User.
$!
$   WRITE SYS$OUTPUT "Compiling On A VAX Machine."
$!
$!  Define The Machine Type.
$!
$   MACHINE_TYPE = "VAX"
$!
$!  Define The Compile Command For VAX.
$!
$   CC :== CC/PREFIX=(ALL,EXCEPT=(PCLOSE,POPEN,GETPWUID,GETLOGIN,READDIR, -
                      CLOSEDIR,OPENDIR,UNLINK,WAITPID,RMDIR)) -
             /STANDARD=VAXC/NOOPTIMIZE/DEBUG/DEFINE=("HAVE_CONFIG_H=1")
$!
$! Else, We Are On An AXP Machine.
$!
$ ELSE
$!
$!  We Are On A AXP Machine So Tell The User.
$!
$   WRITE SYS$OUTPUT "Compiling On A AXP Machine."
$!
$!  Define The Machine Type.
$!
$   MACHINE_TYPE = "AXP"
$!
$!  Define The Compile Command For AXP.
$!
$   CC :== CC/PREFIX=(ALL,EXCEPT=(PCLOSE,POPEN,GETPWUID,GETLOGIN,READDIR, -
                      CLOSEDIR,OPENDIR,UNLINK,WAITPID,RMDIR)) -
             /STANDARD=VAXC/NOOPTIMIZE/DEBUG/DEFINE=("HAVE_CONFIG_H=1")
$!
$! End Of The Machine Check.
$!
$ ENDIF
$!
$! Define The ZLIB Library Name.
$!
$ ZLIB_NAME = "SYS$DISK:[.ZLIB]ZLIB-''MACHINE_TYPE'.OLB"
$!
$! Define The DIFFLIB Library Name.
$!
$ DIFFLIB_NAME = "SYS$DISK:[.DIFF]DIFFLIB-''MACHINE_TYPE'.OLB"
$!
$! Define The GNULIB Library.
$!
$ GNULIB_NAME = "SYS$DISK:[.LIB]GNULIB-''MACHINE_TYPE'.OLB"
$!
$! Define The VMSLIB Library.
$!
$ VMSLIB_NAME = "SYS$DISK:[.VMS]VMSLIB-''MACHINE_TYPE'.OLB"
$!
$! Define The CVSLIB Library.
$!
$ CVSLIB_NAME = "SYS$DISK:[.SRC]CVSLIB-''MACHINE_TYPE'.OLB"
$!
$! Check To See What We Are To Do.
$!
$ IF (BUILDALL.EQS."TRUE")
$ THEN
$!
$!  Build "Everything".
$!
$   GOSUB BUILD_ZLIB
$   GOSUB BUILD_DIFFLIB
$   GOSUB BUILD_GNULIB
$   GOSUB BUILD_VMSLIB
$   GOSUB BUILD_CVSLIB
$   GOSUB BUILD_CVS
$!
$! Else...
$!
$ ELSE
$!
$!  Build Just What The User Wants Us To Build.
$!
$   GOSUB BUILD_'BUILDALL'
$!
$! Time To Exit The Build Check.
$!
$ ENDIF
$!
$! Time To EXIT.
$!
$ EXIT
$!
$! Build The ZLIB Library.
$!
$ BUILD_ZLIB:
$!
$! Tell The User What We Are Doing.
$!
$ WRITE SYS$OUTPUT ""
$ WRITE SYS$OUTPUT "Compling The ",ZLIB_NAME," Library."
$ WRITE SYS$OUTPUT "Using Compile Command: ",CC,"/INCLUDE=(SYS$DISK:[.ZLIB])"
$ WRITE SYS$OUTPUT ""
$!
$! Check To See If We Already Have A "ZLIB-xxx.OLB" Library...
$!
$ IF (F$SEARCH(ZLIB_NAME).EQS."")
$ THEN
$!
$!  Guess Not, Create The Library.
$!
$   LIBRARY/CREATE/OBJECT 'ZLIB_NAME'
$!
$! End The Library Check.
$!
$ ENDIF
$!
$! Define The Files That Are Necessary For The ZLIB Library.
$!
$ ZLIB_FILES = "ADLER32,COMPRESS,CRC32,GZIO,UNCOMPR,DEFLATE,TREES," + -
               "ZUTIL,INFLATE,INFBLOCK,INFTREES,INFCODES,INFUTIL," + -
               "INFFAST"
$!
$!  Define A File Counter And Set It To "0".
$!
$ ZLIB_FILE_COUNTER = 0
$!
$! Top Of The File Loop.
$!
$ NEXT_ZLIB_FILE:
$!
$! O.K, Extract The File Name From The File List.
$!
$ ZLIB_FILE_NAME = F$ELEMENT(ZLIB_FILE_COUNTER,",",ZLIB_FILES)
$!
$! Check To See If We Are At The End Of The File List.
$!
$ IF (ZLIB_FILE_NAME.EQS.",") THEN GOTO ZLIB_FILE_DONE
$!
$! Increment The Counter.
$!
$ ZLIB_FILE_COUNTER = ZLIB_FILE_COUNTER + 1
$!
$! Create The Source File Name.
$!
$ ZLIB_SOURCE_FILE = "SYS$DISK:[.ZLIB]" + ZLIB_FILE_NAME + ".C"
$!
$! Create The Object File Name.
$!
$ ZLIB_OBJECT_FILE = "SYS$DISK:[.ZLIB]" + ZLIB_FILE_NAME + ".OBJ"
$!
$! Check To See If The File We Want To Compile Actually Exists.
$!
$ IF (F$SEARCH(ZLIB_SOURCE_FILE).EQS."")
$ THEN
$!
$!  Tell The User That The File Dosen't Exist.
$!
$   WRITE SYS$OUTPUT ""
$   WRITE SYS$OUTPUT "The File ",ZLIB_SOURCE_FILE," Dosen't Exist."
$   WRITE SYS$OUTPUT ""
$!
$!  Exit The Build.
$!
$   EXIT
$!
$! End The File Check.
$!
$ ENDIF
$!
$! Tell The User What We Are Compiling.
$!
$  WRITE SYS$OUTPUT "	",ZLIB_SOURCE_FILE
$!
$! Compile The File.
$!
$  CC/INCLUDE=(SYS$DISK:[.ZLIB])/OBJECT='ZLIB_OBJECT_FILE' 'ZLIB_SOURCE_FILE'
$!
$! Add It To The Library.
$!
$ LIBRARY/REPLACE/OBJECT 'ZLIB_NAME' 'ZLIB_OBJECT_FILE'
$!
$! Go Back And Do It Again.
$!
$ GOTO NEXT_ZLIB_FILE
$!
$! All Done Compiling.
$!
$ ZLIB_FILE_DONE:
$!
$! Delete The Object Files.
$!
$ DELETE/NOCONFIRM/NOLOG SYS$DISK:[.ZLIB]*.OBJ;*
$!
$! That's It, Time To Return From Where We Came From.
$!
$ RETURN
$!
$! Build The DIFFLIB Library.
$!
$ BUILD_DIFFLIB:
$!
$! Tell The User What We Are Doing.
$!
$ WRITE SYS$OUTPUT ""
$ WRITE SYS$OUTPUT "Compling The ",DIFFLIB_NAME," Library."
$ WRITE SYS$OUTPUT "Using Compile Command: ",CC,"/INCLUDE=(SYS$DISK:[.DIFF],SYS$DISK:[.LIB],SYS$DISK:[.SRC],SYS$DISK:[.VMS])"
$ WRITE SYS$OUTPUT ""
$!
$! Check To See If We Already Have A "DIFFLIB-xxx.OLB" Library...
$!
$ IF (F$SEARCH(DIFFLIB_NAME).EQS."")
$ THEN
$!
$!  Guess Not, Create The Library.
$!
$   LIBRARY/CREATE/OBJECT 'DIFFLIB_NAME'
$!
$! End The Library Check.
$!
$ ENDIF
$!
$! Define The Files That Are Necessary For The DIFFLIB Library.
$!
$ DIFFLIB_FILES = "ANALYZE,CMPBUF,CONTEXT,DIFF,DIFF3,DIR,ED,IFDEF,IO," + -
                  "NORMAL,SIDE,UTIL,VERSION"
$!
$!  Define A File Counter And Set It To "0".
$!
$ DIFFLIB_FILE_COUNTER = 0
$!
$! Top Of The File Loop.
$!
$ NEXT_DIFFLIB_FILE:
$!
$! O.K, Extract The File Name From The File List.
$!
$ DIFFLIB_FILE_NAME = F$ELEMENT(DIFFLIB_FILE_COUNTER,",",DIFFLIB_FILES)
$!
$! Check To See If We Are At The End Of The File List.
$!
$ IF (DIFFLIB_FILE_NAME.EQS.",") THEN GOTO DIFFLIB_FILE_DONE
$!
$! Increment The Counter.
$!
$ DIFFLIB_FILE_COUNTER = DIFFLIB_FILE_COUNTER + 1
$!
$! Create The Source File Name.
$!
$ DIFFLIB_SOURCE_FILE = "SYS$DISK:[.DIFF]" + DIFFLIB_FILE_NAME + ".C"
$!
$! Create The Object File Name.
$!
$ DIFFLIB_OBJECT_FILE = "SYS$DISK:[.DIFF]" + DIFFLIB_FILE_NAME + ".OBJ"
$!
$! Check To See If The File We Want To Compile Actually Exists.
$!
$ IF (F$SEARCH(DIFFLIB_SOURCE_FILE).EQS."")
$ THEN
$!
$!  Tell The User That The File Dosen't Exist.
$!
$   WRITE SYS$OUTPUT ""
$   WRITE SYS$OUTPUT "The File ",DIFFLIB_SOURCE_FILE," Dosen't Exist."
$   WRITE SYS$OUTPUT ""
$!
$!  Exit The Build.
$!
$   EXIT
$!
$! End The File Check.
$!
$ ENDIF
$!
$! Tell The User What We Are Compiling.
$!
$  WRITE SYS$OUTPUT "	",DIFFLIB_SOURCE_FILE
$!
$! Compile The File.
$!
$  CC/INCLUDE=(SYS$DISK:[.DIFF],SYS$DISK:[.LIB],SYS$DISK:[.SRC],SYS$DISK:[.VMS]) -
     /OBJECT='DIFFLIB_OBJECT_FILE' 'DIFFLIB_SOURCE_FILE'
$!
$! Add It To The Library.
$!
$ LIBRARY/REPLACE/OBJECT 'DIFFLIB_NAME' 'DIFFLIB_OBJECT_FILE'
$!
$! Go Back And Do It Again.
$!
$ GOTO NEXT_DIFFLIB_FILE
$!
$! All Done Compiling.
$!
$ DIFFLIB_FILE_DONE:
$!
$! Delete The Object Files.
$!
$ DELETE/NOCONFIRM/NOLOG SYS$DISK:[.DIFF]*.OBJ;*
$!
$! That's It, Time To Return From Where We Came From.
$!
$ RETURN
$!
$! Build The GNULIB-xxx Library.
$!
$ BUILD_GNULIB:
$!
$! Tell The User What We Are Doing.
$!
$ WRITE SYS$OUTPUT ""
$ WRITE SYS$OUTPUT "Compling The ",GNULIB_NAME," Library."
$ WRITE SYS$OUTPUT "Using Compile Command: ",CC,"/INCLUDE=(SYS$DISK:[.LIB],SYS$DISK:[.SRC],SYS$DISK:[.VMS])"
$ WRITE SYS$OUTPUT ""
$!
$! Check To See If We Already Have A "GNULIB-xxx.OLB" Library...
$!
$ IF (F$SEARCH(GNULIB_NAME).EQS."")
$ THEN
$!
$!  Guess Not, Create The Library.
$!
$   LIBRARY/CREATE/OBJECT 'GNULIB_NAME'
$!
$! End The Library Check.
$!
$ ENDIF
$!
$! Define The Files That Are Necessary For The GNULIB Library.
$!
$ GNULIB_FILES = "FNMATCH,GETDATE,GETLINE,GETOPT,GETOPT1,MD5,REGEX," + -
                 "SAVECWD,SIGHANDLE,STRIPSLASH,VALLOC,XGETWD,YESNO"
$!
$!  Define A File Counter And Set It To "0".
$!
$ GNULIB_FILE_COUNTER = 0
$!
$! Top Of The File Loop.
$!
$ NEXT_GNULIB_FILE:
$!
$! O.K, Extract The File Name From The File List.
$!
$ GNULIB_FILE_NAME = F$ELEMENT(GNULIB_FILE_COUNTER,",",GNULIB_FILES)
$!
$! Check To See If We Are At The End Of The File List.
$!
$ IF (GNULIB_FILE_NAME.EQS.",") THEN GOTO GNULIB_FILE_DONE
$!
$! Increment The Counter.
$!
$ GNULIB_FILE_COUNTER = GNULIB_FILE_COUNTER + 1
$!
$! Create The Source File Name.
$!
$ GNULIB_SOURCE_FILE = "SYS$DISK:[.LIB]" + GNULIB_FILE_NAME + ".C"
$!
$! Create The Object File Name.
$!
$ GNULIB_OBJECT_FILE = "SYS$DISK:[.LIB]" + GNULIB_FILE_NAME + ".OBJ"
$!
$! Check To See If The File We Want To Compile Actually Exists.
$!
$ IF (F$SEARCH(GNULIB_SOURCE_FILE).EQS."")
$ THEN
$!
$!  Tell The User That The File Dosen't Exist.
$!
$   WRITE SYS$OUTPUT ""
$   WRITE SYS$OUTPUT "The File ",GNULIB_SOURCE_FILE," Dosen't Exist."
$   WRITE SYS$OUTPUT ""
$!
$!  Exit The Build.
$!
$   EXIT
$!
$! End The File Check.
$!
$ ENDIF
$!
$! Tell The User What We Are Compiling.
$!
$  WRITE SYS$OUTPUT "	",GNULIB_SOURCE_FILE
$!
$! Compile The File.
$!
$ CC/INCLUDE=(SYS$DISK:[.LIB],SYS$DISK:[.SRC],SYS$DISK:[.VMS]) -
    /OBJECT='GNULIB_OBJECT_FILE' 'GNULIB_SOURCE_FILE'
$!
$! Add It To The Library.
$!
$ LIBRARY/REPLACE/OBJECT 'GNULIB_NAME' 'GNULIB_OBJECT_FILE'
$!
$! Go Back And Do It Again.
$!
$ GOTO NEXT_GNULIB_FILE
$!
$! All Done Compiling.
$!
$ GNULIB_FILE_DONE:
$!
$! Delete The Object Files.
$!
$ DELETE/NOCONFIRM/NOLOG SYS$DISK:[.LIB]*.OBJ;*
$!
$! That's All, Time To Return From Where We Came From.
$!
$ RETURN
$!
$! Build The VMSLIB-xxx Library.
$!
$ BUILD_VMSLIB:
$!
$! Tell The User What We Are Doing.
$!
$ WRITE SYS$OUTPUT ""
$ WRITE SYS$OUTPUT "Compling The ",VMSLIB_NAME," Library."
$ WRITE SYS$OUTPUT "Using Compile Command: ",CC,"/INCLUDE=(SYS$DISK:[.LIB],SYS$DISK:[.SRC],SYS$DISK:[.VMS])"
$ WRITE SYS$OUTPUT ""
$!
$! Check To See If We Already Have A "VMSLIB-xxx.OLB" Library...
$!
$ IF (F$SEARCH(VMSLIB_NAME).EQS."")
$ THEN
$!
$!  Guess Not, Create The Library.
$!
$   LIBRARY/CREATE/OBJECT 'VMSLIB_NAME'
$!
$! End The Library Check.
$!
$ ENDIF
$!
$! Define The Files That Are Necessary For The VMSLIB Library.
$!
$ VMSLIB_FILES = "FILESUBR,FILUTILS,GETPASS,GETWD,MISC,NDIR,PC," + -
                 "PIPE,PIPED_CHILD,PWD,RCMD,READLINK,RMDIR," + -
                 "STARTSERVER,STAT,UNLINK,UTIME,VMSMUNCH,WAITPID"
$!
$!  Define A File Counter And Set It To "0".
$!
$ VMSLIB_FILE_COUNTER = 0
$!
$! Top Of The File Loop.
$!
$ NEXT_VMSLIB_FILE:
$!
$! O.K, Extract The File Name From The File List.
$!
$ VMSLIB_FILE_NAME = F$ELEMENT(VMSLIB_FILE_COUNTER,",",VMSLIB_FILES)
$!
$! Check To See If We Are At The End Of The File List.
$!
$ IF (VMSLIB_FILE_NAME.EQS.",") THEN GOTO VMSLIB_FILE_DONE
$!
$! Increment The Counter.
$!
$ VMSLIB_FILE_COUNTER = VMSLIB_FILE_COUNTER + 1
$!
$! Create The Source File Name.
$!
$ VMSLIB_SOURCE_FILE = "SYS$DISK:[.VMS]" + VMSLIB_FILE_NAME + ".C"
$!
$! Create The Object File Name.
$!
$ VMSLIB_OBJECT_FILE = "SYS$DISK:[.VMS]" + VMSLIB_FILE_NAME + ".OBJ"
$!
$! Check To See If The File We Want To Compile Actually Exists.
$!
$ IF (F$SEARCH(VMSLIB_SOURCE_FILE).EQS."")
$ THEN
$!
$!  Tell The User That The File Dosen't Exist.
$!
$   WRITE SYS$OUTPUT ""
$   WRITE SYS$OUTPUT "The File ",VMSLIB_SOURCE_FILE," Dosen't Exist."
$   WRITE SYS$OUTPUT ""
$!
$!  Exit The Build.
$!
$   EXIT
$!
$! End The File Check.
$!
$ ENDIF
$!
$! Tell The User What We Are Compiling.
$!
$ WRITE SYS$OUTPUT "	",VMSLIB_SOURCE_FILE
$!
$! Check To See If We Are Compiling The VMSMUNCH.C File.
$!
$ IF (VMSLIB_FILE_NAME.EQS."VMSMUNCH")
$ THEN
$!
$!  It Is, So Use The Special Compile (i.e "/NOSTANDARD").
$!
$   CC/INCLUDE=(SYS$DISK:[.LIB],SYS$DISK:[.SRC],SYS$DISK:[.VMS]) -
      /NOSTANDARD/OBJECT='VMSLIB_OBJECT_FILE' 'VMSLIB_SOURCE_FILE'
$!
$! Else...
$!
$ ELSE
$!
$!  Compile The File Normally.
$!
$   CC/INCLUDE=(SYS$DISK:[.LIB],SYS$DISK:[.SRC],SYS$DISK:[.VMS]) -
      /OBJECT='VMSLIB_OBJECT_FILE' 'VMSLIB_SOURCE_FILE'
$!
$! Time To End The File Check.
$!
$ ENDIF
$!
$! Add It To The Library.
$!
$ LIBRARY/REPLACE/OBJECT 'VMSLIB_NAME' 'VMSLIB_OBJECT_FILE'
$!
$! Go Back And Do It Again.
$!
$ GOTO NEXT_VMSLIB_FILE
$!
$! All Done Compiling.
$!
$ VMSLIB_FILE_DONE:
$!
$! Delete The Object Files.
$!
$ DELETE/NOCONFIRM/NOLOG SYS$DISK:[.VMS]*.OBJ;*
$!
$! That's All, Time To Return From Where We Came From.
$!
$ RETURN
$!
$! Build The CVSLIB-xxx Library.
$!
$ BUILD_CVSLIB:
$!
$! Tell The User What We Are Doing.
$!
$ WRITE SYS$OUTPUT ""
$ WRITE SYS$OUTPUT "Compling The ",CVSLIB_NAME," Library."
$ WRITE SYS$OUTPUT "Using Compile Command: ",CC,"/INCLUDE=(SYS$DISK:[.SRC],SYS$DISK:[.VMS],SYS$DISK:[.LIB],SYS$DISK:[.ZLIB],SYS$DISK:[.DIFF])"
$ WRITE SYS$OUTPUT ""
$!
$! Check To See If We Already Have A "CVSLIB-xxx.OLB" Library...
$!
$ IF (F$SEARCH(CVSLIB_NAME).EQS."")
$ THEN
$!
$!  Guess Not, Create The Library.
$!
$   LIBRARY/CREATE/OBJECT 'CVSLIB_NAME'
$!
$! End The Library Check.
$!
$ ENDIF
$!
$! Define The Files That Are Necessary For The CVSLIB Library.
$!
$ CVSLIB_FILES = "ADD,ADMIN,BUFFER,CHECKIN,CHECKOUT,CLASSIFY,CLIENT," + -
                 "COMMIT,CREATE_ADM,CVSRC,DIFF,EDIT,ENTRIES,ERROR," + -
                 "EXPAND_PATH,FILEATTR,FIND_NAMES,HASH,HISTORY,IGNORE," + -
                 "IMPORT,LOCK,LOG,LOGIN,LOGMSG,MKMODULES,MODULES,MYNDBM," + -
                 "NO_DIFF,PARSEINFO,PATCH,RCS,RCSCMDS,RECURSE,RELEASE," + -
                 "REMOVE,REPOS,ROOT,RTAG,RUN,SCRAMBLE,SERVER,STATUS,SUBR," + -
                 "TAG,UPDATE,VERSION,VERS_TS,WATCH,WRAPPER,ZLIB"
$!
$! Define A File Counter And Set It To "0".
$!
$ CVSLIB_FILE_COUNTER = 0
$!
$! Top Of The File Loop.
$!
$ NEXT_CVSLIB_FILE:
$!
$! O.K, Extract The File Name From The File List.
$!
$ CVSLIB_FILE_NAME = F$ELEMENT(CVSLIB_FILE_COUNTER,",",CVSLIB_FILES)
$!
$! Check To See If We Are At The End Of The File List.
$!
$ IF (CVSLIB_FILE_NAME.EQS.",") THEN GOTO CVSLIB_FILE_DONE
$!
$! Increment The Counter.
$!
$ CVSLIB_FILE_COUNTER = CVSLIB_FILE_COUNTER + 1
$!
$! Create The Source File Name.
$!
$ CVSLIB_SOURCE_FILE = "SYS$DISK:[.SRC]" + CVSLIB_FILE_NAME + ".C"
$!
$! Create The Object File Name.
$!
$ CVSLIB_OBJECT_FILE = "SYS$DISK:[.SRC]" + CVSLIB_FILE_NAME + ".OBJ"
$!
$! Check To See If The File We Want To Compile Actually Exists.
$!
$ IF (F$SEARCH(CVSLIB_SOURCE_FILE).EQS."")
$ THEN
$!
$!  Tell The User That The File Dosen't Exist.
$!
$   WRITE SYS$OUTPUT ""
$   WRITE SYS$OUTPUT "The File ",CVSLIB_SOURCE_FILE," Dosen't Exist."
$   WRITE SYS$OUTPUT ""
$!
$!  Exit The Build.
$!
$   EXIT
$!
$! End The File Check.
$!
$ ENDIF
$!
$! Tell The User What We Are Compiling.
$!
$  WRITE SYS$OUTPUT "	",CVSLIB_SOURCE_FILE
$!
$! Compile The File.
$!
$ CC/INCLUDE=(SYS$DISK:[.SRC],SYS$DISK:[.VMS],SYS$DISK:[.LIB], -
              SYS$DISK:[.ZLIB],SYS$DISK:[.DIFF]) -
    /OBJECT='CVSLIB_OBJECT_FILE' 'CVSLIB_SOURCE_FILE'
$!
$! Add It To The Library.
$!
$ LIBRARY/REPLACE/OBJECT 'CVSLIB_NAME' 'CVSLIB_OBJECT_FILE'
$!
$! Go Back And Do It Again.
$!
$ GOTO NEXT_CVSLIB_FILE
$!
$! All Done Compiling.
$!
$ CVSLIB_FILE_DONE:
$!
$! Delete The Object Files.
$!
$ DELETE/NOCONFIRM/NOLOG SYS$DISK:[.SRC]*.OBJ;*
$!
$! That's All, Time To Return From Where We Came From.
$!
$ RETURN
$!
$! Build CVS.EXE
$!
$ BUILD_CVS:
$!
$! Check To See If We Have The "ZLIB-xxx.OLB" Library...
$!
$ IF (F$SEARCH(ZLIB_NAME).EQS."")
$ THEN
$!
$!  Tell The User We Can't Find The "ZLIB" Library, So We Are Gong To
$!  Just Create It.
$!
$   WRITE SYS$OUTPUT ""
$   WRITE SYS$OUTPUT "Can't Find The ",ZLIB_NAME," Library.  Since It Is"
$   WRITE SYS$OUTPUT "Needed To Build The CVS-''MACHINE_TYPE'.EXE Executable We Will Compile It Now."
$!
$!  Build The "ZLIB" Library.
$!
$   GOSUB BUILD_ZLIB
$!
$! End The ZLIB Library Check.
$!
$ ENDIF
$!
$! Check To See If We Have The "DIFFLIB-xxx.OLB" Library...
$!
$ IF (F$SEARCH(DIFFLIB_NAME).EQS."")
$ THEN
$!
$!  Tell The User We Can't Find The "DIFFLIB" Library, So We Are Gong To
$!  Just Create It.
$!
$   WRITE SYS$OUTPUT ""
$   WRITE SYS$OUTPUT "Can't Find The ",DIFFLIB_NAME," Library.  Since It Is"
$   WRITE SYS$OUTPUT "Needed To Build The CVS-''MACHINE_TYPE'.EXE Executable We Will Compile It Now."
$!
$!  Build The "DIFFLIB" Library.
$!
$   GOSUB BUILD_DIFFLIB
$!
$! End The DIFFLIB Library Check.
$!
$ ENDIF
$!
$! Check To See If We Have The "GNULIB-xxx.OLB" Library...
$!
$ IF (F$SEARCH(GNULIB_NAME).EQS."")
$ THEN
$!
$!  Tell The User We Can't Find The "GNULIB" Library, So We Are Gong To
$!  Just Create It.
$!
$   WRITE SYS$OUTPUT ""
$   WRITE SYS$OUTPUT "Can't Find The ",GNULIB_NAME," Library.  Since It Is"
$   WRITE SYS$OUTPUT "Needed To Build The CVS-''MACHINE_TYPE'.EXE Executable We Will Compile It Now."
$!
$!  Build The "GNULIB" Library.
$!
$   GOSUB BUILD_GNULIB
$!
$! End The GNULIB Library Check.
$!
$ ENDIF
$!
$! Check To See If We Have The "VMSLIB-xxx.OLB" Library...
$!
$ IF (F$SEARCH(VMSLIB_NAME).EQS."")
$ THEN
$!
$!  Tell The User We Can't Find The "VMSLIB" Library, So We Are Gong To
$!  Just Create It.
$!
$   WRITE SYS$OUTPUT ""
$   WRITE SYS$OUTPUT "Can't Find The ",VMSLIB_NAME," Library.  Since It Is"
$   WRITE SYS$OUTPUT "Needed To Build The CVS-''MACHINE_TYPE'.EXE Executable We Will Compile It Now."
$!
$!  Build The "VMSLIB" Library.
$!
$   GOSUB BUILD_VMSLIB
$!
$! End The VMSLIB Library Check.
$!
$ ENDIF
$!
$! Check To See If We Have The "CVSLIB-xxx.OLB" Library...
$!
$ IF (F$SEARCH(CVSLIB_NAME).EQS."")
$ THEN
$!
$!  Tell The User We Can't Find The "CVSLIB" Library, So We Are Gong To
$!  Just Create It.
$!
$   WRITE SYS$OUTPUT ""
$   WRITE SYS$OUTPUT "Can't Find The ",CVSLIB_NAME," Library.  Since It Is"
$   WRITE SYS$OUTPUT "Needed To Build The CVS-''MACHINE_TYPE'.EXE Executable We Will Compile It Now."
$!
$!  Build The "CVSLIB" Library.
$!
$   GOSUB BUILD_CVSLIB
$!
$! End The CVSLIB Library Check.
$!
$ ENDIF
$!
$! Check To Make Sure We Have The SYS$DISK:[.SRC]MAIN.C File.
$!
$ IF (F$SEARCH("SYS$DISK:[.SRC]MAIN.C").EQS."")
$ THEN
$!
$!  Tell The User We Can't Find The "MAIN.C" File, So We Are Gong To
$!  Exit As We Can't Compile Without It.
$!
$   WRITE SYS$OUTPUT ""
$   WRITE SYS$OUTPUT "Can't Find The SYS$DISK:[.SRC]MAIN.C File.  Since It's"
$   WRITE SYS$OUTPUT "Needed To Build CVS-''MACHINE_TYPE'.EXE We Will Exit Now."
$   WRITE SYS$OUTPUT ""
$!
$!  Since We Can't Compile Without, Time To Exit.
$!
$   EXIT
$!
$! End The MAIN.C File Check.
$!
$ ENDIF
$!
$! Well, Since It Looks Like We Have Everything, Tell The User What We
$! Are Going To Do.
$!
$ WRITE SYS$OUTPUT ""
$ WRITE SYS$OUTPUT "Building SYS$DISK:[]CVS-''MACHINE_TYPE'.EXE"
$ WRITE SYS$OUTPUT "Using Compile Command: ",CC,"/INCLUDE=(SYS$DISK:[.SRC],SYS$DISK:[.VMS],SYS$DISK:[.LIB])"
$ WRITE SYS$OUTPUT ""
$!
$! Compile MAIN.C
$!
$ CC/INCLUDE=(SYS$DISK:[.SRC],SYS$DISK:[.VMS],SYS$DISK:[.LIB]) -
    /OBJECT=SYS$DISK:[]CVS-'MACHINE_TYPE'.OBJ SYS$DISK:[.SRC]MAIN.C
$!
$! Link The Executable.
$!
$ LINK/'DEBUGGER'/'TRACEBACK'/EXE=SYS$DISK:[]CVS-'MACHINE_TYPE'.EXE -
      SYS$DISK:[]CVS-'MACHINE_TYPE'.OBJ,'CVSLIB_NAME'/LIBRARY, -
      'GNULIB_NAME'/LIBRARY,'VMSLIB_NAME'/LIBRARY,'ZLIB_NAME'/LIBRARY, -
      'DIFFLIB_NAME'/LIBRARY
$!,SYS$COMMON:[SYSLIB]VAXCRTL.OLB/LIBRARY
$!
$! That's All, Time To Return From Where We Came From.
$!
$ RETURN
$!
$! Check The User's Options.
$!
$ CHECK_OPTIONS:
$!
$! Check To See If We Are To "Just Build Everything."
$!
$ IF (P1.EQS."").OR.(P1.EQS."ALL")
$ THEN
$!
$!  P1 Is Blank Or "ALL", So Just Build Everything.
$!
$   BUILDALL = "TRUE"
$!
$! Else
$!
$ ELSE
$!
$!  Check To See If P1 Has A Valid Arguement.
$!
$   IF (P1.EQS."ZLIB").OR.(P1.EQS."DIFFLIB").OR.(P1.EQS."GNULIB").OR. -
       (P1.EQS."VMSLIB").OR.(P1.EQS."CVSLIB").OR.(P1.EQS."CVS")
$   THEN
$!
$!    A Valid Arguement.
$!
$     BUILDALL = P1
$!
$!   Else...
$!
$   ELSE
$!
$!    Tell The User We Don't Know What They Want.
$!
$     WRITE SYS$OUTPUT ""
$     WRITE SYS$OUTPUT "The Option ",P1," Is Invalid.  The Valid Options Are:"
$     WRITE SYS$OUTPUT ""
$     WRITE SYS$OUTPUT "    ALL         :  Just Build 'Everything'."
$     WRITE SYS$OUTPUT "    ZLIB        :  Just Build The ZLIB-xxx.OLB Library."
$     WRITE SYS$OUTPUT "    DIFFLIB     :  Just Build The DIFFLIB-xxx.OLB Library."
$     WRITE SYS$OUTPUT "    GNULIB      :  Just Build The GNULIB-xxx.OLB Library."
$     WRITE SYS$OUTPUT "    VMSLIB      :  Just Biuld The VMSLIB-xxx.OLB Library."
$     WRITE SYS$OUTPUT "    CVSLIB      :  Just Build The CVSLIB-xxx.OLB Library."
$     WRITE SYS$OUTPUT "    CVS         :  Just Build The CVS Executable."
$     WRITE SYS$OUTPUT ""
$!
$!    Time To Exit.
$!
$     EXIT
$!
$!  Time To End The Valid Arguement Check.
$!
$   ENDIF
$!
$! Time To End The BUILDALL Check.
$!
$ ENDIF
$!
$! Check To See If We Are To Link Without Debugger Information.
$!
$ IF ((P2.EQS."").OR.(P2.EQS."NODEBUG"))
$ THEN
$!
$!  P2 Is Either Blank Or "NODEBUG" So Link Without Debugger Information.
$!
$   DEBUGGER  = "NODEBUG"
$   TRACEBACK = "NOTRACEBACK"
$!
$!  Tell The User What They Selected.
$!
$   WRITE SYS$OUTPUT ""
$   WRITE SYS$OUTPUT "Runtime Debugger Won't Be Included At Link."
$!
$! Else...
$!
$ ELSE
$!
$!  Check To See If We Are To Link With Debugger Information.
$!
$   IF (P2.EQS."DEBUG")
$   THEN
$!
$!    Compile Without Link Information.
$!
$     DEBUGGER  = "DEBUG"
$     TRACEBACK = "TRACEBACK"
$!
$!    Tell The User What They Selected.
$!
$     WRITE SYS$OUTPUT ""
$     WRITE SYS$OUTPUT "Runtime Debugger Will Be Included At Link."
$!
$!  Else...
$!
$   ELSE
$!
$!    Tell The User Entered An Invalid Option..
$!
$     WRITE SYS$OUTPUT ""
$     WRITE SYS$OUTPUT "The Option ",P2," Is Invalid.  The Valid Options Are:"
$     WRITE SYS$OUTPUT ""
$     WRITE SYS$OUTPUT "    DEBUG    :  Link With The Debugger Information."
$     WRITE SYS$OUTPUT "    NODEBUG  :  Link Without The Debugger Information."
$     WRITE SYS$OUTPUT ""
$!
$!    Time To EXIT.
$!
$     EXIT
$   ENDIF
$ ENDIF
$!
$! Time To Return To Where We Were.
$!
$ RETURN
