 [inherit('PQM_OBJ:GLOBALDEF' 	,'SYS$LIBRARY:STARLET' # 	,'SYS$LIBRARY:PASCAL$LIB_ROUTINES' # 	,'SYS$LIBRARY:PASCAL$SMG_ROUTINES'  )] Module JOBS (output); P {*******************************************************************************  6   	JOBS		Routines which operate on the jobs in a queue  :   This module contains the routines which manipulate jobs.  ?   	Created 7-Nov-2000 by J.Begg, VSM Software Services Pty Ltd. C   	Copyright  2000 VSM Software Development.  All rights reserved.   P *******************************************************************************}   CONST 0 	{ Define the layout of the job detail display }  ^ 	QUEUE_LABEL	= 'Queue: ';				{ Line 1: Queue: XXXXXXXXXXXXXXXXXXXX   Form: XXXXXXXXXXXXXXXXX } 	QUEUE_ROW	= 1; # 	QUEUE_COL	= length(QUEUE_LABEL)+1;    	QFORM_LABEL	= '   Form: ';  	QFORM_ROW	= 1; R 	QFORM_COL	= QUEUE_COL + max(QUEUE_NAME_SIZE,JOB_NAME_SIZE) + length(QFORM_LABEL);  \ 	JOB_LABEL	= '  Job: ';				{ Line 2:   Job: XXXXXXXXXXXXXXXXXXXX   Form: XXXXXXXXXXXXXXXXX } 	JOB_ROW		= 2;  	JOB_COL		= length(JOB_LABEL)+1;   	JFORM_LABEL	= '   Form: ';  	JFORM_ROW	= 2; P 	JFORM_COL	= JOB_COL + max(QUEUE_NAME_SIZE,JOB_NAME_SIZE) + length(JFORM_LABEL);  T 	SUBMITTED_LABEL	= 'Submitted: ';			{ Line 3: Submitted: XX-XXX-XXXX XX:XX:XX.XX			} 	SUBMITTED_ROW	= 4; + 	SUBMITTED_COL	= length(SUBMITTED_LABEL)+1;   ] 	FILE_LABEL	= ' File: ';				{ Line 4: File: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX }  	FILE_ROW	= 3;! 	FILE_COL	= length(FILE_LABEL)+1;    	JOB_DETAIL_ROWS	= 4;   W 	JOB_BROWSER_HEADING	= 'ENTRY JOB                                 USERNAME     STATUS'; - 	JOB_BROWSER_PASTE_ROW	= JOB_DETAIL_ROWS + 4; B 	JOB_BROWSER_ENTRY	= 5;			{ No. of characters for 'ENTRY' column }@ 	JOB_BROWSER_JOB		= 34;			{ No. of characters for 'JOB' column }R 	JOB_BROWSER_USERNAME	= USERNAME_SIZE;	{ No. of characters for 'USERNAME' column }E 	JOB_BROWSER_STATUS	= 25;			{ No. of characters for 'STATUS' column }    VAR  	FILE_LEN		: integer;    	detail_display		: unsigned;  ' 	job_browser		: browse_list value ZERO;    	qui_search_number	: integer; 6 	qui_search_name		: varying [QUEUE_NAME_SIZE] of char;0 	qui_search_flags	: [readonly] SEARCH_FLAGS$TYPE) 				  value [QUI$V_SEARCH_ALL_JOBS: TRUE; " 					 QUI$V_SEARCH_WILDCARD: TRUE; 					 otherwise ZERO];    	qui_after_time		: VMS_datetime;! 	qui_completed_at	: VMS_datetime; ! 	qui_retain_until	: VMS_datetime; ! 	qui_submitted_at	: VMS_datetime; 3 	qui_form_name		: varying [FORM_NAME_SIZE] of char;  	qui_blocks_done		: integer; 	qui_job_blocks		: integer; 8 	qui_condition		: packed array [1..3] of [long] integer; 	qui_entry_number	: integer;! 	qui_job_flags		: JOB_FLAGS$TYPE; 1 	qui_job_name		: varying [JOB_NAME_SIZE] of char; # 	qui_job_status		: JOB_STATUS$TYPE;  	qui_job_priority	: integer; 	qui_file_count		: integer; & 	qui_files		: file_info_ptr value NIL;. 	qui_pending_reason	: PENDING_JOB_REASON$TYPE;5 	qui_queue_name		: varying [QUEUE_NAME_SIZE] of char; 1 	qui_username		: varying [USERNAME_SIZE] of char; * 	qui_decoded_job_status	: Job_Status_Text;2 	qui_filename		: varying [FILE_NAME_SIZE] of char;% 	qui_file_status		: FILE_STATUS$TYPE;  	qui_file_first_page	: integer;  	qui_file_last_page	: integer;  = 	qui_queue_itemlist	: array [1..3] of Item_List_3 value ZERO; < 	qui_job_itemlist	: array [0..20] of Item_List_3 value ZERO;< 	qui_file_itemlist	: array [1..5] of Item_List_3 value ZERO;    P {******************************************************************************* *									       * *	DISPLAY_HELP							       *  *									       *P * Displays on-line help about the commands available in the Queue display.     * *									       *P *******************************************************************************}   Procedure DISPLAY_HELP; - var help_display : [static] unsigned value 0; "     terminator	 : [word] 0..65535; begin  if help_display = 0 then	     begin P     SMG$CREATE_VIRTUAL_DISPLAY (pasteboard_rows, pasteboard_cols, help_display);d     SMG$PUT_LINE_HIGHWIDE (help_display, '    PQM '+PQM_VERSION+ '    Jobs Display', 3, SMG$M_BOLD);  p     SMG$PUT_LINE (help_display, ' The Jobs Display is divided into two panels.  The lower panel lists all the');q     SMG$PUT_LINE (help_display, ' jobs in the selected queue, together with the entry number, username and job'); q     SMG$PUT_LINE (help_display, ' status.  The upper panel shows specific details about the currently selected'); U     SMG$PUT_LINE (help_display, ' job (as indicated by the reverse video text).', 2);   j     SMG$PUT_LINE (help_display, ' Within the lower panel you can use the following keys to move around:');j     SMG$PUT_LINE (help_display, ' Prev Screen   Move up the job list by approximately 2/3 of the screen');l     SMG$PUT_LINE (help_display, ' Next Screen   Move down the job list by approximately 2/3 of the screen');S     SMG$PUT_LINE (help_display, ' Up Arrow      Move up the job list by one line'); U     SMG$PUT_LINE (help_display, ' Down Arrow    Move down the job list by one line'); g     SMG$PUT_LINE (help_display, ' Do or PF4     Display a menu of operations appropriate to this job'); O     SMG$PUT_LINE (help_display, ' Return/Enter  Return to the Queues Display'); R     SMG$PUT_LINE (help_display, ' Space bar     Force an update of the job list');O     SMG$PUT_LINE (help_display, ' Letter "Q"    Return to the Queues Display'); D     SMG$PUT_LINE (help_display, ' Ctrl/W        Redraw the screen');>     SMG$PUT_LINE (help_display, ' Ctrl/Z        Quit PQM', 2);  c     SMG$PUT_LINE (help_display, 'Press any key to return to PQM', pasteboard_rows,, SMG$M_REVERSE);      end;  > SMG$PASTE_VIRTUAL_DISPLAY (help_display, pasteboard_id, 1, 1);- SMG$READ_KEYSTROKE (keyboard_id, terminator); : SMG$UNPASTE_VIRTUAL_DISPLAY (help_display, pasteboard_id); end;  P {******************************************************************************* *									       *( *	DECODE_PENDING_JOB_REASON					       * *									       *C * This routine decodes the QUI$_PENDING_JOB_REASON status		       *  *									       *P *******************************************************************************}   [global]E Procedure DECODE_PENDING_JOB_REASON (var str : varying [len] of char; , 				     p       : PENDING_JOB_REASON$TYPE); begin 	 with p do G     if      QUI$V_PEND_STOCK_MISMATCH		then str := 'Pending (formtype)' M     else if QUI$V_PEND_CHAR_MISMATCH		then str := 'Pending (characteristics)' &     else if QUI$V_PEND_JOB_SIZE_MAX or> 	    QUI$V_PEND_JOB_SIZE_MIN		then str := 'Pending (job size)'C     else if QUI$V_PEND_NO_ACCESS		then str := 'Pending (no access)' P     else if QUI$V_PEND_LOWERCASE_MISMATCH	then str := 'Pending (lowercase reqd)'     else str := 'Pending'; end;  P {******************************************************************************* *									       *# *	DISPLAY_JOB_DETAILS						       *  *									       *B * Updates the job detail display at the top of the page.		       * *									       *  *	ONE_LINE_SUMMARY						       * *									       *P * Builds the text string which provides a one-line summary of the job in the   *% * job browser display.							       *  *									       *P *******************************************************************************}  3 Procedure DISPLAY_JOB_DETAILS (job : job_info_ptr);   var f : string(pasteboard_cols); begin * SMG$BEGIN_DISPLAY_UPDATE (detail_display); if job = NIL then '     { There are no jobs in this queue } 	     begin F     SMG$ERASE_CHARS (detail_display, JOB_NAME_SIZE, JOB_ROW, JOB_COL);K     SMG$ERASE_CHARS (detail_display, FORM_NAME_SIZE, JFORM_ROW, JFORM_COL); B     SMG$ERASE_LINE (detail_display, SUBMITTED_ROW, SUBMITTED_COL);7     SMG$ERASE_LINE (detail_display, FILE_ROW, FILE_COL)      end  else     with job^ do 	begin 	f := '';  APPEND_FIELD (f, name, JOB_NAME_SIZE);  SMG$PUT_CHARS (detail_display, f, JOB_ROW, JOB_COL,, DETAIL_VALUE_RENDITION, DETAIL_VALUE_COMPLEMENT);  	f := '';  APPEND_FIELD (f, form, FORM_NAME_SIZE);  SMG$PUT_CHARS (detail_display, f, JFORM_ROW, JFORM_COL,, DETAIL_VALUE_RENDITION, DETAIL_VALUE_COMPLEMENT); 	$ASCTIM (f.length, f.body, submit_time);  SMG$PUT_CHARS (detail_display, f, SUBMITTED_ROW, SUBMITTED_COL,, DETAIL_VALUE_RENDITION, DETAIL_VALUE_COMPLEMENT); @ 	LIB$TRIM_FILESPEC (files^[1].name, f.body, FILE_LEN, f.length); 	if length(f) < FILE_LEN then f := f + pad(' ',' ',FILE_LEN-length(f)); SMG$PUT_CHARS (detail_display, f, FILE_ROW, FILE_COL,, DETAIL_VALUE_RENDITION, DETAIL_VALUE_COMPLEMENT); 	end; ( SMG$END_DISPLAY_UPDATE (detail_display); end;    A Procedure ONE_LINE_SUMMARY (var buffer : string; job : job_info);  begin 
 buffer := '';  with job do 	     begin 7     writev(buffer, entry_number:JOB_BROWSER_ENTRY,' '); 4     APPEND_FIELD (buffer, name, JOB_BROWSER_JOB, 2);=     APPEND_FIELD (buffer, username, JOB_BROWSER_USERNAME, 1); >     APPEND_FIELD (buffer, decoded_status, JOB_BROWSER_STATUS);     end; end;  P {******************************************************************************* *									       * *	MANAGE_JOBS							       * *									       *P * This is the outermost routine for managing jobs.  It builds a list of all    *P * the jobs in the selected queue, then displays that list and invites the user *3 * user to select and manipulate a job.					       *  *									       *P * The job list is held in the order in which it will be displayed on the       *P * screen, which is the same as the order in which the jobs are retrieved from  *P * the queue database (by $GETQUI) *except* that retained jobs are stored in    *1 * most-recently-completed job first.					       *  *									       *P *******************************************************************************}   [global]/ Procedure MANAGE_JOBS (queue : queue_info_ptr);    Var ret_status		: integer;&     read_terminator	: [word] 0..65535;     job_count		: integer := 0;     scroll_index	: integer; D     selected		: job_info_ptr := NIL;		{ Currently hightlighted job }M     first, last		: [static] job_info_ptr := NIL;	{ Point to entire job list } i     oldest, recent	: [static] job_info_ptr := NIL;	{ Oldest and most recently completed (retained) jobs } !     finished		: boolean := FALSE; (     force_list_update	: boolean := TRUE;    P     {--------------------------------------------------------------------------}$     procedure display_queue_details;$     var f : string(pasteboard_cols);	     begin      with queue^ do 	begin 	f := '';  APPEND_FIELD (f, name, QUEUE_NAME_SIZE);  SMG$PUT_CHARS (detail_display, f, QUEUE_ROW, QUEUE_COL,, DETAIL_VALUE_RENDITION, DETAIL_VALUE_COMPLEMENT); 	 	f := ''; & 	if not flags.QUI$V_QUEUE_GENERIC then+ 	    APPEND_FIELD (f, form, FORM_NAME_SIZE)  	else > 	    APPEND_FIELD (f, ' -- generic queue --', FORM_NAME_SIZE);j 	SMG$PUT_CHARS (detail_display, f, QFORM_ROW, QFORM_COL,, DETAIL_VALUE_RENDITION, DETAIL_VALUE_COMPLEMENT) 	end;      end;    P     {--------------------------------------------------------------------------}3     function get_job_info (efn           : integer;  			   var context   : unsigned; ) 			   GETQUI_func   : [truncate] integer; # 			   target	 : pointer) : integer;      { A 	This routine makes at least two calls to SYS$GETQUIW to retrieve D 	extended information about a single job.  The GETQUI_func parameterB 	specifies what search context to establish; if not specified, theC 	supplied context is used as-is to retrieve the next job in a queue  	which was specified earlier.      }      var ret_status	: integer;  	job_status	: integer; 	f		: integer; 	IOSB		: IO_Status_Block; , 	buffer		: varying [FILE_NAME_SIZE] of char;   	procedure decode_job_status;  	begin 	with qui_job_status do 
 	    begin5 	    if QUI$V_JOB_EXECUTING or QUI$V_JOB_STALLED then 8 		{ Attempt to determine which file is being processed } 		begin  		if QUI$V_JOB_STALLED then ) 		    qui_decoded_job_status := 'Stalled'  		else. 		    if queue^.status.QUI$V_QUEUE_SERVER then) 			qui_decoded_job_status := 'Processing' 
 		    else( 			qui_decoded_job_status := 'Printing';	 		f := 1; c 		while (f <= qui_file_count) and_then not qui_files^[f].status.QUI$V_FILE_EXECUTING do f := f + 1;  		if f <= qui_file_count then 4 		    { Display the file currently being processed } 		    begin  		    if QUI$V_JOB_STALLED then  			begin= 			qui_decoded_job_status := qui_decoded_job_status + ' on '; ( 			LIB$TRIM_FILESPEC (qui_files^[f].name 					  ,%descr buffer J 					  ,size(qui_decoded_job_status.body) - length(qui_decoded_job_status)	 					  ); < 			qui_decoded_job_status := qui_decoded_job_status + buffer 			end
 		    elseH 			LIB$TRIM_FILESPEC (qui_files^[f].name, %descr qui_decoded_job_status)	 		    end  		end J 	    else if QUI$V_JOB_ABORTING		then qui_decoded_job_status := 'Aborting'H 	    else if QUI$V_JOB_HOLDING		then qui_decoded_job_status := 'Holding'N 	    else if QUI$V_JOB_INACCESSIBLE	then qui_decoded_job_status := 'no access'k 	    else if QUI$V_JOB_PENDING		then decode_pending_job_reason (qui_decoded_job_status, qui_pending_reason) H 	    else if QUI$V_JOB_REFUSED		then qui_decoded_job_status := 'Refused'% 	    else if QUI$V_JOB_RETAINED		then  		begin  		if odd(qui_condition[1]) then + 		    qui_decoded_job_status := 'Completed'  		else( 		    qui_decoded_job_status := 'Failed' 		end J 	    else if QUI$V_JOB_STARTING		then qui_decoded_job_status := 'Starting'I 	    else if QUI$V_JOB_SUSPENDED		then qui_decoded_job_status := 'Paused' ) 	    else if QUI$V_JOB_TIMED_RELEASE	then  		begin 7 		$ASCTIM (buffer.length, buffer.body, qui_after_time); ; 		qui_decoded_job_status := 'Until ' + substr(buffer,1,17);  		end;! 	    end; { with qui_job_status }  	end; { decode_job_status }        begin { Get_Job_Info }L     if present(GETQUI_func) and_then (GETQUI_func = QUI$_DISPLAY_ENTRY) then> 	{ Establish a new context by going direct to a specific job } 	begin 	context := -1; 9 	qui_search_number := target::job_info_ptr^.entry_number; R 	job_status := $GETQUIW (efn, QUI$_DISPLAY_ENTRY, context, qui_job_itemlist, IOSB) 	end     else 	begin 	if present(GETQUI_func) then K 	    { Do a DISPLAY_QUEUE to prepare for retrieving all jobs in the queue } 
 	    begin 	    context := -1; 5 	    qui_search_name := target::queue_info_ptr^.name; ? 	    qui_queue_itemlist[1].item_len := length(qui_search_name); ^ 	    ret_status := $GETQUIW (efn, QUI$_DISPLAY_QUEUE, context, %ref qui_queue_itemlist, IOSB);4 	    if odd(ret_status) then ret_status := IOSB.sts;3 	    if not odd(ret_status) then return ret_status; 	 	    end; 9 	{ Get job information based on the established context } Y 	job_status := $GETQUIW (efn, QUI$_DISPLAY_JOB, context, %ref qui_job_itemlist[1], IOSB);  	end;   '     { Check that we got some job data } 3     if odd(job_status) then job_status := IOSB.sts;      if not odd(job_status) then h 	if (job_status = JBC$_NOMOREJOB) or (job_status = JBC$_NOSUCHJOB) or (job_status = JBC$_NOSUCHENT) then 	    return job_status         else 	    LIB$SIGNAL (job_status);   1     { Ensure the file info buffer is big enough }      if qui_files <> NIL then 	begin* 	if qui_files^.count < qui_file_count then
 	    begin 	    dispose(qui_files);" 	    new(qui_files,qui_file_count) 	    end 	end     else 	new(qui_files,qui_file_count);         { Get the file information }     f := 0; 
     repeatS 	ret_status := $GETQUIW (efn, QUI$_DISPLAY_FILE, context, qui_file_itemlist, IOSB); 0 	if odd(ret_status) then ret_status := IOSB.sts; 	if odd(ret_status) then
 	    begin 	    f := f + 1;/ 	    qui_files^[f].name        := qui_filename; 2 	    qui_files^[f].status      := qui_file_status;6 	    qui_files^[f].start_page  := qui_file_first_page;5 	    qui_files^[f].finish_page := qui_file_last_page;  	    end     until not odd(ret_status);h     if (ret_status <> JBC$_NOMOREFILE) and (ret_status <> JBC$_NOSUCHFILE) then LIB$SIGNAL (ret_status);       decode_job_status;     get_job_info := job_status     end; { get_job_info }     P     {--------------------------------------------------------------------------}4     procedure copy_job_details (var job : job_info);     var f : integer;	     begin      with job do  	begin 	name		:= qui_job_name;  	form		:= qui_form_name; 	flags		:= qui_job_flags;  	status		:= qui_job_status;'* 	decoded_status	:= qui_decoded_job_status;& 	pending_reason	:= qui_pending_reason;" 	retain_until	:= qui_retain_until;  	blocks_done	:= qui_blocks_done; 	priority	:= qui_job_priority;" 	if status.QUI$V_JOB_RETAINED then
 	    begin( 	    completed_time := qui_completed_at;% 	    condition      := qui_condition;t	 	    end; N 	if (qui_files <> NIL) and (files <> NIL) then for f := 1 to qui_file_count do
 	    begin3 	    files^[f].status      := qui_files^[f].status;g7 	    files^[f].start_page  := qui_files^[f].start_page;*8 	    files^[f].finish_page := qui_files^[f].finish_page;	 	    end;o 	end;h     end;    P     {--------------------------------------------------------------------------};     function update_one_job (job : job_info_ptr) : boolean;t     {_L       Calls get_job_info to get the latest information about a specific job.3       Returns TRUE if the update could not be done.Q     }B/     var efn        : [static] unsigned value 0;b 	ret_status : integer; 	context    : unsigned;}& 	buffer	   : string(job_browser.cols);	     begin %     if efn = 0 then LIB$GET_EF (efn);RG     ret_status := get_job_info (efn, context, QUI$_DISPLAY_ENTRY, job);g     if not odd(ret_status) thenB 	beginm 	if (ret_status <> JBC$_NOSUCHJOB) and (ret_status <> JBC$_NOMOREJOB) and (ret_status <> JBC$_NOSUCHENT) thenU 	    LIB$SIGNAL(ret_status);L 	return TRUE;	{ which should cause the job to be removed from the job list } 	end; `     if ne(qui_queue_name, job^.queue^.name) then return TRUE;	{ Job is no longer in this queue }     copy_job_details (job^);     display_job_details (job);$     one_line_summary (buffer, job^);W     SMG$PUT_CHARS (job_browser.display, buffer, job^.display_row, 1, SMG$M_ERASE_LINE); 6     BROWSE_SELECT_ROW (job_browser, job^.display_row);     update_one_job := FALSEM     end;    P     {--------------------------------------------------------------------------}     procedure update_job_list;     { E 	Calls get_job_info to get details on all jobs in the queue.  As jobsbE 	are received fron get_job_info, the list of "known" jobs is searchedqE 	and a new list of "known" jobs is built.  Jobs found in the old list	F 	are moved to the new list as they are seen by get_job_info.  Any jobsD 	remaining in the old list after get_job_info reports "no more jobs" 	are deleted from the list. G 	Note: we do it this way, rather than creating a complete new list fromqH 	scratch each time, because it should be more efficient when a queue hasF 	a large number of jobs.  (And shouldn't be less efficient otherwise.)     }c&     var	efn		: [static] unsigned := 0; 	ret_status	: integer; 	context		: unsigned;j 	job, n, 	first_active,
 	last_active,m 	oldest_retained,A' 	recent_retained	: job_info_ptr := NIL;B 	f		: integer; 	active		: boolean := TRUE;   Z 	function search_active_jobs (resume, top : job_info_ptr; entry : integer) : job_info_ptr; 	{I 	  Search the "active" job list for this job, starting from the currently I 	  indicated job.  If we hit the end of the active jobs, start again from	D 	  the top of the list until we reach the job we first started with. 	} 	var j : job_info_ptr; 	begin
 	j := resume;_ 	while j <> NIL do
 	    begin. 	    if j^.entry_number = entry then return j;H 	    if not j^.status.QUI$V_JOB_RETAINED then j := j^.next else j := NIL	 	    end;i: 	{ Try the search again, this time starting from the top }
 	j := top;& 	while (j <> NIL) and (j <> resume) do
 	    begin. 	    if j^.entry_number = entry then return j;H 	    if not j^.status.QUI$V_JOB_RETAINED then j := j^.next else j := NIL	 	    end;e 	{ We haven't found the job }b 	search_active_jobs := NIL 	end;	  _ 	function search_retained_jobs (resume, bottom : job_info_ptr; entry : integer) : job_info_ptr;  	{G 	  Search the "retained" list for this job, starting from the currently I 	  indicated job.  If we hit the active jobs, start again from the bottom F 	  of the retained list and continue until we find the job or until weI 	  hit the job we started with.  Note that the "retained" list is held in+H 	  reverse chronological order, which is likely to be the opposite order- 	  to which $GETQUIW returns job information.h 	} 	var j : job_info_ptr; 	begin
 	j := resume;e 	while j <> NIL do
 	    begin. 	    if j^.entry_number = entry then return j;D 	    if j^.status.QUI$V_JOB_RETAINED then j := j^.prev else j := NIL	 	    end;s, 	{ Start again from the bottom of the list }
 	j := bottom;_& 	while (j <> NIL) and (j <> resume) do
 	    begin. 	    if j^.entry_number = entry then return j;D 	    if j^.status.QUI$V_JOB_RETAINED then j := j^.prev else j := NIL	 	    end;' 	{ We haven't found the job }l 	search_retained_jobs := NIL 	end;i    = 	function more_recent(date1, date2 : VMS_Datetime) : boolean;s 	begin0 	if date1.hi > date2.hi then more_recent := TRUEE 	else if date1.hi = date2.hi then more_recent := date1.lo >= date2.lo  	else more_recent := FALSE 	end;)    7 	function older(date1, date2 : VMS_Datetime) : boolean;  	begin* 	if date1.hi < date2.hi then older := TRUE? 	else if date1.hi = date2.hi then older := date1.lo <= date2.loe 	else older := FALSE 	end;_         begin { update_job_list } %     if efn = 0 then LIB$GET_EF (efn);M     job_count := 0;l     job := NIL; I     ret_status := get_job_info (efn, context, QUI$_DISPLAY_QUEUE, queue);t     while odd(ret_status) do 	begin 	job_count := job_count + 1;1 	active := not qui_job_status.QUI$V_JOB_RETAINED;M 	{G 	  Attempt to locate the job in our lists of known jobs.  Note that the(H 	  following code will return "job not found" if a previously active jobE 	  has completed and is now retained on the queue, or if a previouslyrH 	  retained job has been made active again (e.g. SET ENTRY/RELEASE).  InH 	  either case it will be set up as a "new" job and the old copy will be 	  deleted in due course.* 	} 	if active then*= 	    job := search_active_jobs (job, first, qui_entry_number)	 	else A 	    job := search_retained_jobs (job, oldest, qui_entry_number);O   	if job = NIL then3 	    { This job has probably not been seen before }*
 	    begin 	    new(job); 	    job^ := ZERO; 	    job^.queue := queue;  	    with job^ doR 		beginr 		name		:= qui_job_name; 		username	:= qui_username;I 		form		:= qui_form_name; # 		entry_number	:= qui_entry_number;S 		size		:= qui_job_blocks;! 		blocks_done	:= qui_blocks_done;U" 		submit_time	:= qui_submitted_at; 		flags		:= qui_job_flags; 		status		:= qui_job_status; 		priority	:= qui_job_priority;I 		file_count	:= qui_file_count;  		new(files,file_count);9 		for f := 1 to file_count do files^[f] := qui_files^[f];e 		if not active then 		    beginh) 		    completed_time	:= qui_completed_at;l" 		    condition		:= qui_condition;' 		    retain_until	:= qui_retain_until;*
 		    end;" 		if status.QUI$V_JOB_PENDING then+ 		    pending_reason	:= qui_pending_reason; + 		decoded_status	:= qui_decoded_job_status;d 		enda 	    end 	elsepA 	    { Update the job details and remove it from the "old" list }*
 	    begin 	    copy_job_details (job^);iU 	    if job^.prev <> NIL then job^.prev^.next := job^.next else first := first^.next;	S 	    if job^.next <> NIL then job^.next^.prev := job^.prev else last := last^.prev;*	 	    end;*  5 	{ Move the job details to the appropriate new list }b 	if active then 
 	    begin 	    if last_active = NIL then9 		{ Assume this is the first job; create the "new" list }  		begin  		first_active := job; 		job^.prev := NIL 		endR	 	    elsed 		beginpB 		{ Move the job to the end of the active jobs in the "new" list } 		last_active^.next := job;M 		job^.prev := last_active;R 		end; 	    last_active := job; 	    job^.next := NIL; 	    end 	elseEB 	    { Put the retained job at the appropriate place in the list }
 	    begin" 	    if recent_retained = NIL thenB 		{ Assume this is the first retained job; create the "new" list } 		beginV 		oldest_retained := job;E 		job^.next := NIL;  		job^.prev := NIL;  		recent_retained := job;$ 		endR	 	    elsei 		{,; 		  Put this job into the "new" retained list in descendingU: 		  order of completion time, i.e. most recently completed 		  job first. 		}d 		begin,L 		if more_recent (job^.completed_time, recent_retained^.completed_time) then 		    beginI# 		    recent_retained^.prev := job;I# 		    job^.next := recent_retained;I 		    job^.prev := NIL;' 		    recent_retained := job;$	 		    enddK 		else if older (job^.completed_time, oldest_retained^.completed_time) thenO 		    begine# 		    oldest_retained^.next := job;d# 		    job^.prev := oldest_retained;E 		    job^.next := NIL;r 		    oldest_retained := job; 	 		    end' 		elseF 		    { Search the retained list for the right place to put this job } 		    beginP 		    n := oldest_retained;_Q 		    while more_recent (job^.completed_time, n^.completed_time) do n := n^.prev;  		    job^.prev := n;  		    job^.next := n^.next;T 		    job^.next^.prev := job;* 		    n^.next := job;*	 		    end* 		end* 	    end; { retained job }  # 	{ Get the next job from $GETQUIW }	* 	ret_status := get_job_info (efn, context) 	end;u    <     { Check the status from SYS$GETQUIW, and exit if error }M     if (ret_status <> JBC$_NOMOREJOB) and (ret_status <> JBC$_NOSUCHJOB) then* 	begin$ 	if ret_status = SS$_DEVOFFLINE thenR 	    MESSAGE ('Unable to get job information: JOB_CONTROLLER process not running')) 	else if ret_status = JBC$_JOBQUEDIS then ] 	    MESSAGE ('Unable to get job information: System job/queue manager has not been started')Q 	elsec 	    LIB$SIGNAL (ret_status);r 	return* 	end;t       {-D 	At this point we have two "new" lists - active and retained - which 	must be joined into one.*8 	We also have a single "old" list which must be deleted.     }A     while first <> NIL do_ 	{ Delete the old list } 	begin 	job := first; 	first := first^.next;( 	if job = selected then selected := NIL; 	dispose(job^.files);  	dispose(job); 	end;oT     if first_active  = NIL then first := recent_retained else first := first_active;S     if oldest_retained = NIL then last := last_active else last := oldest_retained;      oldest := oldest_retained;     recent := recent_retained;4     if (last_active <> NIL) and (recent <> NIL) then4 	{ Hook the "active" and "retained" lists together } 	begin 	last_active^.next := recent;- 	recent^.prev := last_active 	end;u-     if selected = NIL then selected := first;s7     if selected <> NIL then selected^.selected := TRUE;P     end; { update_job_list }    O     {-------------------------------------------------------------------------}I     procedure display_job_list;f     { E 	Refreshes the job browser display with the latest information on allO 	known jobs.     } "     var job	: job_info_ptr := NIL;# 	buffer	: string(job_browser.cols);T 	r, sel	: integer;	     beginM3     SMG$BEGIN_DISPLAY_UPDATE (job_browser.display);E*     BROWSE_ERASE (job_browser, job_count);     if first <> NIL then 	begin 	job := first; 	r := 1;
 	sel := 0;! 	while job <> NIL do with job^ do 
 	    begin< 	    { Build the one-line summary information for this job }% 	    one_line_summary (buffer, job^); 0 	    SMG$PUT_LINE (job_browser.display, buffer); 	    display_row := r; 	    if selected then sel := r;  	    r := r + 1; 	    job := job^.nextU	 	    end;m& 	BROWSE_SELECT_ROW (job_browser, sel); 	end     else5 	MESSAGE ('No jobs in '+queue^.name, MESSAGE_SILENT);t1     SMG$END_DISPLAY_UPDATE (job_browser.display);d#     display_job_details (selected);s     end; { display_job_list }e    O     {-------------------------------------------------------------------------} 0     procedure job_running_menu (job : job_info);     { B 	Displays a menu of commands which are applicable to a job that is	 	running:D 		Pause	 		Stop & Retainr 		Abort Jobl 		Stop Queue
 		Reset Queuei 		SHOW ENTRY/FULLS 		Exit this menu     }e     const MENU_ITEM_COUNT	= 8; 	  MENU_ITEM_WIDTH	= 15; 	  MENU_OPTION_Pause	= 1;n 	  MENU_OPTION_Display	= 2;= 	  MENU_OPTION_Stop_Job	= 3; 	  MENU_OPTION_Abort	= 4;' 	  MENU_OPTION_Stop_Que	= 5; 	  MENU_OPTION_Reset	= 6;_ 	  MENU_OPTION_SHOW	= 7; 	  MENU_OPTION_Exit	= 8;     var ret_status	: integer;i 	job_row		: integer; 	f		: integer;B 	job_menu	: SMG_Menu(MENU_ITEM_COUNT, MENU_ITEM_WIDTH) value ZERO; 	terminator	: [word] 0..65535;, 	sjc_itemlist	: array [1..10] of Item_List_3' 			  value [1: [item_code : SJC$_QUEUE;f 				     retaddr   : ZERO; 				     otherwise ZERO];d 				 otherwise ZERO];g 	IOSB		: IO_Status_Block;   	     begin	8     sjc_itemlist[1].item_len := length(job.queue^.name);?     sjc_itemlist[1].bufaddr  := iaddress(job.queue^.name.body);d4     job_menu.choices[MENU_OPTION_Pause]		:= 'Pause';<     job_menu.choices[MENU_OPTION_Display]	:= 'Display File';>     job_menu.choices[MENU_OPTION_Stop_Job]	:= 'Stop & Retain';8     job_menu.choices[MENU_OPTION_Abort]		:= 'Abort Job';;     job_menu.choices[MENU_OPTION_Stop_Que]	:= 'Stop Queue';J:     job_menu.choices[MENU_OPTION_Reset]		:= 'Reset Queue';=     job_menu.choices[MENU_OPTION_SHOW]		:= 'SHOW ENTRY/FULL';h<     job_menu.choices[MENU_OPTION_Exit]		:= 'Exit this menu';T     job_row := job.display_row - job_browser.viewport_start + JOB_BROWSER_PASTE_ROW;%     PREPARE_MENU (job_menu, job_row);_  '     { Determine the default selection }      with job.status do0 	if QUI$V_JOB_ABORTING or QUI$V_JOB_STALLED then 	    job_menu.selection := 6 	elseq 	    job_menu.selection := 1;d  3     ret_status := SMG$SELECT_FROM_MENU (keyboard_id  				       ,job_menu.display0 				       ,job_menu.selection	{ selected item }/ 				       ,job_menu.selection	{ initial item }  				       ,			{ flags }+ 				       ,'PQM_HELPLIB'		{ help library } & 				       ,300			{ 5-minute timeout } 				       ,terminator);     if not odd(ret_status) thenn  	if (ret_status = SMG$_EOF) then 	    { Don't do anything }
 	    begin+ 	    job_menu.selection := MENU_ITEM_COUNT;t 	    ret_status := SS$_NORMAL  	    end 	elseE
 	    begin 	    LIB$SIGNAL (ret_status);i+ 	    job_menu.selection := MENU_ITEM_COUNT; 	 	    end;(  !     { Process the selected item }A     case job_menu.selection of' 	MENU_OPTION_Pause: { Pause the queue } 
 	    beginB 	    MESSAGE ('Pausing queue ' + job.queue^.name, MESSAGE_SILENT);F 	    ret_status := $SNDJBCW (, SJC$_PAUSE_QUEUE,, sjc_itemlist, IOSB);4 	    if odd(ret_status) then ret_status := IOSB.sts;	 	    end;u  8 	MENU_OPTION_Display: { Display the file being printed }
 	    begin 	    f := 1;f 	    while (f <= job.file_count) and_then not job.files^[f].status.QUI$V_FILE_EXECUTING do f := f + 1;' 	    if f > job.file_count then f := 1;U& 	    DISPLAY_FILE (job.files^[f].name)	 	    end;I 	)> 	MENU_OPTION_Stop_Job, { Stop job and retain it in the queue }! 	MENU_OPTION_Abort: { Abort Job }O
 	    begin] 	    if CONFIRM ('Really stop job ' + job.name + ' (entry '+dec(job.entry_number,5)+')') thenO 		beginb` 		MESSAGE ('Stopping job ' + job.name + ' (entry '+dec(job.entry_number,5)+')', MESSAGE_SILENT);@ 		sjc_itemlist[2] := Item_List_3 [item_code : SJC$_ENTRY_NUMBER;) 						item_len  : size(job.entry_number);^- 						bufaddr   : iaddress(job.entry_number);d 						retaddr   : ZERO];  		if job_menu.selection = 2 then 		    begin 0 		    sjc_itemlist[3].item_code := SJC$_REQUEUE;- 		    sjc_itemlist[4].item_code := SJC$_HOLD;e
 		    end;A 		ret_status := $SNDJBCW (, SJC$_ABORT_JOB,, sjc_itemlist, IOSB);s1 		if odd(ret_status) then ret_status := IOSB.sts;I 		end;	 	    end;e  % 	MENU_OPTION_Stop_Que: { Stop queue } 
 	    beginC 	    MESSAGE ('Stopping queue ' + job.queue^.name, MESSAGE_SILENT); D 	    ret_status := $SNDJBC (, SJC$_STOP_QUEUE,, sjc_itemlist, IOSB);4 	    if odd(ret_status) then ret_status := IOSB.sts;	 	    end;   ( 	MENU_OPTION_Reset: { Stop/Reset queue }
 	    beginD 	    MESSAGE ('Resetting queue ' + job.queue^.name, MESSAGE_SILENT);F 	    ret_status := $SNDJBCW (, SJC$_RESET_QUEUE,, sjc_itemlist, IOSB);4 	    if odd(ret_status) then ret_status := IOSB.sts;	 	    end;-  2 	MENU_OPTION_SHOW: { DCL command SHOW ENTRY/FULL }
 	    begin| 	    DISPLAY_DCL_COMMAND ('SHOW ENTRY/FULL ' + dec(job.entry_number), JOB_BROWSER_PASTE_ROW-1, job_browser.viewport_rows+1);	 	    end;:  ( 	MENU_OPTION_Exit: { Don't do anything } 	    ret_status := SS$_NORMAL;         end;C     if (ret_status = JBC$_NORMAL) or (ret_status = SS$_NORMAL) then  	ERASE_MESSAGE     else 	SYS_MESSAGE (ret_status);  0     SMG$BEGIN_PASTEBOARD_UPDATE (pasteboard_id);>     SMG$POP_VIRTUAL_DISPLAY (job_menu.display, pasteboard_id);     end; { job_running_menu }i    O     {-------------------------------------------------------------------------}h0     procedure job_waiting_menu (job : job_info);     {sB 	Displays a menu of commands which are applicable to a job that is
 	not running:^ 		Display File
 		Release Job] 		Move to Queueu 		Delete Job 		Set Job Formtype 		Set Queue Formtype 		Stop Queue
 		Reset Queue- 		SHOW ENTRY/FULL- 		Exit this menu     }-     const MENU_ITEM_COUNT	= 13;_ 	  MENU_ITEM_WIDTH	= 18; 	  MENU_OPTION_Display	= 1;l 	  MENU_OPTION_Release	= 2;e 	  MENU_OPTION_Hold	= 3; 	  MENU_OPTION_Move	= 4; 	  MENU_OPTION_Raise	= 5;t 	  MENU_OPTION_Lower	= 6;  	  MENU_OPTION_Delete	= 7; 	  MENU_OPTION_Job_Form	= 8; 	  MENU_OPTION_Que_Form	= 9; 	  MENU_OPTION_Stop	= 10;_ 	  MENU_OPTION_Reset	= 11; 	  MENU_OPTION_SHOW	= 12;_ 	  MENU_OPTION_Exit	= 13;:     var ret_status	: integer;U 	job_row		: integer;B 	job_menu	: SMG_Menu(MENU_ITEM_COUNT, MENU_ITEM_WIDTH) value ZERO; 	queue_selector	: SMG_Menu_ptr;B 	terminator	: [word] 0..65535;, 	sjc_itemlist	: array [1..10] of Item_List_3' 			  value [1: [item_code : SJC$_QUEUE;e 				     retaddr   : ZERO; 				     otherwise ZERO];  				 otherwise ZERO];o 	IOSB		: IO_Status_Block;   	     begins8     sjc_itemlist[1].item_len := length(job.queue^.name);?     sjc_itemlist[1].bufaddr  := iaddress(job.queue^.name.body);^<     job_menu.choices[MENU_OPTION_Display]	:= 'Display File';;     job_menu.choices[MENU_OPTION_Release]	:= 'Release Job';o6     job_menu.choices[MENU_OPTION_Hold]		:= 'Hold Job';;     job_menu.choices[MENU_OPTION_Move]		:= 'Move to Queue';-A     job_menu.choices[MENU_OPTION_Raise]		:= 'Raise job Priority'; A     job_menu.choices[MENU_OPTION_Lower]		:= 'Lower job Priority'; 9     job_menu.choices[MENU_OPTION_Delete]	:= 'Delete Job';wA     job_menu.choices[MENU_OPTION_Job_Form]	:= 'Set Job Formtype';bC     job_menu.choices[MENU_OPTION_Que_Form]	:= 'Set Queue Formtype'; 8     job_menu.choices[MENU_OPTION_Stop]		:= 'Stop Queue';:     job_menu.choices[MENU_OPTION_Reset]		:= 'Reset Queue';=     job_menu.choices[MENU_OPTION_SHOW]		:= 'SHOW ENTRY/FULL';l<     job_menu.choices[MENU_OPTION_Exit]		:= 'Exit this menu';T     job_row := job.display_row - job_browser.viewport_start + JOB_BROWSER_PASTE_ROW;%     PREPARE_MENU (job_menu, job_row);:  '     { Determine the default selection }e     with job.status do 	if QUI$V_JOB_RETAINED then,. 	    job_menu.selection := MENU_OPTION_DisplayP 	else if QUI$V_JOB_PENDING and job.pending_reason.QUI$V_PEND_STOCK_MISMATCH then/ 	    job_menu.selection := MENU_OPTION_Que_Formo 	elsen/ 	    job_menu.selection := MENU_OPTION_Release; 3     ret_status := SMG$SELECT_FROM_MENU (keyboard_idr 				       ,job_menu.display0 				       ,job_menu.selection	{ selected item }/ 				       ,job_menu.selection	{ initial item }  				       ,			{ flags }+ 				       ,'PQM_HELPLIB'		{ help library }e& 				       ,300			{ 5-minute timeout } 				       ,terminator);     if not odd(ret_status) thens  	if (ret_status = SMG$_EOF) then 	    { Don't do anything }
 	    begin+ 	    job_menu.selection := MENU_ITEM_COUNT;t 	    ret_status := SS$_NORMAL  	    end 	else 
 	    begin 	    LIB$SIGNAL (ret_status);m+ 	    job_menu.selection := MENU_ITEM_COUNT;a	 	    end;O  !     { Process the selected item }=     case job_menu.selection of; 	MENU_OPTION_Display: { Display the first file in the job }t' 	    DISPLAY_FILE (job.files^[1].name);:  ) 	MENU_OPTION_Release: { Release the Job }r
 	    begind 	    MESSAGE ('Releasing job ' + job.name + ' (entry '+dec(job.entry_number,5)+')', MESSAGE_SILENT);C 	    sjc_itemlist[2] := Item_List_3 [item_code : SJC$_ENTRY_NUMBER;n, 					    item_len  : size(job.entry_number);0 					    bufaddr   : iaddress(job.entry_number); 					    retaddr   : ZERO];r5 	    sjc_itemlist[3].item_code := SJC$_NO_AFTER_TIME;p/ 	    sjc_itemlist[4].item_code := SJC$_NO_HOLD;fL 	    ret_status := $SNDJBCW (, SJC$_ALTER_JOB,, %ref sjc_itemlist[2], IOSB);4 	    if odd(ret_status) then ret_status := IOSB.sts;	 	    end;   # 	MENU_OPTION_Hold: { Hold the Job }e
 	    beginb 	    MESSAGE ('Holding job ' + job.name + ' (entry '+dec(job.entry_number,5)+')', MESSAGE_SILENT);C 	    sjc_itemlist[2] := Item_List_3 [item_code : SJC$_ENTRY_NUMBER; , 					    item_len  : size(job.entry_number);0 					    bufaddr   : iaddress(job.entry_number); 					    retaddr   : ZERO];h, 	    sjc_itemlist[3].item_code := SJC$_HOLD;L 	    ret_status := $SNDJBCW (, SJC$_ALTER_JOB,, %ref sjc_itemlist[2], IOSB);4 	    if odd(ret_status) then ret_status := IOSB.sts;	 	    end;h  4 	MENU_OPTION_Move: { Move the job to another queue }
 	    beginE 	    BUILD_QUEUE_SELECTOR (queue_selector, job_row, job.queue^.name);)4 	    ret_status := SMG$SELECT_FROM_MENU (keyboard_id$ 					       ,queue_selector^.display8 					       ,queue_selector^.selection	{ selected item }7 					       ,queue_selector^.selection	{ initial item }n" 					       ,				{ control flags }- 					       ,'PQM_HELPLIB'			{ help library }s( 					       ,300				{ timeout - 5 mins } 					       ,terminator);l8 	    if not odd(ret_status) then with queue_selector^ do 		begin 1 		selection := count;  { Don't change the queue }A! 		if (ret_status = SMG$_EOF) thent 		    ret_status := SS$_NORMAL 		else 		    LIB$SIGNAL (ret_status); 		end;U 	   if queue_selector^.selection < queue_selector^.count then with queue_selector^ dop 		beginrx 		MESSAGE ('Moving job '+job.name+' (entry '+dec(job.entry_number,5)+') to queue '+choices[selection], MESSAGE_SILENT);	@ 		sjc_itemlist[2] := Item_List_3 [item_code : SJC$_ENTRY_NUMBER;0 					        item_len  : size(job.entry_number);4 					        bufaddr   : iaddress(job.entry_number); 					        retaddr   : ZERO];tE 		sjc_itemlist[3] := Item_List_3 [item_code : SJC$_DESTINATION_QUEUE;e4 					        item_len  : length(choices[selection]);6 					        bufaddr   : iaddress(choices[selection]); 					        retaddr   : ZERO];nI 		ret_status := $SNDJBCW (, SJC$_ALTER_JOB,, %ref sjc_itemlist[2], IOSB);b1 		if odd(ret_status) then ret_status := IOSB.sts;; 		end;	 	    end;q  - 	MENU_OPTION_Raise: { Increase job priority }a  	    if job.priority >= 255 then9 		MESSAGE ('Job priority is already as high as possible')I	 	    elseu 		begin_k 		MESSAGE ('Raising priority of job ' + job.name + ' (entry '+dec(job.entry_number,5)+')', MESSAGE_SILENT);a- 		job.priority := min(255, job.priority + 5);:@ 		sjc_itemlist[2] := Item_List_3 [item_code : SJC$_ENTRY_NUMBER;) 						item_len  : size(job.entry_number);;- 						bufaddr   : iaddress(job.entry_number);d 						retaddr   : ZERO];< 		sjc_itemlist[3] := Item_List_3 [item_code : SJC$_PRIORITY;% 						item_len  : size(job.priority);o) 						bufaddr   : iaddress(job.priority);  						retaddr   : ZERO];I 		ret_status := $SNDJBCW (, SJC$_ALTER_JOB,, %ref sjc_itemlist[2], IOSB);.1 		if odd(ret_status) then ret_status := IOSB.sts;  		end;  - 	MENU_OPTION_Lower: { Decrease job priority }t 	    if job.priority <= 0 then8 		MESSAGE ('Job priority is already as low as possible')	 	    else  		begin l 		MESSAGE ('Lowering priority of job ' + job.name + ' (entry '+dec(job.entry_number,5)+')', MESSAGE_SILENT);+ 		job.priority := max(0, job.priority - 5); @ 		sjc_itemlist[2] := Item_List_3 [item_code : SJC$_ENTRY_NUMBER;) 						item_len  : size(job.entry_number);j- 						bufaddr   : iaddress(job.entry_number);  						retaddr   : ZERO];< 		sjc_itemlist[3] := Item_List_3 [item_code : SJC$_PRIORITY;% 						item_len  : size(job.priority);t) 						bufaddr   : iaddress(job.priority);I 						retaddr   : ZERO];I 		ret_status := $SNDJBCW (, SJC$_ALTER_JOB,, %ref sjc_itemlist[2], IOSB);e1 		if odd(ret_status) then ret_status := IOSB.sts;L 		end;  # 	MENU_OPTION_Delete: { Delete Job }s
 	    begin_ 	    if CONFIRM ('Really delete job ' + job.name + ' (entry '+dec(job.entry_number,5)+')') thens 		beginy` 		MESSAGE ('Deleting job ' + job.name + ' (entry '+dec(job.entry_number,5)+')', MESSAGE_SILENT);@ 		sjc_itemlist[2] := Item_List_3 [item_code : SJC$_ENTRY_NUMBER;) 						item_len  : size(job.entry_number);d- 						bufaddr   : iaddress(job.entry_number);i 						retaddr   : ZERO];B 		ret_status := $SNDJBCW (, SJC$_DELETE_JOB,, sjc_itemlist, IOSB);1 		if odd(ret_status) then ret_status := IOSB.sts;  		endd	 	    end;^  + 	MENU_OPTION_Job_Form: { Set Job Formtype }N
 	    beginC 	    BUILD_FORM_SELECTOR (form_selector, job_row, job.queue^.form);i4 	    ret_status := SMG$SELECT_FROM_MENU (keyboard_id# 					       ,form_selector^.display 7 					       ,form_selector^.selection	{ selected item }d6 					       ,form_selector^.selection	{ initial item }" 					       ,				{ control flags }- 					       ,'PQM_HELPLIB'			{ help library } ( 					       ,300				{ timeout - 5 mins } 					       ,terminator);m7 	    if not odd(ret_status) then with form_selector^ do  		begin 4 		selection := count;  { Don't change the formtype }! 		if (ret_status = SMG$_EOF) then$ 		    ret_status := SS$_NORMAL 		else 		    LIB$SIGNAL (ret_status); 		end;I 	    SMG$UNPASTE_VIRTUAL_DISPLAY (form_selector^.display, pasteboard_id);OS 	    if form_selector^.selection < form_selector^.count then with form_selector^ do( 		begino@ 		MESSAGE ('Setting form '+choices[selection], MESSAGE_SILENT);	@ 		sjc_itemlist[2] := Item_List_3 [item_code : SJC$_ENTRY_NUMBER;0 					        item_len  : size(job.entry_number);4 					        bufaddr   : iaddress(job.entry_number); 					        retaddr   : ZERO];s= 		sjc_itemlist[3] := Item_List_3 [item_code : SJC$_FORM_NAME;{4 					        item_len  : length(choices[selection]);6 					        bufaddr   : iaddress(choices[selection]); 					        retaddr   : ZERO];oA 		ret_status := $SNDJBCW (, SJC$_ALTER_JOB,, sjc_itemlist, IOSB);e1 		if odd(ret_status) then ret_status := IOSB.sts;e 		end;	 	    end;a  - 	MENU_OPTION_Que_Form: { Set Queue Formtype } 
 	    begin< 	    BUILD_FORM_SELECTOR (form_selector, job_row, job.form);4 	    ret_status := SMG$SELECT_FROM_MENU (keyboard_id# 					       ,form_selector^.displayh7 					       ,form_selector^.selection	{ selected item }e6 					       ,form_selector^.selection	{ initial item }" 					       ,				{ control flags }- 					       ,'PQM_HELPLIB'			{ help library };( 					       ,300				{ timeout - 5 mins } 					       ,terminator);-7 	    if not odd(ret_status) then with form_selector^ doa 		begint4 		selection := count;  { Don't change the formtype }! 		if (ret_status = SMG$_EOF) thenn 		    ret_status := SS$_NORMAL 		else 		    LIB$SIGNAL (ret_status); 		end;I 	    SMG$UNPASTE_VIRTUAL_DISPLAY (form_selector^.display, pasteboard_id);_S 	    if form_selector^.selection < form_selector^.count then with form_selector^ doh 		beginn@ 		MESSAGE ('Setting form '+choices[selection], MESSAGE_SILENT);	= 		sjc_itemlist[2] := Item_List_3 [item_code : SJC$_FORM_NAME;t4 					        item_len  : length(choices[selection]);6 					        bufaddr   : iaddress(choices[selection]); 					        retaddr   : ZERO];eC 		ret_status := $SNDJBCW (, SJC$_ALTER_QUEUE,, sjc_itemlist, IOSB); 1 		if odd(ret_status) then ret_status := IOSB.sts;d 		end;	 	    end;E  ! 	MENU_OPTION_Stop: { Stop queue }S
 	    beginC 	    MESSAGE ('Stopping queue ' + job.queue^.name, MESSAGE_SILENT);aD 	    ret_status := $SNDJBC (, SJC$_STOP_QUEUE,, sjc_itemlist, IOSB);4 	    if odd(ret_status) then ret_status := IOSB.sts;	 	    end;   ( 	MENU_OPTION_Reset: { Stop/Reset queue }
 	    beginD 	    MESSAGE ('Resetting queue ' + job.queue^.name, MESSAGE_SILENT);F 	    ret_status := $SNDJBCW (, SJC$_RESET_QUEUE,, sjc_itemlist, IOSB);4 	    if odd(ret_status) then ret_status := IOSB.sts;	 	    end;s  2 	MENU_OPTION_SHOW: { DCL command SHOW ENTRY/FULL }| 	    DISPLAY_DCL_COMMAND ('SHOW ENTRY/FULL ' + dec(job.entry_number), JOB_BROWSER_PASTE_ROW-1, job_browser.viewport_rows+1);  ( 	MENU_OPTION_Exit: { Don't do anything } 	    ret_status := SS$_NORMAL;         end;C     if (ret_status = JBC$_NORMAL) or (ret_status = SS$_NORMAL) thene 	ERASE_MESSAGE     else 	SYS_MESSAGE (ret_status);  0     SMG$BEGIN_PASTEBOARD_UPDATE (pasteboard_id);>     SMG$POP_VIRTUAL_DISPLAY (job_menu.display, pasteboard_id);     end; { job_waiting_menu }    d Begin  { MANAGE_JOBS }  " { Get the latest job information } update_job_list;  , SMG$BEGIN_PASTEBOARD_UPDATE (pasteboard_id);   if detail_display = 0 then%     { Create the job detail display } 	     beginbp     ret_status := SMG$CREATE_VIRTUAL_DISPLAY (JOB_DETAIL_ROWS, pasteboard_cols-2, detail_display, SMG$M_BORDER);     if not odd(ret_status) thene 	begin0 	writeln('Unable to create Job detail display'); 	LIB$SIGNAL (ret_status);N 	end;	t     SMG$PUT_CHARS (detail_display, QUEUE_LABEL, QUEUE_ROW, 1,, DETAIL_HEADING_RENDITION, DETAIL_HEADING_COMPLEMENT);     SMG$CHANGE_RENDITION (detail_display, QUEUE_ROW, QUEUE_COL, 1, QUEUE_NAME_SIZE, DETAIL_HEADING_RENDITION, DETAIL_HEADING_COMPLEMENT);      SMG$PUT_CHARS (detail_display, QFORM_LABEL, QFORM_ROW, QUEUE_COL+max(QUEUE_NAME_SIZE,JOB_NAME_SIZE),, DETAIL_HEADING_RENDITION, DETAIL_HEADING_COMPLEMENT);lp     SMG$PUT_CHARS (detail_display, JOB_LABEL, JOB_ROW, 1,, DETAIL_HEADING_RENDITION, DETAIL_HEADING_COMPLEMENT);     SMG$PUT_CHARS (detail_display, JFORM_LABEL, JFORM_ROW, JOB_COL+max(QUEUE_NAME_SIZE,JOB_NAME_SIZE),, DETAIL_HEADING_RENDITION, DETAIL_HEADING_COMPLEMENT);i|     SMG$PUT_CHARS (detail_display, SUBMITTED_LABEL, SUBMITTED_ROW, 1,, DETAIL_HEADING_RENDITION, DETAIL_HEADING_COMPLEMENT);r     SMG$PUT_CHARS (detail_display, FILE_LABEL, FILE_ROW, 1,, DETAIL_HEADING_RENDITION, DETAIL_HEADING_COMPLEMENT);     SMG$LABEL_BORDER (detail_display, ' PQM '+PQM_VERSION+' ', SMG$K_TOP, 2, DETAIL_HEADING_RENDITION, DETAIL_HEADING_COMPLEMENT);/     FILE_LEN := pasteboard_cols - 2 - FILE_COL;n     end;   if job_browser.display = 0 thenn&     { Create the job browser display }	     begin u     ret_status := BROWSE_CREATE (job_count, pasteboard_rows-JOB_BROWSER_PASTE_ROW, JOB_BROWSER_HEADING, job_browser);      if not odd(ret_status) thenb 	begin& 	writeln('Unable to create Job List'); 	LIB$SIGNAL (ret_status) 	end;      end;     { Reveal what we've done }   display_queue_details; display_job_list; \ SMG$PASTE_VIRTUAL_DISPLAY (job_browser.headings, pasteboard_id, JOB_BROWSER_PASTE_ROW-1, 1);Y SMG$PASTE_VIRTUAL_DISPLAY (job_browser.display, pasteboard_id, JOB_BROWSER_PASTE_ROW, 1); N SMG$PASTE_VIRTUAL_DISPLAY (detail_display, pasteboard_id, 2, 2, time_display);* SMG$END_PASTEBOARD_UPDATE (pasteboard_id);    N { Run in a loop, updating the queue information and processing user requests }   repeat  F     UPDATE_TIME_DISPLAY;			{ Update the time displayed on the screen }       if read_timeout > 0 thenO 	ret_status := SMG$READ_KEYSTROKE (keyboard_id, read_terminator,, read_timeout)G     elseA 	ret_status := SMG$READ_KEYSTROKE (keyboard_id, read_terminator); ?     if not odd(ret_status) and (ret_status <> SS$_TIMEOUT) thend 	begin 	if ret_status = SMG$_EOF then
 	    begin 	    finished := TRUE; 	    exit_flag := TRUE;	
 	    continuet 	    end 	elseS 	    LIB$SIGNAL (ret_status) 	end;t       case read_terminator ofn 	SMG$K_TRM_HELP,5 	SMG$K_TRM_QUESTION_MARK : { Display on-screen help }	 			  DISPLAY_HELP;  _ 	SMG$K_TRM_PREV_SCREEN : { Highlight the job which appears 2/3 way up screen from current job }g
 			  begin4 			  SMG$BEGIN_DISPLAY_UPDATE (job_browser.display); 			  if selected = NIL thenN 			      { No jobs to browse }+ 			      MESSAGE('No jobs in '+queue^.name)r& 			  else if selected^.prev = NIL then+ 			      { We're 'up' as far as we can go }b* 			      message('Already at top of list')	 			  elsee 			      begin 			      ERASE_MESSAGE;N% 			      selected^.selected := FALSE;t 			      scroll_index := 0;td 			      while (selected^.prev <> NIL) and (scroll_index < (job_browser.viewport_rows * 2 div 3)) do 				  begin ( 			          selected := selected^.prev;& 				  scroll_index := scroll_index + 1
 				  end;M 			      if selected^.prev = NIL then MESSAGE('Top of list', MESSAGE_SILENT);g$ 			      selected^.selected := TRUE;8 			      force_list_update := update_one_job (selected);
 			      end;)2 			  SMG$END_DISPLAY_UPDATE (job_browser.display);	 			  end;   ] 	SMG$K_TRM_NEXT_SCREEN : { Highlight the job which appears 2/3 way up down from current job }p
 			  begin4 			  SMG$BEGIN_DISPLAY_UPDATE (job_browser.display); 			  if selected = NIL then- 			      { No jobs to browse }+ 			      MESSAGE('No jobs in '+queue^.name)o& 			  else if selected^.next = NIL then- 			      { We're 'down' as far as we can go }n- 			      message('Already at bottom of list')		 			  elseu 			      begin 			      ERASE_MESSAGE;e% 			      selected^.selected := FALSE;  			      scroll_index := 0;	d 			      while (selected^.next <> NIL) and (scroll_index < (job_browser.viewport_rows * 2 div 3)) do 				  begin ( 			          selected := selected^.next;& 				  scroll_index := scroll_index + 1
 				  end;P 			      if selected^.next = NIL then MESSAGE('Bottom of list', MESSAGE_SILENT);$ 			      selected^.selected := TRUE;8 			      force_list_update := update_one_job (selected);
 			      end;_2 			  SMG$END_DISPLAY_UPDATE (job_browser.display);	 			  end;t  I 	SMG$K_TRM_UP	: { Highlight the job which appears above the current job }E
 			  begin4 			  SMG$BEGIN_DISPLAY_UPDATE (job_browser.display); 			  if selected = NIL thens 			      { No jobs to browse }+ 			      MESSAGE('No jobs in '+queue^.name)Q& 			  else if selected^.prev = NIL then+ 			      { We're 'up' as far as we can go }o* 			      message('Already at top of list')	 			  elsem 			      begin 			      ERASE_MESSAGE;e% 			      selected^.selected := FALSE;d$ 			      selected := selected^.prev;$ 			      selected^.selected := TRUE;8 			      force_list_update := update_one_job (selected);
 			      end;'2 			  SMG$END_DISPLAY_UPDATE (job_browser.display);	 			  end;   K 	SMG$K_TRM_DOWN	: { Highlight the job which appears below the current job }M
 			  begin4 			  SMG$BEGIN_DISPLAY_UPDATE (job_browser.display); 			  if selected = NIL thenr 			      { No jobs to browse }+ 			      MESSAGE('No jobs in '+queue^.name) & 			  else if selected^.next = NIL then- 			      { We're 'down' as far as we can go }s- 			      message('Already at bottom of list') 	 			  elsee 			      begin 			      ERASE_MESSAGE;e% 			      selected^.selected := FALSE;R$ 			      selected := selected^.next;$ 			      selected^.selected := TRUE;8 			      force_list_update := update_one_job (selected);
 			      end;;2 			  SMG$END_DISPLAY_UPDATE (job_browser.display);	 			  end;    	SMG$K_TRM_DO,V 	SMG$K_TRM_PF4	: { Display a menu of job operations and perform the user's selection }
 			  begin 			  ERASE_MESSAGE;$5 			  if selected <> NIL then with selected^.status doP 			      begin! 			      if QUI$V_JOB_ABORTING orn 				 QUI$V_JOB_EXECUTING orM 				 QUI$V_JOB_STALLED or. 				 QUI$V_JOB_STARTING or 				 QUI$V_JOB_SUSPENDED thene" 				  job_running_menu (selected^)
 			      else # 				  job_waiting_menu (selected^);	. 			      if odd(UPDATE_ONE_QUEUE(queue^)) then 				  begins' 				  if update_one_job (selected) thenc# 				      force_list_update := TRUE	
 				  else 				      display_queue_details 	 				  end 
 			      else	 				  finished := TRUE 			      end	 			  else  			      { Queue is empty }eL 			      MESSAGE ('To manipulate this queue, return to the Queues display');. 			  SMG$END_PASTEBOARD_UPDATE (pasteboard_id)	 			  end;u   	SMG$K_TRM_UPPERCASE_Q,  	SMG$K_TRM_LOWERCASE_Q,L 	SMG$K_TRM_CTRLM,u3 	SMG$K_TRM_ENTER	: { Return to the QUEUES display }  			  finished := TRUE;   	SMG$K_TRM_TIMEOUT, 1 	SMG$K_TRM_SPACE	: { Update the entire job list }y/ 			  if not odd(UPDATE_ONE_QUEUE (queue^)) thenS 			      finished := TRUEm	 			  elseN# 			      force_list_update	:= TRUE;r  < 	SMG$K_TRM_CTRLW	: { Redraw the screen without changing it }( 			  SMG$REPAINT_SCREEN (pasteboard_id);  ' 	      otherwise	  { Unexpected input }_* 			  MESSAGE('Unexpected input; ignored'); 	end;e       if force_list_update then	 	begin 	display_queue_details;r 	update_job_list;  	display_job_list; 	force_list_update := FALSEo 	end;J   until finished;    {s,   Unselect the job in case it's still around.   the next time we come into the Jobs display. }s4 if selected <> NIL then selected^.selected := FALSE;   ERASE_MESSAGE;, SMG$BEGIN_PASTEBOARD_UPDATE (pasteboard_id);A SMG$UNPASTE_VIRTUAL_DISPLAY (job_browser.display, pasteboard_id); B SMG$UNPASTE_VIRTUAL_DISPLAY (job_browser.headings, pasteboard_id);< SMG$UNPASTE_VIRTUAL_DISPLAY (detail_display, pasteboard_id);   End;    P {*******************************************************************************% *	Module Initialisation						       *lP *******************************************************************************}   TO BEGIN DO[   begin;  P {-------------------------------------------------------------------------------, 	Prepare the QUEUE item list for SYS$GETQUIWP -------------------------------------------------------------------------------}  C qui_queue_itemlist[1]	:= Item_List_3 [item_code : QUI$_SEARCH_NAME;l0 					bufaddr   : iaddress(qui_search_name.body); 					otherwise ZERO];   D qui_queue_itemlist[2]	:= Item_List_3 [item_code : QUI$_SEARCH_FLAGS;( 					item_len  : size(qui_search_flags);, 					bufaddr   : iaddress(qui_search_flags); 					retaddr   : ZERO];	    P {------------------------------------------------------------------------------- 	Prepare the JOB item listP -------------------------------------------------------------------------------}  C qui_job_itemlist[0]	:= Item_List_3 [item_code : QUI$_SEARCH_NUMBER;f) 					item_len  : size(qui_search_number);^- 					bufaddr   : iaddress(qui_search_number);  					retaddr   : ZERO];j  B qui_job_itemlist[1]	:= Item_List_3 [item_code : QUI$_SEARCH_FLAGS;( 					item_len  : size(qui_search_flags);, 					bufaddr   : iaddress(qui_search_flags); 					retaddr	  : ZERO];   @ qui_job_itemlist[2]	:= Item_List_3 [item_code : QUI$_AFTER_TIME;& 					item_len  : size(qui_after_time);* 					bufaddr   : iaddress(qui_after_time); 					retaddr   : ZERO];N  ? qui_job_itemlist[3]	:= Item_List_3 [item_code : QUI$_FORM_NAME;	* 					item_len  : size(qui_form_name.body);. 					bufaddr   : iaddress(qui_form_name.body);1 					retaddr   : iaddress(qui_form_name.length)];m  F qui_job_itemlist[4]	:= Item_List_3 [item_code : QUI$_COMPLETED_BLOCKS;' 					item_len  : size(qui_blocks_done);n+ 					bufaddr   : iaddress(qui_blocks_done);> 					retaddr	  : ZERO];o  F qui_job_itemlist[5]	:= Item_List_3 [item_code : QUI$_CONDITION_VECTOR;% 					item_len  : size(qui_condition);a) 					bufaddr	  : iaddress(qui_condition);, 					retaddr   : ZERO];.  B qui_job_itemlist[6]	:= Item_List_3 [item_code : QUI$_ENTRY_NUMBER;( 					item_len  : size(qui_entry_number);, 					bufaddr   : iaddress(qui_entry_number); 					retaddr   : ZERO];e  ? qui_job_itemlist[7]	:= Item_List_3 [item_code : QUI$_JOB_FLAGS;_% 					item_len  : size(qui_job_flags);	) 					bufaddr   : iaddress(qui_job_flags);u 					retaddr   : ZERO];i  > qui_job_itemlist[8]	:= Item_List_3 [item_code : QUI$_JOB_NAME;) 					item_len  : size(qui_job_name.body);.- 					bufaddr   : iaddress(qui_job_name.body);s0 					retaddr   : iaddress(qui_job_name.length)];  @ qui_job_itemlist[9]	:= Item_List_3 [item_code : QUI$_JOB_STATUS;& 					item_len  : size(qui_job_status);* 					bufaddr   : iaddress(qui_job_status); 					retaddr   : ZERO];   A qui_job_itemlist[10]	:= Item_List_3 [item_code : QUI$_FILE_COUNT;i& 					item_len  : size(qui_file_count);* 					bufaddr   : iaddress(qui_file_count); 					retaddr   : ZERO];m  J qui_job_itemlist[11]	:= Item_List_3 [item_code : QUI$_JOB_COMPLETION_TIME;( 					item_len  : size(qui_completed_at);, 					bufaddr   : iaddress(qui_completed_at); 					retaddr   : ZERO];e  I qui_job_itemlist[12]	:= Item_List_3 [item_code : QUI$_JOB_RETENTION_TIME; ( 					item_len  : size(qui_retain_until);, 					bufaddr   : iaddress(qui_retain_until); 					retaddr   : ZERO];e  ? qui_job_itemlist[13]	:= Item_List_3 [item_code : QUI$_JOB_SIZE; ) 				   	item_len  : size(qui_job_blocks);l* 					bufaddr   : iaddress(qui_job_blocks); 					retaddr   : ZERO];   I qui_job_itemlist[14]	:= Item_List_3 [item_code : QUI$_PENDING_JOB_REASON;m* 					item_len  : size(qui_pending_reason);. 					bufaddr   : iaddress(qui_pending_reason); 					retaddr   : ZERO];e  F qui_job_itemlist[15]	:= Item_List_3 [item_code : QUI$_SUBMISSION_TIME;( 					item_len  : size(qui_submitted_at);, 					bufaddr   : iaddress(qui_submitted_at); 					retaddr   : ZERO];e  ? qui_job_itemlist[16]	:= Item_List_3 [item_code : QUI$_USERNAME;F) 					item_len  : size(qui_username.body); - 					bufaddr   : iaddress(qui_username.body);o0 					retaddr   : iaddress(qui_username.length)];  A qui_job_itemlist[17]	:= Item_List_3 [item_code : QUI$_QUEUE_NAME; + 					item_len  : size(qui_queue_name.body);d/ 					bufaddr   : iaddress(qui_queue_name.body); 2 					retaddr   : iaddress(qui_queue_name.length)];  ? qui_job_itemlist[18]	:= Item_List_3 [item_code : QUI$_PRIORITY;u( 					item_len  : size(qui_job_priority);, 					bufaddr   : iaddress(qui_job_priority); 					retaddr   : ZERO];e  P {------------------------------------------------------------------------------- 	Prepare the FILE item listMP -------------------------------------------------------------------------------}  I qui_file_itemlist[1]	:= Item_List_3 [item_code : QUI$_FILE_SPECIFICATION;n) 					item_len  : size(qui_filename.body);c- 					bufaddr   : iaddress(qui_filename.body);c0 					retaddr   : iaddress(qui_filename.length)];  B qui_file_itemlist[2]	:= Item_List_3 [item_code : QUI$_FILE_STATUS;' 					item_len  : size(qui_file_status); + 					bufaddr   : iaddress(qui_file_status);  					retaddr   : ZERO];Z  A qui_file_itemlist[3]	:= Item_List_3 [item_code : QUI$_FIRST_PAGE;{+ 					item_len  : size(qui_file_first_page);e/ 					bufaddr   : iaddress(qui_file_first_page);e 					retaddr   : ZERO];   @ qui_file_itemlist[4]	:= Item_List_3 [item_code : QUI$_LAST_PAGE;* 					item_len  : size(qui_file_last_page);. 					bufaddr   : iaddress(qui_file_last_page); 					retaddr   : ZERO];r   end;   End.