/* fixcf */

/* fixcf - a program which will alter existing sendmail.cf files to contain
 * the right rulesets for inflex and others 
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "strlower.h"
 
#define _INFLEX_RULE "R$*	$#inflex $:$1\n"

#define _USAGE "fixcf Usage:\n\
	fixcf -s <spool directory> -t <status file> -m <MDA def file> -i <sendmail.cf> -o <inflex.cf>\n\n"

	
char *_spool_location = NULL;
char *_status_file = NULL;
char *_minflex_file = NULL;
char *_sendmail_cf_file = NULL;
char *_inflex_cf_file = NULL;

int parse_file( FILE *inf, FILE *outf ){
	
	int located_R0 = 0;
	int located_status = 0;
	int located_spool = 0;
	int hit = 0;
	
	char inl[1024];
	char lowline[1024];
	
	while (fgets(inl,1023,inf)){

		strcpy(lowline, inl); strlower(lowline);
			
		if (located_status==0) {
			if (strstr(lowline,"o statusfile=")){
				fprintf(outf,"O StatusFile=%s\n",_status_file);
				located_status=1;
				hit++;
				}
			} 
			
		if (located_spool==0) {
			if (strstr(lowline,"o queuedirectory=")){
				fprintf(outf,"O QueueDirectory=%s\n",_spool_location);
				located_spool=1;
				hit++;
				}
			} 
			
		if (located_R0==0){
			/* Here we check for both sparselocal=98, which is post v8.9.3 sendmail
			* and S98, which is v8.9.3 */
			if (strstr(lowline,"sparselocal=98")\
||strstr(lowline,"s98")\
||strstr(lowline,"$#local $: <@>")\
){
				fprintf(outf,"%s",inl);
				fprintf(outf,"%s",_INFLEX_RULE);
				located_R0=1;
				hit++;
				}
			}
			 
		if (hit == 0) { fprintf(outf,"%s",inl); } else { hit = 0; }
		
		} /* keep going until we run out of sendmail.cf lines. */
		
		return 0;
		}
				
int add_MDA(FILE *inf, FILE *outf) {
	
	char line[1024];
	
	while (fgets(line,1024,inf)){
		fprintf(outf,"%s",line);
		}
		
	return 0;
	}
	

int set_parameters( int argc, char **argv ){
	
	int i;
	
	for (i = 0; i < argc; i++){
		if (argv[i][0] == '-') {
			switch (argv[i][1]){
				case 't': _status_file = argv[++i]; break;
				case 's': _spool_location = argv[++i]; break;
				case 'm': _minflex_file = argv[++i]; break;
				case 'i': _sendmail_cf_file = argv[++i]; break;
				case 'o': _inflex_cf_file = argv[++i]; break;
				default: fprintf(stderr,"Error: unknow parameter '%s'\n",argv[i]); exit(1);
				}
			}
		}
	
	return 0;
	}
	
	
int dump_parms( int argc, char **argv) {
	int i;
	
	for (i=1; i < argc; i++){
		fprintf(stderr,"%s ",argv[i]);
		}
	fprintf(stderr,"\n");
	
	return 0;
	
	}
	
	
int main( int argc, char **argv ){

	FILE *inf, *outf;
	
	/* Our parameters list... */
	
	set_parameters(argc, argv);

	fprintf(stderr,"\n\n%s\n%s\n%s\n%s\n%s\n\n",_status_file, _spool_location, _minflex_file, _sendmail_cf_file, _inflex_cf_file);
	if (!( _status_file && _spool_location && _minflex_file && _sendmail_cf_file && _inflex_cf_file )){
		fprintf(stderr,"%s",_USAGE);
		dump_parms( argc, argv);
		exit(1);
		}
		
	inf = fopen(_sendmail_cf_file,"r");
	outf = fopen(_inflex_cf_file,"w");
	
	parse_file(inf, outf);
	
	fclose(inf);
	
	inf = fopen(_minflex_file,"r");
	add_MDA(inf, outf);
	
	fclose(inf);
	fclose(outf);
	
	return 0;
	}			 
