#!/bin/sh
#
#-------------------------------------------------------------------
#
# install.sh - taken from the XaMime commercial Email-Scanner distro
#
# written by Paul L Daniels
# pldaniels@pldaniels.com
#
# This routine is used as part of the inflex installation procedure
#
#

	
#
# Set our ANSI codes
don="\033[0;40;33m"
doff="\033[0;40;37m"
dg="\033[0;40;32m"
dw="\033[0;40;37m"
dr="\033[0;40;31m"

report=install.log
username=inflex
groupname=inflex
passwd=/etc/passwd
shadow=/etc/shadow
group=/etc/group
sendmailpg=`which sendmail`
adminemail=postmaster
libdir=/usr/lib
install_version="1.0.11 - May 12 7:18 EST 2001 pldaniels <pldaniels@pldaniels.com>"




#  Operating Systems
#  Operating Systems
#  Operating Systems
#
_redhat=1
_slackware=2
_debian=3
_suse=4
_freebsd=5

#  AntiVirus software
#  AntiVirus software
#  AntiVirus software
#
_noav=0
_fprot=1
_sophos=2
_mcafee=3
_nod32=4


preset_suse(){
	groupadd="/usr/sbin/groupadd"
	useradd="/usr/sbin/useradd"
	inetd="inetd"
	inetdfile="/etc/inetd.conf"
	ldconfig="/sbin/ldconfig"
	libdir="/usr/lib"
	crontabfile="/etc/crontab"
	services="/etc/services"
	passwd="/etc/passwd"
	shadow="/etc/shadow"
	group="/etc/group"
	sendmailpg="/usr/sbin/sendmail"
	grep_flags="-rli"
	find_flags="-iname"
	}

preset_redhat(){
	groupadd="/usr/sbin/groupadd"
	useradd="/usr/sbin/useradd"
	inetd="xinetd"
	inetdfile="/etc/xinetd.conf"
	ldconfig="/sbin/ldconfig"
	libdir="/usr/lib"
	crontabfile="/etc/crontab"
	services="/etc/services"
	passwd="/etc/passwd"
	shadow="/etc/shadow"
	group="/etc/group"
	sendmailpg="/usr/sbin/sendmail"
        grep_flags="-rli"
        find_flags="-iname"

	}

preset_slackware(){
   groupadd="/usr/sbin/groupadd"
   useradd="/usr/sbin/useradd"
	inetd="inetd"
	inetdfile="/etc/inetd.conf"
	ldconfig="/sbin/ldconfig"
	libdir="/usr/local/lib"
	crontabfile="/var/spool/cron/crontabs/root"
	services="/etc/services"
	passwd="/etc/passwd"
	shadow="/etc/shadow"
	group="/etc/group"
        grep_flags="-rli"
        find_flags="-iname"

	}

preset_debian(){
   groupadd="/usr/sbin/groupadd"
   useradd="/usr/sbin/useradd"
	inetd="inetd"
	inetdfile="/etc/inetd.conf"
	ldconfig="/sbin/ldconfig"
	libdir="/usr/lib"
	crontabfile="/etc/crontab"
	services="/etc/services"
	passwd="/etc/passwd"
	shadow="/etc/shadow"
	group="/etc/group"
        grep_flags="-rli"
        find_flags="-iname"

	}

preset_freebsd(){
	inetd="inetd"
	inetdfile="/etc/inetd.conf"
	ldconfig="/sbin/ldconfig"
	libdir="/usr/lib"
	crontabfile="/etc/crontab"
	services="/etc/services"
	passwd="/etc/passwd"
	shadow="/etc/shadow"
	group="/etc/group"
        grep_flags="-li"
        find_flags="-name"

	}



# Find SED
# Find SED
# Find SED
#
if [ -e /usr/bin/sed ]
then
	sedpg=/usr/bin/sed
	fi
	
if [ -e /bin/sed ]
then
	sedpg=/bin/sed
	fi
	
if [ -e /usr/local/bin/sed ]
then
	sedpg=/usr/local/bin/sed
	fi
	


# Ask for OverWrite
# Ask for OverWrite
# Ask for OverWrite
#
askow(){

	if [ -e ${inflexdir}/${source} ]
	then
		printf "'${source}' already exists, do you want to overwrite? (y/N) : "
		read x
		if [ "a$x" = "ay" ]
		then
			install -c -m $fmode -o ${username} -g ${groupname} ${source} ${inflexdir} >>$report 2>>$report
			fi
	else
		install -c -m $fmode -o ${username} -g ${groupname} ${source} ${inflexdir} >>$report 2>>$report
		fi

}		

	
# Search/Replace for the inflex.raw file
# Search/Replace for the inflex.raw file
# Search/Replace for the inflex.raw file
#			
SR(){
	epath=`./escpath $replacewith`
	sedstring=s/$searchfor/$epath/
	${sedpg} ${sedstring} inflex.raw > inflex.raw_
	mv inflex.raw_ inflex.raw
	}



# Copy our .raw file to a safe place, for when we're finished up
# Copy our .raw file to a safe place, for when we're finished up
# Copy our .raw file to a safe place, for when we're finished up
#
cp inflex.raw inflex.raw.safe

printf "$don $doff________________________________________________________\n\
_\n\
_ Inflex v1.0.3 Installation.\n\
_\n\
_\n"



# First off, compile fixcf
# First off, compile fixcf
# First off, compile fixcf
#
printf "Compiling FixCF..."
make fixcf
printf "${don}done.${doff}\n"




# Then make and install ripMIME
# Then make and install ripMIME
# Then make and install ripMIME
#
printf "Compiling and installing ripMIME 1.0.0d...(http://pldaniels.com/ripmime)"
cd ripmime-1.0.0d
make
make install
cd ..
printf "${don}done.${doff}\n"



# Get our system specific binary locations, and insert them into the inflex.raw file
# Get our system specific binary locations, and insert them into the inflex.raw file
# Get our system specific binary locations, and insert them into the inflex.raw file
#
searchfor=__CUT__
replacewith=`which cut`
SR

searchfor=__TEST__
replacewith=`which test`
SR

searchfor=__MAIL__
replacewith=`which mail`
SR

searchfor=__GREP__
replacewith=`which grep`
SR

searchfor=__FILE__
replacewith=`which file`
SR

searchfor=__FIND__
replacewith=`which find`
SR

searchfor=__TOUCH__
replacewith=`which touch`
SR

searchfor=__FORMAIL__
replacewith=`which formail`
SR

searchfor=__SENDMAIL__
replacewith=`which sendmail`
SR

searchfor=__RIPMIME__
replacewith=`which ripmime`
SR


			
printf "\nInstall version : $install_version\n\n\n\n\
                 $don Welcome to inflex$doff\n\
					  \n\
					  \n\
This install program will perform the following operations...\n\
\n\
	. Ask a series of questions regarding inflex\n\
	. Create required user/group account\n\
	. Locate your sendmail.cf and create an inflex.cf\n\
	. Ask you 'are you really sure'...\n\
	. Install inflex files into specified location\n\
	. Inform you of changes made.\n\n\n"


# clear our log file
# clear our log file
# clear our log file
#
echo "" > $report




# Try and predetermin our OS
# Try and predetermin our OS
# Try and predetermin our OS
#
#		Is it FreeBSD ?
#
install_os=$_slackware

whatos=`uname -s`
if [ $whatos = "FreeBSD" ]
then
	install_os=$_freebsd
elif [ -f /etc/SuSE-release ]
then
	install_os=$_suse
elif [ -d /usr/i386-slackware-linux ]
then
	install_os=$_slackware
elif [ -f /etc/redhat-release ]
then
	install_os=$_redhat
elif [ -f /etc/debian_version ]
then
	install_os=$_debian
	fi


# Present the results, and ask for confirmation
# Present the results, and ask for confirmation
# Present the results, and ask for confirmation
#
printf "$bon OS which you are installing this for?$boff\n\
1. Linux RedHat\n\
2. Linux Slackware\n\
3. Linux Debian\n\
4. Linux SuSE
5. FreeBSD\n\
   $bon Choice $boff [$don${install_os}$doff] : "
read x
if [ "a$x" != "a" ]
then
	install_os=$x
	fi
printf "\n"



# Run our preset functions depending on our choice of OS
# Run our preset functions depending on our choice of OS
# Run our preset functions depending on our choice of OS
#
if [ $install_os -eq $_redhat ]
then
	preset_redhat
elif [ $install_os -eq $_slackware ]
then
	preset_slackware
elif [ $install_os -eq $_debian ]
then
	preset_debian
elif [ $install_os -eq $_freebsd ]
then
	preset_freebsd
elif [ $install_os -eq $_suse ]
then
	preset_suse
	fi

# Change OS specific flags for GREP and FIND
# Change OS specific flags for GREP and FIND
# Change OS specific flags for GREP and FIND
#
searchfor=__GREP_FLAGS__
replacewith=$grep_flags
SR

searchfor=__FIND_FLAGS__
replacewith=$find_flags
SR



# Find out what AntiVirus (if any) we have
# Find out what AntiVirus (if any) we have
# Find out what AntiVirus (if any) we have
#
detect_av(){

	if [ -e /usr/local/fsav/fsav ]
	then
		_av=$_fprot
	elif [ -e /usr/local/sophos/sweep ]
	then
		_av=$_sophos
	elif [ -e /usr/local/uvscan/uvscan ]
	then
		_av=$_mcafee
	elif [ -e /usr/local/nod32/nod32 ]
	then
		_av=$_nod32
	else
		_av=$_noav
		fi

	}



# Scan and determin which AntiVirus Software we have
# Scan and determin which AntiVirus Software we have
# Scan and determin which AntiVirus Software we have
#
detect_av
printf "$bon AntiVirus program to use ?$boff\n\
0. No AntiVirus\n\
1. FProt/Datafellows FSAV\n\
2. Sophos Sweep\n\
3. McAfee UVscan\n\
4. NOD 32\n\
   $bon Choice $boff [$don$_av$doff] : "
read x
if [ "a$x" != "a" ]
then
	_av=$x
	fi
printf "\n"



# Alter the inflex.raw file so that it now reflects the
# correct Antivirus solution
#
if [ $_av -eq $_fprot ]
then
	searchfor=__FSAV__
	replacewith="/usr/local/fsav/fsav"
	SR

	searchfor=__SOPHOS__
	replacewith=""
	SR

	searchfor=__MCAFEE__
	replacewith=""
	SR

	searchfor=__NOD32__
	replacewith=""
	SR

elif [ $_av -eq $_sophos ]
then
	searchfor=__FSAV__
	replacewith=""
	SR

	searchfor=__SOPHOS__
	replacewith="/usr/local/sophos/sweep"
	SR

	searchfor=__MCAFEE__
	replacewith=""
	SR

        searchfor=__NOD32__
        replacewith=""
        SR



elif [ $_av -eq $_mcafee ]
then
	searchfor=__FSAV__
	replacewith=""
	SR

	searchfor=__SOPHOS__
	replacewith=""
	SR

        searchfor=__NOD32__
        replacewith=""
        SR

	searchfor=__MCAFEE__
	replacewith="/usr/local/uvscan/uvscan"
	SR
	
elif [ $_av -eq $_nod32 ]
then
        searchfor=__FSAV__
        replacewith=""
        SR

        searchfor=__SOPHOS__
        replacewith=""
        SR

        searchfor=__NOD32__
        replacewith="/usr/local/nod32/nod32"
        SR


        searchfor=__MCAFEE__
        replacewith=""
        SR

elif [ $_av -eq 0 ]
then

        searchfor=__NOD32__
        replacewith=""
        SR

        searchfor=__FSAV__
        replacewith=""
        SR

        searchfor=__SOPHOS__
        replacewith=""
        SR


        searchfor=__MCAFEE__
        replacewith=""
        SR

        fi






# Set our CRONTAB entry for the queue
# Set our CRONTAB entry for the queue
# Set our CRONTAB entry for the queue
#
# FreeBSD and SuSE require a UID in each CRON entry
#
#
if [ $install_os -eq $_suse\
 -o $install_os -eq $_freebsd ]
then
        crontab_entry='0,15,30,45 * * * * root '"${sendmailpg} -q"
else 
	crontab_entry='0,15,30,45 * * * *	'"${sendmailpg} -q"
fi
	
	


# Find our sendmail.cf
# Find our sendmail.cf
# Find our sendmail.cf
#
if [ -e /etc/sendmail.cf ]
then
	sendmailcf=/etc/sendmail.cf
	fi
	
if [ -e /etc/mail/sendmail.cf ]
then
	sendmailcf=/etc/mail/sendmail.cf
	fi




# Alter our inflex.raw file
# Alter our inflex.raw file
# Alter our inflex.raw file
#
searchfor=__SENDMAIL_CF__
replacewith=$sendmailcf
SR
	


	
# Get where the inflex program is to be installed.
# Get where the inflex program is to be installed.
# Get where the inflex program is to be installed.
#	
inflexdir=/usr/local/inflex
printf "inflex install directory? [$don${inflexdir}$doff] : "
read x
if [ "a$x" != "a" ] 
then
	inflexdir=$x
	fi




# Now that we have the inflex install dir, we can convert the raw inflex file
# Now that we have the inflex install dir, we can convert the raw inflex file
# Now that we have the inflex install dir, we can convert the raw inflex file
#
searchfor=__INFLEXDIR__
replacewith=$inflexdir
SR

printf "inflex user [$don${username}$doff] : "
read x
if [ "a$x" != "a" ]
then
	username=$x
	fi
	
printf "inflex group [$don${groupname}$doff] : "
read x
if [ "a$x" != "a" ]
then
	groupname=$x
	fi
		
printf "User to receive all email blocked reports ? [$don${adminemail}$doff] : "
read x
if [ "a$x" != "a" ]
then
	adminemail=$x
	fi

searchfor=__ADMIN_EMAIL__
replacewith=$adminemail
SR

printf "Sendmail configuration file [$don${sendmailcf}$doff] : "
read x
if [ "a$x" != "a" ]
then
	sendmailcf=$x
	fi


printf "\n\n\n\n\
Details of your installation...\n\
	    Install path: $dg$inflexdir$doff\n\
	    inflex User: $dg$username$doff\n\
	   inflex Group: $dg$groupname$doff\n\
	     Admin Email: $dg$adminemail$doff\n\
	Sendmail.cf file: $dg$sendmailcf$doff\n\
	\n\
Are these details correct (y/n) : "
read x

if [ "a$x" != "ay" ]
then
	printf "\n\
	You can reinstall simply by typing in ./install.sh again.\n\n\n\n"
	cp inflex.raw.safe inflex.raw
	exit
	fi



	
# get a line count of how many inflex's appear in 
# either passwd/group
#
printf "Checking user/group details...\n"
userresult=`id $username | grep "uid=" | wc -l`
groupresult=0




# Create our user/group as required
# Create our user/group as required
# Create our user/group as required
#
if [ $groupresult -eq 0 ]
then
	if [ $install_os -eq $_freebsd ]
	then
		pw add group $groupname
	else
		$groupadd $groupname
		fi
	printf  "added group '$groupname'..$don done$doff.\n"
else
	printf  "group '$groupname'$don already exists$doff.\n"
	fi



# Add the user
# Add the user
# Add the user
#
if [ $userresult -eq 0 ]
then
	if [ $install_os -eq $_freebsd ]
	then
		pw add user $username -g $groupname
	else
		$useradd -d $inflexdir -g $groupname -s /bin/false $username
		fi
	printf  "added user '$username'..$don done$doff.\n"
else
	printf  "user '$username'$don already exists$doff.\n"
	fi


# Get the uid/gid
# Get the uid/gid
# Get the uid/gid
#
printf "Getting UID/GID..."
uid=`id $username | cut -d= -f2 | cut -d'(' -f1`
gid=`id $username | cut -d= -f3 | cut -d'(' -f1`
printf "UID for $username = $uid, GID for $username = $gid\n"



# Create our inflex.cf file off the existing sendmail.cf
# Create our inflex.cf file off the existing sendmail.cf
# Create our inflex.cf file off the existing sendmail.cf
#
# first, update our MDA mods file...
#
printf "Creating MDA file..."
printf "\n\
Minflex,	P=${inflexdir}/inflex, F=ClsDFM:/|@qShPm,\n\
		S=0, R=0, T=DNS/RFC822/X-Unix,\n\
		A=inflex \$h \$u \$f \n" > ./Minflex.MDA
printf "$don done.$doff\n"




# Then apply it to the current sendmail.cf file...
# Then apply it to the current sendmail.cf file...
# Then apply it to the current sendmail.cf file...
#
printf "Applying updates to sendmail.cf to create inflex.cf..."
./fixcf -s ${inflexdir}/spool -t ${inflexdir}/inflex.st -m ./Minflex.MDA -i ${sendmailcf} -o ./inflex.cf > /dev/null 2>/dev/null
printf "$don done.$doff\n"




# Create the directories...
# Create the directories...
# Create the directories...
#
printf "Installing files..."
mkdir -p ${inflexdir} >>$report 2>>$report
mkdir -p ${inflexdir}/spool  >>$report 2>>$report
mkdir -p ${inflexdir}/tmp >>$report 2>>$report
printf "$don done.$doff\n"




# Set the permissions...
# Set the permissions...
# Set the permissions...
#
chmod 755 ${inflexdir}/spool >>$report 2>>$report
chmod 755 ${inflexdir}/tmp >>$report 2>>$report
chown -R root:daemon ${inflexdir}  >>$report 2>>$report
#chown ${username}:${groupname} ${inflexdir}




# Install our binaries
# Install our binaries
# Install our binaries
#
mv inflex.raw inflex
install -c -m 700 -o ${username} -g ${groupname} inflex ${inflexdir}  >>$report 2>>$report




# Set root.root ability of the inflex file
# Set root.root ability of the inflex file
# Set root.root ability of the inflex file
#
#chmod a+s ${inflexdir}/inflex >>$report 2>>$report


# Install the Auxilary files...
# Install the Auxilary files...
# Install the Auxilary files...
#
fmode=600
for source in inflex.cf;
do
	askow
done

printf "$don done.$doff\n"



# Now, lets clean up any temp files...
# Now, lets clean up any temp files...
# Now, lets clean up any temp files...
#
printf "cleaning up temporary install files..."
printf "$don done.$doff\n"



# See if there already is a CRON entry for running sendmail queue
# See if there already is a CRON entry for running sendmail queue
# See if there already is a CRON entry for running sendmail queue
#
#
cronexists=`grep sendmail ${crontabfile} | grep -v grep | wc -l`


# now lets do the sendmail -q
# now lets do the sendmail -q
# now lets do the sendmail -q
#
if [ $cronexists -eq 0 ]
then
	printf "\n\n\n\
		Install sendmail periodic (15 minute) queuing in crontab (y/n) ? : "
	read x

	if [ "a$x" = "ay" ]
	then
		printf "Crontab file location [$don${crontabfile}$doff] : "
		read x
	
		# if the user entered something, then we better use it 
		#
		if [ "a$x" != "a" ]
		then
			crontabfile=$x
		fi
		
		printf "Installing cronjob into ${cronttabfile}..."
		echo "$crontab_entry" >> ${crontabfile}
		printf "$don done$doff.\n"
		fi
	fi

if [ ${cronexists} -ne 0 ]
then
	printf "Crontab entry already exists, $don skipping update$doff\n\n"
	fi



# Ask if we want to restart sendmail...
# Ask if we want to restart sendmail...
# Ask if we want to restart sendmail...
#
printf "\n\
	Do you want to restart sendmail (y/N) : "
read x
if [ "a$x" = "ay" ]
then
	killall sendmail
	sleep 2
	${sendmailpg} -bd -q15m -C ${inflexdir}/inflex.cf
	count=`ps -ax | grep sendmail | grep -v grep | wc -l`
	if [ $count -gt 0 ]
	then
		printf "$don Successfully restarted$doff.\n"
	else
		printf "$dr Error - Could not restart$doff.\n"
		fi
	fi
	
	
	
# Test the size of the log file, if there are more than 0 lines in it, then we have had errors
#

printf "____________________________________________________________________\n\n"

logsize=`grep -v '^$' < $report | wc -l`
if [ $logsize -gt 0 ]
then
	printf "\n\n\nThere may have been errors in the Inflex installation,
please check $report for details.\n\n\n"
else
	printf "\n\n\nCongratulations, Inflex is installed.\n\n\n"
	fi
	
printf "Please add the new sendmail startup to your startup\n\
scripts, the startup line should now appear as...\n\
\n\
	${sendmailpg} -bd -q15m -C ${inflexdir}/inflex.cf\n\
\n\
Thank you and enjoy the new safety of your email...\n\n\
This install script was backported from the commercial XaMime Email\n\
sanitation program. http://xamime.com\n\n\
$install_version\n\
\n\
___________________________________________________________________\n"

# revert the inflex.raw back, so if we run install again,it's okay!
#
cp inflex.raw.safe inflex.raw



#
# END.
