/*----------------------------------------
 * ripMIME - 
 *
 * Written by Paul L Daniels
 * pldaniels@pldaniels.com
 *
 * (C)2001 P.L.Daniels
 * http://www.pldaniels.com/ripmime
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>

#include "debugging.h"
#include "mime.h"

char defaultdir[]=".";
char version[]="v1.0.0pr5 - 27/03/2001 (C) PLDaniels http://www.pldaniels.com/ripmime";
char help[]="ripMIME -i <mime file> -d <directory> [-p prefix] [-e [header file]] [-vVh] [--syslog_on] [--stderr_off]\n\
	Options available :\n\
		-i : Input MIME encoded file (use '-' to input from STDIN)\n\
		-d : Output directory\n\
		-p : Specify prefix filename to be used on files without a filename (default 'text')\n\
		-e [headers file name] : Dump headers from mailpack (default '_headers_')\n\
		-v : Turn on verbosity\n\
		--syslog_on : Turn on syslog'ing (default is OFF)\n\
		--stderr_off : Turn off stderr logging (default is ON)\n\
		--no_nameless : Do not save nameless attachments\n\
		-V : Give version information\n\
		-h : This message (help)\n\n\n";
		
	
		
int main( int argc, char **argv ){
	
	char *dir = defaultdir, *inputfile=NULL;
	int i=0;

	/* if the user has just typed in "ripmime" and nothing else, then we had better give them
	 * the rundown on how to use this program */
	if (argc < 2) {	
		fprintf(stderr,"%s\n%s",version,help);
		exit(1);
		}

	_debug_on();
	
	/* determine our arguments */		
	for (i = 1; i < argc; i++){
		
		/* if the first char of the argument is a '-', then we possibly have a flag */
		if (argv[i][0] == '-') {
			
			/* test the 2nd char of the parameter */
			switch (argv[i][1]){
				case 'i': i++; inputfile = argv[i]; break;
				case 'd': i++; dir = argv[i]; break;
				case 'p': i++; MIME_set_blankfileprefix(argv[i]); break; /* this is in mime.h */
				case 'e': MIME_set_dumpheaders(1); 
					if ( (i < (argc-1))&&(argv[i+1][0] != '-')) MIME_set_headersname(argv[++i]);
					break; /* makes MIME dump out the headers to a file */
				case 'v': MIME_set_verbosity(1); break; /* make ripMIME talk as it walks */
				case 'V': fprintf(stderr,"%s\n",version); exit(1); break;
				case 'h': fprintf(stderr,"%s\n",help); exit(1); break;
				/* if we get ANOTHER - symbol, then we have an extended flag */
				case '-': 
					if (strncmp(&(argv[i][2]),"syslog_on",9) == 0) { MIME_set_syslogging(1); }
					else
					if (strncmp(&(argv[i][2]),"stderr_off",10) == 0) { MIME_set_stderrlogging(0); }
					else 
					if (strncmp(&(argv[i][2]),"no_nameless",11) == 0) { MIME_set_no_nameless(1); }
					else { 
						fprintf(stderr, "Cannot interpret option \"%s\"\n%s\n",argv[i],help);exit(1);break; 
						}
					break;

				/* else, just dump out the help message */
				default : fprintf(stderr, "Cannot interpret option \"%s\"\n%s\n",argv[i],help);exit(1);break;
				} /* Switch argv[i][1] */
			} /* if argv[i][0] == - */
		} /* for */
	
	/* if our input filename wasn't specified, then we better let the user know! */
	if (!inputfile) {
		fprintf(stderr,"Error: No input file was specified\n");
		exit(1);
		}
	
	/* Turn on debugging (works if compiled with -DDEBUG */
	_debug_on();
	
	/* Fire up the randomizer */
	srand(time(NULL));
	
	/* clean up the output directory name if required (remove any trailing /'s, as suggested by James Cownie 03/02/2001 */
	if (dir[strlen(dir)-1] == '/') dir[strlen(dir)-1] = '\0';
	
	/* Create the output directory required as specified by the -d parameter */
	mkdir(dir,S_IRWXU);
	
	/* Unpack the contents */
	MIME_init();
	MIME_unpack( dir, inputfile, 0);
	
	/* do any last minute things */
	MIME_close();
	return 0;
	}

/*-END-----------------------------------------------------------*/
