// TODO: phisycs constants
#include <string.h>
#include "writer.h"
#include "defines.h"
#include "consts.h"
#include "math_consts.h"


/* Consts table entry */
struct const_entry
{
  identifier (name);		/* const name   */
  double value;			/* const value  */
    message (msg);		/* help message */
};


static const struct const_entry Consts[] = {
  /* pi greek definition */
  {
   "pi",
   PI,
   "p greek"},

  /* natural base logarithm definition */
  {
   "e",
   E,
   "natural base logarithm"},

  /* zero definition */
  {
   "zero",
   ZERO,
   "null value"},

  /* a small number */
  {
   "epsi",
   EPSILON,
   "epsilon"}
};

#define PARSER_CONSTS_TABLE_LENGTH (sizeof(Consts) / sizeof(Consts[0]))

int
parser_search_const (const char *name)
{
  register int i = 0;
  assert (name);

  while (i < PARSER_CONSTS_TABLE_LENGTH)
    {
      if ((strncmp (name, Consts[i].name, IDENTIFIER_LENGHT)) == 0)
	return 1;
      i += 1;
    }
  return 0;
}

double
parser_get_const_value (const char *name)
{
  register int i = 0;

  while (i < PARSER_CONSTS_TABLE_LENGTH)
    {
      if ((strncmp (name, Consts[i].name, IDENTIFIER_LENGHT)) == 0)
	return Consts[i].value;
      i += 1;
    }

  return 0.0;
}

void
parser_print_consts_table (void)
{
  register int i = 0;

  while (i < PARSER_CONSTS_TABLE_LENGTH)
    {
      writeln ("%-s {%s} = %g", Consts[i].name, Consts[i].msg,
	       Consts[i].value);
      i += 1;
    }
}
