// TODO: print a error hint when throw an error
// TODO: print a more accurate error report (also on a logfile?)
#include <setjmp.h>
#include <string.h>
#include "writer.h"
#include "errors.h"
#include "util.h"
#include "defines.h"

static const char *parser_err_msgs[ERROR_COUNT] = {
  "no error",
  "syntax error",
  "unbalanced parenthesis",
  "division by zero",
  "unknown variable",
  "maximum variables reached",
  "unrecognised function",
  "wrong number of arguments to function",
  "missing an argument",
  "negative argument",
  "null argument",
  "domain error in function",
  "variable already exist as constant",
  "internal range error",
  "identifier too long"
};

/* set long jump by error condition and spar_eval */
jmp_buf jb;

void
parser_throw_error (parser_error_t error, const char token[])
{
  assert (token);
  write (HEADER_PARSER "%s", parser_err_msgs[error]);

  if ((strlen (token)) != 0)
    write (" \"%s\"", token);

  writeln ("");

  longjmp (jb, 1);
}

void
parser_print_error_messages (void)
{
  register int i = 0;

  while (i < ERROR_COUNT)
    {
      writeln ("error code [%d]: \"%s\"", i, parser_err_msgs[i]);
      i += 1;
    }
}

const char *
parser_get_error_message (parser_error_t error)
{
  return parser_err_msgs[error];
}
