#ifndef _errors_h_
#define _errors_h_

typedef enum
{
  NO_ERROR = 0,			/* no error */
  ERROR_SYNTAX,
  ERROR_UNBALAN,
  ERROR_DIVZERO,
  ERROR_UNKNOWN,
  ERROR_MAXVARS,
  ERROR_BADFUNC,
  ERROR_NUMARGS,
  ERROR_NOARG,
  ERROR_NEGARG,
  ERROR_NULLARG,
  ERROR_DOMAIN,
  ERROR_CONST,
  ERROR_RANGE,			/* = ERANGE             */
  ERROR_IDENF,			/* identifier too long  */
  ERROR_COUNT			/* parser error counter */
}
parser_error_t;

extern void parser_print_error_messages (void);
extern void parser_throw_error (parser_error_t, const char[]);
extern const char *parser_get_error_message (parser_error_t);

#endif /* _errors_h_ */
