// TODO: add the function get and put
// TODO: add functions with variable arguments
//                                      average (43,434,32,4)
//                                              max (434,44,56,5)
//                                              min (55,3,7,8)
#include <string.h>
#include "defines.h"
#include "writer.h"
#include "errors.h"
#include "funcs.h"
#include "util.h"
#include "math_library.h"

static double
fake_function (double a)
{
  return a;
}

static double
fake2_function (double a, double b)
{
  return a + b;
}

const struct function_entry Funcs[] = {
  /* one arg functions... */
  {"sin",			/* name to invoke this function */
   FUNCTION_WITH_ONE_ARG,	/* how many arguments it gets   */
   FUNCTION_CLASS_TRIG,		/* math type (for help command) */
   M_sin,			/* function to call (one arg)   */
   fake2_function		/* function to call (two args)  */
   },

  {"cos",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_TRIG,
   M_cos,
   fake2_function},

  {"tan",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_TRIG,
   M_tan,
   fake2_function},

  {"asin",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_ITRIG,
   M_arcsin,
   fake2_function},

  {"acos",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_ITRIG,
   M_arccos,
   fake2_function},

  {"atan",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_ITRIG,
   M_arctan,
   fake2_function},

  {"sinh",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_HYPER,
   M_sinh,
   fake2_function},

  {"cosh",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_HYPER,
   M_cosh,
   fake2_function},

  {"tanh",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_HYPER,
   M_tanh,
   fake2_function},

  {"asinh",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_HYPER,
   M_asinh,
   fake2_function},

  {"acosh",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_HYPER,
   M_acosh,
   fake2_function},

  {"atanh",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_HYPER,
   M_atanh,
   fake2_function},

  {"exp",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_EXP,
   M_exp,
   fake2_function},

  {"log",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_LOG,
   M_log,
   fake2_function},

  {"logb",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_LOG,
   M_log2,
   fake2_function},

  {"logt",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_LOG,
   M_log10,
   fake2_function},

  {"floor",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_SPECIAL,
   M_floor,
   fake2_function},

  {"ceil",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_SPECIAL,
   M_ceil,
   fake2_function},

  {"sgn",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_SPECIAL,
   M_sign,
   fake2_function},

  {"abs",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_SPECIAL,
   M_abs,
   fake2_function},

  {"deg",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_SPECIAL,
   M_deg,
   fake2_function},

  {"rad",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_SPECIAL,
   M_rad,
   fake2_function},

  {"fat",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_SPECIAL,
   M_nfat,
   fake2_function},

  {"sum",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_SPECIAL,
   M_sum,
   fake2_function},

  {"inv",
   FUNCTION_WITH_ONE_ARG,
   FUNCTION_CLASS_SPECIAL,
   M_inv,
   fake2_function},

  /* two args functions... */
  {"max",
   FUNCTION_WITH_TWO_ARG,
   FUNCTION_CLASS_SPECIAL,
   fake_function,
   M_max},

  {"min",
   FUNCTION_WITH_TWO_ARG,
   FUNCTION_CLASS_SPECIAL,
   fake_function,
   M_min},

  {"sqrn",
   FUNCTION_WITH_TWO_ARG,
   FUNCTION_CLASS_EXP,
   fake_function,
   M_sqrn},

  {"hypot",
   FUNCTION_WITH_TWO_ARG,
   FUNCTION_CLASS_ITRIG,
   fake_function,
   M_hypot},

  {"mcd",
   FUNCTION_WITH_TWO_ARG,
   FUNCTION_CLASS_SPECIAL,
   fake_function,
   M_mcd},

  {"expn",
   FUNCTION_WITH_TWO_ARG,
   FUNCTION_CLASS_EXP,
   fake_function,
   M_expn}
};


/* math name of the implemented functions */
static const char *function_math_names[] = {
  "sin",
  "cos",
  "tan",
  "arcsin",
  "arccos",
  "arctan",
  "sinh",
  "cosh",
  "tanh",
  "asinh",
  "acosh",
  "atanh",
  "exp",
  "log",
  "log2",
  "log10",
  "floor",
  "ceil",
  "sgn",
  "|x|",
  "deg",
  "rad",
  "x!",
  "sum(1..x)",
  "inv",
  "M",
  "m",
  "x^(1/y)",
  "hypot",
  "mcd",
  "exp[n]"
};

static const char *function_type_string[FUNCTION_CLASS_COUNTER] = {
  "Trigonometric",
  "Inverse Trigonometric",
  "Exponential",
  "Logarithm",
  "Hyperbolic",
  "Special",
  "User_defined"
};

static const char *function_args_string[FUNCTION_WITH_COUNTER] = {
  "",
  "(x)",
  "(x,y)",
  "(...)"
};

#define PARSER_FUNCS_TABLE_LENGTH (sizeof(Funcs) / sizeof(Funcs[0]))

int
parser_check_function (const char name[])
{
  register int i = 0;

  assert (name);

  /* scan the entire funcs table... */
  while (i < PARSER_FUNCS_TABLE_LENGTH)
    {
      /* check if name is a function name */
      if ((strncmp (name, Funcs[i].name, IDENTIFIER_LENGHT)) == 0)
	/* return the index of the function */
	return i;

      i += 1;
    }

  /* function "name" not found! */
  return SYMBOL_NOT_FOUND;

}

void
parser_print_funcs_table (void)
{
  register int i = 0;

  while (i < PARSER_FUNCS_TABLE_LENGTH)
    {
      writeln ("%-8s %s", Funcs[i].name, function_math_names[i]);
      i += 1;
    }
}

int
parser_make_function_help (const char *name, struct function_doc_entry *tmp)
{
  int fnc_code = parser_check_function (name);

  assert (name);
  assert (tmp);

  if (fnc_code != SYMBOL_NOT_FOUND)
    {
      strcat (strcpy (tmp->math, function_math_names[fnc_code]),
	      function_args_string[Funcs[fnc_code].args]);
      strcat (strcpy (tmp->type, function_type_string[Funcs[fnc_code].type]),
	      " function");
      strcpy (tmp->name, Funcs[fnc_code].name);
      tmp->args = Funcs[fnc_code].args;
      return 1;
    }
  return 0;
}

double
parser_run_function (int _code, double arg[])
{
  assert (_code < PARSER_FUNCS_TABLE_LENGTH);
  assert (arg[0]);

  switch (Funcs[_code].args)
    {
    case FUNCTION_WITH_ONE_ARG:
      return Funcs[_code].func (arg[0]);
      break;

    case FUNCTION_WITH_TWO_ARG:
      return Funcs[_code].func2 (arg[0], arg[1]);
      break;

    case FUNCTION_WITH_VAR_ARG:
    case FUNCTION_WITH_COUNTER:
      break;

    }
  return 0.0;
}

function_args_t parser_get_function_argc (int _code)
{
  return Funcs[_code].args;
}

const char *
parser_get_function_name (int _code)
{
  return Funcs[_code].name;
}
