#ifndef _funcs_h_
#define _funcs_h_

#include "defines.h"

/* some extensions... */
typedef enum
{
  FUNCTION_WITH_ONE_ARG = 1,	/* function with one argument           */
  FUNCTION_WITH_TWO_ARG,	/* function with two arguments        */
  FUNCTION_WITH_VAR_ARG,	/* function with variable nums of args  */
  FUNCTION_WITH_COUNTER
}
function_args_t;

typedef enum
{
  FUNCTION_CLASS_TRIG,
  FUNCTION_CLASS_ITRIG,
  FUNCTION_CLASS_EXP,
  FUNCTION_CLASS_LOG,
  FUNCTION_CLASS_HYPER,
  FUNCTION_CLASS_SPECIAL,
  FUNCTION_CLASS_USER,
  FUNCTION_CLASS_COUNTER
}
function_class_t;


struct function_entry
{
  identifier (name);		/* names (as spar can regognize them)    */
  function_args_t args;		/*  number of arguments                  */
  function_class_t type;	/* type of function               */
  double (*func) (double);	/* pointer to one_arg function          */
  double (*func2) (double, double);	/* pointer to two_arg function      */
};

struct function_doc_entry
{
  identifier (name);
  message (math);
  message (type);
  function_args_t args;
};

extern int function_help (char *, struct function_doc_entry *);
//extern const struct function_entry Funcs[];
extern double parser_run_function (int, double[]);
extern function_args_t parser_get_function_argc (int);
extern const char *parser_get_function_name (int);
extern int parser_check_function (const char[]);
extern void parser_print_funcs_table (void);
extern int parser_make_function_help (const char *,
				      struct function_doc_entry *);

#endif /* _funcs_h_ */
